[![Documentation Status](https://readthedocs.org/projects/contact-map/badge/?version=latest)](http://contact-map.readthedocs.io/en/latest/?badge=latest)
[![Linux Build Status](https://travis-ci.org/dwhswenson/contact_map.svg?branch=master)](https://travis-ci.org/dwhswenson/contact_map)
[![Windows Build status](https://ci.appveyor.com/api/projects/status/em3fo96sjrg2vmcc/branch/master?svg=true)](https://ci.appveyor.com/project/dwhswenson/contact-map/branch/master)
[![Coverage Status](https://coveralls.io/repos/github/dwhswenson/contact_map/badge.svg?branch=master)](https://coveralls.io/github/dwhswenson/contact_map?branch=master)
[![PyPI](https://img.shields.io/pypi/v/contact-map.svg)](https://pypi.python.org/pypi/contact-map/)
[![conda-forge](https://img.shields.io/conda/v/conda-forge/contact_map.svg)](https://github.com/conda-forge/contact_map-feedstock)

[![Codacy Badge](https://api.codacy.com/project/badge/Grade/f7f3cf53698e4655ac8895f13fa5dea6)](https://www.codacy.com/app/dwhswenson/contact_map?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=dwhswenson/contact_map&amp;utm_campaign=Badge_Grade)
[![Maintainability](https://api.codeclimate.com/v1/badges/84768756d594176d8da6/maintainability)](https://codeclimate.com/github/dwhswenson/contact_map/maintainability)

# Contact Map Explorer

This package provides tools for analyzing and exploring contacts
(residue-residue and atom-atom) from a trajectory generated by molecular
dynamics. It builds on the excellent tools provided by
[MDTraj](http://mdtraj.org).

Contacts can be an important tool for defining (meta)stable states in
processes involving biomolecules. For example, an analysis of contacts can
be particularly useful when defining bound states during a binding processes
between proteins, DNA, and small molecules (such as potential drugs).

The contacts analyzed by Contact Map Explorer can be either intermolecular or
intramolecular, and can be analyzed on a residue-residue basis or an atom-atom
basis.

This package makes it very easy to answer questions like:

* What contacts are present in a trajectory?
* Which contacts are most common in a trajectory?
* What is the difference between the frequency of contacts in one trajectory
  and another?  (Or with a specific frame, such as a PDB entry.)
* For a particular residue-residue contact pair of interest, which atoms are
  most frequently in contact?

It also facilitates visualization of the contact matrix, with colors
representing the fraction of trajectory time that the contact was present.

Full documentation is at http://contact-map.readthedocs.io/.

## Installation

The easiest way to install is with `conda`. Conda is a powerful package and
environment management system. If you do not already have a highly
customized Python environment, we recommend starting by installing `conda`,
either in the [full anaconda
distribution](https://www.anaconda.com/download/) or the [smaller-footprint
miniconda](https://conda.io/miniconda.html). This package is distributed
through the [conda-forge](http://conda-forge.org) channel; install it with:

```bash
conda install -c conda-forge contact_map
```

If you don't want to use `conda`, you can also use `pip` (via a more
complicated process) or do a developer install. See the [installation
documentation](http://contact-map.readthedocs.io/en/latest/installing.html)
for details.

## Support and development

Contact Map Explorer is an open source project, released under the GNU LGPL,
version 2.1 or (at your option) any later version. Development takes place
in public at https://github.com/dwhswenson/contact_map; your contributions
would be welcome!

If you have suggestions or bug reports, please [raise an issue on our GitHub
issue page](https://github.com/dwhswenson/contact_map/issues).
