from RSTAB.initModel import Model, clearAttributes
from enum import Enum

class LoadCasesAndCombinations():

    def __init__(self,
                 params: dict = {
                    "current_standard_for_combination_wizard": 6207,
                    "activate_combination_wizard_and_classification": True,
                    "activate_combination_wizard": True,
                    "result_combinations_active": False,
                    "result_combinations_parentheses_active": False,
                    "result_combinations_consider_sub_results": False,
                    "combination_name_according_to_action_category": False
                 },
                 model= Model):

        """
        Args:
            params(dict, optional): Combination Wizard Parameters

                        National Annex                                      Codes
                       ----------------                                     -----
        NATIONAL_ANNEX_AND_EDITION_EN_1990_CEN_2010_04		                6207
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BDS_2015_02		                6034
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BS_2009_06		                6035
        NATIONAL_ANNEX_AND_EDITION_EN_1990_CSN_2015_05		                6036
        NATIONAL_ANNEX_AND_EDITION_EN_1990_CYS_2010_06		                6037
        NATIONAL_ANNEX_AND_EDITION_EN_1990_DIN_2012_08		                6038
        NATIONAL_ANNEX_AND_EDITION_EN_1990_DS_2013_05		                6039
        NATIONAL_ANNEX_AND_EDITION_EN_1990_ELOT_2009_01		                6360
        NATIONAL_ANNEX_AND_EDITION_EN_1990_EVS_2010_04		                6548
        NATIONAL_ANNEX_AND_EDITION_EN_1990_I_S_2010_03		                6040
        NATIONAL_ANNEX_AND_EDITION_EN_1990_ILNAS_2020_03		            6042
        NATIONAL_ANNEX_AND_EDITION_EN_1990_LST_2012_01		                6041
        NATIONAL_ANNEX_AND_EDITION_EN_1990_LVS_2015_01		                6043
        NATIONAL_ANNEX_AND_EDITION_EN_1990_MS_2010_05		                6044
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NBN_2015_07		                6045
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NEN_2007_09		                6046
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NEN_2019_11		                6047
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NF_2011_12		                6048
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NP_2009_12		                6049
        NATIONAL_ANNEX_AND_EDITION_EN_1990_NS_2016_05		                6050
        NATIONAL_ANNEX_AND_EDITION_EN_1990_OENORM_2013_03		            6051
        NATIONAL_ANNEX_AND_EDITION_EN_1990_PN_2010_09		                6052
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SFS_2010_09		                6053
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SIST_2010_09		                6054
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SR_2009_10		                6055
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SS_2012_06		                6056
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SS_2010_04		                6057
        NATIONAL_ANNEX_AND_EDITION_EN_1990_SS_2019_01		                6414
        NATIONAL_ANNEX_AND_EDITION_EN_1990_STN_2010_11		                6058
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TKP_2011_11		                6059
        NATIONAL_ANNEX_AND_EDITION_EN_1990_UNE_2019_04		                6060
        NATIONAL_ANNEX_AND_EDITION_EN_1990_UNI_2010_10		                6061
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_CEN_2010_04	            6208
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_BDS_2015_02		        6062
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_BS_2009_06		        6063
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_CSN_2015_05		        6064
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_CYS_2010_06		        6065
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_DIN_2012_08		        6066
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_DS_2013_09		        6067
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_I_S_2010_03		        6068
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_ILNAS_2020_03		        6070
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_LST_2012_01		        6069
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_LVS_2015_01		        6071
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NBN_2015_07		        6072
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NEN_2007_09		        6073
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NEN_2019_11		        6074
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NF_2015_01		        6075
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NP_2009_12		        6076
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_NS_2016_05		        6077
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_OENORM_2009_07	        6078
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_OENORM_2019_06		    6079
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_PN_2010_09		        6080
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_SFS_2010_09		        6081
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_SIST_2010_09		        6082
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_SR_2009_10		        6083
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_SS_2010_04		        6084
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_SS_2019_01		        6415
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_STN_2010_11		        6085
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_TKP_2011_11		        6351
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_UNE_2010_07		        6086
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_UNE_2019_04		        6087
        NATIONAL_ANNEX_AND_EDITION_EN_1990_TIMBER_UNI_2010_10		        6088
        NATIONAL_ANNEX_AND_EDITION_EN_1990_CRANES_CEN_2010_04		        6209
        NATIONAL_ANNEX_AND_EDITION_EN_1990_CRANES_DIN_2012_08		        6089
        NATIONAL_ANNEX_AND_EDITION_EN_1990_GEOTECHNICS_CEN_2010_04		    6210
        NATIONAL_ANNEX_AND_EDITION_COMBINATION_WIZARD_NONE		            6232
        NATIONAL_ANNEX_AND_EDITION_CAN_CSA_2000		                        6230
        NATIONAL_ANNEX_AND_EDITION_SIA_260_SIA_260_2013_08		            6225
        NATIONAL_ANNEX_AND_EDITION_SIA_260_TIMBER_SIA_260_2013_08		    6226
        NATIONAL_ANNEX_AND_EDITION_CTE_DB_SE_CTE_DB_SE_2009_04		        6227
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_2022_COMBINATION_WIZARD		    6555
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_2016_COMBINATION_WIZARD		    6238
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_2010		                        6237
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_2005		                        6236
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_2002		                        6235
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_WOOD_2022		                    6579
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_WOOD_2016		                    6350
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_WOOD_2010		                    6241
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_WOOD_2005		                    6240
        NATIONAL_ANNEX_AND_EDITION_ASCE_7_WOOD_2002		                    6239
        NATIONAL_ANNEX_AND_EDITION_ACI_318_2019_COMBINATION_WIZARD		    6403
        NATIONAL_ANNEX_AND_EDITION_ACI_318_2014_COMBINATION_WIZARD		    6269
        NATIONAL_ANNEX_AND_EDITION_ACI_318_2011		                        6268
        NATIONAL_ANNEX_AND_EDITION_ACI_318_2008		                        6267
        NATIONAL_ANNEX_AND_EDITION_IBC_2018		                            6361
        NATIONAL_ANNEX_AND_EDITION_IBC_2015		                            6273
        NATIONAL_ANNEX_AND_EDITION_NBC_2015_COMBINATION_WIZARD		        6272
        NATIONAL_ANNEX_AND_EDITION_NBC_2005		                            6271
        NATIONAL_ANNEX_AND_EDITION_NBR_8681_NBR_8681_2003_03		        6270
        NATIONAL_ANNEX_AND_EDITION_IS_800_IS_800_2007_12		            6317
        NATIONAL_ANNEX_AND_EDITION_BS_5950_2000_01		                    6325
        NATIONAL_ANNEX_AND_EDITION_SANS_10160_1_2010_05		                6331
        NATIONAL_ANNEX_AND_EDITION_NBC_WOOD_2015		                    6336
        NATIONAL_ANNEX_AND_EDITION_NTC_NTC_2018_01		                    6358
        NATIONAL_ANNEX_AND_EDITION_SP_20_13330_2016		                    6380
        NATIONAL_ANNEX_AND_EDITION_EN_15512_CEN_2009_03	                    6435
        NATIONAL_ANNEX_AND_EDITION_NTC_TIMBER_2018_01		                6436
        NATIONAL_ANNEX_AND_EDITION_GB_50068_GB_50011_2018		            6514
        NATIONAL_ANNEX_AND_EDITION_GB_50009_GB_50011_2016		            6516
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_CEN_2010_04		    6517
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_BDS_2015_02		    6518
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_BS_2009_06		    6522
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_CSN_2015_05		    6523
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_CYS_2010_06		    6524
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_DIN_2012_08		    6525
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_DS_2013_09		    6526
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_I_S_2010_03		    6527
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_ILNAS_2020_03		6529
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_LST_2012_01		    6528
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_LVS_2015_01		    6530
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_NBN_2015_07		    6531
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_NEN_2019_11		    6532
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_NF_2011_12		    6533
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_NP_2009_12		    6534
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_NS_2016_05		    6535
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_OENORM_2019_06		6536
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_PN_2010_09		    6537
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_SFS_2010_09		    6538
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_SIST_2010_09		    6539
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_SS_2019_01		    6541
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_STN_2010_11		    6521
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_TKP_2011_11		    6542
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_UNE_2019_04		    6543
        NATIONAL_ANNEX_AND_EDITION_EN_1990_BASE_TIMBER_UNI_2010_10		    6544
        NATIONAL_ANNEX_AND_EDITION_AS_NZS_1170_0_2002		                6546
        """

        # Client model | Load Cases And Combinations
        clientObject = model.clientModel.factory.create('ns0:load_cases_and_combinations')

        # Clears object atributes | Sets all atributes to None
        clearAttributes(clientObject)

        # Adding optional parameters via dictionary
        if params:
            for key in params:
                clientObject[key] = params[key]

        # Set Load Case And Combinations to client model
        model.clientModel.service.set_load_cases_and_combinations(clientObject)

    @staticmethod
    def getAvailableLoadActionCategoryTypes(model=Model):

        '''
        Args:
            model (RSTAB Class, optional): Model to be read
        '''

        actionCategoryDictionary = {'6207': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6034': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6035': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6036': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6037': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6038': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_ACTIONS_QO', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6039': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6360': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6548': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6040': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6042': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6041': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6043': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'],
        '6044': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6045': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6046': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6047': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_RAIN_LOAD_QR', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6048': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6049': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6050': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6051': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6052': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6053': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ICE_QI', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6054': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6055': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ',
        'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6056': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6057': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6414': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6058': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6059': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6060':
        ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6061': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6208': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6062': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6063': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6064': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6065': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6066': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_ACTIONS_QO', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6067': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6068': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6070': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6069': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6071': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6072': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6073': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H',
        'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ',
        'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6074': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_RAIN_LOAD_QR', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6075': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6076': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6077': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6078': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6079': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6080': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6081': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ICE_QI', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6082': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE',
        'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6083': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6084': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6415': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6085': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6351': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6086': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A',
        'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS',
        'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6087': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6088': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6209': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_11_12_13_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_1_7_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_8_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_9_10_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_SUPPORT_FORCES_Q_CR', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_FROM_CRANES_G_CR', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6089': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_11_12_13_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_1_7_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_8_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_CLASS_9_10_Q_CR', 'ACTION_CATEGORY_IMPOSED_LOADS_FROM_CRANES_SUPPORT_FORCES_Q_CR', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_ACTIONS_QO', 'ACTION_CATEGORY_PERMANENT_FROM_CRANES_G_CR', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6210': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_GEOTECHNICAL_LOADS_PERMANENT_GEP', 'ACTION_CATEGORY_GEOTECHNICAL_LOADS_VARIABLE_GEV', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6232': ['ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G'], '6230': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_INFLUENCES_RESULTING_FROM_TEMPERATURE_CHANGES_SHRINKAGE_OR_CREEP_ETC_T', 'ACTION_CATEGORY_LIVE_LOAD_DUE_TO_EARTHQUAKE_E', 'ACTION_CATEGORY_LIVE_LOAD_DUE_TO_WIND_W', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_NONE_NONE'], '6225': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_LOADS_GS',
        'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_WATER_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_EARTH_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_WATER_PRESSURE_GS', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6226': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_LOADS_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_EARTH_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_PERMANENT_WATER_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_EARTH_PRESSURE_GS', 'ACTION_CATEGORY_ACTION_FROM_SOIL_VARIABLE_WATER_PRESSURE_GS', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6227': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_GEOTECHNICAL_LOADS_VARIABLE_GEV', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_ROOFS_ACCESSIBLE_ONLY_PRIVATELY_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G1_ROOFS_SLOPE_LESS_THAN_20_Q_G1', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G2_ROOFS_SLOPE_MORE_THAN_40_Q_G2', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_EARTH_PRESSURE_G_E', 'ACTION_CATEGORY_PERMANENT_SELF_WEIGHT_SELF_WEIGHT_OF_SOIL_G', 'ACTION_CATEGORY_PERMANENT_WATER_PRESSURE_G_W', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6555': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV', 'ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI', 'ACTION_CATEGORY_LOAD_DUE_TO_GROUND_WATER_PRESSURE_HW', 'ACTION_CATEGORY_TORNADO_LOAD_WT', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_OR_PRESSURE_OF_BULK_MATERIALS_HEB'], '6238': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV', 'ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6237': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'],
        '6236': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6235': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6579': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV', 'ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI', 'ACTION_CATEGORY_LOAD_DUE_TO_GROUND_WATER_PRESSURE_HW', 'ACTION_CATEGORY_TORNADO_LOAD_WT', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_OR_PRESSURE_OF_BULK_MATERIALS_HEB'], '6350': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_VERTICAL_EV', 'ACTION_CATEGORY_EFFECTS_OF_HORIZONTAL_EARTHQUAKE_FORCES_QE', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_NOTIONAL_LOAD_FOR_STRUCTURAL_INTEGRITY_N', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6241': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_ARISING_FROM_EXTRAORDINARY_EVENT_AK', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6240': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6239': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6403': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L',
        'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6269': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6268': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6267': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6361': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6273': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_FLOOD_LOAD_FA', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_LOAD_DUE_TO_FLUIDS_WITH_WELL_DEFINED_PRESSURES_AND_MAXIMUM_HEIGHTS_F', 'ACTION_CATEGORY_LOAD_DUE_TO_LATERAL_EARTH_PRESSURE_GROUND_WATER_PRESSURE_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_RAIN_LOAD_R', 'ACTION_CATEGORY_ROOF_LIVE_LOAD_LR', 'ACTION_CATEGORY_SELF_STRAINING_FORCE_T', 'ACTION_CATEGORY_SNOW_LOAD_S', 'ACTION_CATEGORY_WEIGHT_OF_ICE_DI', 'ACTION_CATEGORY_WIND_LOAD_W', 'ACTION_CATEGORY_WIND_ON_ICE_DETERMINED_IN_ACCORDANCE_WITH_SECTION_10_WI'], '6272': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S',
        'ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T', 'ACTION_CATEGORY_WIND_LOAD_W'], '6271': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S', 'ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T', 'ACTION_CATEGORY_WIND_LOAD_W'], '6270': ['ACTION_CATEGORY_ACTIONS_WITH_LIMITED_MAXIMUM_VALUES_Q_LI', 'ACTION_CATEGORY_EXCEPTIONAL_EXC', 'ACTION_CATEGORY_GENERAL_CONSTRUCTION_ELEMENTS_AND_EQUIPMENT_G_GE', 'ACTION_CATEGORY_GENERAL_VARIABLE_ACTIONS_Q_GE', 'ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_G_IN', 'ACTION_CATEGORY_INDUSTRIALIZED_CONSTRUCTION_ELEMENTS_WITH_ADDITION_ON_SITE_G_IS', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_SELF_WEIGHT_OF_METAL_STRUCTURES_G_ME', 'ACTION_CATEGORY_SELF_WEIGHT_OF_PREFABRICATED_STRUCTURES_G_PR', 'ACTION_CATEGORY_SELF_WEIGHT_OF_STRUCTURES_BUILT_ON_SITE_G_SI', 'ACTION_CATEGORY_SETTLEMENTS_OF_SUPPORTS_SHRINKAGE_SETT', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6317': ['ACTION_CATEGORY_ACCIDENTAL_LOAD_AL', 'ACTION_CATEGORY_DEAD_LOAD_DL', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_EL', 'ACTION_CATEGORY_IMPOSED_LOADS_LIVE_LOADS_LL', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_WIND_LOAD_WL'], '6325': ['ACTION_CATEGORY_DEAD_LOAD_GK', 'ACTION_CATEGORY_IMPOSED_LOAD_QK', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_NOTIONAL_HORIZONTAL_FORCES_ACCORDING_TO_BS_5950_NK', 'ACTION_CATEGORY_WIND_LOAD_WK'], '6331': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTIONS_DUE_TO_CRANES_HORIZONTAL_AND_VERTICAL_Q_CR', 'ACTION_CATEGORY_IMPOSED_DEFORMATIONS_DUE_TO_PRE_STRESSING_P', 'ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_EXCLUDING_CATEGORIES_A_TO_D_Q_J', 'ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_A_Q_KA', 'ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_B_Q_KB', 'ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_C_Q_KC', 'ACTION_CATEGORY_IMPOSED_LOADS_ACCESSIBLE_FLAT_ROOFS_WITH_OCCUPANCY_D_Q_KD', 'ACTION_CATEGORY_IMPOSED_LOADS_AREAS_WHERE_PEOPLE_CAN_CONGREGATE_Q_C', 'ACTION_CATEGORY_IMPOSED_LOADS_DOMESTIC_AND_RESIDENTIAL_AREAS_Q_A', 'ACTION_CATEGORY_IMPOSED_LOADS_FORK_LIFTS_Q_FL', 'ACTION_CATEGORY_IMPOSED_LOADS_HELICOPTER_LOAD_Q_HC', 'ACTION_CATEGORY_IMPOSED_LOADS_INACCESSIBLE_ROOFS_Q_H', 'ACTION_CATEGORY_IMPOSED_LOADS_INDUSTRIAL_USE_Q_E2', 'ACTION_CATEGORY_IMPOSED_LOADS_LIGHT_INDUSTRIAL_USE_Q_E1', 'ACTION_CATEGORY_IMPOSED_LOADS_PUBLIC_AREAS_NOT_SUSCEPTIBLE_TO_CROWDING_Q_B', 'ACTION_CATEGORY_IMPOSED_LOADS_SHOPPING_AREAS_Q_D', 'ACTION_CATEGORY_IMPOSED_LOADS_STORAGE_AREAS_Q_E3', 'ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_Q_F', 'ACTION_CATEGORY_IMPOSED_LOADS_TRAFFIC_AND_PARKING_AREAS_FOR_VEHICLES_25_KN_TO_160_KN_Q_G', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_IMPOSED_PERMANENT_DEFORMATIONS_FOR_EXAMPLE_SETTLEMENT_G_OT', 'ACTION_CATEGORY_OTHER_TYPES_OF_VARIABLE_LOADS_Q_OT', 'ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_G_GF', 'ACTION_CATEGORY_PERMANENT_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_G_GU', 'ACTION_CATEGORY_PERMANENT_LOADS_FROM_FLUIDS_G_FL', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SELF_WEIGHT_G', 'ACTION_CATEGORY_THERMAL_ACTIONS_QT', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUNDWATER_GEF1', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_GROUND_WATER_FLUIDS_GEF2', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_FACTORED_OTHER_ACTIONS_GEF3', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUNDWATER_GEU1', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_GROUND_WATER_FLUIDS_GEU2', 'ACTION_CATEGORY_VARIABLE_GEOTECHNICAL_ACTIONS_SOIL_PARAMETERS_UN_FACTORED_OTHER_ACTIONS_GEU3', 'ACTION_CATEGORY_VARIABLE_LOADS_FROM_FLUIDS_Q_FL', 'ACTION_CATEGORY_WIND_QW'], '6336': ['ACTION_CATEGORY_DEAD_LOAD_D', 'ACTION_CATEGORY_EARTHQUAKE_LOAD_E', 'ACTION_CATEGORY_LATERAL_EARTH_PRESSURE_H', 'ACTION_CATEGORY_LIVE_LOAD_L', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SNOW_ICE_AND_RAIN_S', 'ACTION_CATEGORY_TEMPERATURE_SHRINKAGE_CREEP_ETC_T', 'ACTION_CATEGORY_WIND_LOAD_W'], '6358': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_ACCESSIBLE_ONLY_FOR_MAINTENANCE_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_ACCESSIBLE_QI_I', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_ROOFS_FOR_SPECIAL_USES_HELIPORTS_QI_K', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G1', 'ACTION_CATEGORY_PERMANENT_IMPOSED_NON_STRUCTURAL_G2', 'ACTION_CATEGORY_PERMANENT_NON_STRUCTURAL_G2', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6380': ['ACTION_CATEGORY_CONCENTRATED_AND_RAILING_LOADS_Q_CO', 'ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LIQUID_Q_E3', 'ACTION_CATEGORY_EQUIPMENT_CHARGES_OF_CONTAINERS_LOOSE_Q_E4', 'ACTION_CATEGORY_EQUIPMENT_FORKLIFTS_AND_ELECTRIC_TRUCKS_Q_E5', 'ACTION_CATEGORY_EQUIPMENT_ISOLATION_OF_EQUIPMENT_Q_E2', 'ACTION_CATEGORY_EQUIPMENT_PERMANENT_EQUIPMENT_Q_E1', 'ACTION_CATEGORY_EQUIPMENT_STORED_MATERIALS_AND_PRODUCTS_Q_M', 'ACTION_CATEGORY_ICE_LOADINGS_Q_I', 'ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_6K_Q_C4', 'ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_7K_Q_C3', 'ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_ELASTIC_Q_C2', 'ACTION_CATEGORY_LOADS_FROM_CRANES_GROUP_8K_RIGID_Q_C1', 'ACTION_CATEGORY_LOADS_FROM_CRANES_OTHER_GROUPS_Q_C5', 'ACTION_CATEGORY_LOADS_FROM_VEHICLES_Q_V', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_2_KN_M2_AND_MORE_Q_U2', 'ACTION_CATEGORY_PREMISES_OF_BUILDINGS_UNIFORM_LOADS_LESS_THAN_2_KN_M2_Q_U1', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_ON_BUILDING_SITE_G_C3', 'ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_1600_KG_M3_AND_LESS_PREFABRICATED_G_C2', 'ACTION_CATEGORY_SELF_WEIGHT_CONCRETE_MORE_THAN_1600_KG_M3_STONE_TIMBER_G_C1', 'ACTION_CATEGORY_SELF_WEIGHT_SOIL_MODIFIED_G_SM', 'ACTION_CATEGORY_SELF_WEIGHT_SOIL_NATURAL_G_SN', 'ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_G_S1', 'ACTION_CATEGORY_SELF_WEIGHT_STEEL_CONSTRUCTIONS_OVER_50_OF_TOTAL_LOAD_G_S2', 'ACTION_CATEGORY_SNOW_LOADINGS_Q_S', 'ACTION_CATEGORY_SPECIAL_LOADINGS_PS', 'ACTION_CATEGORY_TEMPERATURE_CLIMATIC_INFLUENCES_Q_T', 'ACTION_CATEGORY_WIND_LOADINGS_Q_W'], '6435': ['ACTION_CATEGORY_ACCIDENTAL_ACTION_A', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_LIVE_LOADS_QO', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PLACEMENT_LOADS_QP', 'ACTION_CATEGORY_UNIT_LOADS_QU'], '6436': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_ACCESSIBLE_ONLY_FOR_MAINTENANCE_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_ACCESSIBLE_QI_I', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_ROOFS_FOR_SPECIAL_USES_HELIPORTS_QI_K', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G1', 'ACTION_CATEGORY_PERMANENT_IMPOSED_NON_STRUCTURAL_G2', 'ACTION_CATEGORY_PERMANENT_NON_STRUCTURAL_G2', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6514': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_ADJACENT_TO_BLAST_FURNACE_TABLE_5_4_1_2_Q_AS', 'ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_TABLE_5_4_1_1_Q_AS', 'ACTION_CATEGORY_CIVIL_BUILDINGS_ASSEMBLY_HALL_THEATER_CINEMA_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_BUS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_ROOF_BUS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_OTHER_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_POPULATION_MAY_BE_CONCENTRATED_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_FOR_OTHER_BUILDINGS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_CANTEEN_DINING_HALL_ORDINARY_ARCHIVES_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_CLASSROOM_LABORATORY_READING_ROOM_MEETING_ROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_DANCE_HALL_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_DWELLING_HOSTEL_HOTEL_OFFICE_HOSPITAL_WARD_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_GYMNASIUM_ARENA_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_FOR_DINING_HALL_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_OTHER_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_LAUNDRY_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_HOSTEL_HOTEL_NURSERY_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_OFFICE_CLASSROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_THICK_STREAM_OF_PEOPLE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_APARTMENT_HOUSE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_OTHER_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STANDS_WITHOUT_FIXED_SEAT_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STOREHOUSE_FOR_COLLECTING_BOOKS_ARCHIVES_STOREROOMS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STORES_AND_SHOPS_EXHIBITION_HALLS_STATION_PORT_AIRPORT_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_VENTILATOR_MOTOR_ROOM_ELEVATOR_MOTOR_ROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_WAREHOUSE_WITH_A_DENSE_CONCENTRATION_OF_SHELVING_Q_CB', 'ACTION_CATEGORY_CONSTRUCTION_AND_MAINTENANCE_LOADS_AND_HORIZONTAL_LOAD_ON_RAILINGS_ACC_TO_5_5_3_Q_CM', 'ACTION_CATEGORY_CRANE_LOADS_LIFTING_HOOK_CRANES_OF_WORKING_GRADE_A8_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A1_A3_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A4_A5_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A6_A7_Q_CR', 'ACTION_CATEGORY_HORIZONTAL_EARTHQUAKE_ACTION_EH', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_COTTON_MILLING_WORKSHOP_TABLE_D_0_1_4_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_GRAIN_PROCESSING_WORKSHOP_TABLE_D_0_1_6_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_1_2_4_6_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_3_5_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_7_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_METAL_WORKING_WORKSHOP_TABLE_D_0_1_1_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_PREPARATORY_WORKSHOP_FOR_TIRE_PLANT_TABLE_D_0_1_5_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_SEMICONDUCTOR_PRODUCTION_WORKSHOP_TABLE_D_0_1_3_Q_IB', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_HELICOPTER_ON_THE_ROOF_ACC_TO_5_3_2_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_MANNED_ROOF_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_GARDEN_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_SPORTS_GROUND_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_UNMANNED_ROOF_Q_LR', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_III_S', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_II_S', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_I_S', 'ACTION_CATEGORY_THERMAL_ACTION_ACCORDING_TO_9_1_3_T', 'ACTION_CATEGORY_VERTICAL_EARTHQUAKE_ACTION_EV', 'ACTION_CATEGORY_WIND_LOAD_ACCORDING_TO_8_1_4_W'], '6516': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_ADJACENT_TO_BLAST_FURNACE_TABLE_5_4_1_2_Q_AS', 'ACTION_CATEGORY_ASH_LOAD_ON_ROOFINGS_TABLE_5_4_1_1_Q_AS', 'ACTION_CATEGORY_CIVIL_BUILDINGS_ASSEMBLY_HALL_THEATER_CINEMA_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_BUS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_ONE_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_FLOOR_FIRE_ENGINE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_AUTOMOBILE_PASSAGE_AND_GARAGE_TWO_WAY_SLAB_ROOF_BUS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_OTHER_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BALCONY_POPULATION_MAY_BE_CONCENTRATED_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_BATHROOM_TOILET_AND_WASHROOM_FOR_OTHER_BUILDINGS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_CANTEEN_DINING_HALL_ORDINARY_ARCHIVES_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_CLASSROOM_LABORATORY_READING_ROOM_MEETING_ROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_DANCE_HALL_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_DWELLING_HOSTEL_HOTEL_OFFICE_HOSPITAL_WARD_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_GYMNASIUM_ARENA_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_FOR_DINING_HALL_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_KITCHEN_OTHER_Q_CB',
        'ACTION_CATEGORY_CIVIL_BUILDINGS_LAUNDRY_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_HOSTEL_HOTEL_NURSERY_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_OFFICE_CLASSROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_PASSAGE_ENTRANCE_HALL_STAIRCASE_THICK_STREAM_OF_PEOPLE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_APARTMENT_HOUSE_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STAIRS_OTHER_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STANDS_WITHOUT_FIXED_SEAT_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STOREHOUSE_FOR_COLLECTING_BOOKS_ARCHIVES_STOREROOMS_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_STORES_AND_SHOPS_EXHIBITION_HALLS_STATION_PORT_AIRPORT_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_VENTILATOR_MOTOR_ROOM_ELEVATOR_MOTOR_ROOM_Q_CB', 'ACTION_CATEGORY_CIVIL_BUILDINGS_WAREHOUSE_WITH_A_DENSE_CONCENTRATION_OF_SHELVING_Q_CB', 'ACTION_CATEGORY_CONSTRUCTION_AND_MAINTENANCE_LOADS_AND_HORIZONTAL_LOAD_ON_RAILINGS_ACC_TO_5_5_3_Q_CM', 'ACTION_CATEGORY_CRANE_LOADS_LIFTING_HOOK_CRANES_OF_WORKING_GRADE_A8_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A1_A3_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A4_A5_Q_CR', 'ACTION_CATEGORY_CRANE_LOADS_WORKING_GRADES_A6_A7_Q_CR', 'ACTION_CATEGORY_HORIZONTAL_EARTHQUAKE_ACTION_EH', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_COTTON_MILLING_WORKSHOP_TABLE_D_0_1_4_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_GRAIN_PROCESSING_WORKSHOP_TABLE_D_0_1_6_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_1_2_4_6_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_3_5_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_MANUFACTURING_WORKSHOP_TABLE_D_0_1_2_ITEM_NO_7_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_METAL_WORKING_WORKSHOP_TABLE_D_0_1_1_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_PREPARATORY_WORKSHOP_FOR_TIRE_PLANT_TABLE_D_0_1_5_Q_IB', 'ACTION_CATEGORY_INDUSTRIAL_BUILDINGS_SEMICONDUCTOR_PRODUCTION_WORKSHOP_TABLE_D_0_1_3_Q_IB', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_HELICOPTER_ON_THE_ROOF_ACC_TO_5_3_2_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_MANNED_ROOF_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_GARDEN_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_ROOF_SPORTS_GROUND_Q_LR', 'ACTION_CATEGORY_LIVE_LOADS_ON_ROOFS_UNMANNED_ROOF_Q_LR', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_III_S', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_II_S', 'ACTION_CATEGORY_SNOW_LOAD_ZONE_I_S', 'ACTION_CATEGORY_THERMAL_ACTION_ACCORDING_TO_9_1_3_T', 'ACTION_CATEGORY_VERTICAL_EARTHQUAKE_ACTION_EV', 'ACTION_CATEGORY_WIND_LOAD_ACCORDING_TO_8_1_4_W'], '6517': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6518': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_INACCESSIBLE_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_HELICOPTER_QI_K', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_K_FLAT_ROOFS_OTHER_QI_K', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6522': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6523': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6524': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6525': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_OTHER_ACTIONS_QO', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6526': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6527': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H',
        'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6529': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_FINLAND_ICELAND_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6528': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6530': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6531':
        ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ACTIONS_DURING_EXECUTION_Q_EX', 'ACTION_CATEGORY_FOUNDATION_SUBSIDENCE_QF', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PERMANENT_SMALL_FLUCTUATIONS_G_ASTERISK', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6532': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_RAIN_LOAD_QR', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6533': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_I_ROOFS_HELICOPTER_QI_I', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_J_ROOFS_HELIPORT_EQUIPMENT_QI_J', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_SNOW_REGION_SAINT_PIERRE_AND_MIQUELON_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6534': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6535': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6536': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6537': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6538': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_ICE_QI', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_OUTDOOR_TERRACES_AND_BALCONIES_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_THAN_2_75_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_LESS_OR_EQUAL_TO_2_75_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6539': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6541': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_1_LESS_OR_EQUAL_TO_SK_LESSER_THAN_2_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_2_LESS_OR_EQUAL_TO_SK_LESSER_THAN_3_KN_M2_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_SK_GREATER_OR_EQUAL_TO_3_KN_M2_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6521': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6542': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6543': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6544': ['ACTION_CATEGORY_ACCIDENTAL_ACTIONS_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_A_DOMESTIC_RESIDENTIAL_AREAS_QI_A', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_B_OFFICE_AREAS_QI_B', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_C_CONGREGATION_AREAS_QI_C', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_D_SHOPPING_AREAS_QI_D', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_E_STORAGE_AREAS_QI_E', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_F_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_30_KN_QI_F',
        'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_G_TRAFFIC_AREA_VEHICLE_WEIGHT_LESS_OR_EQUAL_TO_160_KN_QI_G', 'ACTION_CATEGORY_IMPOSED_LOADS_CATEGORY_H_ROOFS_QI_H', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_PERMANENT_IMPOSED_GQ', 'ACTION_CATEGORY_PRESTRESS_P', 'ACTION_CATEGORY_SEISMIC_ACTIONS_AE', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_GREATER_THAN_1000_M_QS', 'ACTION_CATEGORY_SNOW_ICE_LOADS_H_LESS_OR_EQUAL_TO_1000_M_QS', 'ACTION_CATEGORY_TEMPERATURE_NON_FIRE_QT', 'ACTION_CATEGORY_WIND_QW'], '6546': ['ACTION_CATEGORY_EARTH_PRESSURE_FE', 'ACTION_CATEGORY_GROUND_WATER_FGW', 'ACTION_CATEGORY_ICE_ACTION_FICE', 'ACTION_CATEGORY_IMPOSED_ACTION_Q', 'ACTION_CATEGORY_LIQUID_PRESSURE_FLP', 'ACTION_CATEGORY_NONE_NONE', 'ACTION_CATEGORY_PERMANENT_G', 'ACTION_CATEGORY_RAINWATER_PONDING_FPND', 'ACTION_CATEGORY_SERVICEABILITY_EARTHQUAKE_ACTION_ES', 'ACTION_CATEGORY_SERVICEABILITY_WIND_ACTION_WS', 'ACTION_CATEGORY_SNOW_ACTION_FSN', 'ACTION_CATEGORY_THERMAL_ACTIONS_ARISING_FROM_THE_FIRE_T', 'ACTION_CATEGORY_ULTIMATE_EARTHQUAKE_ACTION_EU', 'ACTION_CATEGORY_ULTIMATE_WIND_ACTION_WU']}

        standardCode = model.clientModel.service.get_load_cases_and_combinations().current_standard_for_combination_wizard

        return actionCategoryDictionary[str(standardCode)]
