/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.MFC;
import org.jgroups.util.CreditMap;
import org.jgroups.util.NonBlockingCreditMap;
import org.jgroups.util.Tuple;

@MBean(description="Simple non-blocking flow control protocol based on a credit system")
public class MFC_NB
extends MFC {
    @Property(description="Max number of bytes of all queued messages for a given destination. If a given destination has no credits left and the message cannot be added to the queue because it is full, then the sender thread will be blocked until there is again space available in the queue, or the protocol is stopped.")
    protected int max_queue_size = 10000000;
    protected final Consumer<Message> send_function = msg -> this.down_prot.down((Message)msg);
    protected Future<?> credit_send_task;

    public int getMaxQueueSize() {
        return this.max_queue_size;
    }

    public MFC_NB setMaxQueueSize(int s2) {
        this.max_queue_size = s2;
        return this;
    }

    @ManagedAttribute(description="Whether or not messages are currently being queued due to insufficient credits")
    public boolean isQueuing() {
        return ((NonBlockingCreditMap)this.credits).isQueuing();
    }

    @ManagedAttribute(description="The number of messages currently queued due to insufficient credit")
    public int getNumberOfQueuedMessages() {
        return ((NonBlockingCreditMap)this.credits).getQueuedMessages();
    }

    @ManagedAttribute(description="The total size of all currently queued messages")
    public int getQueuedSize() {
        return ((NonBlockingCreditMap)this.credits).getQueuedMessageSize();
    }

    @ManagedAttribute(description="The number of times messages have been queued due to insufficient credits")
    public int getNumberOfQueuings() {
        return ((NonBlockingCreditMap)this.credits).getEnqueuedMessages();
    }

    @Override
    protected CreditMap createCreditMap(long max_creds) {
        return new NonBlockingCreditMap(max_creds, this.max_queue_size, new ReentrantLock(true), this.send_function);
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.max_block_time > 0L) {
            this.credit_send_task = this.getTransport().getTimer().scheduleWithFixedDelay(this::sendCreditRequestsIfNeeded, this.max_block_time, this.max_block_time, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.credit_send_task != null) {
            this.credit_send_task.cancel(true);
        }
    }

    @Override
    protected Object handleDownMessage(Message msg) {
        Address dest = msg.dest();
        if (dest != null) {
            return this.down_prot.down(msg);
        }
        int length = msg.length();
        if (this.running) {
            if (this.credits.decrement(msg, length, 0L)) {
                return this.down_prot.down(msg);
            }
            if (this.needToSendCreditRequest()) {
                List<Tuple<Address, Long>> targets = this.credits.getMembersWithCreditsLessThan(this.min_credits);
                for (Tuple<Address, Long> tuple : targets) {
                    this.sendCreditRequest(tuple.getVal1(), Math.min(this.max_credits, this.max_credits - tuple.getVal2()));
                }
            }
            return null;
        }
        return this.down_prot.down(msg);
    }

    protected void sendCreditRequestsIfNeeded() {
        if (this.credits.getMinCredits() < this.min_credits && this.needToSendCreditRequest()) {
            List<Tuple<Address, Long>> targets = this.credits.getMembersWithCreditsLessThan(this.min_credits);
            for (Tuple<Address, Long> tuple : targets) {
                this.sendCreditRequest(tuple.getVal1(), Math.min(this.max_credits, this.max_credits - tuple.getVal2()));
            }
        }
    }
}

