/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.xsite.irac.IracManagerKeyInfo;

public class IracManagerKeyInfoImpl
implements IracManagerKeyInfo {
    private final int segment;
    private final Object key;
    private final Object owner;

    public IracManagerKeyInfoImpl(int segment, Object key, Object owner) {
        this.segment = segment;
        this.key = Objects.requireNonNull(key);
        this.owner = Objects.requireNonNull(owner);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IracManagerKeyInfo)) {
            return false;
        }
        IracManagerKeyInfo that = (IracManagerKeyInfo)o;
        if (this.segment != that.getSegment()) {
            return false;
        }
        if (!this.key.equals(that.getKey())) {
            return false;
        }
        return this.owner.equals(that.getOwner());
    }

    public int hashCode() {
        int result = this.segment;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.owner.hashCode();
        return result;
    }

    public static void writeTo(ObjectOutput output, IracManagerKeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            output.writeObject(null);
            return;
        }
        output.writeObject(keyInfo.getKey());
        UnsignedNumeric.writeUnsignedInt(output, keyInfo.getSegment());
        output.writeObject(keyInfo.getOwner());
    }

    public static IracManagerKeyInfo readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        Object key = input.readObject();
        if (key == null) {
            return null;
        }
        return new IracManagerKeyInfoImpl(UnsignedNumeric.readUnsignedInt(input), key, input.readObject());
    }
}

