/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SegmentedEntryStreamSupplier<K, V>
implements AbstractLocalCacheStream.StreamSupplier<CacheEntry<K, V>, Stream<CacheEntry<K, V>>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Cache<K, V> cache;
    private final ToIntFunction<Object> toIntFunction;
    private final InternalDataContainer<K, V> internalDataContainer;

    public SegmentedEntryStreamSupplier(Cache<K, V> cache, ToIntFunction<Object> toIntFunction, InternalDataContainer<K, V> internalDataContainer) {
        this.cache = cache;
        this.toIntFunction = toIntFunction;
        this.internalDataContainer = internalDataContainer;
    }

    @Override
    public Stream<CacheEntry<K, V>> buildStream(IntSet segmentsToFilter, Set<?> keysToFilter, boolean parallel) {
        Stream<CacheEntry<K, V>> stream;
        if (keysToFilter != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Applying key filtering %s", (Object)keysToFilter);
            }
            AdvancedCache<K, V> advancedCache = AbstractDelegatingCache.unwrapCache(this.cache).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
            Stream keyStream = parallel ? keysToFilter.parallelStream() : keysToFilter.stream();
            stream = keyStream.map(advancedCache::getCacheEntry).filter(Objects::nonNull);
            if (segmentsToFilter != null && this.toIntFunction != null) {
                if (log.isTraceEnabled()) {
                    log.tracef("Applying segment filter %s", (Object)segmentsToFilter);
                }
                stream = stream.filter(k -> {
                    Object key = k.getKey();
                    int segment = this.toIntFunction.applyAsInt(key);
                    boolean isPresent = segmentsToFilter.contains(segment);
                    if (log.isTraceEnabled()) {
                        log.tracef("Is key %s present in segment %d? %b", key, (Object)segment, (Object)isPresent);
                    }
                    return isPresent;
                });
            }
        } else {
            stream = segmentsToFilter != null ? StreamSupport.stream(this.cast(this.internalDataContainer.spliterator(segmentsToFilter)), parallel) : StreamSupport.stream(this.cast(this.internalDataContainer.spliterator()), parallel);
            if (this.cache.getCacheConfiguration().clustering().cacheMode().isScattered()) {
                stream = stream.filter(ce -> ce.getValue() != null);
            }
        }
        return stream;
    }

    private Spliterator<CacheEntry<K, V>> cast(Spliterator spliterator) {
        return spliterator;
    }
}

