/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.infinispan.commons.jdkspecific.CallerId;
import org.infinispan.security.CachePermission;

public final class Security {
    private static final ThreadLocal<Boolean> PRIVILEGED = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<Deque<Subject>> SUBJECT = new InheritableThreadLocal<Deque<Subject>>(){

        @Override
        protected Deque<Subject> childValue(Deque<Subject> parentValue) {
            return parentValue == null ? null : new ArrayDeque<Subject>(parentValue);
        }
    };

    private static boolean isTrustedClass(Class<?> klass) {
        String packageName = klass.getPackage().getName();
        return packageName.startsWith("org.infinispan") || packageName.startsWith("org.jboss.as.clustering.infinispan");
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass(3))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        return action.run();
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (!Security.isPrivileged() && Security.isTrustedClass(CallerId.getCallerClass(3))) {
            try {
                PRIVILEGED.set(true);
                T t = action.run();
                return t;
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
            finally {
                PRIVILEGED.remove();
            }
        }
        try {
            return action.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    private static Deque<Subject> pre(Subject subject) {
        if (subject == null) {
            return null;
        }
        Deque<Subject> stack = SUBJECT.get();
        if (stack == null) {
            stack = new ArrayDeque<Subject>(3);
            SUBJECT.set(stack);
        }
        stack.push(subject);
        return stack;
    }

    private static void post(Subject subject, Deque<Subject> stack) {
        if (subject != null) {
            stack.pop();
            if (stack.isEmpty()) {
                SUBJECT.remove();
            }
        }
    }

    public static void doAs(Subject subject, Runnable action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            action.run();
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R doAs(Subject subject, Function<T, R> function, T t) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            R r = function.apply(t);
            return r;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, U, R> R doAs(Subject subject, BiFunction<T, U, R> function, T t, U u) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            R r = function.apply(t, u);
            return r;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        Deque<Subject> stack = Security.pre(subject);
        try {
            T t = action.run();
            return t;
        }
        finally {
            Security.post(subject, stack);
        }
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        Deque<Subject> stack = Security.pre(subject);
        try {
            T t = action.run();
            return t;
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
        finally {
            Security.post(subject, stack);
        }
    }

    public static void checkPermission(CachePermission permission) throws AccessControlException {
        if (!Security.isPrivileged()) {
            throw new AccessControlException("Call from unprivileged code", permission);
        }
    }

    public static boolean isPrivileged() {
        return PRIVILEGED.get();
    }

    public static Subject getSubject() {
        Deque<Subject> subjects = SUBJECT.get();
        if (subjects != null && !subjects.isEmpty()) {
            return subjects.peek();
        }
        AccessControlContext acc = AccessController.getContext();
        if (System.getSecurityManager() == null) {
            return Subject.getSubject(acc);
        }
        return AccessController.doPrivileged(() -> Subject.getSubject(acc));
    }

    public static Principal getSubjectUserPrincipal(Subject s2) {
        if (s2 != null && !s2.getPrincipals().isEmpty()) {
            return s2.getPrincipals().iterator().next();
        }
        return null;
    }

    public static String toString(Subject subject) {
        StringBuilder sb = new StringBuilder("Subject: [");
        boolean comma = false;
        for (Principal p : subject.getPrincipals()) {
            if (comma) {
                sb.append(" ,");
            }
            sb.append(p.toString());
            comma = true;
        }
        return sb.append(']').toString();
    }
}

