/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.AbstractInvocationContextFactory;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;

@Scope(value=Scopes.NAMED_CACHE)
public class TransactionalInvocationContextFactory
extends AbstractInvocationContextFactory {
    @Inject
    TransactionManager tm;
    @Inject
    TransactionTable transactionTable;
    @Inject
    BatchContainer batchContainer;
    private boolean batchingEnabled;

    @Start
    public void start() {
        this.batchingEnabled = this.config.invocationBatching().enabled();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        return this.newNonTxInvocationContext(null);
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        return new SingleKeyNonTxInvocationContext(null);
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        Transaction runningTx = this.getRunningTx();
        if (runningTx == null && !isWrite) {
            if (keyCount == 1) {
                return this.createSingleKeyNonTxInvocationContext();
            }
            return this.newNonTxInvocationContext(null);
        }
        return this.createInvocationContext(runningTx, false);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx, boolean implicitTransaction) {
        if (tx == null) {
            throw new IllegalArgumentException("Cannot create a transactional context without a valid Transaction instance.");
        }
        LocalTransaction localTransaction = this.transactionTable.getOrCreateLocalTransaction(tx, implicitTransaction);
        return new LocalTxInvocationContext(localTransaction);
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext(LocalTransaction localTransaction) {
        return new LocalTxInvocationContext(localTransaction);
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        RemoteTxInvocationContext ctx = new RemoteTxInvocationContext(tx);
        return ctx;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        return this.newNonTxInvocationContext(origin);
    }

    private Transaction getRunningTx() {
        try {
            Transaction transaction = null;
            if (this.batchingEnabled) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            if (transaction == null) {
                transaction = this.tm.getTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }

    protected final NonTxInvocationContext newNonTxInvocationContext(Address origin) {
        NonTxInvocationContext ctx = new NonTxInvocationContext(origin);
        return ctx;
    }
}

