/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.stream.LongStream;
import org.infinispan.commons.util.Util;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnsafeHolder;
import sun.misc.Unsafe;

public class MemoryAddressHash {
    private static final Unsafe UNSAFE = UnsafeHolder.UNSAFE;
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private final long memory;
    private final int pointerCount;
    private final OffHeapMemoryAllocator allocator;

    public MemoryAddressHash(int pointers, OffHeapMemoryAllocator allocator) {
        this.pointerCount = Util.findNextHighestPowerOfTwo(pointers);
        long bytes = (long)this.pointerCount << 3;
        this.allocator = allocator;
        this.memory = allocator.allocate(bytes);
        UNSAFE.setMemory(this.memory, bytes, (byte)0);
    }

    public void putMemoryAddressOffset(int offset, long address) {
        MEMORY.putLong(this.memory, offset << 3, address);
    }

    public long getMemoryAddressOffset(int offset) {
        return MEMORY.getLong(this.memory, (long)offset << 3);
    }

    public long getMemoryAddressOffsetNoTraceIfAbsent(int offset) {
        return MEMORY.getLongNoTraceIfAbsent(this.memory, (long)offset << 3);
    }

    public void deallocate() {
        this.allocator.deallocate(this.memory, this.pointerCount << 3);
    }

    public LongStream toStream() {
        return LongStream.iterate(0L, l -> l + 8L).limit(this.pointerCount).map(l -> MEMORY.getLong(this.memory, l)).filter(l -> l != 0L);
    }

    public LongStream removeAll() {
        return LongStream.iterate(0L, l -> l + 8L).limit(this.pointerCount).map(l -> MEMORY.getAndSetLongNoTraceIfAbsent(this.memory, l, 0L)).filter(l -> l != 0L);
    }

    public LongStream removeAll(int offset, int count) {
        return LongStream.iterate((long)offset << 3, l -> l + 8L).limit(count).map(l -> MEMORY.getAndSetLongNoTraceIfAbsent(this.memory, l, 0L)).filter(l -> l != 0L);
    }

    public int getPointerCount() {
        return this.pointerCount;
    }
}

