/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfiguration
extends ConfigurationElement<TransactionConfiguration> {
    public static final AttributeDefinition<Boolean> AUTO_COMMIT = AttributeDefinition.builder(Attribute.AUTO_COMMIT, Boolean.valueOf(true)).immutable().build();
    public static final AttributeDefinition<Long> CACHE_STOP_TIMEOUT = AttributeDefinition.builder(Attribute.STOP_TIMEOUT, Long.valueOf(TimeUnit.SECONDS.toMillis(30L))).build();
    public static final AttributeDefinition<LockingMode> LOCKING_MODE = AttributeDefinition.builder(Attribute.LOCKING, LockingMode.OPTIMISTIC).immutable().build();
    public static final AttributeDefinition<TransactionManagerLookup> TRANSACTION_MANAGER_LOOKUP = AttributeDefinition.builder(Attribute.TRANSACTION_MANAGER_LOOKUP_CLASS, GenericTransactionManagerLookup.INSTANCE).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).autoPersist(false).global(false).immutable().build();
    public static final AttributeDefinition<TransactionSynchronizationRegistryLookup> TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP = AttributeDefinition.builder("transaction-synchronization-registry-lookup", null, TransactionSynchronizationRegistryLookup.class).copier(IdentityAttributeCopier.identityCopier()).autoPersist(false).immutable().build();
    public static final AttributeDefinition<TransactionMode> TRANSACTION_MODE = AttributeDefinition.builder(Attribute.MODE, TransactionMode.NON_TRANSACTIONAL).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> USE_SYNCHRONIZATION = AttributeDefinition.builder("synchronization", Boolean.valueOf(false)).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Boolean> USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS = AttributeDefinition.builder("single-phase-auto-commit", Boolean.valueOf(false)).build();
    public static final AttributeDefinition<Long> REAPER_WAKE_UP_INTERVAL = AttributeDefinition.builder(Attribute.REAPER_WAKE_UP_INTERVAL, Long.valueOf(30000L)).immutable().build();
    public static final AttributeDefinition<Long> COMPLETED_TX_TIMEOUT = AttributeDefinition.builder(Attribute.COMPLETED_TX_TIMEOUT, Long.valueOf(60000L)).immutable().build();
    public static final AttributeDefinition<Boolean> NOTIFICATIONS = AttributeDefinition.builder(Attribute.NOTIFICATIONS, Boolean.valueOf(true)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> autoCommit;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> cacheStopTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<LockingMode> lockingMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<TransactionManagerLookup> transactionManagerLookup;
    private final org.infinispan.commons.configuration.attributes.Attribute<TransactionSynchronizationRegistryLookup> transactionSynchronizationRegistryLookup;
    private final org.infinispan.commons.configuration.attributes.Attribute<TransactionMode> transactionMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> useSynchronization;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> use1PcForAutoCommitTransactions;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> reaperWakeUpInterval;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> completedTxTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> notifications;
    private final RecoveryConfiguration recovery;
    private final boolean invocationBatching;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TransactionConfiguration.class, AUTO_COMMIT, CACHE_STOP_TIMEOUT, LOCKING_MODE, TRANSACTION_MANAGER_LOOKUP, TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP, TRANSACTION_MODE, USE_SYNCHRONIZATION, USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS, REAPER_WAKE_UP_INTERVAL, COMPLETED_TX_TIMEOUT, NOTIFICATIONS);
    }

    TransactionConfiguration(AttributeSet attributes, RecoveryConfiguration recovery, boolean invocationBatching) {
        super(Element.TRANSACTION, attributes, recovery);
        this.autoCommit = attributes.attribute(AUTO_COMMIT);
        this.cacheStopTimeout = attributes.attribute(CACHE_STOP_TIMEOUT);
        this.lockingMode = attributes.attribute(LOCKING_MODE);
        this.transactionManagerLookup = attributes.attribute(TRANSACTION_MANAGER_LOOKUP);
        this.transactionSynchronizationRegistryLookup = attributes.attribute(TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP);
        this.transactionMode = attributes.attribute(TRANSACTION_MODE);
        this.useSynchronization = attributes.attribute(USE_SYNCHRONIZATION);
        this.use1PcForAutoCommitTransactions = attributes.attribute(USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS);
        this.reaperWakeUpInterval = attributes.attribute(REAPER_WAKE_UP_INTERVAL);
        this.completedTxTimeout = attributes.attribute(COMPLETED_TX_TIMEOUT);
        this.notifications = attributes.attribute(NOTIFICATIONS);
        this.recovery = recovery;
        this.invocationBatching = invocationBatching;
    }

    public boolean autoCommit() {
        return this.autoCommit.get();
    }

    public TransactionConfiguration cacheStopTimeout(long l) {
        this.cacheStopTimeout.set(l);
        return this;
    }

    public long cacheStopTimeout() {
        return this.cacheStopTimeout.get();
    }

    public LockingMode lockingMode() {
        return this.lockingMode.get();
    }

    public TransactionConfiguration lockingMode(LockingMode lockingMode) {
        this.lockingMode.set(lockingMode);
        return this;
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return this.transactionManagerLookup.get();
    }

    public TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup() {
        return this.transactionSynchronizationRegistryLookup.get();
    }

    public TransactionMode transactionMode() {
        return this.transactionMode.get();
    }

    public boolean useSynchronization() {
        return this.useSynchronization.get();
    }

    public RecoveryConfiguration recovery() {
        return this.recovery;
    }

    public long reaperWakeUpInterval() {
        return this.reaperWakeUpInterval.get();
    }

    public long completedTxTimeout() {
        return this.completedTxTimeout.get();
    }

    public boolean use1PcForAutoCommitTransactions() {
        return this.use1PcForAutoCommitTransactions.get();
    }

    public boolean notifications() {
        return this.notifications.get();
    }
}

