/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.FileLookup;

public abstract class AbstractFileLookup
implements FileLookup {
    private static final Log log = LogFactory.getLog(AbstractFileLookup.class);

    @Override
    public InputStream lookupFile(String filename, ClassLoader cl) {
        try {
            return this.lookupFileStrict(filename, cl);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected abstract InputStream getAsInputStreamFromClassLoader(String var1, ClassLoader var2);

    @Override
    public InputStream lookupFileStrict(String filename, ClassLoader cl) throws FileNotFoundException {
        InputStream is;
        InputStream inputStream2 = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename, cl);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debugf("Unable to find file %s in classpath; searching for this file on the filesystem instead.", (Object)filename);
            }
            return new FileInputStream(filename);
        }
        return is;
    }

    @Override
    public InputStream lookupFileStrict(URI uri, ClassLoader cl) throws FileNotFoundException {
        String scheme;
        switch (scheme = uri.getScheme()) {
            case "file": {
                return new FileInputStream(new File(uri.getPath()));
            }
            case "jar": {
                String uriAsString = uri.toString();
                String insideJarFilePath = uriAsString.substring(uriAsString.lastIndexOf("!") + 1);
                InputStream streamToBeReturned = this.getAsInputStreamFromClassLoader(insideJarFilePath, cl);
                if (streamToBeReturned == null) {
                    throw Log.CONTAINER.unableToLoadFileUsingScheme(scheme);
                }
                return streamToBeReturned;
            }
        }
        InputStream streamToBeReturned = this.getAsInputStreamFromClassLoader(uri.toString(), cl);
        if (streamToBeReturned == null) {
            throw Log.CONTAINER.unableToLoadFileUsingScheme(scheme);
        }
        return streamToBeReturned;
    }

    @Override
    public URL lookupFileLocation(String filename, ClassLoader cl) {
        File f;
        URL u = this.getAsURLFromClassLoader(filename, cl);
        if (u == null && (f = new File(filename)).exists()) {
            try {
                u = f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return u;
    }

    protected abstract URL getAsURLFromClassLoader(String var1, ClassLoader var2);

    @Override
    public Collection<URL> lookupFileLocations(String filename, ClassLoader cl) throws IOException {
        Collection<URL> u = this.getAsURLsFromClassLoader(filename, cl);
        File f = new File(filename);
        if (f.exists()) {
            try {
                u.add(f.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return u;
    }

    protected abstract Collection<URL> getAsURLsFromClassLoader(String var1, ClassLoader var2) throws IOException;
}

