/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;

public final class StandardConversions {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static Object convertTextToText(Object source2, MediaType sourceType, MediaType destinationType) {
        Charset destinationCharset;
        if (source2 == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (!sourceType.match(MediaType.TEXT_PLAIN)) {
            throw Log.CONTAINER.invalidMediaType("text/plain", sourceType.toString());
        }
        boolean asString2 = destinationType.hasStringType();
        Charset sourceCharset = sourceType.getCharset();
        if (sourceCharset.equals(destinationCharset = destinationType.getCharset())) {
            return StandardConversions.convertTextClass(source2, destinationType, asString2);
        }
        byte[] byteContent = source2 instanceof byte[] ? (byte[])source2 : source2.toString().getBytes(sourceCharset);
        return StandardConversions.convertTextClass(StandardConversions.convertCharset(byteContent, sourceCharset, destinationCharset), destinationType, asString2);
    }

    private static Object convertTextClass(Object text, MediaType destination, boolean asString2) {
        if (asString2) {
            return text instanceof byte[] ? new String((byte[])text, destination.getCharset()) : text.toString();
        }
        return text instanceof byte[] ? text : (Object)text.toString().getBytes(destination.getCharset());
    }

    @Deprecated
    public static byte[] convertTextToOctetStream(Object source2, MediaType sourceType) {
        if (source2 == null) {
            return null;
        }
        if (sourceType == null) {
            throw new NullPointerException("MediaType cannot be null!");
        }
        if (source2 instanceof byte[]) {
            return (byte[])source2;
        }
        return source2.toString().getBytes(sourceType.getCharset());
    }

    public static String convertTextToObject(Object source2, MediaType sourceType) {
        if (source2 == null) {
            return null;
        }
        if (source2 instanceof String) {
            return source2.toString();
        }
        if (source2 instanceof byte[]) {
            byte[] bytesSource = (byte[])source2;
            return new String(bytesSource, sourceType.getCharset());
        }
        throw Log.CONTAINER.invalidTextContent(source2);
    }

    @Deprecated
    public static String convertTextToUrlEncoded(Object source2, MediaType sourceType) {
        return StandardConversions.urlEncode(source2, sourceType);
    }

    @Deprecated
    public static byte[] convertOctetStreamToText(byte[] source2, MediaType destination) {
        if (source2 == null) {
            return null;
        }
        return StandardConversions.convertCharset(source2, StandardCharsets.UTF_8, destination.getCharset());
    }

    @Deprecated
    public static Object convertOctetStreamToJava(byte[] source2, MediaType destination, Marshaller marshaller) {
        if (source2 == null) {
            return null;
        }
        if (!destination.match(MediaType.APPLICATION_OBJECT)) {
            throw Log.CONTAINER.invalidMediaType("application/x-java-object", destination.toString());
        }
        String classType = destination.getClassType();
        if (classType == null) {
            return source2;
        }
        if (classType.equals("ByteArray")) {
            return source2;
        }
        if (destination.hasStringType()) {
            return new String(source2, StandardCharsets.UTF_8);
        }
        try {
            return marshaller.objectFromByteBuffer(source2);
        }
        catch (IOException | ClassNotFoundException | IllegalStateException e) {
            throw Log.CONTAINER.conversionNotSupported(source2, "application/octet-stream", destination.toString());
        }
    }

    @Deprecated
    public static byte[] convertJavaToOctetStream(Object source2, MediaType sourceMediaType, Marshaller marshaller) throws IOException, InterruptedException {
        if (source2 == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("sourceMediaType not conforming to application/x-java-object!");
        }
        return marshaller.objectToByteBuffer(StandardConversions.decodeObjectContent(source2, sourceMediaType));
    }

    public static byte[] convertJavaToProtoStream(Object source2, MediaType sourceMediaType, ImmutableSerializationContext ctx) throws IOException, InterruptedException {
        if (source2 == null) {
            return null;
        }
        if (!sourceMediaType.match(MediaType.APPLICATION_OBJECT)) {
            throw new EncodingException("sourceMediaType not conforming to application/x-java-object!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source2, sourceMediaType);
        if (decoded instanceof byte[]) {
            return (byte[])decoded;
        }
        if (decoded instanceof String && StandardConversions.isJavaString(sourceMediaType)) {
            return ((String)decoded).getBytes(StandardCharsets.UTF_8);
        }
        return ProtobufUtil.toWrappedByteArray(ctx, source2);
    }

    private static boolean isJavaString(MediaType mediaType) {
        return mediaType.match(MediaType.APPLICATION_OBJECT) && mediaType.hasStringType();
    }

    @Deprecated
    public static byte[] convertJavaToText(Object source2, MediaType sourceMediaType, MediaType destinationMediaType) {
        if (source2 == null) {
            return null;
        }
        if (sourceMediaType == null || destinationMediaType == null) {
            throw new NullPointerException("sourceMediaType and destinationMediaType cannot be null!");
        }
        Object decoded = StandardConversions.decodeObjectContent(source2, sourceMediaType);
        if (decoded instanceof byte[]) {
            return StandardConversions.convertCharset(source2, StandardCharsets.UTF_8, destinationMediaType.getCharset());
        }
        String asString2 = decoded.toString();
        return asString2.getBytes(destinationMediaType.getCharset());
    }

    @Deprecated
    public static Object decodeObjectContent(Object content, MediaType contentMediaType) {
        if (content == null) {
            return null;
        }
        if (contentMediaType == null) {
            throw new NullPointerException("contentMediaType cannot be null!");
        }
        String type = contentMediaType.getClassType();
        if (type == null) {
            return content;
        }
        if (type.equals("ByteArray")) {
            if (content instanceof byte[]) {
                return content;
            }
            if (content instanceof String) {
                return StandardConversions.hexToBytes(content.toString());
            }
            throw new EncodingException("Cannot read ByteArray!");
        }
        String strContent = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
        switch (type) {
            case "java.lang.String": {
                return strContent;
            }
            case "java.lang.Boolean": {
                return Boolean.parseBoolean(strContent);
            }
            case "java.lang.Short": {
                return Short.parseShort(strContent);
            }
            case "java.lang.Byte": {
                return Byte.parseByte(strContent);
            }
            case "java.lang.Integer": {
                return Integer.parseInt(strContent);
            }
            case "java.lang.Long": {
                return Long.parseLong(strContent);
            }
            case "java.lang.Float": {
                return Float.valueOf(Float.parseFloat(strContent));
            }
            case "java.lang.Double": {
                return Double.parseDouble(strContent);
            }
        }
        return content;
    }

    public static byte[] convertCharset(Object content, Charset fromCharset, Charset toCharset) {
        if (content == null) {
            return null;
        }
        if (fromCharset == null || toCharset == null) {
            throw new NullPointerException("Charset cannot be null!");
        }
        byte[] bytes = content instanceof String ? content.toString().getBytes(fromCharset) : (content instanceof byte[] ? (byte[])content : content.toString().getBytes(fromCharset));
        if (fromCharset.equals(toCharset)) {
            return bytes;
        }
        CharBuffer inputContent = fromCharset.decode(ByteBuffer.wrap(bytes));
        ByteBuffer result = toCharset.encode(inputContent);
        return Arrays.copyOf(result.array(), result.limit());
    }

    @Deprecated
    public static byte[] decodeOctetStream(Object input, MediaType octetStream) {
        if (input == null) {
            throw new NullPointerException("input must not be null");
        }
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        if (input instanceof String) {
            String encoding = octetStream.getParameter("encoding").orElse("hex");
            String src = input.toString();
            return encoding.equals("hex") ? StandardConversions.hexToBytes(src) : Base64.getUrlDecoder().decode(src);
        }
        throw new EncodingException("Cannot decode binary content " + input.getClass());
    }

    @Deprecated
    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder r = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            r.append(HEX_DIGITS[b >> 4 & 0xF]);
            r.append(HEX_DIGITS[b & 0xF]);
        }
        return "0x" + r.toString();
    }

    private static int forDigit(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (digit == 'a') {
            return 10;
        }
        if (digit == 'b') {
            return 11;
        }
        if (digit == 'c') {
            return 12;
        }
        if (digit == 'd') {
            return 13;
        }
        if (digit == 'e') {
            return 14;
        }
        if (digit == 'f') {
            return 15;
        }
        throw new EncodingException("Invalid digit found in hex format!");
    }

    @Deprecated
    public static byte[] hexToBytes(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.isEmpty()) {
            return new byte[0];
        }
        if (!hex.startsWith("0x") || hex.length() % 2 != 0) {
            throw new EncodingException("Illegal hex literal!");
        }
        byte[] result = new byte[(hex.length() - 2) / 2];
        for (int i = 2; i < hex.length(); i += 2) {
            byte b;
            int msb = StandardConversions.forDigit(hex.charAt(i));
            int lsb = StandardConversions.forDigit(hex.charAt(i + 1));
            result[(i - 2) / 2] = b = (byte)(msb * 16 + lsb);
        }
        return result;
    }

    @Deprecated
    public static Object convertUrlEncodedToObject(Object content) {
        Object decoded = StandardConversions.urlDecode(content);
        return StandardConversions.convertTextToObject(decoded, MediaType.TEXT_PLAIN);
    }

    @Deprecated
    public static Object convertUrlEncodedToText(Object content, MediaType destinationType) {
        return StandardConversions.convertTextToText(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN, destinationType);
    }

    @Deprecated
    public static Object convertUrlEncodedToOctetStream(Object content) {
        return StandardConversions.convertTextToOctetStream(StandardConversions.urlDecode(content), MediaType.TEXT_PLAIN);
    }

    @Deprecated
    public static String urlEncode(Object content, MediaType mediaType) {
        if (content == null) {
            return null;
        }
        try {
            String asString2 = content instanceof byte[] ? new String((byte[])content, StandardCharsets.UTF_8) : content.toString();
            return URLEncoder.encode(asString2, mediaType.getCharset().toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Log.CONTAINER.errorEncoding(content, MediaType.APPLICATION_WWW_FORM_URLENCODED);
        }
    }

    @Deprecated
    public static Object urlDecode(Object content) {
        try {
            if (content == null) {
                return null;
            }
            if (content instanceof byte[]) {
                byte[] bytesSource = (byte[])content;
                return URLDecoder.decode(new String(bytesSource, StandardCharsets.UTF_8), StandardCharsets.UTF_8.toString());
            }
            return URLDecoder.decode(content.toString(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw Log.CONTAINER.cannotDecodeFormURLContent(content);
        }
    }

    @Deprecated
    public static Object convertOctetStreamToUrlEncoded(Object content, MediaType contentType) {
        byte[] decoded = StandardConversions.decodeOctetStream(content, contentType);
        return StandardConversions.urlEncode(decoded, MediaType.TEXT_PLAIN);
    }
}

