/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;

public final class MediaTypeResolver {
    private static final Map<String, String> FILE_MAP = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getLog(MediaTypeResolver.class);
    private static final String MIME_TYPES = "mime.types";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateFileMap() {
        BufferedInputStream bis;
        InputStream in;
        block5: {
            in = null;
            bis = null;
            try {
                in = MediaTypeResolver.class.getClassLoader().getResourceAsStream(MIME_TYPES);
                if (in == null) {
                    LOG.cannotLoadMimeTypes(MIME_TYPES);
                    break block5;
                }
                bis = new BufferedInputStream(in);
                Scanner scanner = new Scanner((InputStream)bis, StandardCharsets.UTF_8.name());
                while (scanner.hasNextLine()) {
                    String[] split;
                    String line = scanner.nextLine();
                    if (line.startsWith("#") || (split = line.split("\\s+")).length <= 1) continue;
                    String mediaType = split[0];
                    for (int i = 1; i < split.length; ++i) {
                        FILE_MAP.put(split[i], mediaType);
                    }
                }
            }
            catch (Throwable throwable) {
                Util.close(in, bis);
                LOG.debugf("Loaded %s with %d file types", (Object)MIME_TYPES, (Object)FILE_MAP.size());
                throw throwable;
            }
        }
        Util.close(in, bis);
        LOG.debugf("Loaded %s with %d file types", (Object)MIME_TYPES, (Object)FILE_MAP.size());
    }

    private MediaTypeResolver() {
    }

    public static String getMediaType(String fileName) {
        if (fileName == null) {
            return null;
        }
        int idx = fileName.lastIndexOf(".");
        if (idx == -1 || idx == fileName.length()) {
            return null;
        }
        return FILE_MAP.get(fileName.toLowerCase().substring(idx + 1));
    }

    static {
        MediaTypeResolver.populateFileMap();
    }
}

