/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.PersistentUUID;

public class RebalanceStartCommand
extends AbstractCacheControlCommand {
    public static final byte COMMAND_ID = 92;
    private String cacheName;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private CacheTopology.Phase phase;
    private List<Address> actualMembers;
    private List<PersistentUUID> persistentUUIDs;
    private int rebalanceId;
    private int topologyId;
    private int viewId;

    public RebalanceStartCommand() {
        super((byte)92);
    }

    public RebalanceStartCommand(String cacheName, Address origin, CacheTopology cacheTopology, int viewId) {
        super((byte)92, origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
        this.phase = cacheTopology.getPhase();
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.phase, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleRebalance(this.cacheName, topology, this.viewId, this.origin);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public CacheTopology.Phase getPhase() {
        return this.phase;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString(this.cacheName, output);
        output.writeObject(this.currentCH);
        output.writeObject(this.pendingCH);
        MarshallUtil.marshallEnum(this.phase, output);
        MarshallUtil.marshallCollection(this.actualMembers, output);
        MarshallUtil.marshallCollection(this.persistentUUIDs, output);
        output.writeInt(this.topologyId);
        output.writeInt(this.rebalanceId);
        output.writeInt(this.viewId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.cacheName = MarshallUtil.unmarshallString(input);
        this.currentCH = (ConsistentHash)input.readObject();
        this.pendingCH = (ConsistentHash)input.readObject();
        this.phase = MarshallUtil.unmarshallEnum(input, CacheTopology.Phase::valueOf);
        this.actualMembers = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.persistentUUIDs = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.topologyId = input.readInt();
        this.rebalanceId = input.readInt();
        this.viewId = input.readInt();
    }

    public String toString() {
        return "RebalanceStartCommand{cacheName='" + this.cacheName + '\'' + ", origin=" + this.origin + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", phase=" + (Object)((Object)this.phase) + ", actualMembers=" + this.actualMembers + ", persistentUUIDs=" + this.persistentUUIDs + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + '}';
    }
}

