/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;

public final class ReadWriteManyCommand<K, V, R>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 52;
    private Collection<?> keys;
    private Function<EntryView.ReadWriteEntryView<K, V>, R> f;
    boolean isForwarded = false;

    public ReadWriteManyCommand(Collection<?> keys2, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.keys = keys2;
        this.f = f;
    }

    public ReadWriteManyCommand(ReadWriteManyCommand command) {
        super(command);
        this.keys = command.keys;
        this.f = command.f;
    }

    public ReadWriteManyCommand() {
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public Function<EntryView.ReadWriteEntryView<K, V>, R> getFunction() {
        return this.f;
    }

    public void setKeys(Collection<?> keys2) {
        this.keys = keys2;
        this.internalMetadataMap.keySet().retainAll(keys2);
    }

    public final ReadWriteManyCommand<K, V, R> withKeys(Collection<?> keys2) {
        this.setKeys(keys2);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 52;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallCollection(this.keys, output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
        MarshallUtil.marshallMap(this.internalMetadataMap, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.keys = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.f = (Function)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
        this.internalMetadataMap = MarshallUtil.unmarshallMap(input, ConcurrentHashMap::new);
    }

    @Override
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @Override
    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyCommand(ctx, this);
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.keys;
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReadWriteManyCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", f=").append(this.f);
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.keys;
    }

    @Override
    public Mutation toMutation(Object key) {
        return new Mutations.ReadWrite<K, V, R>(this.keyDataConversion, this.valueDataConversion, this.f);
    }
}

