/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XhtmlParser {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final char END_OF_CHARS = '\uffff';
    private Set<String> elements = new HashSet<String>();
    private Set<String> attributes = new HashSet<String>();
    private Map<String, String> entities = new HashMap<String, String>();
    private ParserSecurityPolicy policy = ParserSecurityPolicy.Accept;
    private boolean trimWhitespace;
    private boolean mustBeWellFormed = true;
    private boolean validatorMode;
    private Reader rdr;
    private String cache = "";
    private XhtmlNode unwindPoint;
    private String lastText = "";
    private int line = 1;
    private int col = 0;
    private char lastChar;
    private XhtmlNode.Location lastLoc;

    public XhtmlParser() {
        this.elements.add("p");
        this.elements.add("br");
        this.elements.add("div");
        this.elements.add("h1");
        this.elements.add("h2");
        this.elements.add("h3");
        this.elements.add("h4");
        this.elements.add("h5");
        this.elements.add("h6");
        this.elements.add("a");
        this.elements.add("span");
        this.elements.add("b");
        this.elements.add("em");
        this.elements.add("i");
        this.elements.add("strong");
        this.elements.add("small");
        this.elements.add("big");
        this.elements.add("tt");
        this.elements.add("small");
        this.elements.add("dfn");
        this.elements.add("q");
        this.elements.add("var");
        this.elements.add("abbr");
        this.elements.add("acronym");
        this.elements.add("cite");
        this.elements.add("blockquote");
        this.elements.add("hr");
        this.elements.add("address");
        this.elements.add("bdo");
        this.elements.add("kbd");
        this.elements.add("q");
        this.elements.add("sub");
        this.elements.add("sup");
        this.elements.add("ul");
        this.elements.add("ol");
        this.elements.add("li");
        this.elements.add("dl");
        this.elements.add("dt");
        this.elements.add("dd");
        this.elements.add("pre");
        this.elements.add("table");
        this.elements.add("caption");
        this.elements.add("colgroup");
        this.elements.add("col");
        this.elements.add("thead");
        this.elements.add("tr");
        this.elements.add("tfoot");
        this.elements.add("tbody");
        this.elements.add("th");
        this.elements.add("td");
        this.elements.add("code");
        this.elements.add("samp");
        this.elements.add("img");
        this.elements.add("map");
        this.elements.add("area");
        this.attributes.add("title");
        this.attributes.add("style");
        this.attributes.add("class");
        this.attributes.add("id");
        this.attributes.add("lang");
        this.attributes.add("xml:lang");
        this.attributes.add("dir");
        this.attributes.add("accesskey");
        this.attributes.add("tabindex");
        this.attributes.add("span");
        this.attributes.add("width");
        this.attributes.add("align");
        this.attributes.add("valign");
        this.attributes.add("char");
        this.attributes.add("charoff");
        this.attributes.add("abbr");
        this.attributes.add("axis");
        this.attributes.add("headers");
        this.attributes.add("scope");
        this.attributes.add("rowspan");
        this.attributes.add("colspan");
        this.attributes.add("a.href");
        this.attributes.add("a.name");
        this.attributes.add("img.src");
        this.attributes.add("img.border");
        this.attributes.add("div.xmlns");
        this.attributes.add("blockquote.cite");
        this.attributes.add("q.cite");
        this.attributes.add("a.charset");
        this.attributes.add("a.type");
        this.attributes.add("a.name");
        this.attributes.add("a.href");
        this.attributes.add("a.hreflang");
        this.attributes.add("a.rel");
        this.attributes.add("a.rev");
        this.attributes.add("a.shape");
        this.attributes.add("a.coords");
        this.attributes.add("img.src");
        this.attributes.add("img.alt");
        this.attributes.add("img.longdesc");
        this.attributes.add("img.height");
        this.attributes.add("img.width");
        this.attributes.add("img.usemap");
        this.attributes.add("img.ismap");
        this.attributes.add("map.name");
        this.attributes.add("area.shape");
        this.attributes.add("area.coords");
        this.attributes.add("area.href");
        this.attributes.add("area.nohref");
        this.attributes.add("area.alt");
        this.attributes.add("table.summary");
        this.attributes.add("table.width");
        this.attributes.add("table.border");
        this.attributes.add("table.frame");
        this.attributes.add("table.rules");
        this.attributes.add("table.cellspacing");
        this.attributes.add("table.cellpadding");
        this.defineEntities();
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public boolean isMustBeWellFormed() {
        return this.mustBeWellFormed;
    }

    public XhtmlParser setMustBeWellFormed(boolean mustBeWellFormed) {
        this.mustBeWellFormed = mustBeWellFormed;
        return this;
    }

    public boolean isValidatorMode() {
        return this.validatorMode;
    }

    public XhtmlParser setValidatorMode(boolean validatorMode) {
        this.validatorMode = validatorMode;
        return this;
    }

    public ParserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ParserSecurityPolicy policy) {
        this.policy = policy;
    }

    public XhtmlNode parseHtmlNode(Element node) throws FHIRFormatError {
        return this.parseHtmlNode(node, null);
    }

    public XhtmlNode parseHtmlNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = this.parseNode(node, defaultNS);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(node.getLocalName());
        defaultNS = this.checkNS(res, node, defaultNS);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)node.getAttributes().item(i);
            if (!this.attributeIsOk(res.getName(), attr.getName(), attr.getValue()) || attr.getLocalName().startsWith("xmlns")) continue;
            res.getAttributes().put(attr.getName(), attr.getValue());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                res.addText(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 8) {
                res.addComment(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 1) {
                if (!this.elementIsOk(child.getLocalName())) continue;
                res.getChildNodes().add(this.parseNode((Element)child, defaultNS));
                continue;
            }
            throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(child.getNodeType()) + this.descLoc());
        }
        return res;
    }

    private String checkNS(XhtmlNode res, Element node, String defaultNS) {
        if (!this.validatorMode) {
            return null;
        }
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return null;
        }
        if (!ns.equals(defaultNS)) {
            res.getAttributes().put("xmlns", ns);
            return ns;
        }
        return defaultNS;
    }

    public XhtmlNode parseHtmlNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = this.parseNode(xpp);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(xpp.getName());
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            String an = "xml".equals(xpp.getAttributePrefix(i)) ? "xml:" + xpp.getAttributeName(i) : xpp.getAttributeName(i);
            String av = xpp.getAttributeValue(i);
            if (!this.attributeIsOk(xpp.getName(), an, av)) continue;
            res.getAttributes().put(an, av);
        }
        int eventType = xpp.next();
        while (eventType != 3) {
            if (eventType == 4) {
                res.addText(xpp.getText());
                xpp.next();
            } else if (eventType == 9) {
                res.addComment(xpp.getText());
                xpp.next();
            } else if (eventType == 2) {
                if (this.elementIsOk(xpp.getName())) {
                    res.getChildNodes().add(this.parseNode(xpp));
                }
            } else {
                throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(eventType) + this.descLoc());
            }
            eventType = xpp.getEventType();
        }
        xpp.next();
        return res;
    }

    private boolean attributeIsOk(String elem, String attr, String value) throws FHIRFormatError {
        boolean ok;
        if (this.validatorMode) {
            return true;
        }
        boolean bl = ok = this.attributes.contains(attr) || this.attributes.contains(elem + "." + attr);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new FHIRFormatError("Illegal HTML attribute " + elem + "." + attr);
            }
        }
        if ((elem + "." + attr).equals("img.src") && !value.startsWith("#") && !value.startsWith("http:") && !value.startsWith("https:")) {
            switch (this.policy) {
                case Accept: {
                    return true;
                }
                case Drop: {
                    return false;
                }
                case Reject: {
                    throw new FHIRFormatError("Illegal Image Reference " + value);
                }
            }
        }
        return false;
    }

    private boolean elementIsOk(String name) throws FHIRFormatError {
        if (this.validatorMode) {
            return true;
        }
        boolean ok = this.elements.contains(name);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                throw new FHIRFormatError("Illegal HTML element " + name);
            }
        }
        return false;
    }

    private String descLoc() {
        return " at line " + Integer.toString(this.line) + " column " + Integer.toString(this.col);
    }

    public XhtmlDocument parse(String source2, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new StringReader(source2);
        return this.parse(entryName);
    }

    public XhtmlDocument parse(InputStream input, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new InputStreamReader(input, StandardCharsets.UTF_8);
        return this.parse(entryName);
    }

    private XhtmlDocument parse(String entryName) throws FHIRFormatError, IOException {
        XhtmlDocument result = new XhtmlDocument();
        this.skipWhiteSpaceAndComments(result);
        if (this.peekChar() != '<') {
            throw new FHIRFormatError("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        this.markLocation();
        QName n = new QName(this.readName().toLowerCase());
        if (entryName != null && !n.getName().equals(entryName)) {
            throw new FHIRFormatError("Unable to Parse HTML - starts with '" + n + "' not '" + entryName + "'" + this.descLoc());
        }
        XhtmlNode root = result.addTag(n.getName());
        root.setLocation(this.markLocation());
        this.parseAttributes(root);
        this.markLocation();
        NSMap nsm = this.checkNamespaces(n, root, null, true);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + n + " " + this.descLoc());
            }
            this.readChar();
        } else {
            this.unwindPoint = null;
            ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
            this.parseElementInner(root, p, nsm, true);
        }
        return result;
    }

    private XhtmlNode.Location markLocation() {
        XhtmlNode.Location res = this.lastLoc;
        this.lastLoc = new XhtmlNode.Location(this.line, this.col);
        return res;
    }

    private NSMap checkNamespaces(QName n, XhtmlNode node, NSMap nsm, boolean root) {
        NSMap result = new NSMap(nsm);
        ArrayList<String> nsattrs = new ArrayList<String>();
        for (String an : node.getAttributes().keySet()) {
            if (an.equals("xmlns")) {
                result.def(node.getAttribute(an));
                nsattrs.add(an);
            }
            if (!an.startsWith("xmlns:")) continue;
            result.ns(an.substring(6), node.getAttribute(an));
            nsattrs.add(an);
        }
        for (String s2 : nsattrs) {
            node.getAttributes().remove(s2);
        }
        if (n.hasNs()) {
            String nns = result.get(n.getNs());
            if (!nns.equals(result.def())) {
                node.getAttributes().put("xmlns", nns);
                result.def(nns);
            }
        } else if (root && result.hasDef()) {
            node.getAttributes().put("xmlns", result.def());
        }
        return result;
    }

    private void addTextNode(XhtmlNode node, StringBuilder s2) {
        String t;
        String string = t = this.isTrimWhitespace() ? s2.toString().trim() : s2.toString();
        if (t.length() > 0) {
            this.lastText = t;
            node.addText(t).setLocation(this.markLocation());
            s2.setLength(0);
        }
    }

    private void parseElementInner(XhtmlNode node, List<XhtmlNode> parents, NSMap nsm, boolean escaping) throws FHIRFormatError, IOException {
        StringBuilder s2 = new StringBuilder();
        while (this.peekChar() != '\uffff' && !parents.contains(this.unwindPoint) && node != this.unwindPoint) {
            if (this.peekChar() == '<') {
                this.addTextNode(node, s2);
                this.readChar();
                if (this.peekChar() == '!') {
                    String sc = this.readToCommentEnd();
                    node.addComment(sc).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '?') {
                    node.addComment(this.readToTagEnd()).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '/') {
                    int i;
                    this.readChar();
                    QName n = new QName(this.readToTagEnd());
                    if (node.getName().equals(n.getName())) {
                        return;
                    }
                    if (this.mustBeWellFormed) {
                        throw new FHIRFormatError("Malformed XHTML: Found \"</" + n.getName() + ">\" expecting \"</" + node.getName() + ">\"" + this.descLoc());
                    }
                    for (i = parents.size() - 1; i >= 0; --i) {
                        if (!parents.get(i).getName().equals(n)) continue;
                        this.unwindPoint = parents.get(i);
                    }
                    if (this.unwindPoint == null) continue;
                    for (i = parents.size(); i > 0; --i) {
                        if (i < parents.size() && parents.get(i) == this.unwindPoint) {
                            return;
                        }
                        if (i == parents.size()) {
                            parents.get(i - 1).getChildNodes().addAll(node.getChildNodes());
                            node.getChildNodes().clear();
                            continue;
                        }
                        parents.get(i - 1).getChildNodes().addAll(parents.get(i).getChildNodes());
                        parents.get(i).getChildNodes().clear();
                    }
                    continue;
                }
                if (Character.isLetterOrDigit(this.peekChar())) {
                    this.parseElement(node, parents, nsm);
                    continue;
                }
                throw new FHIRFormatError("Unable to Parse HTML - node '" + node.getName() + "' has unexpected content '" + this.peekChar() + "' (last text = '" + this.lastText + "'" + this.descLoc());
            }
            if (this.peekChar() == '&') {
                this.parseLiteral(s2);
                continue;
            }
            s2.append(this.readChar());
        }
        this.addTextNode(node, s2);
    }

    private void parseElement(XhtmlNode parent, List<XhtmlNode> parents, NSMap nsm) throws IOException, FHIRFormatError {
        this.markLocation();
        QName name = new QName(this.readName());
        XhtmlNode node = parent.addTag(name.getName());
        node.setLocation(this.markLocation());
        ArrayList<XhtmlNode> newParents = new ArrayList<XhtmlNode>();
        newParents.addAll(parents);
        newParents.add(parent);
        this.parseAttributes(node);
        this.markLocation();
        nsm = this.checkNamespaces(name, node, nsm, false);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + name + " " + this.descLoc());
            }
            this.readChar();
        } else {
            this.parseElementInner(node, newParents, nsm, "script".equals(name.getName()));
        }
    }

    private void parseAttributes(XhtmlNode node) throws FHIRFormatError, IOException {
        while (Character.isWhitespace(this.peekChar())) {
            this.readChar();
        }
        while (this.peekChar() != '>' && this.peekChar() != '/' && this.peekChar() != '\uffff') {
            String name = this.readName();
            if (name.length() == 0) {
                throw new FHIRFormatError("Unable to read attribute on <" + node.getName() + ">" + this.descLoc());
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
            if (this.isNameChar(this.peekChar()) || this.peekChar() == '>' || this.peekChar() == '/') {
                node.getAttributes().put(name, null);
            } else {
                if (this.peekChar() != '=') {
                    throw new FHIRFormatError("Unable to read attribute '" + name + "' value on <" + node.getName() + ">" + this.descLoc());
                }
                this.readChar();
                while (Character.isWhitespace(this.peekChar())) {
                    this.readChar();
                }
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    node.getAttributes().put(name, this.parseAttributeValue(this.readChar()));
                } else {
                    node.getAttributes().put(name, this.parseAttributeValue('\uffff'));
                }
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }
    }

    private String parseAttributeValue(char term) throws IOException, FHIRFormatError {
        StringBuilder b = new StringBuilder();
        while (this.peekChar() != '\uffff' && this.peekChar() != '>' && (term != '\uffff' || this.peekChar() != '/') && this.peekChar() != term) {
            if (this.peekChar() == '&') {
                this.parseLiteral(b);
                continue;
            }
            b.append(this.readChar());
        }
        if (this.peekChar() == term) {
            this.readChar();
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipWhiteSpaceAndComments(XhtmlNode focus) throws IOException, FHIRFormatError {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
        if (this.peekChar() != '<') return;
        char ch = this.readChar();
        if (this.peekChar() == '!') {
            this.readChar();
            if (this.peekChar() == '-') {
                this.readChar();
                if (this.peekChar() != '-') throw new FHIRFormatError("unrecognised element type <!" + this.peekChar() + this.descLoc());
                this.readChar();
                if (this.peekChar() == ' ') {
                    this.readChar();
                }
                focus.addComment(this.readToCommentEnd());
            } else {
                focus.addDocType(this.readToDocTypeEnd());
            }
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else if (this.peekChar() == '?') {
            String r = this.readToTagEnd();
            focus.addInstruction(r.substring(1, r.length() - 1));
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else {
            this.pushChar(ch);
        }
    }

    private void skipWhiteSpace() throws IOException {
        if (this.trimWhitespace) {
            while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
                this.readChar();
            }
        }
    }

    private void skipWhiteSpaceInternal() throws IOException {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
    }

    private void pushChar(char ch) {
        this.cache = Character.toString(ch) + this.cache;
    }

    private char peekChar() throws IOException {
        if (this.cache.length() > 0) {
            return this.cache.charAt(0);
        }
        if (!this.rdr.ready()) {
            return '\uffff';
        }
        int i = this.rdr.read();
        if (i == -1) {
            this.cache = "";
            return '\uffff';
        }
        char c = (char)i;
        this.cache = Character.toString(c);
        return c;
    }

    private char readChar() throws IOException {
        char c;
        if (this.cache.length() > 0) {
            c = this.cache.charAt(0);
            this.cache = this.cache.length() == 1 ? "" : this.cache.substring(1);
        } else {
            c = !this.rdr.ready() ? (char)'\uffff' : (char)((char)this.rdr.read());
        }
        if (c == '\r' || c == '\n') {
            if (c == '\r' || this.lastChar != '\r') {
                ++this.line;
                this.col = 0;
            }
            this.lastChar = c;
        }
        ++this.col;
        return c;
    }

    private String readToTagEnd() throws IOException, FHIRFormatError {
        StringBuilder s2 = new StringBuilder();
        while (this.peekChar() != '>' && this.peekChar() != '\uffff') {
            s2.append(this.readChar());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        } else if (this.mustBeWellFormed) {
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s2.toString();
    }

    private String readToDocTypeEnd() throws IOException, FHIRFormatError {
        StringBuilder s2 = new StringBuilder();
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '>') {
                done = true;
                this.readChar();
                continue;
            }
            if (c != '\uffff') {
                s2.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s2.toString();
    }

    private String readToCommentEnd() throws IOException, FHIRFormatError {
        if (this.peekChar() == '!') {
            this.readChar();
        }
        StringBuilder s2 = new StringBuilder();
        boolean simple = true;
        if (this.peekChar() == '-') {
            this.readChar();
            boolean bl = simple = this.peekChar() != '-';
            if (simple) {
                s2.append('-');
            } else {
                this.readChar();
            }
        }
        boolean doctypeEntities = false;
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '-') {
                this.readChar();
                if (this.peekChar() == '-') {
                    this.readChar();
                    if (this.peekChar() == '>') {
                        done = true;
                        continue;
                    }
                    s2.append("--");
                    continue;
                }
                s2.append('-');
                continue;
            }
            if (doctypeEntities && c == ']') {
                s2.append(this.readChar());
                if (this.peekChar() != '>') continue;
                done = true;
                continue;
            }
            if (simple && this.peekChar() == '>' && !doctypeEntities) {
                done = true;
                continue;
            }
            if (c == '[' && s2.toString().startsWith("DOCTYPE ")) {
                doctypeEntities = true;
                s2.append(this.readChar());
                continue;
            }
            if (c != '\uffff') {
                s2.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        }
        if (doctypeEntities) {
            this.parseDoctypeEntities(s2.toString());
        }
        return s2.toString();
    }

    private void parseDoctypeEntities(String s2) {
        while (s2.contains("<!ENTITY")) {
            s2 = s2.substring(s2.indexOf("<!ENTITY"));
            int e = s2.indexOf(">");
            String ed = s2.substring(0, e + 1);
            s2 = s2.substring(e + 1);
            ed = ed.substring(8).trim();
            e = ed.indexOf(" ");
            String n = ed.substring(0, e).trim();
            ed = ed.substring(e).trim();
            e = ed.indexOf(" ");
            ed = ed.substring(e).trim();
            String v = ed.substring(0, ed.length() - 1);
            this.entities.put(n, v);
        }
    }

    private boolean isNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == ':';
    }

    private String readName() throws IOException {
        StringBuilder s2 = new StringBuilder();
        while (this.isNameChar(this.peekChar())) {
            s2.append(this.readChar());
        }
        return s2.toString();
    }

    private String readUntil(char ch) throws IOException {
        StringBuilder s2 = new StringBuilder();
        while (this.peekChar() != '\u0000' && this.peekChar() != ch) {
            s2.append(this.readChar());
        }
        this.readChar();
        return s2.toString();
    }

    private String readUntil(String sc) throws IOException {
        StringBuilder s2 = new StringBuilder();
        while (this.peekChar() != '\u0000' && sc.indexOf(this.peekChar()) == -1) {
            s2.append(this.readChar());
        }
        this.readChar();
        return s2.toString();
    }

    private void parseLiteral(StringBuilder s2) throws IOException, FHIRFormatError {
        this.readChar();
        String c = this.readUntil(";&'\"><");
        if (c.isEmpty()) {
            throw new FHIRFormatError("Invalid literal declaration following text: " + s2);
        }
        if (c.charAt(0) == '#') {
            if (this.isInteger(c.substring(1), 10)) {
                s2.append((char)Integer.parseInt(c.substring(1)));
            } else if (c.charAt(1) == 'x' && this.isInteger(c.substring(2), 16)) {
                s2.append((char)Integer.parseInt(c.substring(2), 16));
            }
        } else if (this.entities.containsKey(c)) {
            s2.append(this.entities.get(c));
        } else if (c.equals("apos")) {
            s2.append('\'');
        } else if (c.equals("quot")) {
            s2.append('\"');
        } else if (c.equals("nbsp")) {
            s2.append(XhtmlNode.NBSP);
        } else if (c.equals("amp")) {
            s2.append('&');
        } else if (c.equals("lsquo")) {
            s2.append('\u2018');
        } else if (c.equals("rsquo")) {
            s2.append('\u2019');
        } else if (c.equals("gt")) {
            s2.append('>');
        } else if (c.equals("lt")) {
            s2.append('<');
        } else if (c.equals("copy")) {
            s2.append('\u00a9');
        } else if (c.equals("reg")) {
            s2.append('\u00ae');
        } else if (c.equals("sect")) {
            s2.append('\u00a7');
        } else if (c.equals("fnof")) {
            s2.append('\u0192');
        } else if (c.equals("Alpha")) {
            s2.append('\u0391');
        } else if (c.equals("Beta")) {
            s2.append('\u0392');
        } else if (c.equals("Gamma")) {
            s2.append('\u0393');
        } else if (c.equals("Delta")) {
            s2.append('\u0394');
        } else if (c.equals("Epsilon")) {
            s2.append('\u0395');
        } else if (c.equals("Zeta")) {
            s2.append('\u0396');
        } else if (c.equals("Eta")) {
            s2.append('\u0397');
        } else if (c.equals("Theta")) {
            s2.append('\u0398');
        } else if (c.equals("Iota")) {
            s2.append('\u0399');
        } else if (c.equals("Kappa")) {
            s2.append('\u039a');
        } else if (c.equals("Lambda")) {
            s2.append('\u039b');
        } else if (c.equals("Mu")) {
            s2.append('\u039c');
        } else if (c.equals("Nu")) {
            s2.append('\u039d');
        } else if (c.equals("Xi")) {
            s2.append('\u039e');
        } else if (c.equals("Omicron")) {
            s2.append('\u039f');
        } else if (c.equals("Pi")) {
            s2.append('\u03a0');
        } else if (c.equals("Rho")) {
            s2.append('\u03a1');
        } else if (c.equals("Sigma")) {
            s2.append('\u03a3');
        } else if (c.equals("Tau")) {
            s2.append('\u03a4');
        } else if (c.equals("Upsilon")) {
            s2.append('\u03a5');
        } else if (c.equals("Phi")) {
            s2.append('\u03a6');
        } else if (c.equals("Chi")) {
            s2.append('\u03a7');
        } else if (c.equals("Psi")) {
            s2.append('\u03a8');
        } else if (c.equals("Omega")) {
            s2.append('\u03a9');
        } else if (c.equals("alpha")) {
            s2.append('\u03b1');
        } else if (c.equals("beta")) {
            s2.append('\u03b2');
        } else if (c.equals("gamma")) {
            s2.append('\u03b3');
        } else if (c.equals("delta")) {
            s2.append('\u03b4');
        } else if (c.equals("epsilon")) {
            s2.append('\u03b5');
        } else if (c.equals("zeta")) {
            s2.append('\u03b6');
        } else if (c.equals("eta")) {
            s2.append('\u03b7');
        } else if (c.equals("theta")) {
            s2.append('\u03b8');
        } else if (c.equals("iota")) {
            s2.append('\u03b9');
        } else if (c.equals("kappa")) {
            s2.append('\u03ba');
        } else if (c.equals("lambda")) {
            s2.append('\u03bb');
        } else if (c.equals("mu")) {
            s2.append('\u03bc');
        } else if (c.equals("nu")) {
            s2.append('\u03bd');
        } else if (c.equals("xi")) {
            s2.append('\u03be');
        } else if (c.equals("omicron")) {
            s2.append('\u03bf');
        } else if (c.equals("pi")) {
            s2.append('\u03c0');
        } else if (c.equals("rho")) {
            s2.append('\u03c1');
        } else if (c.equals("sigmaf")) {
            s2.append('\u03c2');
        } else if (c.equals("sigma")) {
            s2.append('\u03c3');
        } else if (c.equals("tau")) {
            s2.append('\u03c4');
        } else if (c.equals("upsilon")) {
            s2.append('\u03c5');
        } else if (c.equals("phi")) {
            s2.append('\u03c6');
        } else if (c.equals("chi")) {
            s2.append('\u03c7');
        } else if (c.equals("psi")) {
            s2.append('\u03c8');
        } else if (c.equals("omega")) {
            s2.append('\u03c9');
        } else if (c.equals("thetasym")) {
            s2.append('\u03d1');
        } else if (c.equals("upsih")) {
            s2.append('\u03d2');
        } else if (c.equals("piv")) {
            s2.append('\u03d6');
        } else if (c.equals("bull")) {
            s2.append('\u2022');
        } else if (c.equals("hellip")) {
            s2.append('\u2026');
        } else if (c.equals("prime")) {
            s2.append('\u2032');
        } else if (c.equals("Prime")) {
            s2.append('\u2033');
        } else if (c.equals("oline")) {
            s2.append('\u203e');
        } else if (c.equals("frasl")) {
            s2.append('\u2044');
        } else if (c.equals("weierp")) {
            s2.append('\u2118');
        } else if (c.equals("image")) {
            s2.append('\u2111');
        } else if (c.equals("real")) {
            s2.append('\u211c');
        } else if (c.equals("trade")) {
            s2.append('\u2122');
        } else if (c.equals("alefsym")) {
            s2.append('\u2135');
        } else if (c.equals("larr")) {
            s2.append('\u2190');
        } else if (c.equals("uarr")) {
            s2.append('\u2191');
        } else if (c.equals("rarr")) {
            s2.append('\u2192');
        } else if (c.equals("darr")) {
            s2.append('\u2193');
        } else if (c.equals("harr")) {
            s2.append('\u2194');
        } else if (c.equals("crarr")) {
            s2.append('\u21b5');
        } else if (c.equals("lArr")) {
            s2.append('\u21d0');
        } else if (c.equals("uArr")) {
            s2.append('\u21d1');
        } else if (c.equals("rArr")) {
            s2.append('\u21d2');
        } else if (c.equals("dArr")) {
            s2.append('\u21d3');
        } else if (c.equals("hArr")) {
            s2.append('\u21d4');
        } else if (c.equals("forall")) {
            s2.append('\u2200');
        } else if (c.equals("part")) {
            s2.append('\u2202');
        } else if (c.equals("exist")) {
            s2.append('\u2203');
        } else if (c.equals("empty")) {
            s2.append('\u2205');
        } else if (c.equals("nabla")) {
            s2.append('\u2207');
        } else if (c.equals("isin")) {
            s2.append('\u2208');
        } else if (c.equals("notin")) {
            s2.append('\u2209');
        } else if (c.equals("ni")) {
            s2.append('\u220b');
        } else if (c.equals("prod")) {
            s2.append('\u220f');
        } else if (c.equals("sum")) {
            s2.append('\u2211');
        } else if (c.equals("minus")) {
            s2.append('\u2212');
        } else if (c.equals("lowast")) {
            s2.append('\u2217');
        } else if (c.equals("radic")) {
            s2.append('\u221a');
        } else if (c.equals("prop")) {
            s2.append('\u221d');
        } else if (c.equals("infin")) {
            s2.append('\u221e');
        } else if (c.equals("ang")) {
            s2.append('\u2220');
        } else if (c.equals("and")) {
            s2.append('\u2227');
        } else if (c.equals("or")) {
            s2.append('\u2228');
        } else if (c.equals("cap")) {
            s2.append('\u2229');
        } else if (c.equals("cup")) {
            s2.append('\u222a');
        } else if (c.equals("int")) {
            s2.append('\u222b');
        } else if (c.equals("there4")) {
            s2.append('\u2234');
        } else if (c.equals("sim")) {
            s2.append('\u223c');
        } else if (c.equals("cong")) {
            s2.append('\u2245');
        } else if (c.equals("asymp")) {
            s2.append('\u2248');
        } else if (c.equals("ne")) {
            s2.append('\u2260');
        } else if (c.equals("equiv")) {
            s2.append('\u2261');
        } else if (c.equals("le")) {
            s2.append('\u2264');
        } else if (c.equals("ge")) {
            s2.append('\u2265');
        } else if (c.equals("sub")) {
            s2.append('\u2282');
        } else if (c.equals("sup")) {
            s2.append('\u2283');
        } else if (c.equals("nsub")) {
            s2.append('\u2284');
        } else if (c.equals("sube")) {
            s2.append('\u2286');
        } else if (c.equals("supe")) {
            s2.append('\u2287');
        } else if (c.equals("oplus")) {
            s2.append('\u2295');
        } else if (c.equals("otimes")) {
            s2.append('\u2297');
        } else if (c.equals("perp")) {
            s2.append('\u22a5');
        } else if (c.equals("sdot")) {
            s2.append('\u22c5');
        } else if (c.equals("lceil")) {
            s2.append('\u2308');
        } else if (c.equals("rceil")) {
            s2.append('\u2309');
        } else if (c.equals("lfloor")) {
            s2.append('\u230a');
        } else if (c.equals("rfloor")) {
            s2.append('\u230b');
        } else if (c.equals("lang")) {
            s2.append('\u2329');
        } else if (c.equals("rang")) {
            s2.append('\u232a');
        } else if (c.equals("loz")) {
            s2.append('\u25ca');
        } else if (c.equals("spades")) {
            s2.append('\u2660');
        } else if (c.equals("clubs")) {
            s2.append('\u2663');
        } else if (c.equals("hearts")) {
            s2.append('\u2665');
        } else if (c.equals("diams")) {
            s2.append('\u2666');
        } else if (c.equals("ndash")) {
            s2.append('\u2013');
        } else if (c.equals("mdash")) {
            s2.append('\u2014');
        } else if (c.equals("ldquo")) {
            s2.append('\u201d');
        } else if (c.equals("rdquo")) {
            s2.append('\u00c9');
        } else if (c.equals("frac14")) {
            s2.append('\u00bc');
        } else if (!this.mustBeWellFormed) {
            s2.append("&" + c);
        } else {
            throw new FHIRFormatError("unable to parse character reference '" + c + "'' (last text = '" + this.lastText + "'" + this.descLoc());
        }
    }

    private boolean isInteger(String s2, int base) {
        try {
            Integer.parseInt(s2, base);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public XhtmlNode parseFragment(String source2) throws IOException, FHIRException {
        this.rdr = new StringReader(source2);
        return this.parseFragment();
    }

    public XhtmlNode parseFragment(InputStream input) throws IOException, FHIRException {
        this.rdr = new InputStreamReader(input);
        return this.parseFragment();
    }

    private XhtmlNode parseFragment() throws IOException, FHIRException {
        this.skipWhiteSpace();
        if (this.peekChar() != '<') {
            throw new FHIRException("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        if (this.peekChar() == '?') {
            this.readToTagEnd();
            this.skipWhiteSpaceInternal();
            if (this.peekChar() != '<') {
                throw new FHIRException("Unable to Parse HTML - does not start with tag after processing instruction. Found " + this.peekChar() + this.descLoc());
            }
            this.readChar();
        }
        String n = this.readName().toLowerCase();
        this.readToTagEnd();
        XhtmlNode result = new XhtmlNode(NodeType.Element);
        int colonIndex = n.indexOf(58);
        if (colonIndex != -1) {
            n = n.substring(colonIndex + 1);
        }
        result.setName(n);
        this.unwindPoint = null;
        ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
        this.parseElementInner(result, p, null, true);
        return result;
    }

    private void defineEntities() {
        this.entities.put("&AElig;", "\u00c6");
        this.entities.put("&AMP;", "&");
        this.entities.put("&Aacute;", "\u00c1");
        this.entities.put("&Abreve;", "\u0102");
        this.entities.put("&Acirc;", "\u00c2");
        this.entities.put("&Acy;", "\u0410");
        this.entities.put("&Afr;", "\ud835\udd04");
        this.entities.put("&Agrave;", "\u00c0");
        this.entities.put("&Alpha;", "\u0391");
        this.entities.put("&Amacr;", "\u0100");
        this.entities.put("&And;", "\u2a53");
        this.entities.put("&Aogon;", "\u0104");
        this.entities.put("&Aopf;", "\ud835\udd38");
        this.entities.put("&ApplyFunction;", "\u2061");
        this.entities.put("&Aring;", "\u00c5");
        this.entities.put("&Ascr;", "\ud835\udc9c");
        this.entities.put("&Assign;", "\u2254");
        this.entities.put("&Atilde;", "\u00c3");
        this.entities.put("&Auml;", "\u00c4");
        this.entities.put("&Backslash;", "\u2216");
        this.entities.put("&Barv;", "\u2ae7");
        this.entities.put("&Barwed;", "\u2306");
        this.entities.put("&Bcy;", "\u0411");
        this.entities.put("&Because;", "\u2235");
        this.entities.put("&Bernoullis;", "\u212c");
        this.entities.put("&Beta;", "\u0392");
        this.entities.put("&Bfr;", "\ud835\udd05");
        this.entities.put("&Bopf;", "\ud835\udd39");
        this.entities.put("&Breve;", "\u02d8");
        this.entities.put("&Bscr;", "\u212c");
        this.entities.put("&Bumpeq;", "\u224e");
        this.entities.put("&CHcy;", "\u0427");
        this.entities.put("&COPY;", "\u00a9");
        this.entities.put("&Cacute;", "\u0106");
        this.entities.put("&Cap;", "\u22d2");
        this.entities.put("&CapitalDifferentialD;", "\u2145");
        this.entities.put("&Cayleys;", "\u212d");
        this.entities.put("&Ccaron;", "\u010c");
        this.entities.put("&Ccedil;", "\u00c7");
        this.entities.put("&Ccirc;", "\u0108");
        this.entities.put("&Cconint;", "\u2230");
        this.entities.put("&Cdot;", "\u010a");
        this.entities.put("&Cedilla;", "\u00b8");
        this.entities.put("&CenterDot;", "\u00b7");
        this.entities.put("&Cfr;", "\u212d");
        this.entities.put("&Chi;", "\u03a7");
        this.entities.put("&CircleDot;", "\u2299");
        this.entities.put("&CircleMinus;", "\u2296");
        this.entities.put("&CirclePlus;", "\u2295");
        this.entities.put("&CircleTimes;", "\u2297");
        this.entities.put("&ClockwiseContourIntegral;", "\u2232");
        this.entities.put("&CloseCurlyDoubleQuote;", "\u201d");
        this.entities.put("&CloseCurlyQuote;", "\u2019");
        this.entities.put("&Colon;", "\u2237");
        this.entities.put("&Colone;", "\u2a74");
        this.entities.put("&Congruent;", "\u2261");
        this.entities.put("&Conint;", "\u222f");
        this.entities.put("&ContourIntegral;", "\u222e");
        this.entities.put("&Copf;", "\u2102");
        this.entities.put("&Coproduct;", "\u2210");
        this.entities.put("&CounterClockwiseContourIntegral;", "\u2233");
        this.entities.put("&Cross;", "\u2a2f");
        this.entities.put("&Cscr;", "\ud835\udc9e");
        this.entities.put("&Cup;", "\u22d3");
        this.entities.put("&CupCap;", "\u224d");
        this.entities.put("&DD;", "\u2145");
        this.entities.put("&DDotrahd;", "\u2911");
        this.entities.put("&DJcy;", "\u0402");
        this.entities.put("&DScy;", "\u0405");
        this.entities.put("&DZcy;", "\u040f");
        this.entities.put("&Dagger;", "\u2021");
        this.entities.put("&Darr;", "\u21a1");
        this.entities.put("&Dashv;", "\u2ae4");
        this.entities.put("&Dcaron;", "\u010e");
        this.entities.put("&Dcy;", "\u0414");
        this.entities.put("&Del;", "\u2207");
        this.entities.put("&Delta;", "\u0394");
        this.entities.put("&Dfr;", "\ud835\udd07");
        this.entities.put("&DiacriticalAcute;", "\u00b4");
        this.entities.put("&DiacriticalDot;", "\u02d9");
        this.entities.put("&DiacriticalDoubleAcute;", "\u02dd");
        this.entities.put("&DiacriticalGrave;", "`");
        this.entities.put("&DiacriticalTilde;", "\u02dc");
        this.entities.put("&Diamond;", "\u22c4");
        this.entities.put("&DifferentialD;", "\u2146");
        this.entities.put("&Dopf;", "\ud835\udd3b");
        this.entities.put("&Dot;", "\u00a8");
        this.entities.put("&DotDot;", "\u20dc");
        this.entities.put("&DotEqual;", "\u2250");
        this.entities.put("&DoubleContourIntegral;", "\u222f");
        this.entities.put("&DoubleDot;", "\u00a8");
        this.entities.put("&DoubleDownArrow;", "\u21d3");
        this.entities.put("&DoubleLeftArrow;", "\u21d0");
        this.entities.put("&DoubleLeftRightArrow;", "\u21d4");
        this.entities.put("&DoubleLeftTee;", "\u2ae4");
        this.entities.put("&DoubleLongLeftArrow;", "\u27f8");
        this.entities.put("&DoubleLongLeftRightArrow;", "\u27fa");
        this.entities.put("&DoubleLongRightArrow;", "\u27f9");
        this.entities.put("&DoubleRightArrow;", "\u21d2");
        this.entities.put("&DoubleRightTee;", "\u22a8");
        this.entities.put("&DoubleUpArrow;", "\u21d1");
        this.entities.put("&DoubleUpDownArrow;", "\u21d5");
        this.entities.put("&DoubleVerticalBar;", "\u2225");
        this.entities.put("&DownArrow;", "\u2193");
        this.entities.put("&DownArrowBar;", "\u2913");
        this.entities.put("&DownArrowUpArrow;", "\u21f5");
        this.entities.put("&DownBreve;", "\u0311");
        this.entities.put("&DownLeftRightVector;", "\u2950");
        this.entities.put("&DownLeftTeeVector;", "\u295e");
        this.entities.put("&DownLeftVector;", "\u21bd");
        this.entities.put("&DownLeftVectorBar;", "\u2956");
        this.entities.put("&DownRightTeeVector;", "\u295f");
        this.entities.put("&DownRightVector;", "\u21c1");
        this.entities.put("&DownRightVectorBar;", "\u2957");
        this.entities.put("&DownTee;", "\u22a4");
        this.entities.put("&DownTeeArrow;", "\u21a7");
        this.entities.put("&Downarrow;", "\u21d3");
        this.entities.put("&Dscr;", "\ud835\udc9f");
        this.entities.put("&Dstrok;", "\u0110");
        this.entities.put("&ENG;", "\u014a");
        this.entities.put("&ETH;", "\u00d0");
        this.entities.put("&Eacute;", "\u00c9");
        this.entities.put("&Ecaron;", "\u011a");
        this.entities.put("&Ecirc;", "\u00ca");
        this.entities.put("&Ecy;", "\u042d");
        this.entities.put("&Edot;", "\u0116");
        this.entities.put("&Efr;", "\ud835\udd08");
        this.entities.put("&Egrave;", "\u00c8");
        this.entities.put("&Element;", "\u2208");
        this.entities.put("&Emacr;", "\u0112");
        this.entities.put("&EmptySmallSquare;", "\u25fb");
        this.entities.put("&EmptyVerySmallSquare;", "\u25ab");
        this.entities.put("&Eogon;", "\u0118");
        this.entities.put("&Eopf;", "\ud835\udd3c");
        this.entities.put("&Epsilon;", "\u0395");
        this.entities.put("&Equal;", "\u2a75");
        this.entities.put("&EqualTilde;", "\u2242");
        this.entities.put("&Equilibrium;", "\u21cc");
        this.entities.put("&Escr;", "\u2130");
        this.entities.put("&Esim;", "\u2a73");
        this.entities.put("&Eta;", "\u0397");
        this.entities.put("&Euml;", "\u00cb");
        this.entities.put("&Exists;", "\u2203");
        this.entities.put("&ExponentialE;", "\u2147");
        this.entities.put("&Fcy;", "\u0424");
        this.entities.put("&Ffr;", "\ud835\udd09");
        this.entities.put("&FilledSmallSquare;", "\u25fc");
        this.entities.put("&FilledVerySmallSquare;", "\u25aa");
        this.entities.put("&Fopf;", "\ud835\udd3d");
        this.entities.put("&ForAll;", "\u2200");
        this.entities.put("&Fouriertrf;", "\u2131");
        this.entities.put("&Fscr;", "\u2131");
        this.entities.put("&GJcy;", "\u0403");
        this.entities.put("&GT;", ">");
        this.entities.put("&Gamma;", "\u0393");
        this.entities.put("&Gammad;", "\u03dc");
        this.entities.put("&Gbreve;", "\u011e");
        this.entities.put("&Gcedil;", "\u0122");
        this.entities.put("&Gcirc;", "\u011c");
        this.entities.put("&Gcy;", "\u0413");
        this.entities.put("&Gdot;", "\u0120");
        this.entities.put("&Gfr;", "\ud835\udd0a");
        this.entities.put("&Gg;", "\u22d9");
        this.entities.put("&Gopf;", "\ud835\udd3e");
        this.entities.put("&GreaterEqual;", "\u2265");
        this.entities.put("&GreaterEqualLess;", "\u22db");
        this.entities.put("&GreaterFullEqual;", "\u2267");
        this.entities.put("&GreaterGreater;", "\u2aa2");
        this.entities.put("&GreaterLess;", "\u2277");
        this.entities.put("&GreaterSlantEqual;", "\u2a7e");
        this.entities.put("&GreaterTilde;", "\u2273");
        this.entities.put("&Gscr;", "\ud835\udca2");
        this.entities.put("&Gt;", "\u226b");
        this.entities.put("&HARDcy;", "\u042a");
        this.entities.put("&Hacek;", "\u02c7");
        this.entities.put("&Hat;", "^");
        this.entities.put("&Hcirc;", "\u0124");
        this.entities.put("&Hfr;", "\u210c");
        this.entities.put("&HilbertSpace;", "\u210b");
        this.entities.put("&Hopf;", "\u210d");
        this.entities.put("&HorizontalLine;", "\u2500");
        this.entities.put("&Hscr;", "\u210b");
        this.entities.put("&Hstrok;", "\u0126");
        this.entities.put("&HumpDownHump;", "\u224e");
        this.entities.put("&HumpEqual;", "\u224f");
        this.entities.put("&IEcy;", "\u0415");
        this.entities.put("&IJlig;", "\u0132");
        this.entities.put("&IOcy;", "\u0401");
        this.entities.put("&Iacute;", "\u00cd");
        this.entities.put("&Icirc;", "\u00ce");
        this.entities.put("&Icy;", "\u0418");
        this.entities.put("&Idot;", "\u0130");
        this.entities.put("&Ifr;", "\u2111");
        this.entities.put("&Igrave;", "\u00cc");
        this.entities.put("&Im;", "\u2111");
        this.entities.put("&Imacr;", "\u012a");
        this.entities.put("&ImaginaryI;", "\u2148");
        this.entities.put("&Implies;", "\u21d2");
        this.entities.put("&Int;", "\u222c");
        this.entities.put("&Integral;", "\u222b");
        this.entities.put("&Intersection;", "\u22c2");
        this.entities.put("&InvisibleComma;", "\u2063");
        this.entities.put("&InvisibleTimes;", "\u2062");
        this.entities.put("&Iogon;", "\u012e");
        this.entities.put("&Iopf;", "\ud835\udd40");
        this.entities.put("&Iota;", "\u0399");
        this.entities.put("&Iscr;", "\u2110");
        this.entities.put("&Itilde;", "\u0128");
        this.entities.put("&Iukcy;", "\u0406");
        this.entities.put("&Iuml;", "\u00cf");
        this.entities.put("&Jcirc;", "\u0134");
        this.entities.put("&Jcy;", "\u0419");
        this.entities.put("&Jfr;", "\ud835\udd0d");
        this.entities.put("&Jopf;", "\ud835\udd41");
        this.entities.put("&Jscr;", "\ud835\udca5");
        this.entities.put("&Jsercy;", "\u0408");
        this.entities.put("&Jukcy;", "\u0404");
        this.entities.put("&KHcy;", "\u0425");
        this.entities.put("&KJcy;", "\u040c");
        this.entities.put("&Kappa;", "\u039a");
        this.entities.put("&Kcedil;", "\u0136");
        this.entities.put("&Kcy;", "\u041a");
        this.entities.put("&Kfr;", "\ud835\udd0e");
        this.entities.put("&Kopf;", "\ud835\udd42");
        this.entities.put("&Kscr;", "\ud835\udca6");
        this.entities.put("&LJcy;", "\u0409");
        this.entities.put("&LT;", "<");
        this.entities.put("&Lacute;", "\u0139");
        this.entities.put("&Lambda;", "\u039b");
        this.entities.put("&Lang;", "\u27ea");
        this.entities.put("&Laplacetrf;", "\u2112");
        this.entities.put("&Larr;", "\u219e");
        this.entities.put("&Lcaron;", "\u013d");
        this.entities.put("&Lcedil;", "\u013b");
        this.entities.put("&Lcy;", "\u041b");
        this.entities.put("&LeftAngleBracket;", "\u27e8");
        this.entities.put("&LeftArrow;", "\u2190");
        this.entities.put("&LeftArrowBar;", "\u21e4");
        this.entities.put("&LeftArrowRightArrow;", "\u21c6");
        this.entities.put("&LeftCeiling;", "\u2308");
        this.entities.put("&LeftDoubleBracket;", "\u27e6");
        this.entities.put("&LeftDownTeeVector;", "\u2961");
        this.entities.put("&LeftDownVector;", "\u21c3");
        this.entities.put("&LeftDownVectorBar;", "\u2959");
        this.entities.put("&LeftFloor;", "\u230a");
        this.entities.put("&LeftRightArrow;", "\u2194");
        this.entities.put("&LeftRightVector;", "\u294e");
        this.entities.put("&LeftTee;", "\u22a3");
        this.entities.put("&LeftTeeArrow;", "\u21a4");
        this.entities.put("&LeftTeeVector;", "\u295a");
        this.entities.put("&LeftTriangle;", "\u22b2");
        this.entities.put("&LeftTriangleBar;", "\u29cf");
        this.entities.put("&LeftTriangleEqual;", "\u22b4");
        this.entities.put("&LeftUpDownVector;", "\u2951");
        this.entities.put("&LeftUpTeeVector;", "\u2960");
        this.entities.put("&LeftUpVector;", "\u21bf");
        this.entities.put("&LeftUpVectorBar;", "\u2958");
        this.entities.put("&LeftVector;", "\u21bc");
        this.entities.put("&LeftVectorBar;", "\u2952");
        this.entities.put("&Leftarrow;", "\u21d0");
        this.entities.put("&Leftrightarrow;", "\u21d4");
        this.entities.put("&LessEqualGreater;", "\u22da");
        this.entities.put("&LessFullEqual;", "\u2266");
        this.entities.put("&LessGreater;", "\u2276");
        this.entities.put("&LessLess;", "\u2aa1");
        this.entities.put("&LessSlantEqual;", "\u2a7d");
        this.entities.put("&LessTilde;", "\u2272");
        this.entities.put("&Lfr;", "\ud835\udd0f");
        this.entities.put("&Ll;", "\u22d8");
        this.entities.put("&Lleftarrow;", "\u21da");
        this.entities.put("&Lmidot;", "\u013f");
        this.entities.put("&LongLeftArrow;", "\u27f5");
        this.entities.put("&LongLeftRightArrow;", "\u27f7");
        this.entities.put("&LongRightArrow;", "\u27f6");
        this.entities.put("&Longleftarrow;", "\u27f8");
        this.entities.put("&Longleftrightarrow;", "\u27fa");
        this.entities.put("&Longrightarrow;", "\u27f9");
        this.entities.put("&Lopf;", "\ud835\udd43");
        this.entities.put("&LowerLeftArrow;", "\u2199");
        this.entities.put("&LowerRightArrow;", "\u2198");
        this.entities.put("&Lscr;", "\u2112");
        this.entities.put("&Lsh;", "\u21b0");
        this.entities.put("&Lstrok;", "\u0141");
        this.entities.put("&Lt;", "\u226a");
        this.entities.put("&Map;", "\u2905");
        this.entities.put("&Mcy;", "\u041c");
        this.entities.put("&MediumSpace;", "\u205f");
        this.entities.put("&Mellintrf;", "\u2133");
        this.entities.put("&Mfr;", "\ud835\udd10");
        this.entities.put("&MinusPlus;", "\u2213");
        this.entities.put("&Mopf;", "\ud835\udd44");
        this.entities.put("&Mscr;", "\u2133");
        this.entities.put("&Mu;", "\u039c");
        this.entities.put("&NJcy;", "\u040a");
        this.entities.put("&Nacute;", "\u0143");
        this.entities.put("&Ncaron;", "\u0147");
        this.entities.put("&Ncedil;", "\u0145");
        this.entities.put("&Ncy;", "\u041d");
        this.entities.put("&NegativeMediumSpace;", "\u200b");
        this.entities.put("&NegativeThickSpace;", "\u200b");
        this.entities.put("&NegativeThinSpace;", "\u200b");
        this.entities.put("&NegativeVeryThinSpace;", "\u200b");
        this.entities.put("&NestedGreaterGreater;", "\u226b");
        this.entities.put("&NestedLessLess;", "\u226a");
        this.entities.put("&NewLine;", "\n");
        this.entities.put("&Nfr;", "\ud835\udd11");
        this.entities.put("&NoBreak;", "\u2060");
        this.entities.put("&NonBreakingSpace;", "\u00a0");
        this.entities.put("&Nopf;", "\u2115");
        this.entities.put("&Not;", "\u2aec");
        this.entities.put("&NotCongruent;", "\u2262");
        this.entities.put("&NotCupCap;", "\u226d");
        this.entities.put("&NotDoubleVerticalBar;", "\u2226");
        this.entities.put("&NotElement;", "\u2209");
        this.entities.put("&NotEqual;", "\u2260");
        this.entities.put("&NotEqualTilde;", "\u2242\u0338");
        this.entities.put("&NotExists;", "\u2204");
        this.entities.put("&NotGreater;", "\u226f");
        this.entities.put("&NotGreaterEqual;", "\u2271");
        this.entities.put("&NotGreaterFullEqual;", "\u22673");
        this.entities.put("&NotGreaterGreater;", "\u226b3");
        this.entities.put("&NotGreaterLess;", "\u2279");
        this.entities.put("&NotGreaterSlantEqual;", "\u2a7e\u0338");
        this.entities.put("&NotGreaterTilde;", "\u2275");
        this.entities.put("&NotHumpDownHump;", "\u224e\u0338");
        this.entities.put("&NotHumpEqual;", "\u224f\u0338");
        this.entities.put("&NotLeftTriangle;", "\u22ea");
        this.entities.put("&NotLeftTriangleBar;", "\u29cf\u0338");
        this.entities.put("&NotLeftTriangleEqual;", "\u22ec");
        this.entities.put("&NotLess;", "\u226e");
        this.entities.put("&NotLessEqual;", "\u2270");
        this.entities.put("&NotLessGreater;", "\u2278");
        this.entities.put("&NotLessLess;", "\u226a\u0338");
        this.entities.put("&NotLessSlantEqual;", "\u2a7d\u0338");
        this.entities.put("&NotLessTilde;", "\u2274");
        this.entities.put("&NotNestedGreaterGreater;", "\u2aa2\u0338");
        this.entities.put("&NotNestedLessLess;", "\u2aa1\u0338");
        this.entities.put("&NotPrecedes;", "\u2280");
        this.entities.put("&NotPrecedesEqual;", "\u2aaf\u0338");
        this.entities.put("&NotPrecedesSlantEqual;", "\u22e0");
        this.entities.put("&NotReverseElement;", "\u220c");
        this.entities.put("&NotRightTriangle;", "\u22eb");
        this.entities.put("&NotRightTriangleBar;", "\u29d0\u0338");
        this.entities.put("&NotRightTriangleEqual;", "\u22ed");
        this.entities.put("&NotSquareSubset;", "\u228f\u0338");
        this.entities.put("&NotSquareSubsetEqual;", "\u22e2");
        this.entities.put("&NotSquareSuperset;", "\u2290\u0338");
        this.entities.put("&NotSquareSupersetEqual;", "\u22e3");
        this.entities.put("&NotSubset;", "\u2282\u20d2");
        this.entities.put("&NotSubsetEqual;", "\u2288");
        this.entities.put("&NotSucceeds;", "\u2281");
        this.entities.put("&NotSucceedsEqual;", "\u2ab0\u0338");
        this.entities.put("&NotSucceedsSlantEqual;", "\u22e1");
        this.entities.put("&NotSucceedsTilde;", "\u227f\u0338");
        this.entities.put("&NotSuperset;", "\u2283\u20d2");
        this.entities.put("&NotSupersetEqual;", "\u2289");
        this.entities.put("&NotTilde;", "\u2241");
        this.entities.put("&NotTildeEqual;", "\u2244");
        this.entities.put("&NotTildeFullEqual;", "\u2247");
        this.entities.put("&NotTildeTilde;", "\u2249");
        this.entities.put("&NotVerticalBar;", "\u2224");
        this.entities.put("&Nscr;", "\ud835\udca9");
        this.entities.put("&Ntilde;", "\u00d1");
        this.entities.put("&Nu;", "\u039d");
        this.entities.put("&OElig;", "\u0152");
        this.entities.put("&Oacute;", "\u00d3");
        this.entities.put("&Ocirc;", "\u00d4");
        this.entities.put("&Ocy;", "\u041e");
        this.entities.put("&Odblac;", "\u0150");
        this.entities.put("&Ofr;", "\ud835\udd12");
        this.entities.put("&Ograve;", "\u00d2");
        this.entities.put("&Omacr;", "\u014c");
        this.entities.put("&Omega;", "\u03a9");
        this.entities.put("&Omicron;", "\u039f");
        this.entities.put("&Oopf;", "\ud835\udd46");
        this.entities.put("&OpenCurlyDoubleQuote;", "\u201c");
        this.entities.put("&OpenCurlyQuote;", "\u2018");
        this.entities.put("&Or;", "\u2a54");
        this.entities.put("&Oscr;", "\ud835\udcaa");
        this.entities.put("&Oslash;", "\u00d8");
        this.entities.put("&Otilde;", "\u00d5");
        this.entities.put("&Otimes;", "\u2a37");
        this.entities.put("&Ouml;", "\u00d6");
        this.entities.put("&OverBar;", "\u203e");
        this.entities.put("&OverBrace;", "\u23de");
        this.entities.put("&OverBracket;", "\u23b4");
        this.entities.put("&OverParenthesis;", "\u23dc");
        this.entities.put("&PartialD;", "\u2202");
        this.entities.put("&Pcy;", "\u041f");
        this.entities.put("&Pfr;", "\ud835\udd13");
        this.entities.put("&Phi;", "\u03a6");
        this.entities.put("&Pi;", "\u03a0");
        this.entities.put("&PlusMinus;", "\u00b1");
        this.entities.put("&Poincareplane;", "\u210c");
        this.entities.put("&Popf;", "\u2119");
        this.entities.put("&Pr;", "\u2abb");
        this.entities.put("&Precedes;", "\u227a");
        this.entities.put("&PrecedesEqual;", "\u2aaf");
        this.entities.put("&PrecedesSlantEqual;", "\u227c");
        this.entities.put("&PrecedesTilde;", "\u227e");
        this.entities.put("&Prime;", "\u2033");
        this.entities.put("&Product;", "\u220f");
        this.entities.put("&Proportion;", "\u2237");
        this.entities.put("&Proportional;", "\u221d");
        this.entities.put("&Pscr;", "\ud835\udcab");
        this.entities.put("&Psi;", "\u03a8");
        this.entities.put("&QUOT;", "\\u0022");
        this.entities.put("&Qfr;", "\ud835\udd14");
        this.entities.put("&Qopf;", "\u211a");
        this.entities.put("&Qscr;", "\ud835\udcac");
        this.entities.put("&RBarr;", "\u2910");
        this.entities.put("&REG;", "\u00ae");
        this.entities.put("&Racute;", "\u0154");
        this.entities.put("&Rang;", "\u27eb");
        this.entities.put("&Rarr;", "\u21a0");
        this.entities.put("&Rarrtl;", "\u2916");
        this.entities.put("&Rcaron;", "\u0158");
        this.entities.put("&Rcedil;", "\u0156");
        this.entities.put("&Rcy;", "\u0420");
        this.entities.put("&Re;", "\u211c");
        this.entities.put("&ReverseElement;", "\u220b");
        this.entities.put("&ReverseEquilibrium;", "\u21cb");
        this.entities.put("&ReverseUpEquilibrium;", "\u296f");
        this.entities.put("&Rfr;", "\u211c");
        this.entities.put("&Rho;", "\u03a1");
        this.entities.put("&RightAngleBracket;", "\u27e9");
        this.entities.put("&RightArrow;", "\u2192");
        this.entities.put("&RightArrowBar;", "\u21e5");
        this.entities.put("&RightArrowLeftArrow;", "\u21c4");
        this.entities.put("&RightCeiling;", "\u2309");
        this.entities.put("&RightDoubleBracket;", "\u27e7");
        this.entities.put("&RightDownTeeVector;", "\u295d");
        this.entities.put("&RightDownVector;", "\u21c2");
        this.entities.put("&RightDownVectorBar;", "\u2955");
        this.entities.put("&RightFloor;", "\u230b");
        this.entities.put("&RightTee;", "\u22a2");
        this.entities.put("&RightTeeArrow;", "\u21a6");
        this.entities.put("&RightTeeVector;", "\u295b");
        this.entities.put("&RightTriangle;", "\u22b3");
        this.entities.put("&RightTriangleBar;", "\u29d0");
        this.entities.put("&RightTriangleEqual;", "\u22b5");
        this.entities.put("&RightUpDownVector;", "\u294f");
        this.entities.put("&RightUpTeeVector;", "\u295c");
        this.entities.put("&RightUpVector;", "\u21be");
        this.entities.put("&RightUpVectorBar;", "\u2954");
        this.entities.put("&RightVector;", "\u21c0");
        this.entities.put("&RightVectorBar;", "\u2953");
        this.entities.put("&Rightarrow;", "\u21d2");
        this.entities.put("&Ropf;", "\u211d");
        this.entities.put("&RoundImplies;", "\u2970");
        this.entities.put("&Rrightarrow;", "\u21db");
        this.entities.put("&Rscr;", "\u211b");
        this.entities.put("&Rsh;", "\u21b1");
        this.entities.put("&RuleDelayed;", "\u29f4");
        this.entities.put("&SHCHcy;", "\u0429");
        this.entities.put("&SHcy;", "\u0428");
        this.entities.put("&SOFTcy;", "\u042c");
        this.entities.put("&Sacute;", "\u015a");
        this.entities.put("&Sc;", "\u2abc");
        this.entities.put("&Scaron;", "\u0160");
        this.entities.put("&Scedil;", "\u015e");
        this.entities.put("&Scirc;", "\u015c");
        this.entities.put("&Scy;", "\u0421");
        this.entities.put("&Sfr;", "\ud835\udd16");
        this.entities.put("&ShortDownArrow;", "\u2193");
        this.entities.put("&ShortLeftArrow;", "\u2190");
        this.entities.put("&ShortRightArrow;", "\u2192");
        this.entities.put("&ShortUpArrow;", "\u2191");
        this.entities.put("&Sigma;", "\u03a3");
        this.entities.put("&SmallCircle;", "\u2218");
        this.entities.put("&Sopf;", "\ud835\udd4a");
        this.entities.put("&Sqrt;", "\u221a");
        this.entities.put("&Square;", "\u25a1");
        this.entities.put("&SquareIntersection;", "\u2293");
        this.entities.put("&SquareSubset;", "\u228f");
        this.entities.put("&SquareSubsetEqual;", "\u2291");
        this.entities.put("&SquareSuperset;", "\u2290");
        this.entities.put("&SquareSupersetEqual;", "\u2292");
        this.entities.put("&SquareUnion;", "\u2294");
        this.entities.put("&Sscr;", "\ud835\udcae");
        this.entities.put("&Star;", "\u22c6");
        this.entities.put("&Sub;", "\u22d0");
        this.entities.put("&Subset;", "\u22d0");
        this.entities.put("&SubsetEqual;", "\u2286");
        this.entities.put("&Succeeds;", "\u227b");
        this.entities.put("&SucceedsEqual;", "\u2ab0");
        this.entities.put("&SucceedsSlantEqual;", "\u227d");
        this.entities.put("&SucceedsTilde;", "\u227f");
        this.entities.put("&SuchThat;", "\u220b");
        this.entities.put("&Sum;", "\u2211");
        this.entities.put("&Sup;", "\u22d1");
        this.entities.put("&Superset;", "\u2283");
        this.entities.put("&SupersetEqual;", "\u2287");
        this.entities.put("&Supset;", "\u22d1");
        this.entities.put("&THORN;", "\u00de");
        this.entities.put("&TRADE;", "\u2122");
        this.entities.put("&TSHcy;", "\u040b");
        this.entities.put("&TScy;", "\u0426");
        this.entities.put("&Tab;", "\t");
        this.entities.put("&Tau;", "\u03a4");
        this.entities.put("&Tcaron;", "\u0164");
        this.entities.put("&Tcedil;", "\u0162");
        this.entities.put("&Tcy;", "\u0422");
        this.entities.put("&Tfr;", "\ud835\udd17");
        this.entities.put("&Therefore;", "\u2234");
        this.entities.put("&Theta;", "\u0398");
        this.entities.put("&ThickSpace;", "\u205f\u200a");
        this.entities.put("&ThinSpace;", "\u2009");
        this.entities.put("&Tilde;", "\u223c");
        this.entities.put("&TildeEqual;", "\u2243");
        this.entities.put("&TildeFullEqual;", "\u2245");
        this.entities.put("&TildeTilde;", "\u2248");
        this.entities.put("&Topf;", "\ud835\udd4b");
        this.entities.put("&TripleDot;", "\u20db");
        this.entities.put("&Tscr;", "\ud835\udcaf");
        this.entities.put("&Tstrok;", "\u0166");
        this.entities.put("&Uacute;", "\u00da");
        this.entities.put("&Uarr;", "\u219f");
        this.entities.put("&Uarrocir;", "\u2949");
        this.entities.put("&Ubrcy;", "\u040e");
        this.entities.put("&Ubreve;", "\u016c");
        this.entities.put("&Ucirc;", "\u00db");
        this.entities.put("&Ucy;", "\u0423");
        this.entities.put("&Udblac;", "\u0170");
        this.entities.put("&Ufr;", "\ud835\udd18");
        this.entities.put("&Ugrave;", "\u00d9");
        this.entities.put("&Umacr;", "\u016a");
        this.entities.put("&UnderBar;", "_");
        this.entities.put("&UnderBrace;", "\u23df");
        this.entities.put("&UnderBracket;", "\u23b5");
        this.entities.put("&UnderParenthesis;", "\u23dd");
        this.entities.put("&Union;", "\u22c3");
        this.entities.put("&UnionPlus;", "\u228e");
        this.entities.put("&Uogon;", "\u0172");
        this.entities.put("&Uopf;", "\ud835\udd4c");
        this.entities.put("&UpArrow;", "\u2191");
        this.entities.put("&UpArrowBar;", "\u2912");
        this.entities.put("&UpArrowDownArrow;", "\u21c5");
        this.entities.put("&UpDownArrow;", "\u2195");
        this.entities.put("&UpEquilibrium;", "\u296e");
        this.entities.put("&UpTee;", "\u22a5");
        this.entities.put("&UpTeeArrow;", "\u21a5");
        this.entities.put("&Uparrow;", "\u21d1");
        this.entities.put("&Updownarrow;", "\u21d5");
        this.entities.put("&UpperLeftArrow;", "\u2196");
        this.entities.put("&UpperRightArrow;", "\u2197");
        this.entities.put("&Upsi;", "\u03d2");
        this.entities.put("&Upsilon;", "\u03a5");
        this.entities.put("&Uring;", "\u016e");
        this.entities.put("&Uscr;", "\ud835\udcb0");
        this.entities.put("&Utilde;", "\u0168");
        this.entities.put("&Uuml;", "\u00dc");
        this.entities.put("&VDash;", "\u22ab");
        this.entities.put("&Vbar;", "\u2aeb");
        this.entities.put("&Vcy;", "\u0412");
        this.entities.put("&Vdash;", "\u22a9");
        this.entities.put("&Vdashl;", "\u2ae6");
        this.entities.put("&Vee;", "\u22c1");
        this.entities.put("&Verbar;", "\u2016");
        this.entities.put("&Vert;", "\u2016");
        this.entities.put("&VerticalBar;", "\u2223");
        this.entities.put("&VerticalLine;", "|");
        this.entities.put("&VerticalSeparator;", "\u2758");
        this.entities.put("&VerticalTilde;", "\u2240");
        this.entities.put("&VeryThinSpace;", "\u200a");
        this.entities.put("&Vfr;", "\ud835\udd19");
        this.entities.put("&Vopf;", "\ud835\udd4d");
        this.entities.put("&Vscr;", "\ud835\udcb1");
        this.entities.put("&Vvdash;", "\u22aa");
        this.entities.put("&Wcirc;", "\u0174");
        this.entities.put("&Wedge;", "\u22c0");
        this.entities.put("&Wfr;", "\ud835\udd1a");
        this.entities.put("&Wopf;", "\ud835\udd4e");
        this.entities.put("&Wscr;", "\ud835\udcb2");
        this.entities.put("&Xfr;", "\ud835\udd1b");
        this.entities.put("&Xi;", "\u039e");
        this.entities.put("&Xopf;", "\ud835\udd4f");
        this.entities.put("&Xscr;", "\ud835\udcb3");
        this.entities.put("&YAcy;", "\u042f");
        this.entities.put("&YIcy;", "\u0407");
        this.entities.put("&YUcy;", "\u042e");
        this.entities.put("&Yacute;", "\u00dd");
        this.entities.put("&Ycirc;", "\u0176");
        this.entities.put("&Ycy;", "\u042b");
        this.entities.put("&Yfr;", "\ud835\udd1c");
        this.entities.put("&Yopf;", "\ud835\udd50");
        this.entities.put("&Yscr;", "\ud835\udcb4");
        this.entities.put("&Yuml;", "\u0178");
        this.entities.put("&ZHcy;", "\u0416");
        this.entities.put("&Zacute;", "\u0179");
        this.entities.put("&Zcaron;", "\u017d");
        this.entities.put("&Zcy;", "\u0417");
        this.entities.put("&Zdot;", "\u017b");
        this.entities.put("&ZeroWidthSpace;", "\u200b");
        this.entities.put("&Zeta;", "\u0396");
        this.entities.put("&Zfr;", "\u2128");
        this.entities.put("&Zopf;", "\u2124");
        this.entities.put("&Zscr;", "\ud835\udcb5");
        this.entities.put("&aacute;", "\u00e1");
        this.entities.put("&abreve;", "\u0103");
        this.entities.put("&ac;", "\u223e");
        this.entities.put("&acE;", "\u223e\u0333");
        this.entities.put("&acd;", "\u223f");
        this.entities.put("&acirc;", "\u00e2");
        this.entities.put("&acute;", "\u00b4");
        this.entities.put("&acy;", "\u0430");
        this.entities.put("&aelig;", "\u00e6");
        this.entities.put("&af;", "\u2061");
        this.entities.put("&afr;", "\ud835\udd1e");
        this.entities.put("&agrave;", "\u00e0");
        this.entities.put("&alefsym;", "\u2135");
        this.entities.put("&aleph;", "\u2135");
        this.entities.put("&alpha;", "\u03b1");
        this.entities.put("&amacr;", "\u0101");
        this.entities.put("&amalg;", "\u2a3f");
        this.entities.put("&amp;", "&");
        this.entities.put("&and;", "\u2227");
        this.entities.put("&andand;", "\u2a55");
        this.entities.put("&andd;", "\u2a5c");
        this.entities.put("&andslope;", "\u2a58");
        this.entities.put("&andv;", "\u2a5a");
        this.entities.put("&ang;", "\u2220");
        this.entities.put("&ange;", "\u29a4");
        this.entities.put("&angle;", "\u2220");
        this.entities.put("&angmsd;", "\u2221");
        this.entities.put("&angmsdaa;", "\u29a8");
        this.entities.put("&angmsdab;", "\u29a9");
        this.entities.put("&angmsdac;", "\u29aa");
        this.entities.put("&angmsdad;", "\u29ab");
        this.entities.put("&angmsdae;", "\u29ac");
        this.entities.put("&angmsdaf;", "\u29ad");
        this.entities.put("&angmsdag;", "\u29ae");
        this.entities.put("&angmsdah;", "\u29af");
        this.entities.put("&angrt;", "\u221f");
        this.entities.put("&angrtvb;", "\u22be");
        this.entities.put("&angrtvbd;", "\u299d");
        this.entities.put("&angsph;", "\u2222");
        this.entities.put("&angst;", "\u00c5");
        this.entities.put("&angzarr;", "\u237c");
        this.entities.put("&aogon;", "\u0105");
        this.entities.put("&aopf;", "\ud835\udd52");
        this.entities.put("&ap;", "\u2248");
        this.entities.put("&apE;", "\u2a70");
        this.entities.put("&apacir;", "\u2a6f");
        this.entities.put("&ape;", "\u224a");
        this.entities.put("&apid;", "\u224b");
        this.entities.put("&apos;", "'");
        this.entities.put("&approx;", "\u2248");
        this.entities.put("&approxeq;", "\u224a");
        this.entities.put("&aring;", "\u00e5");
        this.entities.put("&ascr;", "\ud835\udcb6");
        this.entities.put("&ast;", "*");
        this.entities.put("&asymp;", "\u2248");
        this.entities.put("&asympeq;", "\u224d");
        this.entities.put("&atilde;", "\u00e3");
        this.entities.put("&auml;", "\u00e4");
        this.entities.put("&awconint;", "\u2233");
        this.entities.put("&awint;", "\u2a11");
        this.entities.put("&bNot;", "\u2aed");
        this.entities.put("&backcong;", "\u224c");
        this.entities.put("&backepsilon;", "\u03f6");
        this.entities.put("&backprime;", "\u2035");
        this.entities.put("&backsim;", "\u223d");
        this.entities.put("&backsimeq;", "\u22cd");
        this.entities.put("&barvee;", "\u22bd");
        this.entities.put("&barwed;", "\u2305");
        this.entities.put("&barwedge;", "\u2305");
        this.entities.put("&bbrk;", "\u23b5");
        this.entities.put("&bbrktbrk;", "\u23b6");
        this.entities.put("&bcong;", "\u224c");
        this.entities.put("&bcy;", "\u0431");
        this.entities.put("&bdquo;", "\u201e");
        this.entities.put("&becaus;", "\u2235");
        this.entities.put("&because;", "\u2235");
        this.entities.put("&bemptyv;", "\u29b0");
        this.entities.put("&bepsi;", "\u03f6");
        this.entities.put("&bernou;", "\u212c");
        this.entities.put("&beta;", "\u03b2");
        this.entities.put("&beth;", "\u2136");
        this.entities.put("&between;", "\u226c");
        this.entities.put("&bfr;", "\ud835\udd1f");
        this.entities.put("&bigcap;", "\u22c2");
        this.entities.put("&bigcirc;", "\u25ef");
        this.entities.put("&bigcup;", "\u22c3");
        this.entities.put("&bigodot;", "\u2a00");
        this.entities.put("&bigoplus;", "\u2a01");
        this.entities.put("&bigotimes;", "\u2a02");
        this.entities.put("&bigsqcup;", "\u2a06");
        this.entities.put("&bigstar;", "\u2605");
        this.entities.put("&bigtriangledown;", "\u25bd");
        this.entities.put("&bigtriangleup;", "\u25b3");
        this.entities.put("&biguplus;", "\u2a04");
        this.entities.put("&bigvee;", "\u22c1");
        this.entities.put("&bigwedge;", "\u22c0");
        this.entities.put("&bkarow;", "\u290d");
        this.entities.put("&blacklozenge;", "\u29eb");
        this.entities.put("&blacksquare;", "\u25aa");
        this.entities.put("&blacktriangle;", "\u25b4");
        this.entities.put("&blacktriangledown;", "\u25be");
        this.entities.put("&blacktriangleleft;", "\u25c2");
        this.entities.put("&blacktriangleright;", "\u25b8");
        this.entities.put("&blank;", "\u2423");
        this.entities.put("&blk12;", "\u2592");
        this.entities.put("&blk14;", "\u2591");
        this.entities.put("&blk34;", "\u2593");
        this.entities.put("&block;", "\u2588");
        this.entities.put("&bne;", "=\u20e5");
        this.entities.put("&bnequiv;", "\u2261\u20e5");
        this.entities.put("&bnot;", "\u2310");
        this.entities.put("&bopf;", "\ud835\udd53");
        this.entities.put("&bot;", "\u22a5");
        this.entities.put("&bottom;", "\u22a5");
        this.entities.put("&bowtie;", "\u22c8");
        this.entities.put("&boxDL;", "\u2557");
        this.entities.put("&boxDR;", "\u2554");
        this.entities.put("&boxDl;", "\u2556");
        this.entities.put("&boxDr;", "\u2553");
        this.entities.put("&boxH;", "\u2550");
        this.entities.put("&boxHD;", "\u2566");
        this.entities.put("&boxHU;", "\u2569");
        this.entities.put("&boxHd;", "\u2564");
        this.entities.put("&boxHu;", "\u2567");
        this.entities.put("&boxUL;", "\u255d");
        this.entities.put("&boxUR;", "\u255a");
        this.entities.put("&boxUl;", "\u255c");
        this.entities.put("&boxUr;", "\u2559");
        this.entities.put("&boxV;", "\u2551");
        this.entities.put("&boxVH;", "\u256c");
        this.entities.put("&boxVL;", "\u2563");
        this.entities.put("&boxVR;", "\u2560");
        this.entities.put("&boxVh;", "\u256b");
        this.entities.put("&boxVl;", "\u2562");
        this.entities.put("&boxVr;", "\u255f");
        this.entities.put("&boxbox;", "\u29c9");
        this.entities.put("&boxdL;", "\u2555");
        this.entities.put("&boxdR;", "\u2552");
        this.entities.put("&boxdl;", "\u2510");
        this.entities.put("&boxdr;", "\u250c");
        this.entities.put("&boxh;", "\u2500");
        this.entities.put("&boxhD;", "\u2565");
        this.entities.put("&boxhU;", "\u2568");
        this.entities.put("&boxhd;", "\u252c");
        this.entities.put("&boxhu;", "\u2534");
        this.entities.put("&boxminus;", "\u229f");
        this.entities.put("&boxplus;", "\u229e");
        this.entities.put("&boxtimes;", "\u22a0");
        this.entities.put("&boxuL;", "\u255b");
        this.entities.put("&boxuR;", "\u2558");
        this.entities.put("&boxul;", "\u2518");
        this.entities.put("&boxur;", "\u2514");
        this.entities.put("&boxv;", "\u2502");
        this.entities.put("&boxvH;", "\u256a");
        this.entities.put("&boxvL;", "\u2561");
        this.entities.put("&boxvR;", "\u255e");
        this.entities.put("&boxvh;", "\u253c");
        this.entities.put("&boxvl;", "\u2524");
        this.entities.put("&boxvr;", "\u251c");
        this.entities.put("&bprime;", "\u2035");
        this.entities.put("&breve;", "\u02d8");
        this.entities.put("&brvbar;", "\u00a6");
        this.entities.put("&bscr;", "\ud835\udcb7");
        this.entities.put("&bsemi;", "\u204f");
        this.entities.put("&bsim;", "\u223d");
        this.entities.put("&bsime;", "\u22cd");
        this.entities.put("&bsol;", "\\u005C");
        this.entities.put("&bsolb;", "\u29c5");
        this.entities.put("&bsolhsub;", "\u27c8");
        this.entities.put("&bull;", "\u2022");
        this.entities.put("&bullet;", "\u2022");
        this.entities.put("&bump;", "\u224e");
        this.entities.put("&bumpE;", "\u2aae");
        this.entities.put("&bumpe;", "\u224f");
        this.entities.put("&bumpeq;", "\u224f");
        this.entities.put("&cacute;", "\u0107");
        this.entities.put("&cap;", "\u2229");
        this.entities.put("&capand;", "\u2a44");
        this.entities.put("&capbrcup;", "\u2a49");
        this.entities.put("&capcap;", "\u2a4b");
        this.entities.put("&capcup;", "\u2a47");
        this.entities.put("&capdot;", "\u2a40");
        this.entities.put("&caps;", "\u2229\ufe00");
        this.entities.put("&caret;", "\u2041");
        this.entities.put("&caron;", "\u02c7");
        this.entities.put("&ccaps;", "\u2a4d");
        this.entities.put("&ccaron;", "\u010d");
        this.entities.put("&ccedil;", "\u00e7");
        this.entities.put("&ccirc;", "\u0109");
        this.entities.put("&ccups;", "\u2a4c");
        this.entities.put("&ccupssm;", "\u2a50");
        this.entities.put("&cdot;", "\u010b");
        this.entities.put("&cedil;", "\u00b8");
        this.entities.put("&cemptyv;", "\u29b2");
        this.entities.put("&cent;", "\u00a2");
        this.entities.put("&centerdot;", "\u00b7");
        this.entities.put("&cfr;", "\ud835\udd20");
        this.entities.put("&chcy;", "\u0447");
        this.entities.put("&check;", "\u2713");
        this.entities.put("&checkmark;", "\u2713");
        this.entities.put("&chi;", "\u03c7");
        this.entities.put("&cir;", "\u25cb");
        this.entities.put("&cirE;", "\u29c3");
        this.entities.put("&circ;", "\u02c6");
        this.entities.put("&circeq;", "\u2257");
        this.entities.put("&circlearrowleft;", "\u21ba");
        this.entities.put("&circlearrowright;", "\u21bb");
        this.entities.put("&circledR;", "\u00ae");
        this.entities.put("&circledS;", "\u24c8");
        this.entities.put("&circledast;", "\u229b");
        this.entities.put("&circledcirc;", "\u229a");
        this.entities.put("&circleddash;", "\u229d");
        this.entities.put("&cire;", "\u2257");
        this.entities.put("&cirfnint;", "\u2a10");
        this.entities.put("&cirmid;", "\u2aef");
        this.entities.put("&cirscir;", "\u29c2");
        this.entities.put("&clubs;", "\u2663");
        this.entities.put("&clubsuit;", "\u2663");
        this.entities.put("&colon;", ":");
        this.entities.put("&colone;", "\u2254");
        this.entities.put("&coloneq;", "\u2254");
        this.entities.put("&comma;", ",");
        this.entities.put("&commat;", "@");
        this.entities.put("&comp;", "\u2201");
        this.entities.put("&compfn;", "\u2218");
        this.entities.put("&complement;", "\u2201");
        this.entities.put("&complexes;", "\u2102");
        this.entities.put("&cong;", "\u2245");
        this.entities.put("&congdot;", "\u2a6d");
        this.entities.put("&conint;", "\u222e");
        this.entities.put("&copf;", "\ud835\udd54");
        this.entities.put("&coprod;", "\u2210");
        this.entities.put("&copy;", "\u00a9");
        this.entities.put("&copysr;", "\u2117");
        this.entities.put("&crarr;", "\u21b5");
        this.entities.put("&cross;", "\u2717");
        this.entities.put("&cscr;", "\ud835\udcb8");
        this.entities.put("&csub;", "\u2acf");
        this.entities.put("&csube;", "\u2ad1");
        this.entities.put("&csup;", "\u2ad0");
        this.entities.put("&csupe;", "\u2ad2");
        this.entities.put("&ctdot;", "\u22ef");
        this.entities.put("&cudarrl;", "\u2938");
        this.entities.put("&cudarrr;", "\u2935");
        this.entities.put("&cuepr;", "\u22de");
        this.entities.put("&cuesc;", "\u22df");
        this.entities.put("&cularr;", "\u21b6");
        this.entities.put("&cularrp;", "\u293d");
        this.entities.put("&cup;", "\u222a");
        this.entities.put("&cupbrcap;", "\u2a48");
        this.entities.put("&cupcap;", "\u2a46");
        this.entities.put("&cupcup;", "\u2a4a");
        this.entities.put("&cupdot;", "\u228d");
        this.entities.put("&cupor;", "\u2a45");
        this.entities.put("&cups;", "\u222a\ufe00");
        this.entities.put("&curarr;", "\u21b7");
        this.entities.put("&curarrm;", "\u293c");
        this.entities.put("&curlyeqprec;", "\u22de");
        this.entities.put("&curlyeqsucc;", "\u22df");
        this.entities.put("&curlyvee;", "\u22ce");
        this.entities.put("&curlywedge;", "\u22cf");
        this.entities.put("&curren;", "\u00a4");
        this.entities.put("&curvearrowleft;", "\u21b6");
        this.entities.put("&curvearrowright;", "\u21b7");
        this.entities.put("&cuvee;", "\u22ce");
        this.entities.put("&cuwed;", "\u22cf");
        this.entities.put("&cwconint;", "\u2232");
        this.entities.put("&cwint;", "\u2231");
        this.entities.put("&cylcty;", "\u232d");
        this.entities.put("&dArr;", "\u21d3");
        this.entities.put("&dHar;", "\u2965");
        this.entities.put("&dagger;", "\u2020");
        this.entities.put("&daleth;", "\u2138");
        this.entities.put("&darr;", "\u2193");
        this.entities.put("&dash;", "\u2010");
        this.entities.put("&dashv;", "\u22a3");
        this.entities.put("&dbkarow;", "\u290f");
        this.entities.put("&dblac;", "\u02dd");
        this.entities.put("&dcaron;", "\u010f");
        this.entities.put("&dcy;", "\u0434");
        this.entities.put("&dd;", "\u2146");
        this.entities.put("&ddagger;", "\u2021");
        this.entities.put("&ddarr;", "\u21ca");
        this.entities.put("&ddotseq;", "\u2a77");
        this.entities.put("&deg;", "\u00b0");
        this.entities.put("&delta;", "\u03b4");
        this.entities.put("&demptyv;", "\u29b1");
        this.entities.put("&dfisht;", "\u297f");
        this.entities.put("&dfr;", "\ud835\udd21");
        this.entities.put("&dharl;", "\u21c3");
        this.entities.put("&dharr;", "\u21c2");
        this.entities.put("&diam;", "\u22c4");
        this.entities.put("&diamond;", "\u22c4");
        this.entities.put("&diamondsuit;", "\u2666");
        this.entities.put("&diams;", "\u2666");
        this.entities.put("&die;", "\u00a8");
        this.entities.put("&digamma;", "\u03dd");
        this.entities.put("&disin;", "\u22f2");
        this.entities.put("&div;", "\u00f7");
        this.entities.put("&divide;", "\u00f7");
        this.entities.put("&divideontimes;", "\u22c7");
        this.entities.put("&divonx;", "\u22c7");
        this.entities.put("&djcy;", "\u0452");
        this.entities.put("&dlcorn;", "\u231e");
        this.entities.put("&dlcrop;", "\u230d");
        this.entities.put("&dollar;", "$");
        this.entities.put("&dopf;", "\ud835\udd55");
        this.entities.put("&dot;", "\u02d9");
        this.entities.put("&doteq;", "\u2250");
        this.entities.put("&doteqdot;", "\u2251");
        this.entities.put("&dotminus;", "\u2238");
        this.entities.put("&dotplus;", "\u2214");
        this.entities.put("&dotsquare;", "\u22a1");
        this.entities.put("&doublebarwedge;", "\u2306");
        this.entities.put("&downarrow;", "\u2193");
        this.entities.put("&downdownarrows;", "\u21ca");
        this.entities.put("&downharpoonleft;", "\u21c3");
        this.entities.put("&downharpoonright;", "\u21c2");
        this.entities.put("&drbkarow;", "\u2910");
        this.entities.put("&drcorn;", "\u231f");
        this.entities.put("&drcrop;", "\u230c");
        this.entities.put("&dscr;", "\ud835\udcb9");
        this.entities.put("&dscy;", "\u0455");
        this.entities.put("&dsol;", "\u29f6");
        this.entities.put("&dstrok;", "\u0111");
        this.entities.put("&dtdot;", "\u22f1");
        this.entities.put("&dtri;", "\u25bf");
        this.entities.put("&dtrif;", "\u25be");
        this.entities.put("&duarr;", "\u21f5");
        this.entities.put("&duhar;", "\u296f");
        this.entities.put("&dwangle;", "\u29a6");
        this.entities.put("&dzcy;", "\u045f");
        this.entities.put("&dzigrarr;", "\u27ff");
        this.entities.put("&eDDot;", "\u2a77");
        this.entities.put("&eDot;", "\u2251");
        this.entities.put("&eacute;", "\u00e9");
        this.entities.put("&easter;", "\u2a6e");
        this.entities.put("&ecaron;", "\u011b");
        this.entities.put("&ecir;", "\u2256");
        this.entities.put("&ecirc;", "\u00ea");
        this.entities.put("&ecolon;", "\u2255");
        this.entities.put("&ecy;", "\u044d");
        this.entities.put("&edot;", "\u0117");
        this.entities.put("&ee;", "\u2147");
        this.entities.put("&efDot;", "\u2252");
        this.entities.put("&efr;", "\ud835\udd22");
        this.entities.put("&eg;", "\u2a9a");
        this.entities.put("&egrave;", "\u00e8");
        this.entities.put("&egs;", "\u2a96");
        this.entities.put("&egsdot;", "\u2a98");
        this.entities.put("&el;", "\u2a99");
        this.entities.put("&elinters;", "\u23e7");
        this.entities.put("&ell;", "\u2113");
        this.entities.put("&els;", "\u2a95");
        this.entities.put("&elsdot;", "\u2a97");
        this.entities.put("&emacr;", "\u0113");
        this.entities.put("&empty;", "\u2205");
        this.entities.put("&emptyset;", "\u2205");
        this.entities.put("&emptyv;", "\u2205");
        this.entities.put("&emsp13;", "\u2004");
        this.entities.put("&emsp14;", "\u2005");
        this.entities.put("&emsp;", "\u2003");
        this.entities.put("&eng;", "\u014b");
        this.entities.put("&ensp;", "\u2002");
        this.entities.put("&eogon;", "\u0119");
        this.entities.put("&eopf;", "\ud835\udd56");
        this.entities.put("&epar;", "\u22d5");
        this.entities.put("&eparsl;", "\u29e3");
        this.entities.put("&eplus;", "\u2a71");
        this.entities.put("&epsi;", "\u03b5");
        this.entities.put("&epsilon;", "\u03b5");
        this.entities.put("&epsiv;", "\u03f5");
        this.entities.put("&eqcirc;", "\u2256");
        this.entities.put("&eqcolon;", "\u2255");
        this.entities.put("&eqsim;", "\u2242");
        this.entities.put("&eqslantgtr;", "\u2a96");
        this.entities.put("&eqslantless;", "\u2a95");
        this.entities.put("&equals;", "=");
        this.entities.put("&equest;", "\u225f");
        this.entities.put("&equiv;", "\u2261");
        this.entities.put("&equivDD;", "\u2a78");
        this.entities.put("&eqvparsl;", "\u29e5");
        this.entities.put("&erDot;", "\u2253");
        this.entities.put("&erarr;", "\u2971");
        this.entities.put("&escr;", "\u212f");
        this.entities.put("&esdot;", "\u2250");
        this.entities.put("&esim;", "\u2242");
        this.entities.put("&eta;", "\u03b7");
        this.entities.put("&eth;", "\u00f0");
        this.entities.put("&euml;", "\u00eb");
        this.entities.put("&euro;", "\u20ac");
        this.entities.put("&excl;", "!");
        this.entities.put("&exist;", "\u2203");
        this.entities.put("&expectation;", "\u2130");
        this.entities.put("&exponentiale;", "\u2147");
        this.entities.put("&fallingdotseq;", "\u2252");
        this.entities.put("&fcy;", "\u0444");
        this.entities.put("&female;", "\u2640");
        this.entities.put("&ffilig;", "\ufb03");
        this.entities.put("&fflig;", "\ufb00");
        this.entities.put("&ffllig;", "\ufb04");
        this.entities.put("&ffr;", "\ud835\udd23");
        this.entities.put("&filig;", "\ufb01");
        this.entities.put("&fjlig;", "fj");
        this.entities.put("&flat;", "\u266d");
        this.entities.put("&fllig;", "\ufb02");
        this.entities.put("&fltns;", "\u25b1");
        this.entities.put("&fnof;", "\u0192");
        this.entities.put("&fopf;", "\ud835\udd57");
        this.entities.put("&forall;", "\u2200");
        this.entities.put("&fork;", "\u22d4");
        this.entities.put("&forkv;", "\u2ad9");
        this.entities.put("&fpartint;", "\u2a0d");
        this.entities.put("&frac12;", "\u00bd");
        this.entities.put("&frac13;", "\u2153");
        this.entities.put("&frac14;", "\u00bc");
        this.entities.put("&frac15;", "\u2155");
        this.entities.put("&frac16;", "\u2159");
        this.entities.put("&frac18;", "\u215b");
        this.entities.put("&frac23;", "\u2154");
        this.entities.put("&frac25;", "\u2156");
        this.entities.put("&frac34;", "\u00be");
        this.entities.put("&frac35;", "\u2157");
        this.entities.put("&frac38;", "\u215c");
        this.entities.put("&frac45;", "\u2158");
        this.entities.put("&frac56;", "\u215a");
        this.entities.put("&frac58;", "\u215d");
        this.entities.put("&frac78;", "\u215e");
        this.entities.put("&frasl;", "\u2044");
        this.entities.put("&frown;", "\u2322");
        this.entities.put("&fscr;", "\ud835\udcbb");
        this.entities.put("&gE;", "\u2267");
        this.entities.put("&gEl;", "\u2a8c");
        this.entities.put("&gacute;", "\u01f5");
        this.entities.put("&gamma;", "\u03b3");
        this.entities.put("&gammad;", "\u03dd");
        this.entities.put("&gap;", "\u2a86");
        this.entities.put("&gbreve;", "\u011f");
        this.entities.put("&gcirc;", "\u011d");
        this.entities.put("&gcy;", "\u0433");
        this.entities.put("&gdot;", "\u0121");
        this.entities.put("&ge;", "\u2265");
        this.entities.put("&gel;", "\u22db");
        this.entities.put("&geq;", "\u2265");
        this.entities.put("&geqq;", "\u2267");
        this.entities.put("&geqslant;", "\u2a7e");
        this.entities.put("&ges;", "\u2a7e");
        this.entities.put("&gescc;", "\u2aa9");
        this.entities.put("&gesdot;", "\u2a80");
        this.entities.put("&gesdoto;", "\u2a82");
        this.entities.put("&gesdotol;", "\u2a84");
        this.entities.put("&gesl;", "\u22db\ufe00");
        this.entities.put("&gesles;", "\u2a94");
        this.entities.put("&gfr;", "\ud835\udd24");
        this.entities.put("&gg;", "\u226b");
        this.entities.put("&ggg;", "\u22d9");
        this.entities.put("&gimel;", "\u2137");
        this.entities.put("&gjcy;", "\u0453");
        this.entities.put("&gl;", "\u2277");
        this.entities.put("&glE;", "\u2a92");
        this.entities.put("&gla;", "\u2aa5");
        this.entities.put("&glj;", "\u2aa4");
        this.entities.put("&gnE;", "\u2269");
        this.entities.put("&gnap;", "\u2a8a");
        this.entities.put("&gnapprox;", "\u2a8a");
        this.entities.put("&gne;", "\u2a88");
        this.entities.put("&gneq;", "\u2a88");
        this.entities.put("&gneqq;", "\u2269");
        this.entities.put("&gnsim;", "\u22e7");
        this.entities.put("&gopf;", "\ud835\udd58");
        this.entities.put("&grave;", "`");
        this.entities.put("&gscr;", "\u210a");
        this.entities.put("&gsim;", "\u2273");
        this.entities.put("&gsime;", "\u2a8e");
        this.entities.put("&gsiml;", "\u2a90");
        this.entities.put("&gt;", ">");
        this.entities.put("&gtcc;", "\u2aa7");
        this.entities.put("&gtcir;", "\u2a7a");
        this.entities.put("&gtdot;", "\u22d7");
        this.entities.put("&gtlPar;", "\u2995");
        this.entities.put("&gtquest;", "\u2a7c");
        this.entities.put("&gtrapprox;", "\u2a86");
        this.entities.put("&gtrarr;", "\u2978");
        this.entities.put("&gtrdot;", "\u22d7");
        this.entities.put("&gtreqless;", "\u22db");
        this.entities.put("&gtreqqless;", "\u2a8c");
        this.entities.put("&gtrless;", "\u2277");
        this.entities.put("&gtrsim;", "\u2273");
        this.entities.put("&gvertneqq;", "\u2269\ufe00");
        this.entities.put("&gvnE;", "\u2269\ufe00");
        this.entities.put("&hArr;", "\u21d4");
        this.entities.put("&hairsp;", "\u200a");
        this.entities.put("&half;", "\u00bd");
        this.entities.put("&hamilt;", "\u210b");
        this.entities.put("&hardcy;", "\u044a");
        this.entities.put("&harr;", "\u2194");
        this.entities.put("&harrcir;", "\u2948");
        this.entities.put("&harrw;", "\u21ad");
        this.entities.put("&hbar;", "\u210f");
        this.entities.put("&hcirc;", "\u0125");
        this.entities.put("&hearts;", "\u2665");
        this.entities.put("&heartsuit;", "\u2665");
        this.entities.put("&hellip;", "\u2026");
        this.entities.put("&hercon;", "\u22b9");
        this.entities.put("&hfr;", "\ud835\udd25");
        this.entities.put("&hksearow;", "\u2925");
        this.entities.put("&hkswarow;", "\u2926");
        this.entities.put("&hoarr;", "\u21ff");
        this.entities.put("&homtht;", "\u223b");
        this.entities.put("&hookleftarrow;", "\u21a9");
        this.entities.put("&hookrightarrow;", "\u21aa");
        this.entities.put("&hopf;", "\ud835\udd59");
        this.entities.put("&horbar;", "\u2015");
        this.entities.put("&hscr;", "\ud835\udcbd");
        this.entities.put("&hslash;", "\u210f");
        this.entities.put("&hstrok;", "\u0127");
        this.entities.put("&hybull;", "\u2043");
        this.entities.put("&hyphen;", "\u2010");
        this.entities.put("&iacute;", "\u00ed");
        this.entities.put("&ic;", "\u2063");
        this.entities.put("&icirc;", "\u00ee");
        this.entities.put("&icy;", "\u0438");
        this.entities.put("&iecy;", "\u0435");
        this.entities.put("&iexcl;", "\u00a1");
        this.entities.put("&iff;", "\u21d4");
        this.entities.put("&ifr;", "\ud835\udd26");
        this.entities.put("&igrave;", "\u00ec");
        this.entities.put("&ii;", "\u2148");
        this.entities.put("&iiiint;", "\u2a0c");
        this.entities.put("&iiint;", "\u222d");
        this.entities.put("&iinfin;", "\u29dc");
        this.entities.put("&iiota;", "\u2129");
        this.entities.put("&ijlig;", "\u0133");
        this.entities.put("&imacr;", "\u012b");
        this.entities.put("&image;", "\u2111");
        this.entities.put("&imagline;", "\u2110");
        this.entities.put("&imagpart;", "\u2111");
        this.entities.put("&imath;", "\u0131");
        this.entities.put("&imof;", "\u22b7");
        this.entities.put("&imped;", "\u01b5");
        this.entities.put("&in;", "\u2208");
        this.entities.put("&incare;", "\u2105");
        this.entities.put("&infin;", "\u221e");
        this.entities.put("&infintie;", "\u29dd");
        this.entities.put("&inodot;", "\u0131");
        this.entities.put("&int;", "\u222b");
        this.entities.put("&intcal;", "\u22ba");
        this.entities.put("&integers;", "\u2124");
        this.entities.put("&intercal;", "\u22ba");
        this.entities.put("&intlarhk;", "\u2a17");
        this.entities.put("&intprod;", "\u2a3c");
        this.entities.put("&iocy;", "\u0451");
        this.entities.put("&iogon;", "\u012f");
        this.entities.put("&iopf;", "\ud835\udd5a");
        this.entities.put("&iota;", "\u03b9");
        this.entities.put("&iprod;", "\u2a3c");
        this.entities.put("&iquest;", "\u00bf");
        this.entities.put("&iscr;", "\ud835\udcbe");
        this.entities.put("&isin;", "\u2208");
        this.entities.put("&isinE;", "\u22f9");
        this.entities.put("&isindot;", "\u22f5");
        this.entities.put("&isins;", "\u22f4");
        this.entities.put("&isinsv;", "\u22f3");
        this.entities.put("&isinv;", "\u2208");
        this.entities.put("&it;", "\u2062");
        this.entities.put("&itilde;", "\u0129");
        this.entities.put("&iukcy;", "\u0456");
        this.entities.put("&iuml;", "\u00ef");
        this.entities.put("&jcirc;", "\u0135");
        this.entities.put("&jcy;", "\u0439");
        this.entities.put("&jfr;", "\ud835\udd27");
        this.entities.put("&jmath;", "\u0237");
        this.entities.put("&jopf;", "\ud835\udd5b");
        this.entities.put("&jscr;", "\ud835\udcbf");
        this.entities.put("&jsercy;", "\u0458");
        this.entities.put("&jukcy;", "\u0454");
        this.entities.put("&kappa;", "\u03ba");
        this.entities.put("&kappav;", "\u03f0");
        this.entities.put("&kcedil;", "\u0137");
        this.entities.put("&kcy;", "\u043a");
        this.entities.put("&kfr;", "\ud835\udd28");
        this.entities.put("&kgreen;", "\u0138");
        this.entities.put("&khcy;", "\u0445");
        this.entities.put("&kjcy;", "\u045c");
        this.entities.put("&kopf;", "\ud835\udd5c");
        this.entities.put("&kscr;", "\ud835\udcc0");
        this.entities.put("&lAarr;", "\u21da");
        this.entities.put("&lArr;", "\u21d0");
        this.entities.put("&lAtail;", "\u291b");
        this.entities.put("&lBarr;", "\u290e");
        this.entities.put("&lE;", "\u2266");
        this.entities.put("&lEg;", "\u2a8b");
        this.entities.put("&lHar;", "\u2962");
        this.entities.put("&lacute;", "\u013a");
        this.entities.put("&laemptyv;", "\u29b4");
        this.entities.put("&lagran;", "\u2112");
        this.entities.put("&lambda;", "\u03bb");
        this.entities.put("&lang;", "\u27e8");
        this.entities.put("&langd;", "\u2991");
        this.entities.put("&langle;", "\u27e8");
        this.entities.put("&lap;", "\u2a85");
        this.entities.put("&laquo;", "\u00ab");
        this.entities.put("&larr;", "\u2190");
        this.entities.put("&larrb;", "\u21e4");
        this.entities.put("&larrbfs;", "\u291f");
        this.entities.put("&larrfs;", "\u291d");
        this.entities.put("&larrhk;", "\u21a9");
        this.entities.put("&larrlp;", "\u21ab");
        this.entities.put("&larrpl;", "\u2939");
        this.entities.put("&larrsim;", "\u2973");
        this.entities.put("&larrtl;", "\u21a2");
        this.entities.put("&lat;", "\u2aab");
        this.entities.put("&latail;", "\u2919");
        this.entities.put("&late;", "\u2aad");
        this.entities.put("&lates;", "\u2aad\ufe00");
        this.entities.put("&lbarr;", "\u290c");
        this.entities.put("&lbbrk;", "\u2772");
        this.entities.put("&lbrace;", "{");
        this.entities.put("&lbrack;", "[");
        this.entities.put("&lbrke;", "\u298b");
        this.entities.put("&lbrksld;", "\u298f");
        this.entities.put("&lbrkslu;", "\u298d");
        this.entities.put("&lcaron;", "\u013e");
        this.entities.put("&lcedil;", "\u013c");
        this.entities.put("&lceil;", "\u2308");
        this.entities.put("&lcub;", "{");
        this.entities.put("&lcy;", "\u043b");
        this.entities.put("&ldca;", "\u2936");
        this.entities.put("&ldquo;", "\u201c");
        this.entities.put("&ldquor;", "\u201e");
        this.entities.put("&ldrdhar;", "\u2967");
        this.entities.put("&ldrushar;", "\u294b");
        this.entities.put("&ldsh;", "\u21b2");
        this.entities.put("&le;", "\u2264");
        this.entities.put("&leftarrow;", "\u2190");
        this.entities.put("&leftarrowtail;", "\u21a2");
        this.entities.put("&leftharpoondown;", "\u21bd");
        this.entities.put("&leftharpoonup;", "\u21bc");
        this.entities.put("&leftleftarrows;", "\u21c7");
        this.entities.put("&leftrightarrow;", "\u2194");
        this.entities.put("&leftrightarrows;", "\u21c6");
        this.entities.put("&leftrightharpoons;", "\u21cb");
        this.entities.put("&leftrightsquigarrow;", "\u21ad");
        this.entities.put("&leftthreetimes;", "\u22cb");
        this.entities.put("&leg;", "\u22da");
        this.entities.put("&leq;", "\u2264");
        this.entities.put("&leqq;", "\u2266");
        this.entities.put("&leqslant;", "\u2a7d");
        this.entities.put("&les;", "\u2a7d");
        this.entities.put("&lescc;", "\u2aa8");
        this.entities.put("&lesdot;", "\u2a7f");
        this.entities.put("&lesdoto;", "\u2a81");
        this.entities.put("&lesdotor;", "\u2a83");
        this.entities.put("&lesg;", "\u22da\ufe00");
        this.entities.put("&lesges;", "\u2a93");
        this.entities.put("&lessapprox;", "\u2a85");
        this.entities.put("&lessdot;", "\u22d6");
        this.entities.put("&lesseqgtr;", "\u22da");
        this.entities.put("&lesseqqgtr;", "\u2a8b");
        this.entities.put("&lessgtr;", "\u2276");
        this.entities.put("&lesssim;", "\u2272");
        this.entities.put("&lfisht;", "\u297c");
        this.entities.put("&lfloor;", "\u230a");
        this.entities.put("&lfr;", "\ud835\udd29");
        this.entities.put("&lg;", "\u2276");
        this.entities.put("&lgE;", "\u2a91");
        this.entities.put("&lhard;", "\u21bd");
        this.entities.put("&lharu;", "\u21bc");
        this.entities.put("&lharul;", "\u296a");
        this.entities.put("&lhblk;", "\u2584");
        this.entities.put("&ljcy;", "\u0459");
        this.entities.put("&ll;", "\u226a");
        this.entities.put("&llarr;", "\u21c7");
        this.entities.put("&llcorner;", "\u231e");
        this.entities.put("&llhard;", "\u296b");
        this.entities.put("&lltri;", "\u25fa");
        this.entities.put("&lmidot;", "\u0140");
        this.entities.put("&lmoust;", "\u23b0");
        this.entities.put("&lmoustache;", "\u23b0");
        this.entities.put("&lnE;", "\u2268");
        this.entities.put("&lnap;", "\u2a89");
        this.entities.put("&lnapprox;", "\u2a89");
        this.entities.put("&lne;", "\u2a87");
        this.entities.put("&lneq;", "\u2a87");
        this.entities.put("&lneqq;", "\u2268");
        this.entities.put("&lnsim;", "\u22e6");
        this.entities.put("&loang;", "\u27ec");
        this.entities.put("&loarr;", "\u21fd");
        this.entities.put("&lobrk;", "\u27e6");
        this.entities.put("&longleftarrow;", "\u27f5");
        this.entities.put("&longleftrightarrow;", "\u27f7");
        this.entities.put("&longmapsto;", "\u27fc");
        this.entities.put("&longrightarrow;", "\u27f6");
        this.entities.put("&looparrowleft;", "\u21ab");
        this.entities.put("&looparrowright;", "\u21ac");
        this.entities.put("&lopar;", "\u2985");
        this.entities.put("&lopf;", "\ud835\udd5d");
        this.entities.put("&loplus;", "\u2a2d");
        this.entities.put("&lotimes;", "\u2a34");
        this.entities.put("&lowast;", "\u2217");
        this.entities.put("&lowbar;", "_");
        this.entities.put("&loz;", "\u25ca");
        this.entities.put("&lozenge;", "\u25ca");
        this.entities.put("&lozf;", "\u29eb");
        this.entities.put("&lpar;", "(");
        this.entities.put("&lparlt;", "\u2993");
        this.entities.put("&lrarr;", "\u21c6");
        this.entities.put("&lrcorner;", "\u231f");
        this.entities.put("&lrhar;", "\u21cb");
        this.entities.put("&lrhard;", "\u296d");
        this.entities.put("&lrm;", "\u200e");
        this.entities.put("&lrtri;", "\u22bf");
        this.entities.put("&lsaquo;", "\u2039");
        this.entities.put("&lscr;", "\ud835\udcc1");
        this.entities.put("&lsh;", "\u21b0");
        this.entities.put("&lsim;", "\u2272");
        this.entities.put("&lsime;", "\u2a8d");
        this.entities.put("&lsimg;", "\u2a8f");
        this.entities.put("&lsqb;", "[");
        this.entities.put("&lsquo;", "\u2018");
        this.entities.put("&lsquor;", "\u201a");
        this.entities.put("&lstrok;", "\u0142");
        this.entities.put("&lt;", "<");
        this.entities.put("&ltcc;", "\u2aa6");
        this.entities.put("&ltcir;", "\u2a79");
        this.entities.put("&ltdot;", "\u22d6");
        this.entities.put("&lthree;", "\u22cb");
        this.entities.put("&ltimes;", "\u22c9");
        this.entities.put("&ltlarr;", "\u2976");
        this.entities.put("&ltquest;", "\u2a7b");
        this.entities.put("&ltrPar;", "\u2996");
        this.entities.put("&ltri;", "\u25c3");
        this.entities.put("&ltrie;", "\u22b4");
        this.entities.put("&ltrif;", "\u25c2");
        this.entities.put("&lurdshar;", "\u294a");
        this.entities.put("&luruhar;", "\u2966");
        this.entities.put("&lvertneqq;", "\u2268\ufe00");
        this.entities.put("&lvnE;", "\u2268\ufe00");
        this.entities.put("&mDDot;", "\u223a");
        this.entities.put("&macr;", "\u00af");
        this.entities.put("&male;", "\u2642");
        this.entities.put("&malt;", "\u2720");
        this.entities.put("&maltese;", "\u2720");
        this.entities.put("&map;", "\u21a6");
        this.entities.put("&mapsto;", "\u21a6");
        this.entities.put("&mapstodown;", "\u21a7");
        this.entities.put("&mapstoleft;", "\u21a4");
        this.entities.put("&mapstoup;", "\u21a5");
        this.entities.put("&marker;", "\u25ae");
        this.entities.put("&mcomma;", "\u2a29");
        this.entities.put("&mcy;", "\u043c");
        this.entities.put("&mdash;", "\u2014");
        this.entities.put("&measuredangle;", "\u2221");
        this.entities.put("&mfr;", "\ud835\udd2a");
        this.entities.put("&mho;", "\u2127");
        this.entities.put("&micro;", "\u00b5");
        this.entities.put("&mid;", "\u2223");
        this.entities.put("&midast;", "*");
        this.entities.put("&midcir;", "\u2af0");
        this.entities.put("&middot;", "\u00b7");
        this.entities.put("&minus;", "\u2212");
        this.entities.put("&minusb;", "\u229f");
        this.entities.put("&minusd;", "\u2238");
        this.entities.put("&minusdu;", "\u2a2a");
        this.entities.put("&mlcp;", "\u2adb");
        this.entities.put("&mldr;", "\u2026");
        this.entities.put("&mnplus;", "\u2213");
        this.entities.put("&models;", "\u22a7");
        this.entities.put("&mopf;", "\ud835\udd5e");
        this.entities.put("&mp;", "\u2213");
        this.entities.put("&mscr;", "\ud835\udcc2");
        this.entities.put("&mstpos;", "\u223e");
        this.entities.put("&mu;", "\u03bc");
        this.entities.put("&multimap;", "\u22b8");
        this.entities.put("&mumap;", "\u22b8");
        this.entities.put("&nGg;", "\u22d9\u0338");
        this.entities.put("&nGt;", "\u226b\u20d2");
        this.entities.put("&nGtv;", "\u226b\u0338");
        this.entities.put("&nLeftarrow;", "\u21cd");
        this.entities.put("&nLeftrightarrow;", "\u21ce");
        this.entities.put("&nLl;", "\u22d8\u0338");
        this.entities.put("&nLt;", "\u226a\u20d2");
        this.entities.put("&nLtv;", "\u226a\u0338");
        this.entities.put("&nRightarrow;", "\u21cf");
        this.entities.put("&nVDash;", "\u22af");
        this.entities.put("&nVdash;", "\u22ae");
        this.entities.put("&nabla;", "\u2207");
        this.entities.put("&nacute;", "\u0144");
        this.entities.put("&nang;", "\u2220\u20d2");
        this.entities.put("&nap;", "\u2249");
        this.entities.put("&napE;", "\u2a70\u0338");
        this.entities.put("&napid;", "\u224b\u0338");
        this.entities.put("&napos;", "\u0149");
        this.entities.put("&napprox;", "\u2249");
        this.entities.put("&natur;", "\u266e");
        this.entities.put("&natural;", "\u266e");
        this.entities.put("&naturals;", "\u2115");
        this.entities.put("&nbsp;", "\u00a0");
        this.entities.put("&nbump;", "\u224e\u0338");
        this.entities.put("&nbumpe;", "\u224f\u0338");
        this.entities.put("&ncap;", "\u2a43");
        this.entities.put("&ncaron;", "\u0148");
        this.entities.put("&ncedil;", "\u0146");
        this.entities.put("&ncong;", "\u2247");
        this.entities.put("&ncongdot;", "\u2a6d\u0338");
        this.entities.put("&ncup;", "\u2a42");
        this.entities.put("&ncy;", "\u043d");
        this.entities.put("&ndash;", "\u2013");
        this.entities.put("&ne;", "\u2260");
        this.entities.put("&neArr;", "\u21d7");
        this.entities.put("&nearhk;", "\u2924");
        this.entities.put("&nearr;", "\u2197");
        this.entities.put("&nearrow;", "\u2197");
        this.entities.put("&nedot;", "\u2250\u0338");
        this.entities.put("&nequiv;", "\u2262");
        this.entities.put("&nesear;", "\u2928");
        this.entities.put("&nesim;", "\u2242\u0338");
        this.entities.put("&nexist;", "\u2204");
        this.entities.put("&nexists;", "\u2204");
        this.entities.put("&nfr;", "\ud835\udd2b");
        this.entities.put("&ngE;", "\u2267\u0338");
        this.entities.put("&nge;", "\u2271");
        this.entities.put("&ngeq;", "\u2271");
        this.entities.put("&ngeqq;", "\u2267\u0338");
        this.entities.put("&ngeqslant;", "\u2a7e\u0338");
        this.entities.put("&nges;", "\u2a7e\u0338");
        this.entities.put("&ngsim;", "\u2275");
        this.entities.put("&ngt;", "\u226f");
        this.entities.put("&ngtr;", "\u226f");
        this.entities.put("&nhArr;", "\u21ce");
        this.entities.put("&nharr;", "\u21ae");
        this.entities.put("&nhpar;", "\u2af2");
        this.entities.put("&ni;", "\u220b");
        this.entities.put("&nis;", "\u22fc");
        this.entities.put("&nisd;", "\u22fa");
        this.entities.put("&niv;", "\u220b");
        this.entities.put("&njcy;", "\u045a");
        this.entities.put("&nlArr;", "\u21cd");
        this.entities.put("&nlE;", "\u2266\u0338");
        this.entities.put("&nlarr;", "\u219a");
        this.entities.put("&nldr;", "\u2025");
        this.entities.put("&nle;", "\u2270");
        this.entities.put("&nleftarrow;", "\u219a");
        this.entities.put("&nleftrightarrow;", "\u21ae");
        this.entities.put("&nleq;", "\u2270");
        this.entities.put("&nleqq;", "\u2266\u0338");
        this.entities.put("&nleqslant;", "\u2a7d\u0338");
        this.entities.put("&nles;", "\u2a7d\u0338");
        this.entities.put("&nless;", "\u226e");
        this.entities.put("&nlsim;", "\u2274");
        this.entities.put("&nlt;", "\u226e");
        this.entities.put("&nltri;", "\u22ea");
        this.entities.put("&nltrie;", "\u22ec");
        this.entities.put("&nmid;", "\u2224");
        this.entities.put("&nopf;", "\ud835\udd5f");
        this.entities.put("&not;", "\u00ac");
        this.entities.put("&notin;", "\u2209");
        this.entities.put("&notinE;", "\u22f9\u0338");
        this.entities.put("&notindot;", "\u22f5\u0338");
        this.entities.put("&notinva;", "\u2209");
        this.entities.put("&notinvb;", "\u22f7");
        this.entities.put("&notinvc;", "\u22f6");
        this.entities.put("&notni;", "\u220c");
        this.entities.put("&notniva;", "\u220c");
        this.entities.put("&notnivb;", "\u22fe");
        this.entities.put("&notnivc;", "\u22fd");
        this.entities.put("&npar;", "\u2226");
        this.entities.put("&nparallel;", "\u2226");
        this.entities.put("&nparsl;", "\u2afd\u20e5");
        this.entities.put("&npart;", "\u2202\u0338");
        this.entities.put("&npolint;", "\u2a14");
        this.entities.put("&npr;", "\u2280");
        this.entities.put("&nprcue;", "\u22e0");
        this.entities.put("&npre;", "\u2aaf\u0338");
        this.entities.put("&nprec;", "\u2280");
        this.entities.put("&npreceq;", "\u2aaf\u0338");
        this.entities.put("&nrArr;", "\u21cf");
        this.entities.put("&nrarr;", "\u219b");
        this.entities.put("&nrarrc;", "\u2933\u0338");
        this.entities.put("&nrarrw;", "\u219d\u0338");
        this.entities.put("&nrightarrow;", "\u219b");
        this.entities.put("&nrtri;", "\u22eb");
        this.entities.put("&nrtrie;", "\u22ed");
        this.entities.put("&nsc;", "\u2281");
        this.entities.put("&nsccue;", "\u22e1");
        this.entities.put("&nsce;", "\u2ab0\u0338");
        this.entities.put("&nscr;", "\ud835\udcc3");
        this.entities.put("&nshortmid;", "\u2224");
        this.entities.put("&nshortparallel;", "\u2226");
        this.entities.put("&nsim;", "\u2241");
        this.entities.put("&nsime;", "\u2244");
        this.entities.put("&nsimeq;", "\u2244");
        this.entities.put("&nsmid;", "\u2224");
        this.entities.put("&nspar;", "\u2226");
        this.entities.put("&nsqsube;", "\u22e2");
        this.entities.put("&nsqsupe;", "\u22e3");
        this.entities.put("&nsub;", "\u2284");
        this.entities.put("&nsubE;", "\u2ac5\u0338");
        this.entities.put("&nsube;", "\u2288");
        this.entities.put("&nsubset;", "\u2282\u20d2");
        this.entities.put("&nsubseteq;", "\u2288");
        this.entities.put("&nsubseteqq;", "\u2ac5\u0338");
        this.entities.put("&nsucc;", "\u2281");
        this.entities.put("&nsucceq;", "\u2ab0\u0338");
        this.entities.put("&nsup;", "\u2285");
        this.entities.put("&nsupE;", "\u2ac6\u0338");
        this.entities.put("&nsupe;", "\u2289");
        this.entities.put("&nsupset;", "\u2283\u20d2");
        this.entities.put("&nsupseteq;", "\u2289");
        this.entities.put("&nsupseteqq;", "\u2ac6\u0338");
        this.entities.put("&ntgl;", "\u2279");
        this.entities.put("&ntilde;", "\u00f1");
        this.entities.put("&ntlg;", "\u2278");
        this.entities.put("&ntriangleleft;", "\u22ea");
        this.entities.put("&ntrianglelefteq;", "\u22ec");
        this.entities.put("&ntriangleright;", "\u22eb");
        this.entities.put("&ntrianglerighteq;", "\u22ed");
        this.entities.put("&nu;", "\u03bd");
        this.entities.put("&num;", "#");
        this.entities.put("&numero;", "\u2116");
        this.entities.put("&numsp;", "\u2007");
        this.entities.put("&nvDash;", "\u22ad");
        this.entities.put("&nvHarr;", "\u2904");
        this.entities.put("&nvap;", "\u224d\u20d2");
        this.entities.put("&nvdash;", "\u22ac");
        this.entities.put("&nvge;", "\u2265\u20d2");
        this.entities.put("&nvgt;", ">\u20d2");
        this.entities.put("&nvinfin;", "\u29de");
        this.entities.put("&nvlArr;", "\u2902");
        this.entities.put("&nvle;", "\u2264\u20d2");
        this.entities.put("&nvlt;", "<\u20d2");
        this.entities.put("&nvltrie;", "\u22b4\u20d2");
        this.entities.put("&nvrArr;", "\u2903");
        this.entities.put("&nvrtrie;", "\u22b5\u20d2");
        this.entities.put("&nvsim;", "\u223c\u20d2");
        this.entities.put("&nwArr;", "\u21d6");
        this.entities.put("&nwarhk;", "\u2923");
        this.entities.put("&nwarr;", "\u2196");
        this.entities.put("&nwarrow;", "\u2196");
        this.entities.put("&nwnear;", "\u2927");
        this.entities.put("&oS;", "\u24c8");
        this.entities.put("&oacute;", "\u00f3");
        this.entities.put("&oast;", "\u229b");
        this.entities.put("&ocir;", "\u229a");
        this.entities.put("&ocirc;", "\u00f4");
        this.entities.put("&ocy;", "\u043e");
        this.entities.put("&odash;", "\u229d");
        this.entities.put("&odblac;", "\u0151");
        this.entities.put("&odiv;", "\u2a38");
        this.entities.put("&odot;", "\u2299");
        this.entities.put("&odsold;", "\u29bc");
        this.entities.put("&oelig;", "\u0153");
        this.entities.put("&ofcir;", "\u29bf");
        this.entities.put("&ofr;", "\ud835\udd2c");
        this.entities.put("&ogon;", "\u02db");
        this.entities.put("&ograve;", "\u00f2");
        this.entities.put("&ogt;", "\u29c1");
        this.entities.put("&ohbar;", "\u29b5");
        this.entities.put("&ohm;", "\u03a9");
        this.entities.put("&oint;", "\u222e");
        this.entities.put("&olarr;", "\u21ba");
        this.entities.put("&olcir;", "\u29be");
        this.entities.put("&olcross;", "\u29bb");
        this.entities.put("&oline;", "\u203e");
        this.entities.put("&olt;", "\u29c0");
        this.entities.put("&omacr;", "\u014d");
        this.entities.put("&omega;", "\u03c9");
        this.entities.put("&omicron;", "\u03bf");
        this.entities.put("&omid;", "\u29b6");
        this.entities.put("&ominus;", "\u2296");
        this.entities.put("&oopf;", "\ud835\udd60");
        this.entities.put("&opar;", "\u29b7");
        this.entities.put("&operp;", "\u29b9");
        this.entities.put("&oplus;", "\u2295");
        this.entities.put("&or;", "\u2228");
        this.entities.put("&orarr;", "\u21bb");
        this.entities.put("&ord;", "\u2a5d");
        this.entities.put("&order;", "\u2134");
        this.entities.put("&orderof;", "\u2134");
        this.entities.put("&ordf;", "\u00aa");
        this.entities.put("&ordm;", "\u00ba");
        this.entities.put("&origof;", "\u22b6");
        this.entities.put("&oror;", "\u2a56");
        this.entities.put("&orslope;", "\u2a57");
        this.entities.put("&orv;", "\u2a5b");
        this.entities.put("&oscr;", "\u2134");
        this.entities.put("&oslash;", "\u00f8");
        this.entities.put("&osol;", "\u2298");
        this.entities.put("&otilde;", "\u00f5");
        this.entities.put("&otimes;", "\u2297");
        this.entities.put("&otimesas;", "\u2a36");
        this.entities.put("&ouml;", "\u00f6");
        this.entities.put("&ovbar;", "\u233d");
        this.entities.put("&par;", "\u2225");
        this.entities.put("&para;", "\u00b6");
        this.entities.put("&parallel;", "\u2225");
        this.entities.put("&parsim;", "\u2af3");
        this.entities.put("&parsl;", "\u2afd");
        this.entities.put("&part;", "\u2202");
        this.entities.put("&pcy;", "\u043f");
        this.entities.put("&percnt;", "%");
        this.entities.put("&period;", ".");
        this.entities.put("&permil;", "\u2030");
        this.entities.put("&perp;", "\u22a5");
        this.entities.put("&pertenk;", "\u2031");
        this.entities.put("&pfr;", "\ud835\udd2d");
        this.entities.put("&phi;", "\u03c6");
        this.entities.put("&phiv;", "\u03d5");
        this.entities.put("&phmmat;", "\u2133");
        this.entities.put("&phone;", "\u260e");
        this.entities.put("&pi;", "\u03c0");
        this.entities.put("&pitchfork;", "\u22d4");
        this.entities.put("&piv;", "\u03d6");
        this.entities.put("&planck;", "\u210f");
        this.entities.put("&planckh;", "\u210e");
        this.entities.put("&plankv;", "\u210f");
        this.entities.put("&plus;", "+");
        this.entities.put("&plusacir;", "\u2a23");
        this.entities.put("&plusb;", "\u229e");
        this.entities.put("&pluscir;", "\u2a22");
        this.entities.put("&plusdo;", "\u2214");
        this.entities.put("&plusdu;", "\u2a25");
        this.entities.put("&pluse;", "\u2a72");
        this.entities.put("&plusmn;", "\u00b1");
        this.entities.put("&plussim;", "\u2a26");
        this.entities.put("&plustwo;", "\u2a27");
        this.entities.put("&pm;", "\u00b1");
        this.entities.put("&pointint;", "\u2a15");
        this.entities.put("&popf;", "\ud835\udd61");
        this.entities.put("&pound;", "\u00a3");
        this.entities.put("&pr;", "\u227a");
        this.entities.put("&prE;", "\u2ab3");
        this.entities.put("&prap;", "\u2ab7");
        this.entities.put("&prcue;", "\u227c");
        this.entities.put("&pre;", "\u2aaf");
        this.entities.put("&prec;", "\u227a");
        this.entities.put("&precapprox;", "\u2ab7");
        this.entities.put("&preccurlyeq;", "\u227c");
        this.entities.put("&preceq;", "\u2aaf");
        this.entities.put("&precnapprox;", "\u2ab9");
        this.entities.put("&precneqq;", "\u2ab5");
        this.entities.put("&precnsim;", "\u22e8");
        this.entities.put("&precsim;", "\u227e");
        this.entities.put("&prime;", "\u2032");
        this.entities.put("&primes;", "\u2119");
        this.entities.put("&prnE;", "\u2ab5");
        this.entities.put("&prnap;", "\u2ab9");
        this.entities.put("&prnsim;", "\u22e8");
        this.entities.put("&prod;", "\u220f");
        this.entities.put("&profalar;", "\u232e");
        this.entities.put("&profline;", "\u2312");
        this.entities.put("&profsurf;", "\u2313");
        this.entities.put("&prop;", "\u221d");
        this.entities.put("&propto;", "\u221d");
        this.entities.put("&prsim;", "\u227e");
        this.entities.put("&prurel;", "\u22b0");
        this.entities.put("&pscr;", "\ud835\udcc5");
        this.entities.put("&psi;", "\u03c8");
        this.entities.put("&puncsp;", "\u2008");
        this.entities.put("&qfr;", "\ud835\udd2e");
        this.entities.put("&qint;", "\u2a0c");
        this.entities.put("&qopf;", "\ud835\udd62");
        this.entities.put("&qprime;", "\u2057");
        this.entities.put("&qscr;", "\ud835\udcc6");
        this.entities.put("&quaternions;", "\u210d");
        this.entities.put("&quatint;", "\u2a16");
        this.entities.put("&quest;", "?");
        this.entities.put("&questeq;", "\u225f");
        this.entities.put("&quot;", "\\u0022");
        this.entities.put("&rAarr;", "\u21db");
        this.entities.put("&rArr;", "\u21d2");
        this.entities.put("&rAtail;", "\u291c");
        this.entities.put("&rBarr;", "\u290f");
        this.entities.put("&rHar;", "\u2964");
        this.entities.put("&race;", "\u223d\u0331");
        this.entities.put("&racute;", "\u0155");
        this.entities.put("&radic;", "\u221a");
        this.entities.put("&raemptyv;", "\u29b3");
        this.entities.put("&rang;", "\u27e9");
        this.entities.put("&rangd;", "\u2992");
        this.entities.put("&range;", "\u29a5");
        this.entities.put("&rangle;", "\u27e9");
        this.entities.put("&raquo;", "\u00bb");
        this.entities.put("&rarr;", "\u2192");
        this.entities.put("&rarrap;", "\u2975");
        this.entities.put("&rarrb;", "\u21e5");
        this.entities.put("&rarrbfs;", "\u2920");
        this.entities.put("&rarrc;", "\u2933");
        this.entities.put("&rarrfs;", "\u291e");
        this.entities.put("&rarrhk;", "\u21aa");
        this.entities.put("&rarrlp;", "\u21ac");
        this.entities.put("&rarrpl;", "\u2945");
        this.entities.put("&rarrsim;", "\u2974");
        this.entities.put("&rarrtl;", "\u21a3");
        this.entities.put("&rarrw;", "\u219d");
        this.entities.put("&ratail;", "\u291a");
        this.entities.put("&ratio;", "\u2236");
        this.entities.put("&rationals;", "\u211a");
        this.entities.put("&rbarr;", "\u290d");
        this.entities.put("&rbbrk;", "\u2773");
        this.entities.put("&rbrace;", "}");
        this.entities.put("&rbrack;", "]");
        this.entities.put("&rbrke;", "\u298c");
        this.entities.put("&rbrksld;", "\u298e");
        this.entities.put("&rbrkslu;", "\u2990");
        this.entities.put("&rcaron;", "\u0159");
        this.entities.put("&rcedil;", "\u0157");
        this.entities.put("&rceil;", "\u2309");
        this.entities.put("&rcub;", "}");
        this.entities.put("&rcy;", "\u0440");
        this.entities.put("&rdca;", "\u2937");
        this.entities.put("&rdldhar;", "\u2969");
        this.entities.put("&rdquo;", "\u201d");
        this.entities.put("&rdquor;", "\u201d");
        this.entities.put("&rdsh;", "\u21b3");
        this.entities.put("&real;", "\u211c");
        this.entities.put("&realine;", "\u211b");
        this.entities.put("&realpart;", "\u211c");
        this.entities.put("&reals;", "\u211d");
        this.entities.put("&rect;", "\u25ad");
        this.entities.put("&reg;", "\u00ae");
        this.entities.put("&rfisht;", "\u297d");
        this.entities.put("&rfloor;", "\u230b");
        this.entities.put("&rfr;", "\ud835\udd2f");
        this.entities.put("&rhard;", "\u21c1");
        this.entities.put("&rharu;", "\u21c0");
        this.entities.put("&rharul;", "\u296c");
        this.entities.put("&rho;", "\u03c1");
        this.entities.put("&rhov;", "\u03f1");
        this.entities.put("&rightarrow;", "\u2192");
        this.entities.put("&rightarrowtail;", "\u21a3");
        this.entities.put("&rightharpoondown;", "\u21c1");
        this.entities.put("&rightharpoonup;", "\u21c0");
        this.entities.put("&rightleftarrows;", "\u21c4");
        this.entities.put("&rightleftharpoons;", "\u21cc");
        this.entities.put("&rightrightarrows;", "\u21c9");
        this.entities.put("&rightsquigarrow;", "\u219d");
        this.entities.put("&rightthreetimes;", "\u22cc");
        this.entities.put("&ring;", "\u02da");
        this.entities.put("&risingdotseq;", "\u2253");
        this.entities.put("&rlarr;", "\u21c4");
        this.entities.put("&rlhar;", "\u21cc");
        this.entities.put("&rlm;", "\u200f");
        this.entities.put("&rmoust;", "\u23b1");
        this.entities.put("&rmoustache;", "\u23b1");
        this.entities.put("&rnmid;", "\u2aee");
        this.entities.put("&roang;", "\u27ed");
        this.entities.put("&roarr;", "\u21fe");
        this.entities.put("&robrk;", "\u27e7");
        this.entities.put("&ropar;", "\u2986");
        this.entities.put("&ropf;", "\ud835\udd63");
        this.entities.put("&roplus;", "\u2a2e");
        this.entities.put("&rotimes;", "\u2a35");
        this.entities.put("&rpar;", ")");
        this.entities.put("&rpargt;", "\u2994");
        this.entities.put("&rppolint;", "\u2a12");
        this.entities.put("&rrarr;", "\u21c9");
        this.entities.put("&rsaquo;", "\u203a");
        this.entities.put("&rscr;", "\ud835\udcc7");
        this.entities.put("&rsh;", "\u21b1");
        this.entities.put("&rsqb;", "]");
        this.entities.put("&rsquo;", "\u2019");
        this.entities.put("&rsquor;", "\u2019");
        this.entities.put("&rthree;", "\u22cc");
        this.entities.put("&rtimes;", "\u22ca");
        this.entities.put("&rtri;", "\u25b9");
        this.entities.put("&rtrie;", "\u22b5");
        this.entities.put("&rtrif;", "\u25b8");
        this.entities.put("&rtriltri;", "\u29ce");
        this.entities.put("&ruluhar;", "\u2968");
        this.entities.put("&rx;", "\u211e");
        this.entities.put("&sacute;", "\u015b");
        this.entities.put("&sbquo;", "\u201a");
        this.entities.put("&sc;", "\u227b");
        this.entities.put("&scE;", "\u2ab4");
        this.entities.put("&scap;", "\u2ab8");
        this.entities.put("&scaron;", "\u0161");
        this.entities.put("&sccue;", "\u227d");
        this.entities.put("&sce;", "\u2ab0");
        this.entities.put("&scedil;", "\u015f");
        this.entities.put("&scirc;", "\u015d");
        this.entities.put("&scnE;", "\u2ab6");
        this.entities.put("&scnap;", "\u2aba");
        this.entities.put("&scnsim;", "\u22e9");
        this.entities.put("&scpolint;", "\u2a13");
        this.entities.put("&scsim;", "\u227f");
        this.entities.put("&scy;", "\u0441");
        this.entities.put("&sdot;", "\u22c5");
        this.entities.put("&sdotb;", "\u22a1");
        this.entities.put("&sdote;", "\u2a66");
        this.entities.put("&seArr;", "\u21d8");
        this.entities.put("&searhk;", "\u2925");
        this.entities.put("&searr;", "\u2198");
        this.entities.put("&searrow;", "\u2198");
        this.entities.put("&sect;", "\u00a7");
        this.entities.put("&semi;", ";");
        this.entities.put("&seswar;", "\u2929");
        this.entities.put("&setminus;", "\u2216");
        this.entities.put("&setmn;", "\u2216");
        this.entities.put("&sext;", "\u2736");
        this.entities.put("&sfr;", "\ud835\udd30");
        this.entities.put("&sfrown;", "\u2322");
        this.entities.put("&sharp;", "\u266f");
        this.entities.put("&shchcy;", "\u0449");
        this.entities.put("&shcy;", "\u0448");
        this.entities.put("&shortmid;", "\u2223");
        this.entities.put("&shortparallel;", "\u2225");
        this.entities.put("&shy;", "\u00ad");
        this.entities.put("&sigma;", "\u03c3");
        this.entities.put("&sigmaf;", "\u03c2");
        this.entities.put("&sigmav;", "\u03c2");
        this.entities.put("&sim;", "\u223c");
        this.entities.put("&simdot;", "\u2a6a");
        this.entities.put("&sime;", "\u2243");
        this.entities.put("&simeq;", "\u2243");
        this.entities.put("&simg;", "\u2a9e");
        this.entities.put("&simgE;", "\u2aa0");
        this.entities.put("&siml;", "\u2a9d");
        this.entities.put("&simlE;", "\u2a9f");
        this.entities.put("&simne;", "\u2246");
        this.entities.put("&simplus;", "\u2a24");
        this.entities.put("&simrarr;", "\u2972");
        this.entities.put("&slarr;", "\u2190");
        this.entities.put("&smallsetminus;", "\u2216");
        this.entities.put("&smashp;", "\u2a33");
        this.entities.put("&smeparsl;", "\u29e4");
        this.entities.put("&smid;", "\u2223");
        this.entities.put("&smile;", "\u2323");
        this.entities.put("&smt;", "\u2aaa");
        this.entities.put("&smte;", "\u2aac");
        this.entities.put("&smtes;", "\u2aac\ufe00");
        this.entities.put("&softcy;", "\u044c");
        this.entities.put("&sol;", "/");
        this.entities.put("&solb;", "\u29c4");
        this.entities.put("&solbar;", "\u233f");
        this.entities.put("&sopf;", "\ud835\udd64");
        this.entities.put("&spades;", "\u2660");
        this.entities.put("&spadesuit;", "\u2660");
        this.entities.put("&spar;", "\u2225");
        this.entities.put("&sqcap;", "\u2293");
        this.entities.put("&sqcaps;", "\u2293\ufe00");
        this.entities.put("&sqcup;", "\u2294");
        this.entities.put("&sqcups;", "\u2294\ufe00");
        this.entities.put("&sqsub;", "\u228f");
        this.entities.put("&sqsube;", "\u2291");
        this.entities.put("&sqsubset;", "\u228f");
        this.entities.put("&sqsubseteq;", "\u2291");
        this.entities.put("&sqsup;", "\u2290");
        this.entities.put("&sqsupe;", "\u2292");
        this.entities.put("&sqsupset;", "\u2290");
        this.entities.put("&sqsupseteq;", "\u2292");
        this.entities.put("&squ;", "\u25a1");
        this.entities.put("&square;", "\u25a1");
        this.entities.put("&squarf;", "\u25aa");
        this.entities.put("&squf;", "\u25aa");
        this.entities.put("&srarr;", "\u2192");
        this.entities.put("&sscr;", "\ud835\udcc8");
        this.entities.put("&ssetmn;", "\u2216");
        this.entities.put("&ssmile;", "\u2323");
        this.entities.put("&sstarf;", "\u22c6");
        this.entities.put("&star;", "\u2606");
        this.entities.put("&starf;", "\u2605");
        this.entities.put("&straightepsilon;", "\u03f5");
        this.entities.put("&straightphi;", "\u03d5");
        this.entities.put("&strns;", "\u00af");
        this.entities.put("&sub;", "\u2282");
        this.entities.put("&subE;", "\u2ac5");
        this.entities.put("&subdot;", "\u2abd");
        this.entities.put("&sube;", "\u2286");
        this.entities.put("&subedot;", "\u2ac3");
        this.entities.put("&submult;", "\u2ac1");
        this.entities.put("&subnE;", "\u2acb");
        this.entities.put("&subne;", "\u228a");
        this.entities.put("&subplus;", "\u2abf");
        this.entities.put("&subrarr;", "\u2979");
        this.entities.put("&subset;", "\u2282");
        this.entities.put("&subseteq;", "\u2286");
        this.entities.put("&subseteqq;", "\u2ac5");
        this.entities.put("&subsetneq;", "\u228a");
        this.entities.put("&subsetneqq;", "\u2acb");
        this.entities.put("&subsim;", "\u2ac7");
        this.entities.put("&subsub;", "\u2ad5");
        this.entities.put("&subsup;", "\u2ad3");
        this.entities.put("&succ;", "\u227b");
        this.entities.put("&succapprox;", "\u2ab8");
        this.entities.put("&succcurlyeq;", "\u227d");
        this.entities.put("&succeq;", "\u2ab0");
        this.entities.put("&succnapprox;", "\u2aba");
        this.entities.put("&succneqq;", "\u2ab6");
        this.entities.put("&succnsim;", "\u22e9");
        this.entities.put("&succsim;", "\u227f");
        this.entities.put("&sum;", "\u2211");
        this.entities.put("&sung;", "\u266a");
        this.entities.put("&sup1;", "\u00b9");
        this.entities.put("&sup2;", "\u00b2");
        this.entities.put("&sup3;", "\u00b3");
        this.entities.put("&sup;", "\u2283");
        this.entities.put("&supE;", "\u2ac6");
        this.entities.put("&supdot;", "\u2abe");
        this.entities.put("&supdsub;", "\u2ad8");
        this.entities.put("&supe;", "\u2287");
        this.entities.put("&supedot;", "\u2ac4");
        this.entities.put("&suphsol;", "\u27c9");
        this.entities.put("&suphsub;", "\u2ad7");
        this.entities.put("&suplarr;", "\u297b");
        this.entities.put("&supmult;", "\u2ac2");
        this.entities.put("&supnE;", "\u2acc");
        this.entities.put("&supne;", "\u228b");
        this.entities.put("&supplus;", "\u2ac0");
        this.entities.put("&supset;", "\u2283");
        this.entities.put("&supseteq;", "\u2287");
        this.entities.put("&supseteqq;", "\u2ac6");
        this.entities.put("&supsetneq;", "\u228b");
        this.entities.put("&supsetneqq;", "\u2acc");
        this.entities.put("&supsim;", "\u2ac8");
        this.entities.put("&supsub;", "\u2ad4");
        this.entities.put("&supsup;", "\u2ad6");
        this.entities.put("&swArr;", "\u21d9");
        this.entities.put("&swarhk;", "\u2926");
        this.entities.put("&swarr;", "\u2199");
        this.entities.put("&swarrow;", "\u2199");
        this.entities.put("&swnwar;", "\u292a");
        this.entities.put("&szlig;", "\u00df");
        this.entities.put("&target;", "\u2316");
        this.entities.put("&tau;", "\u03c4");
        this.entities.put("&tbrk;", "\u23b4");
        this.entities.put("&tcaron;", "\u0165");
        this.entities.put("&tcedil;", "\u0163");
        this.entities.put("&tcy;", "\u0442");
        this.entities.put("&tdot;", "\u20db");
        this.entities.put("&telrec;", "\u2315");
        this.entities.put("&tfr;", "\ud835\udd31");
        this.entities.put("&there4;", "\u2234");
        this.entities.put("&therefore;", "\u2234");
        this.entities.put("&theta;", "\u03b8");
        this.entities.put("&thetasym;", "\u03d1");
        this.entities.put("&thetav;", "\u03d1");
        this.entities.put("&thickapprox;", "\u2248");
        this.entities.put("&thicksim;", "\u223c");
        this.entities.put("&thinsp;", "\u2009");
        this.entities.put("&thkap;", "\u2248");
        this.entities.put("&thksim;", "\u223c");
        this.entities.put("&thorn;", "\u00fe");
        this.entities.put("&tilde;", "\u02dc");
        this.entities.put("&times;", "\u00d7");
        this.entities.put("&timesb;", "\u22a0");
        this.entities.put("&timesbar;", "\u2a31");
        this.entities.put("&timesd;", "\u2a30");
        this.entities.put("&tint;", "\u222d");
        this.entities.put("&toea;", "\u2928");
        this.entities.put("&top;", "\u22a4");
        this.entities.put("&topbot;", "\u2336");
        this.entities.put("&topcir;", "\u2af1");
        this.entities.put("&topf;", "\ud835\udd65");
        this.entities.put("&topfork;", "\u2ada");
        this.entities.put("&tosa;", "\u2929");
        this.entities.put("&tprime;", "\u2034");
        this.entities.put("&trade;", "\u2122");
        this.entities.put("&triangle;", "\u25b5");
        this.entities.put("&triangledown;", "\u25bf");
        this.entities.put("&triangleleft;", "\u25c3");
        this.entities.put("&trianglelefteq;", "\u22b4");
        this.entities.put("&triangleq;", "\u225c");
        this.entities.put("&triangleright;", "\u25b9");
        this.entities.put("&trianglerighteq;", "\u22b5");
        this.entities.put("&tridot;", "\u25ec");
        this.entities.put("&trie;", "\u225c");
        this.entities.put("&triminus;", "\u2a3a");
        this.entities.put("&triplus;", "\u2a39");
        this.entities.put("&trisb;", "\u29cd");
        this.entities.put("&tritime;", "\u2a3b");
        this.entities.put("&trpezium;", "\u23e2");
        this.entities.put("&tscr;", "\ud835\udcc9");
        this.entities.put("&tscy;", "\u0446");
        this.entities.put("&tshcy;", "\u045b");
        this.entities.put("&tstrok;", "\u0167");
        this.entities.put("&twixt;", "\u226c");
        this.entities.put("&twoheadleftarrow;", "\u219e");
        this.entities.put("&twoheadrightarrow;", "\u21a0");
        this.entities.put("&uArr;", "\u21d1");
        this.entities.put("&uHar;", "\u2963");
        this.entities.put("&uacute;", "\u00fa");
        this.entities.put("&uarr;", "\u2191");
        this.entities.put("&ubrcy;", "\u045e");
        this.entities.put("&ubreve;", "\u016d");
        this.entities.put("&ucirc;", "\u00fb");
        this.entities.put("&ucy;", "\u0443");
        this.entities.put("&udarr;", "\u21c5");
        this.entities.put("&udblac;", "\u0171");
        this.entities.put("&udhar;", "\u296e");
        this.entities.put("&ufisht;", "\u297e");
        this.entities.put("&ufr;", "\ud835\udd32");
        this.entities.put("&ugrave;", "\u00f9");
        this.entities.put("&uharl;", "\u21bf");
        this.entities.put("&uharr;", "\u21be");
        this.entities.put("&uhblk;", "\u2580");
        this.entities.put("&ulcorn;", "\u231c");
        this.entities.put("&ulcorner;", "\u231c");
        this.entities.put("&ulcrop;", "\u230f");
        this.entities.put("&ultri;", "\u25f8");
        this.entities.put("&umacr;", "\u016b");
        this.entities.put("&uml;", "\u00a8");
        this.entities.put("&uogon;", "\u0173");
        this.entities.put("&uopf;", "\ud835\udd66");
        this.entities.put("&uparrow;", "\u2191");
        this.entities.put("&updownarrow;", "\u2195");
        this.entities.put("&upharpoonleft;", "\u21bf");
        this.entities.put("&upharpoonright;", "\u21be");
        this.entities.put("&uplus;", "\u228e");
        this.entities.put("&upsi;", "\u03c5");
        this.entities.put("&upsih;", "\u03d2");
        this.entities.put("&upsilon;", "\u03c5");
        this.entities.put("&upuparrows;", "\u21c8");
        this.entities.put("&urcorn;", "\u231d");
        this.entities.put("&urcorner;", "\u231d");
        this.entities.put("&urcrop;", "\u230e");
        this.entities.put("&uring;", "\u016f");
        this.entities.put("&urtri;", "\u25f9");
        this.entities.put("&uscr;", "\ud835\udcca");
        this.entities.put("&utdot;", "\u22f0");
        this.entities.put("&utilde;", "\u0169");
        this.entities.put("&utri;", "\u25b5");
        this.entities.put("&utrif;", "\u25b4");
        this.entities.put("&uuarr;", "\u21c8");
        this.entities.put("&uuml;", "\u00fc");
        this.entities.put("&uwangle;", "\u29a7");
        this.entities.put("&vArr;", "\u21d5");
        this.entities.put("&vBar;", "\u2ae8");
        this.entities.put("&vBarv;", "\u2ae9");
        this.entities.put("&vDash;", "\u22a8");
        this.entities.put("&vangrt;", "\u299c");
        this.entities.put("&varepsilon;", "\u03f5");
        this.entities.put("&varkappa;", "\u03f0");
        this.entities.put("&varnothing;", "\u2205");
        this.entities.put("&varphi;", "\u03d5");
        this.entities.put("&varpi;", "\u03d6");
        this.entities.put("&varpropto;", "\u221d");
        this.entities.put("&varr;", "\u2195");
        this.entities.put("&varrho;", "\u03f1");
        this.entities.put("&varsigma;", "\u03c2");
        this.entities.put("&varsubsetneq;", "\u228a\ufe00");
        this.entities.put("&varsubsetneqq;", "\u2acb\ufe00");
        this.entities.put("&varsupsetneq;", "\u228b\ufe00");
        this.entities.put("&varsupsetneqq;", "\u2acc\ufe00");
        this.entities.put("&vartheta;", "\u03d1");
        this.entities.put("&vartriangleleft;", "\u22b2");
        this.entities.put("&vartriangleright;", "\u22b3");
        this.entities.put("&vcy;", "\u0432");
        this.entities.put("&vdash;", "\u22a2");
        this.entities.put("&vee;", "\u2228");
        this.entities.put("&veebar;", "\u22bb");
        this.entities.put("&veeeq;", "\u225a");
        this.entities.put("&vellip;", "\u22ee");
        this.entities.put("&verbar;", "|");
        this.entities.put("&vert;", "|");
        this.entities.put("&vfr;", "\ud835\udd33");
        this.entities.put("&vltri;", "\u22b2");
        this.entities.put("&vnsub;", "\u2282\u20d2");
        this.entities.put("&vnsup;", "\u2283\u20d2");
        this.entities.put("&vopf;", "\ud835\udd67");
        this.entities.put("&vprop;", "\u221d");
        this.entities.put("&vrtri;", "\u22b3");
        this.entities.put("&vscr;", "\ud835\udccb");
        this.entities.put("&vsubnE;", "\u2acb\ufe00");
        this.entities.put("&vsubne;", "\u228a\ufe00");
        this.entities.put("&vsupnE;", "\u2acc\ufe00");
        this.entities.put("&vsupne;", "\u228b\ufe00");
        this.entities.put("&vzigzag;", "\u299a");
        this.entities.put("&wcirc;", "\u0175");
        this.entities.put("&wedbar;", "\u2a5f");
        this.entities.put("&wedge;", "\u2227");
        this.entities.put("&wedgeq;", "\u2259");
        this.entities.put("&weierp;", "\u2118");
        this.entities.put("&wfr;", "\ud835\udd34");
        this.entities.put("&wopf;", "\ud835\udd68");
        this.entities.put("&wp;", "\u2118");
        this.entities.put("&wr;", "\u2240");
        this.entities.put("&wreath;", "\u2240");
        this.entities.put("&wscr;", "\ud835\udccc");
        this.entities.put("&xcap;", "\u22c2");
        this.entities.put("&xcirc;", "\u25ef");
        this.entities.put("&xcup;", "\u22c3");
        this.entities.put("&xdtri;", "\u25bd");
        this.entities.put("&xfr;", "\ud835\udd35");
        this.entities.put("&xhArr;", "\u27fa");
        this.entities.put("&xharr;", "\u27f7");
        this.entities.put("&xi;", "\u03be");
        this.entities.put("&xlArr;", "\u27f8");
        this.entities.put("&xlarr;", "\u27f5");
        this.entities.put("&xmap;", "\u27fc");
        this.entities.put("&xnis;", "\u22fb");
        this.entities.put("&xodot;", "\u2a00");
        this.entities.put("&xopf;", "\ud835\udd69");
        this.entities.put("&xoplus;", "\u2a01");
        this.entities.put("&xotime;", "\u2a02");
        this.entities.put("&xrArr;", "\u27f9");
        this.entities.put("&xrarr;", "\u27f6");
        this.entities.put("&xscr;", "\ud835\udccd");
        this.entities.put("&xsqcup;", "\u2a06");
        this.entities.put("&xuplus;", "\u2a04");
        this.entities.put("&xutri;", "\u25b3");
        this.entities.put("&xvee;", "\u22c1");
        this.entities.put("&xwedge;", "\u22c0");
        this.entities.put("&yacute;", "\u00fd");
        this.entities.put("&yacy;", "\u044f");
        this.entities.put("&ycirc;", "\u0177");
        this.entities.put("&ycy;", "\u044b");
        this.entities.put("&yen;", "\u00a5");
        this.entities.put("&yfr;", "\ud835\udd36");
        this.entities.put("&yicy;", "\u0457");
        this.entities.put("&yopf;", "\ud835\udd6a");
        this.entities.put("&yscr;", "\ud835\udcce");
        this.entities.put("&yucy;", "\u044e");
        this.entities.put("&yuml;", "\u00ff");
        this.entities.put("&zacute;", "\u017a");
        this.entities.put("&zcaron;", "\u017e");
        this.entities.put("&zcy;", "\u0437");
        this.entities.put("&zdot;", "\u017c");
        this.entities.put("&zeetrf;", "\u2128");
        this.entities.put("&zeta;", "\u03b6");
        this.entities.put("&zfr;", "\ud835\udd37");
        this.entities.put("&zhcy;", "\u0436");
        this.entities.put("&zigrarr;", "\u21dd");
        this.entities.put("&zopf;", "\ud835\udd6b");
        this.entities.put("&zscr;", "\ud835\udccf");
        this.entities.put("&zwj;", "\u200d");
        this.entities.put("&zwnj;", "\u200c");
    }

    public static enum ParserSecurityPolicy {
        Accept,
        Drop,
        Reject;

    }

    public class QName {
        private String ns;
        private String name;

        public QName(String src) {
            if (src.contains(":")) {
                this.ns = src.substring(0, src.indexOf(":"));
                this.name = src.substring(src.indexOf(":") + 1);
            } else {
                this.ns = null;
                this.name = src;
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasNs() {
            return this.ns != null;
        }

        public String getNs() {
            return this.ns;
        }

        public String toString() {
            return this.ns + "::" + this.name;
        }
    }

    public class NSMap {
        private Map<String, String> nslist = new HashMap<String, String>();

        public NSMap(NSMap nsm) {
            if (nsm != null) {
                this.nslist.putAll(nsm.nslist);
            }
        }

        public void def(String ns) {
            this.nslist.put("", ns);
        }

        public void ns(String abbrev, String ns) {
            this.nslist.put(abbrev, ns);
        }

        public String def() {
            return this.nslist.get("");
        }

        public boolean hasDef() {
            return this.nslist.containsKey("");
        }

        public String get(String abbrev) {
            return this.nslist.containsKey(abbrev) ? this.nslist.get(abbrev) : "http://error/undefined-namespace";
        }
    }
}

