/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import java.util.ArrayList;
import java.util.List;
import org.fhir.ucum.Converter;
import org.fhir.ucum.DefinedUnit;
import org.fhir.ucum.ExpressionComposer;
import org.fhir.ucum.ExpressionParser;
import org.fhir.ucum.Term;
import org.fhir.ucum.UcumModel;
import org.fhir.ucum.Unit;
import org.fhir.ucum.special.Registry;

public class UcumValidator {
    private UcumModel model;
    private List<String> result;
    private Registry handlers;

    public UcumValidator(UcumModel model, Registry handlers) {
        this.model = model;
        this.handlers = handlers;
    }

    public List<String> validate() {
        this.result = new ArrayList<String>();
        this.checkCodes();
        this.checkUnits();
        return this.result;
    }

    private void checkCodes() {
        for (Unit unit : this.model.getBaseUnits()) {
            this.checkUnitCode(unit.getCode(), true);
        }
        for (Unit unit : this.model.getDefinedUnits()) {
            this.checkUnitCode(unit.getCode(), true);
        }
    }

    private void checkUnits() {
        for (DefinedUnit unit : this.model.getDefinedUnits()) {
            if (!unit.isSpecial()) {
                this.checkUnitCode(unit.getValue().getUnit(), false);
                continue;
            }
            if (this.handlers.exists(unit.getCode())) continue;
            this.result.add("No Handler for " + unit.getCode().toString());
        }
    }

    private void checkUnitCode(String code, boolean primary) {
        try {
            Term term = new ExpressionParser(this.model).parse(code);
            String c = new ExpressionComposer().compose(term);
            if (!c.equals(code)) {
                this.result.add("Round trip failed: " + code + " -> " + c);
            }
            new Converter(this.model, this.handlers).convert(term);
        }
        catch (Exception e) {
            this.result.add(code + ": " + e.getMessage());
        }
        if (primary) {
            try {
                boolean inBrack = false;
                boolean nonDigits = false;
                for (int i = 0; i < code.length(); ++i) {
                    char ch = code.charAt(i);
                    if (ch == '[') {
                        if (inBrack) {
                            throw new Exception("nested [");
                        }
                        inBrack = true;
                    }
                    if (ch == ']') {
                        if (!inBrack) {
                            throw new Exception("] without [");
                        }
                        inBrack = false;
                    }
                    boolean bl = nonDigits = nonDigits || ch < '0' || ch > '9';
                    if (ch < '0' || ch > '9' || inBrack || !nonDigits) continue;
                    throw new Exception("code " + code + " is ambiguous because  it has digits outside []");
                }
            }
            catch (Exception e) {
                this.result.add(e.getMessage());
            }
        }
    }
}

