/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param.binder;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.binder.IParamBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

abstract class BaseJavaPrimitiveBinder<T>
implements IParamBinder<T> {
    protected abstract String doEncode(T var1);

    protected abstract T doParse(String var1);

    @Override
    public List<IQueryParameterOr<?>> encode(FhirContext theContext, T theString) throws InternalErrorException {
        String retVal = this.doEncode(theString);
        if (StringUtils.isBlank(retVal)) {
            return Collections.emptyList();
        }
        List<IQueryParameterOr<?>> retValList = Collections.singletonList(ParameterUtil.singleton(new StringParam(retVal), null));
        return retValList;
    }

    @Override
    public T parse(FhirContext theContext, String theName, List<QualifiedParamList> theParams) throws InternalErrorException, InvalidRequestException {
        if (theParams.size() == 0 || theParams.get(0).size() == 0) {
            return null;
        }
        if (theParams.size() > 1 || theParams.get(0).size() > 1) {
            throw new InvalidRequestException(Msg.code(1955) + "Multiple values detected for non-repeatable parameter '" + theName + "'. This server is not configured to allow multiple (AND) values for this param.");
        }
        T value = this.doParse((String)theParams.get(0).get(0));
        return value;
    }
}

