/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.subsumes;

import au.csiro.pathling.fhir.ParametersUtils;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.CodingHelpers;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyParameters;
import au.csiro.pathling.terminology.subsumes.SubsumesParameters;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public class SubsumesExecutor
implements TerminologyOperation<Parameters, ConceptSubsumptionOutcome> {
    @Nonnull
    private final TerminologyClient terminologyClient;
    @Nonnull
    private final SubsumesParameters parameters;

    public SubsumesExecutor(@Nonnull TerminologyClient terminologyClient, @Nonnull SubsumesParameters parameters) {
        this.terminologyClient = terminologyClient;
        this.parameters = parameters;
    }

    @Override
    @Nonnull
    public Optional<ConceptSubsumptionOutcome> validate() {
        ImmutableCoding codingA = this.parameters.getCodingA();
        ImmutableCoding codingB = this.parameters.getCodingB();
        if (codingA.getSystem() == null || !codingA.getSystem().equals(codingB.getSystem())) {
            return Optional.of(ConceptSubsumptionOutcome.NOTSUBSUMED);
        }
        if (codingA.getCode() == null || codingB.getCode() == null) {
            return Optional.of(ConceptSubsumptionOutcome.NOTSUBSUMED);
        }
        if (codingA.getVersion() != null && codingB.getVersion() != null && !codingA.getVersion().equals(codingB.getVersion())) {
            return Optional.of(ConceptSubsumptionOutcome.NOTSUBSUMED);
        }
        if (CodingHelpers.codingEquals(codingA.toCoding(), codingB.toCoding())) {
            return Optional.of(ConceptSubsumptionOutcome.EQUIVALENT);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public IOperationUntypedWithInput<Parameters> buildRequest() {
        ImmutableCoding codingA = this.parameters.getCodingA();
        ImmutableCoding codingB = this.parameters.getCodingB();
        String resolvedSystem = codingA.getSystem();
        String resolvedVersion = codingA.getVersion() != null ? codingA.getVersion() : codingB.getVersion();
        return this.terminologyClient.buildSubsumes(TerminologyParameters.required(CodeType::new, codingA.getCode()), TerminologyParameters.required(CodeType::new, codingB.getCode()), TerminologyParameters.required(UriType::new, resolvedSystem), TerminologyParameters.optional(StringType::new, resolvedVersion));
    }

    @Override
    @Nonnull
    public ConceptSubsumptionOutcome extractResult(@Nonnull Parameters response) {
        return ParametersUtils.toSubsumptionOutcome(response);
    }

    @Override
    @Nonnull
    public ConceptSubsumptionOutcome invalidRequestFallback() {
        return ConceptSubsumptionOutcome.NOTSUBSUMED;
    }
}

