/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.caching;

import au.csiro.pathling.config.HttpClientCachingConfiguration;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.terminology.caching.CachingTerminologyService;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;

public class PersistentCachingTerminologyService
extends CachingTerminologyService {
    private static final String DATA_DIRECTORY = "data";
    private static final String INDEX_DIRECTORY = "index";

    public PersistentCachingTerminologyService(@Nonnull TerminologyClient terminologyClient, @Nullable Closeable toClose, @Nonnull HttpClientCachingConfiguration configuration) {
        super(terminologyClient, toClose, configuration);
    }

    @Override
    protected EmbeddedCacheManager buildCacheManager() {
        GlobalConfigurationBuilder globalConfigBuilder = new GlobalConfigurationBuilder();
        globalConfigBuilder.serialization().marshaller(new JavaSerializationMarshaller()).allowList().addRegexp(".*");
        GlobalConfiguration globalConfig = globalConfigBuilder.build();
        return new DefaultCacheManager(globalConfig);
    }

    @Override
    protected Cache<Integer, ?> buildCache(@Nonnull EmbeddedCacheManager cacheManager, @Nonnull String cacheName) {
        String storagePath = this.configuration.getStoragePath();
        String dataLocation = Path.of(Objects.requireNonNull(storagePath), DATA_DIRECTORY).toString();
        String indexLocation = Path.of(storagePath, INDEX_DIRECTORY).toString();
        Configuration cacheConfig = new ConfigurationBuilder().memory().maxCount(this.configuration.getMaxEntries()).whenFull(EvictionStrategy.REMOVE).persistence().addSoftIndexFileStore().dataLocation(dataLocation).indexLocation(indexLocation).async().build();
        cacheManager.defineConfiguration(cacheName, cacheConfig);
        return cacheManager.getCache(cacheName);
    }
}

