/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.types;

import au.csiro.pathling.encoders.datatypes.DecimalCustomCoder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class FlexiDecimal {
    public static final int MAX_PRECISION = 38;
    public static final DataType DECIMAL_TYPE = DataTypes.createDecimalType((int)38, (int)0);
    @Nonnull
    public static DataType DATA_TYPE = FlexiDecimal.createFlexibleDecimalType();
    private static final UserDefinedFunction EQUALS_UDF = FlexiDecimal.toBooleanUdf((UDF2<BigDecimal, BigDecimal, Boolean>)(UDF2 & Serializable)(l, r) -> l.compareTo((BigDecimal)r) == 0);
    private static final UserDefinedFunction LT_UDF = FlexiDecimal.toBooleanUdf((UDF2<BigDecimal, BigDecimal, Boolean>)(UDF2 & Serializable)(l, r) -> l.compareTo((BigDecimal)r) < 0);
    private static final UserDefinedFunction LTE_UDF = FlexiDecimal.toBooleanUdf((UDF2<BigDecimal, BigDecimal, Boolean>)(UDF2 & Serializable)(l, r) -> l.compareTo((BigDecimal)r) <= 0);
    private static final UserDefinedFunction GT_UDF = FlexiDecimal.toBooleanUdf((UDF2<BigDecimal, BigDecimal, Boolean>)(UDF2 & Serializable)(l, r) -> l.compareTo((BigDecimal)r) > 0);
    private static final UserDefinedFunction GTE_UDF = FlexiDecimal.toBooleanUdf((UDF2<BigDecimal, BigDecimal, Boolean>)(UDF2 & Serializable)(l, r) -> l.compareTo((BigDecimal)r) >= 0);
    private static final UserDefinedFunction PLUS_UDF = FlexiDecimal.toBigDecimalUdf((UDF2<BigDecimal, BigDecimal, BigDecimal>)((UDF2 & Serializable)BigDecimal::add));
    private static final UserDefinedFunction MULTIPLY_UDF = FlexiDecimal.toBigDecimalUdf((UDF2<BigDecimal, BigDecimal, BigDecimal>)((UDF2 & Serializable)BigDecimal::multiply));
    private static final UserDefinedFunction MINUS_UDF = FlexiDecimal.toBigDecimalUdf((UDF2<BigDecimal, BigDecimal, BigDecimal>)((UDF2 & Serializable)BigDecimal::subtract));
    private static final UserDefinedFunction DIVIDE_UDF = FlexiDecimal.toBigDecimalUdf((UDF2<BigDecimal, BigDecimal, BigDecimal>)((UDF2 & Serializable)BigDecimal::divide));
    private static final UserDefinedFunction TO_DECIMAL = functions.udf(FlexiDecimal::fromValue, (DataType)DecimalCustomCoder.decimalType());

    @Nonnull
    private static StructType createFlexibleDecimalType() {
        Metadata metadata = new MetadataBuilder().build();
        StructField value = new StructField("value", DECIMAL_TYPE, true, metadata);
        StructField scale = new StructField("scale", DataTypes.IntegerType, true, metadata);
        return new StructType(new StructField[]{value, scale});
    }

    @Nonnull
    private static UserDefinedFunction toBooleanUdf(@Nonnull UDF2<BigDecimal, BigDecimal, Boolean> method) {
        UDF2 & Serializable f = (UDF2 & Serializable)(left, right) -> {
            BigDecimal leftValue = FlexiDecimal.fromValue(left);
            BigDecimal rightValue = FlexiDecimal.fromValue(right);
            return leftValue == null || rightValue == null ? null : (Boolean)method.call((Object)leftValue, (Object)rightValue);
        };
        return functions.udf((UDF2)f, (DataType)DataTypes.BooleanType);
    }

    @Nonnull
    private static UDF2<Row, Row, Row> wrapBigDecimal2(@Nonnull UDF2<BigDecimal, BigDecimal, BigDecimal> method) {
        return (UDF2 & Serializable)(left, right) -> left == null || right == null ? null : FlexiDecimal.toValue((BigDecimal)method.call((Object)FlexiDecimal.fromValue(left), (Object)FlexiDecimal.fromValue(right)));
    }

    @Nonnull
    private static UserDefinedFunction toBigDecimalUdf(@Nonnull UDF2<BigDecimal, BigDecimal, BigDecimal> method) {
        return functions.udf(FlexiDecimal.wrapBigDecimal2(method), (DataType)DATA_TYPE);
    }

    @Nullable
    public static BigDecimal fromValue(@Nullable Row row) {
        return row != null && !row.isNullAt(0) ? row.getDecimal(0).movePointLeft(row.getInt(1)) : null;
    }

    @Nullable
    public static Row toValue(@Nullable BigDecimal decimal) {
        Object[] fieldValues = FlexiDecimal.toArrayValue(decimal);
        return fieldValues != null ? RowFactory.create((Object[])fieldValues) : null;
    }

    @Nullable
    private static Object[] toArrayValue(@Nullable BigDecimal decimal) {
        Object[] objectArray;
        BigDecimal normalizedValue = FlexiDecimal.normalize(decimal);
        if (normalizedValue != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = Decimal.apply((BigInteger)normalizedValue.unscaledValue());
            objectArray = objectArray2;
            objectArray2[1] = normalizedValue.scale();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Nullable
    public static BigDecimal normalize(@Nullable BigDecimal decimal) {
        BigDecimal adjustedValue;
        if (decimal == null) {
            return null;
        }
        BigDecimal bigDecimal = adjustedValue = decimal.scale() < 0 ? decimal.setScale(0, RoundingMode.UNNECESSARY) : decimal;
        if (adjustedValue.precision() > 38) {
            int desiredScale = adjustedValue.scale() - (adjustedValue.precision() - 38);
            if (desiredScale >= 0) {
                return adjustedValue.setScale(desiredScale, RoundingMode.HALF_UP);
            }
            return null;
        }
        return adjustedValue;
    }

    @Nonnull
    public static Column equals(@Nonnull Column left, @Nonnull Column right) {
        return EQUALS_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column lt(@Nonnull Column left, @Nonnull Column right) {
        return LT_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column lte(@Nonnull Column left, @Nonnull Column right) {
        return LTE_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column gt(@Nonnull Column left, @Nonnull Column right) {
        return GT_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column gte(@Nonnull Column left, @Nonnull Column right) {
        return GTE_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column plus(@Nonnull Column left, @Nonnull Column right) {
        return PLUS_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column multiply(@Nonnull Column left, @Nonnull Column right) {
        return MULTIPLY_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column minus(@Nonnull Column left, @Nonnull Column right) {
        return MINUS_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column divide(@Nonnull Column left, @Nonnull Column right) {
        return DIVIDE_UDF.apply(new Column[]{left, right});
    }

    @Nonnull
    public static Column toDecimal(@Nonnull Column flexiDecimal) {
        return TO_DECIMAL.apply(new Column[]{flexiDecimal});
    }
}

