/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.config;

import au.csiro.pathling.config.HttpClientCachingStorageType;
import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ValidHttpCacheConfiguration
public class HttpClientCachingConfiguration
implements Serializable {
    private static final long serialVersionUID = -3030386957343963899L;
    @NotNull
    private boolean enabled;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) int maxEntries;
    @NotNull
    private HttpClientCachingStorageType storageType;
    @Nullable
    private String storagePath;
    @Min(value=0L)
    private @Min(value=0L) int defaultExpiry;
    @Nullable
    @Min(value=0L)
    private @Min(value=0L) Integer overrideExpiry;

    private static boolean $default$enabled() {
        return true;
    }

    private static int $default$maxEntries() {
        return 200000;
    }

    private static HttpClientCachingStorageType $default$storageType() {
        return HttpClientCachingStorageType.MEMORY;
    }

    private static int $default$defaultExpiry() {
        return 600;
    }

    HttpClientCachingConfiguration(boolean enabled, int maxEntries, HttpClientCachingStorageType storageType, @Nullable String storagePath, int defaultExpiry, @Nullable Integer overrideExpiry) {
        this.enabled = enabled;
        this.maxEntries = maxEntries;
        this.storageType = storageType;
        this.storagePath = storagePath;
        this.defaultExpiry = defaultExpiry;
        this.overrideExpiry = overrideExpiry;
    }

    public static HttpClientCachingConfigurationBuilder builder() {
        return new HttpClientCachingConfigurationBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public HttpClientCachingStorageType getStorageType() {
        return this.storageType;
    }

    @Nullable
    public String getStoragePath() {
        return this.storagePath;
    }

    public int getDefaultExpiry() {
        return this.defaultExpiry;
    }

    @Nullable
    public Integer getOverrideExpiry() {
        return this.overrideExpiry;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setStorageType(HttpClientCachingStorageType storageType) {
        this.storageType = storageType;
    }

    public void setStoragePath(@Nullable String storagePath) {
        this.storagePath = storagePath;
    }

    public void setDefaultExpiry(int defaultExpiry) {
        this.defaultExpiry = defaultExpiry;
    }

    public void setOverrideExpiry(@Nullable Integer overrideExpiry) {
        this.overrideExpiry = overrideExpiry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientCachingConfiguration)) {
            return false;
        }
        HttpClientCachingConfiguration other = (HttpClientCachingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getMaxEntries() != other.getMaxEntries()) {
            return false;
        }
        if (this.getDefaultExpiry() != other.getDefaultExpiry()) {
            return false;
        }
        Integer this$overrideExpiry = this.getOverrideExpiry();
        Integer other$overrideExpiry = other.getOverrideExpiry();
        if (this$overrideExpiry == null ? other$overrideExpiry != null : !((Object)this$overrideExpiry).equals(other$overrideExpiry)) {
            return false;
        }
        HttpClientCachingStorageType this$storageType = this.getStorageType();
        HttpClientCachingStorageType other$storageType = other.getStorageType();
        if (this$storageType == null ? other$storageType != null : !((Object)((Object)this$storageType)).equals((Object)other$storageType)) {
            return false;
        }
        String this$storagePath = this.getStoragePath();
        String other$storagePath = other.getStoragePath();
        return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientCachingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getMaxEntries();
        result = result * 59 + this.getDefaultExpiry();
        Integer $overrideExpiry = this.getOverrideExpiry();
        result = result * 59 + ($overrideExpiry == null ? 43 : ((Object)$overrideExpiry).hashCode());
        HttpClientCachingStorageType $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : ((Object)((Object)$storageType)).hashCode());
        String $storagePath = this.getStoragePath();
        result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientCachingConfiguration(enabled=" + this.isEnabled() + ", maxEntries=" + this.getMaxEntries() + ", storageType=" + this.getStorageType() + ", storagePath=" + this.getStoragePath() + ", defaultExpiry=" + this.getDefaultExpiry() + ", overrideExpiry=" + this.getOverrideExpiry() + ")";
    }

    public static class HttpClientCachingConfigurationBuilder {
        private boolean enabled$set;
        private boolean enabled$value;
        private boolean maxEntries$set;
        private int maxEntries$value;
        private boolean storageType$set;
        private HttpClientCachingStorageType storageType$value;
        private String storagePath;
        private boolean defaultExpiry$set;
        private int defaultExpiry$value;
        private Integer overrideExpiry;

        HttpClientCachingConfigurationBuilder() {
        }

        public HttpClientCachingConfigurationBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public HttpClientCachingConfigurationBuilder maxEntries(int maxEntries) {
            this.maxEntries$value = maxEntries;
            this.maxEntries$set = true;
            return this;
        }

        public HttpClientCachingConfigurationBuilder storageType(HttpClientCachingStorageType storageType) {
            this.storageType$value = storageType;
            this.storageType$set = true;
            return this;
        }

        public HttpClientCachingConfigurationBuilder storagePath(@Nullable String storagePath) {
            this.storagePath = storagePath;
            return this;
        }

        public HttpClientCachingConfigurationBuilder defaultExpiry(int defaultExpiry) {
            this.defaultExpiry$value = defaultExpiry;
            this.defaultExpiry$set = true;
            return this;
        }

        public HttpClientCachingConfigurationBuilder overrideExpiry(@Nullable Integer overrideExpiry) {
            this.overrideExpiry = overrideExpiry;
            return this;
        }

        public HttpClientCachingConfiguration build() {
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = HttpClientCachingConfiguration.$default$enabled();
            }
            int maxEntries$value = this.maxEntries$value;
            if (!this.maxEntries$set) {
                maxEntries$value = HttpClientCachingConfiguration.$default$maxEntries();
            }
            HttpClientCachingStorageType storageType$value = this.storageType$value;
            if (!this.storageType$set) {
                storageType$value = HttpClientCachingConfiguration.$default$storageType();
            }
            int defaultExpiry$value = this.defaultExpiry$value;
            if (!this.defaultExpiry$set) {
                defaultExpiry$value = HttpClientCachingConfiguration.$default$defaultExpiry();
            }
            return new HttpClientCachingConfiguration(enabled$value, maxEntries$value, storageType$value, this.storagePath, defaultExpiry$value, this.overrideExpiry);
        }

        public String toString() {
            return "HttpClientCachingConfiguration.HttpClientCachingConfigurationBuilder(enabled$value=" + this.enabled$value + ", maxEntries$value=" + this.maxEntries$value + ", storageType$value=" + this.storageType$value + ", storagePath=" + this.storagePath + ", defaultExpiry$value=" + this.defaultExpiry$value + ", overrideExpiry=" + this.overrideExpiry + ")";
        }
    }

    public static class HttpCacheConfigurationValidator
    implements ConstraintValidator<ValidHttpCacheConfiguration, HttpClientCachingConfiguration> {
        @Override
        public void initialize(ValidHttpCacheConfiguration constraintAnnotation) {
        }

        @Override
        public boolean isValid(HttpClientCachingConfiguration value, ConstraintValidatorContext context) {
            if (HttpClientCachingStorageType.DISK.equals((Object)value.getStorageType())) {
                return Objects.nonNull(value.getStoragePath());
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={HttpCacheConfigurationValidator.class})
    @Documented
    public static @interface ValidHttpCacheConfiguration {
        public String message() default "If the storage type is disk, then a storage path must be supplied.";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

