# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue, email, or any other method with the owners of this repository before making a change.

To reach out to the main contributors, send an email to:
- Gacoka Mbui < markgacoka@gmail.com >

To discuss via an issue, go to the link below and open a new issue:
https://github.com/markgacoka/codepropertygraph/issues

Additionally, remember that we have a code of conduct highlighted below. Please be sure to keep these guidelines in mind.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a build. This is done automatically from the `.gitignore` file, but beware of OS dependent files that should be ignored in the pull request.
2. Update the README.md with details of changes to the interface, this includes new environment variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this 'Pull Request' would represent. The versioning scheme we use is Semantic Versioning. Check out [Semantic Versioning](https://semver.org/) here.
4. You may merge the Pull Request in once you have the sign-off of two other developers, or if you do not have permission to do that, you may request the second reviewer to merge it for you.

## Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.

### Our Standards

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or advances.
* Trolling, insulting/derogatory comments, and personal or political attacks.
* Public or private harassment.
* Publishing others' private information, such as a physical or electronic address, without explicit permission.
* Other conduct which could reasonably be considered inappropriate in a professional setting.

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

### Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [INSERT EMAIL ADDRESS]. All
complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Opening a New Issue

For image reference, check the official [Github Docs](https://docs.github.com/en/issues/tracking-your-work-with-issues/creating-an-issue)

The labels we use follow the Github [label](https://docs.github.com/en/issues/using-labels-and-milestones-to-track-work/managing-labels) recommendations:
1. `bug`: Indicates an unexpected problem or unintended behavior.
2. `documentation`: Indicates a need for improvements or additions to documentation.
3. `duplicate`:	Indicates similar issues, pull requests, or discussions
4. `enhancement`: Indicates new feature requests
5. `good first issue`: Indicates a good issue for first-time contributors
6. `help wanted`: Indicates that a maintainer wants help on an issue or pull request
7. `invalid`: Indicates that an issue, pull request, or discussion is no longer relevant
8. `question`: Indicates that an issue, pull request, or discussion needs more information
9. `wontfix`: Indicates that work won't continue on an issue, pull request, or discussion

## Opening a New Pull Request
For image reference, check the official [Github Docs](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request)

For first time contribution:
```
# Clone the Repository to your local machine
git clone https://github.com/markgacoka/codepropertygraph.git

cd codepropertygraph

# Create a new branch
# Replace 'new_branch' with the format: issue_001_description or feature_001_description
# description should describe the biggest change e.g. issue_001_compilation
git checkout -b new_branch

# Make the changes
# [file] should be the files you wish to change. To add all changes to the staging area, run `git add .`

git status

git add [file]

git commit -m "Explain what the change was (start with a capitalized verb)"

git push origin new_branch
```
Go to the GitHub page, click the Compare & pull request button that pops up above the repository.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version]
