"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceFactory = void 0;
const cloudform_types_1 = require("cloudform-types");
const graphql_mapping_template_1 = require("graphql-mapping-template");
const graphql_transformer_common_1 = require("graphql-transformer-common");
class ResourceFactory {
    makeParams() {
        return {};
    }
    initTemplate() {
        return {
            Parameters: this.makeParams(),
            Resources: {},
            Outputs: {},
        };
    }
    makeHttpDataSource(baseURL) {
        return new cloudform_types_1.AppSync.DataSource({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            Name: graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL),
            Type: 'HTTP',
            HttpConfig: {
                Endpoint: this.replaceEnvAndRegion(baseURL),
            },
        });
    }
    referencesEnv(value) {
        return value.match(/(\${env})/) !== null;
    }
    referencesRegion(value) {
        return value.match(/(\${aws_region})/) !== null;
    }
    replaceEnvAndRegion(value) {
        const vars = {};
        if (this.referencesEnv(value)) {
            vars.env = cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.Env);
        }
        if (this.referencesRegion(value)) {
            vars.aws_region = cloudform_types_1.Fn.Ref('AWS::Region');
        }
        if (!vars.env && !vars.aws_region) {
            return value;
        }
        return cloudform_types_1.Fn.Sub(value, vars);
    }
    makeVtlStringArray(inputArray) {
        let returnArray = `[`;
        inputArray.forEach((e) => (returnArray += `\'${e}\', `));
        return returnArray.slice(0, -2) + `]`;
    }
    makeNonNullChecks(nonNullArgs) {
        return graphql_mapping_template_1.compoundExpression([
            graphql_mapping_template_1.comment('START: Manually checking that all non-null arguments are provided either in the query or the body'),
            graphql_mapping_template_1.iff(graphql_mapping_template_1.or(nonNullArgs.map((arg) => graphql_mapping_template_1.parens(graphql_mapping_template_1.and([graphql_mapping_template_1.raw(`!$ctx.args.body.${arg}`), graphql_mapping_template_1.raw(`!$ctx.args.query.${arg}`)])))), graphql_mapping_template_1.ref('util.error("An argument you marked as Non-Null is not present ' + 'in the query nor the body of your request."))')),
            graphql_mapping_template_1.comment('END: Manually checking that all non-null arguments are provided either in the query or the body'),
        ]);
    }
    makeGetResolver(baseURL, path, type, field, headers) {
        const parsedHeaders = headers.map(header => graphql_mapping_template_1.qref(`$headers.put("${header.key}", "${header.value}")`));
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL), 'Name'),
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: this.replaceEnvAndRegion(graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('headers'), graphql_mapping_template_1.ref('utils.http.copyHeaders($ctx.request.headers)')),
                graphql_mapping_template_1.qref('$headers.put("accept-encoding", "application/json")'),
                ...parsedHeaders,
                graphql_mapping_template_1.HttpMappingTemplate.getRequest({
                    resourcePath: path,
                    params: graphql_mapping_template_1.obj({
                        query: graphql_mapping_template_1.ref('util.toJson($ctx.args.query)'),
                        headers: graphql_mapping_template_1.ref('util.toJson($headers)'),
                    }),
                }),
            ]))),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$ctx.result.statusCode == 200'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.ref('ctx.result.headers.get("Content-Type").toLowerCase().contains("xml")'), graphql_mapping_template_1.ref('utils.xml.toJsonString($ctx.result.body)'), graphql_mapping_template_1.ref('ctx.result.body')), graphql_mapping_template_1.ref('util.qr($util.appendError($ctx.result.body, $ctx.result.statusCode))'))),
        });
    }
    makePostResolver(baseURL, path, type, field, nonNullArgs, headers) {
        const parsedHeaders = headers.map(header => graphql_mapping_template_1.qref(`$headers.put("${header.key}", "${header.value}")`));
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL), 'Name'),
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: this.replaceEnvAndRegion(graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
                nonNullArgs.length > 0 ? this.makeNonNullChecks(nonNullArgs) : null,
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('headers'), graphql_mapping_template_1.ref('utils.http.copyHeaders($ctx.request.headers)')),
                graphql_mapping_template_1.qref('$headers.put("Content-Type", "application/json")'),
                graphql_mapping_template_1.qref('$headers.put("accept-encoding", "application/json")'),
                ...parsedHeaders,
                graphql_mapping_template_1.HttpMappingTemplate.postRequest({
                    resourcePath: path,
                    params: graphql_mapping_template_1.obj({
                        body: graphql_mapping_template_1.ref('util.toJson($ctx.args.body)'),
                        query: graphql_mapping_template_1.ref('util.toJson($ctx.args.query)'),
                        headers: graphql_mapping_template_1.ref('util.toJson($headers)'),
                    }),
                }),
            ]))),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$ctx.result.statusCode == 200 || $ctx.result.statusCode == 201'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.ref('ctx.result.headers.get("Content-Type").toLowerCase().contains("xml")'), graphql_mapping_template_1.ref('utils.xml.toJsonString($ctx.result.body)'), graphql_mapping_template_1.ref('ctx.result.body')), graphql_mapping_template_1.ref('util.qr($util.appendError($ctx.result.body, $ctx.result.statusCode))'))),
        });
    }
    makePutResolver(baseURL, path, type, field, nonNullArgs, headers) {
        const parsedHeaders = headers.map(header => graphql_mapping_template_1.qref(`$headers.put("${header.key}", "${header.value}")`));
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL), 'Name'),
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: this.replaceEnvAndRegion(graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
                nonNullArgs.length > 0 ? this.makeNonNullChecks(nonNullArgs) : null,
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('headers'), graphql_mapping_template_1.ref('utils.http.copyHeaders($ctx.request.headers)')),
                graphql_mapping_template_1.qref('$headers.put("Content-Type", "application/json")'),
                graphql_mapping_template_1.qref('$headers.put("accept-encoding", "application/json")'),
                ...parsedHeaders,
                graphql_mapping_template_1.HttpMappingTemplate.putRequest({
                    resourcePath: path,
                    params: graphql_mapping_template_1.obj({
                        body: graphql_mapping_template_1.ref('util.toJson($ctx.args.body)'),
                        query: graphql_mapping_template_1.ref('util.toJson($ctx.args.query)'),
                        headers: graphql_mapping_template_1.ref('util.toJson($headers)'),
                    }),
                }),
            ]))),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$ctx.result.statusCode == 200 || $ctx.result.statusCode == 201'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.ref('ctx.result.headers.get("Content-Type").toLowerCase().contains("xml")'), graphql_mapping_template_1.ref('utils.xml.toJsonString($ctx.result.body)'), graphql_mapping_template_1.ref('ctx.result.body')), graphql_mapping_template_1.ref('util.qr($util.appendError($ctx.result.body, $ctx.result.statusCode))'))),
        });
    }
    makeDeleteResolver(baseURL, path, type, field, headers) {
        const parsedHeaders = headers.map(header => graphql_mapping_template_1.qref(`$headers.put("${header.key}", "${header.value}")`));
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL), 'Name'),
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: this.replaceEnvAndRegion(graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('headers'), graphql_mapping_template_1.ref('utils.http.copyHeaders($ctx.request.headers)')),
                graphql_mapping_template_1.qref('$headers.put("accept-encoding", "application/json")'),
                ...parsedHeaders,
                graphql_mapping_template_1.HttpMappingTemplate.deleteRequest({
                    resourcePath: path,
                    params: graphql_mapping_template_1.obj({
                        headers: graphql_mapping_template_1.ref('util.toJson($headers)'),
                    }),
                }),
            ]))),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$ctx.result.statusCode == 200'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.ref('ctx.result.headers.get("Content-Type").toLowerCase().contains("xml")'), graphql_mapping_template_1.ref('utils.xml.toJsonString($ctx.result.body)'), graphql_mapping_template_1.ref('ctx.result.body')), graphql_mapping_template_1.ref('util.qr($util.appendError($ctx.result.body, $ctx.result.statusCode))'))),
        });
    }
    makePatchResolver(baseURL, path, type, field, nonNullArgs, headers) {
        const parsedHeaders = headers.map(header => graphql_mapping_template_1.qref(`$headers.put("${header.key}", "${header.value}")`));
        return new cloudform_types_1.AppSync.Resolver({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DataSourceName: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.HttpResourceIDs.HttpDataSourceID(baseURL), 'Name'),
            FieldName: field,
            TypeName: type,
            RequestMappingTemplate: this.replaceEnvAndRegion(graphql_mapping_template_1.print(graphql_mapping_template_1.compoundExpression([
                nonNullArgs.length > 0 ? this.makeNonNullChecks(nonNullArgs) : null,
                graphql_mapping_template_1.set(graphql_mapping_template_1.ref('headers'), graphql_mapping_template_1.ref('utils.http.copyHeaders($ctx.request.headers)')),
                graphql_mapping_template_1.qref('$headers.put("Content-Type", "application/json")'),
                graphql_mapping_template_1.qref('$headers.put("accept-encoding", "application/json")'),
                ...parsedHeaders,
                graphql_mapping_template_1.HttpMappingTemplate.patchRequest({
                    resourcePath: path,
                    params: graphql_mapping_template_1.obj({
                        body: graphql_mapping_template_1.ref('util.toJson($ctx.args.body)'),
                        query: graphql_mapping_template_1.ref('util.toJson($ctx.args.query)'),
                        headers: graphql_mapping_template_1.ref('util.toJson($headers)'),
                    }),
                }),
            ]))),
            ResponseMappingTemplate: graphql_mapping_template_1.print(graphql_mapping_template_1.ifElse(graphql_mapping_template_1.raw('$ctx.result.statusCode == 200 || $ctx.result.statusCode == 201'), graphql_mapping_template_1.ifElse(graphql_mapping_template_1.ref('ctx.result.headers.get("Content-Type").toLowerCase().contains("xml")'), graphql_mapping_template_1.ref('utils.xml.toJsonString($ctx.result.body)'), graphql_mapping_template_1.ref('ctx.result.body')), graphql_mapping_template_1.ref('util.qr($util.appendError($ctx.result.body, $ctx.result.statusCode))'))),
        });
    }
}
exports.ResourceFactory = ResourceFactory;
//# sourceMappingURL=resources.js.map