/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
"ed583be1cf": function _(e,s,o){Object.defineProperty(o,"__esModule",{value:!0});const t=e("tslib").__importStar(e("963d0f8803"));o.AwesomePanelExtensions=t,e("@bokehjs/base").register_models(t)},
"963d0f8803": function _(e,a,t){Object.defineProperty(t,"__esModule",{value:!0});var r=e("61ceb3906d");t.FastAnchor=r.FastAnchor;var o=e("cffb3837b7");t.FastButton=o.FastButton;var b=e("b5be3a3047");t.FastCheckboxGroup=b.FastCheckboxGroup;var c=e("ec1eb7e949");t.FastSwitchGroup=c.FastSwitchGroup;var n=e("86ebbe8a0e");t.FastTextAreaInput=n.FastTextAreaInput;var v=e("d7e6a9ee16");t.FastTextInput=v.FastTextInput;var s=e("59f7dfa54f");t.PerspectiveViewer=s.PerspectiveViewer;var u=e("eb1a40b8a7");t.PivotTable=u.PivotTable;var p=e("20967df791");t.Icon=p.Icon;var F=e("e2e34597ee");t.TabulatorModel=F.TabulatorModel;var i=e("5c604c9068");t.WebComponent=i.WebComponent},
"61ceb3906d": function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e("tslib"),n=e("@bokehjs/models/layouts/html_box"),s=i.__importStar(e("@bokehjs/core/properties"));class o extends n.HTMLBoxView{setAttr(e,t){const r=this.anchor_el;null===t?r.setAttribute(e,!1):r.setAttribute(e,t)}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>{null===this.model.name?this.anchor_el.innerHTML="":this.anchor_el.innerHTML=this.model.name}),this.connect(this.model.properties.appearance.change,()=>{this.setAttr("appearance",this.model.appearance)}),this.connect(this.model.properties.href.change,()=>{this.setAttr("href",this.model.href)}),this.connect(this.model.properties.hreflang.change,()=>{this.setAttr("hreflang",this.model.hreflang)}),this.connect(this.model.properties.ping.change,()=>{this.setAttr("ping",this.model.ping)}),this.connect(this.model.properties.href.change,()=>{this.setAttr("referrerpolicy",this.model.referrerpolicy)}),this.connect(this.model.properties.download.change,()=>{this.setAttr("download",this.model.download)}),this.connect(this.model.properties.referrer.change,()=>{this.setAttr("referrer",this.model.referrer)}),this.connect(this.model.properties.rel.change,()=>{this.setAttr("rel",this.model.rel)}),this.connect(this.model.properties.target.change,()=>{this.setAttr("mimetype",this.model.mimetype)})}render(){super.render();const e=document.createElement("fast-anchor");this.anchor_el=e,this.anchor_el.style.width="100%",this.el.appendChild(this.anchor_el),null!==this.model.name&&(this.anchor_el.innerHTML=this.model.name),null!==this.model.appearance&&(e.appearance=this.model.appearance),null!==this.model.href&&(e.href=this.model.href),null!==this.model.hreflang&&(e.hreflang=this.model.hreflang),null!==this.model.ping&&(e.ping=this.model.ping),null!==this.model.referrerpolicy&&(e.referrerpolicy=this.model.referrerpolicy),null!==this.model.download&&(e.download=this.model.download),null!==this.model.referrer&&(e.ref=this.model.referrer),null!==this.model.rel&&(e.rel=this.model.rel),null!==this.model.target&&(e.target=this.model.target),null!==this.model.mimetype&&(e.mimetype=this.model.mimetype)}}r.FastAnchorView=o,o.__name__="FastAnchorView";class l extends n.HTMLBox{constructor(e){super(e)}static init_FastAnchor(){this.prototype.default_view=o,this.define({appearance:[s.String],download:[s.String],href:[s.String],hreflang:[s.String],ping:[s.String],referrerpolicy:[s.String],referrer:[s.String],rel:[s.String],target:[s.String],mimetype:[s.String]})}}r.FastAnchor=l,l.__name__="FastAnchor",l.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_anchor",l.init_FastAnchor()},
"cffb3837b7": function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const s=t("tslib"),n=t("@bokehjs/models/widgets/button"),a=s.__importStar(t("@bokehjs/core/properties"));class i extends n.ButtonView{_render_button(...t){const e=document.createElement("fast-button");return e.innerText=this.model.label,e.disabled=this.model.disabled,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.style.width="100%",e.style.height="100%",e}}o.FastButtonView=i,i.__name__="FastButtonView";class u extends n.Button{constructor(t){super(t)}static init_FastButton(){this.prototype.default_view=i,this.define({appearance:[a.String],autofocus:[a.Boolean]})}}o.FastButton=u,u.__name__="FastButton",u.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_button",u.init_FastButton()},
"b5be3a3047": function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e("tslib"),i=e("@bokehjs/models/widgets/checkbox_group"),n=e("@bokehjs/styles/mixins"),l=e("@bokehjs/styles/widgets/inputs"),a=e("@bokehjs/core/dom"),c=e("@bokehjs/core/util/array"),r=o.__importStar(e("@bokehjs/core/properties"));class h extends i.CheckboxGroupView{render(){const e=a.div({class:[l.bk_input_group,this.model.inline?n.bk_inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:s,labels:t}=this.model;this._inputs=[];for(let o=0;o<t.length;o++){let i=document.createElement("fast-checkbox");this.model.readonly&&i.setAttribute("readonly",!0),i.innerHTML=t[o];const n=i;n.value=""+o,n.addEventListener("change",()=>this.change_active(o)),this._inputs.push(n),this.model.disabled&&(n.disabled=!0),c.includes(s,o)&&(n.checked=!0),e.appendChild(n)}}}t.FastCheckboxGroupView=h,h.__name__="FastCheckboxGroupView";class d extends i.CheckboxGroup{constructor(e){super(e)}static init_FastCheckboxGroup(){this.prototype.default_view=h,this.define({readonly:[r.Boolean]})}}t.FastCheckboxGroup=d,d.__name__="FastCheckboxGroup",d.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_checkbox_group",d.init_FastCheckboxGroup()},
"ec1eb7e949": function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e("tslib"),n=e("@bokehjs/models/widgets/checkbox_group"),o=e("@bokehjs/styles/mixins"),c=e("@bokehjs/styles/widgets/inputs"),a=e("@bokehjs/core/dom"),d=e("@bokehjs/core/util/array"),l=i.__importStar(e("@bokehjs/core/properties"));class h extends n.CheckboxGroupView{render(){const e=a.div({class:[c.bk_input_group,this.model.inline?o.bk_inline:null]});this.el.innerHTML="",this.el.appendChild(e);const{active:t,labels:s}=this.model;this._inputs=[];for(let i=0;i<s.length;i++){let n=document.createElement("fast-switch");this.model.readonly&&n.setAttribute("readonly",!0),n.innerHTML=s[i],n.innerHTML=s[i];const o=n;o.value=""+i,o.addEventListener("change",()=>this.change_active(i)),this._inputs.push(o),this.model.disabled&&(o.disabled=!0),d.includes(t,i)&&(o.checked=!0);const c=document.createElement("span");c.setAttribute("slot","checked-message"),c.innerHTML=this.model.checked_message,o.appendChild(c);const a=document.createElement("span");a.setAttribute("slot","unchecked-message"),a.innerHTML=this.model.unchecked_message,o.appendChild(a),e.appendChild(o)}}}s.FastSwitchGroupView=h,h.__name__="FastSwitchGroupView";class r extends n.CheckboxGroup{constructor(e){super(e)}static init_FastSwitchGroup(){this.prototype.default_view=h,this.define({readonly:[l.Boolean],checked_message:[l.String],unchecked_message:[l.String]})}}s.FastSwitchGroup=r,r.__name__="FastSwitchGroup",r.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_switch_group",r.init_FastSwitchGroup()},
"86ebbe8a0e": function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e("tslib"),n=e("@bokehjs/models/widgets/textarea_input"),l=e("@bokehjs/models/widgets/input_widget"),o=s.__importStar(e("@bokehjs/core/properties"));class a extends l.InputWidgetView{get input_el_any(){return this.input_el}connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""}),this.connect(this.model.properties.value.change,()=>{this.input_el.value=this.model.value}),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder),this.connect(this.model.properties.rows.change,()=>this.input_el.rows=this.model.rows),this.connect(this.model.properties.cols.change,()=>this.input_el.cols=this.model.cols),this.connect(this.model.properties.max_length.change,()=>this.input_el_any.setAttribute("maxlength",this.model.max_length)),this.connect(this.model.properties.appearance.change,()=>this.input_el_any.appearance=this.model.appearance),this.connect(this.model.properties.autofocus.change,()=>this.input_el_any.autofocus=this.model.autofocus),this.connect(this.model.properties.resize.change,()=>this.input_el_any.resize=this.model.resize),this.connect(this.model.properties.spellcheck.change,()=>this.input_el_any.spellcheck=this.model.spellcheck),this.connect(this.model.properties.min_length.change,()=>this.input_el_any.setAttribute("minlength",this.model.min_length)),this.connect(this.model.properties.required.change,()=>this.input_el_any.required=this.model.required),this.connect(this.model.properties.readonly.change,()=>{!0===this.model.readonly?this.input_el_any.setAttribute("readonly",""):this.input_el_any.removeAttribute("readonly")})}render(){super.render();const e=document.createElement("fast-text-area");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",()=>this.change_input()),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.disabled=this.model.disabled,e.placeholder=this.model.placeholder,e.cols=this.model.cols,e.rows=this.model.rows,null!=this.model.max_length&&e.setAttribute("maxlength",this.model.max_length),e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.resize=this.model.resize,e.spellcheck=this.model.spellcheck,null!=this.model.min_length&&e.setAttribute("minlength",this.model.min_length),e.required=this.model.required,!0===this.model.readonly&&e.setAttribute("readonly","")}change_input(){this.model.value=this.input_el.value,super.change_input()}}i.FastTextAreaInputView=a,a.__name__="FastTextAreaInputView";class h extends n.TextAreaInput{constructor(e){super(e)}static init_FastTextAreaInput(){this.prototype.default_view=a,this.define({appearance:[o.String],autofocus:[o.Boolean],resize:[o.String],spellcheck:[o.Boolean],min_length:[o.Number],required:[o.Boolean],readonly:[o.Boolean]})}}i.FastTextAreaInput=h,h.__name__="FastTextAreaInput",h.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_textarea_input",h.init_FastTextAreaInput()},
"d7e6a9ee16": function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e("tslib"),s=e("@bokehjs/models/widgets/text_input"),l=e("@bokehjs/models/widgets/input_widget"),o=n.__importStar(e("@bokehjs/core/properties"));class a extends l.InputWidgetView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>{var e;return this.input_el.name=null!==(e=this.model.name)&&void 0!==e?e:""}),this.connect(this.model.properties.value.change,()=>{this.input_el.value=this.model.value,console.log("value")}),this.connect(this.model.properties.value_input.change,()=>this.input_el.value=this.model.value_input),this.connect(this.model.properties.disabled.change,()=>this.input_el.disabled=this.model.disabled),this.connect(this.model.properties.placeholder.change,()=>this.input_el.placeholder=this.model.placeholder),this.connect(this.model.properties.appearance.change,()=>this.input_el_any.appearance=this.model.appearance),this.connect(this.model.properties.autofocus.change,()=>this.input_el_any.autofocus=this.model.autofocus),this.connect(this.model.properties.type_of_text.change,()=>this.input_el_any.type=this.model.type_of_text),this.connect(this.model.properties.max_length.change,()=>this.input_el_any.setAttribute("maxlength",this.model.max_length)),this.connect(this.model.properties.min_length.change,()=>this.input_el_any.setAttribute("minlength",this.model.min_length)),this.connect(this.model.properties.pattern.change,()=>this.input_el_any.pattern=this.model.pattern),this.connect(this.model.properties.spellcheck.change,()=>this.input_el_any.spellcheck=this.model.spellcheck),this.connect(this.model.properties.required.change,()=>this.input_el_any.required=this.model.required),this.connect(this.model.properties.readonly.change,()=>this.input_el_any.setAttribute("readonly",this.model.readonly))}get input_el_any(){return this.input_el}render(){super.render();const e=document.createElement("fast-text-field");this.input_el=e,this.input_el.className="bk-fast-input",this.input_el.addEventListener("change",()=>this.change_input()),this.input_el.addEventListener("input",()=>this.change_input_oninput()),this.group_el.appendChild(this.input_el),e.name=this.model.name,e.value=this.model.value,e.appearance=this.model.appearance,e.autofocus=this.model.autofocus,e.placeholder=this.model.placeholder,e.disabled=this.model.disabled,e.type=this.model.type_of_text,e.setAttribute("maxlength",this.model.max_length),e.setAttribute("minlength",this.model.min_length),e.pattern=this.model.pattern,e.spellcheck=this.model.spellcheck,e.required=this.model.required,e.disabled=this.model.disabled,e.setAttribute("readonly",this.model.readonly)}change_input(){this.model.value=this.input_el.value,super.change_input()}change_input_oninput(){this.model.value_input=this.input_el.value,super.change_input()}}i.FastTextInputView=a,a.__name__="FastTextInputView";class h extends s.TextInput{constructor(e){super(e)}static init_FastTextInput(){this.prototype.default_view=a,this.define({appearance:[o.String],autofocus:[o.Boolean],type_of_text:[o.String],max_length:[o.Number],min_length:[o.Number],pattern:[o.String],size:[o.Any],spellcheck:[o.Boolean],required:[o.Boolean],readonly:[o.Boolean,!1]})}}i.FastTextInput=h,h.__name__="FastTextInput",h.__module__="awesome_panel_extensions.bokeh_extensions.fast.fast_text_input",h.init_FastTextInput()},
"59f7dfa54f": function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e("tslib"),o=e("@bokehjs/models/layouts/html_box"),r=e("@bokehjs/core/dom"),p=i.__importStar(e("@bokehjs/core/properties")),u=e("88538263fa"),n=["perspective-viewer-material","perspective-viewer-material-dark","perspective-viewer-material-dense","perspective-viewer-material-dense-dark","perspective-viewer-vaporwave"];function a(e){return!n.includes(e)}function l(e){return"perspective-viewer-"+e}class c extends o.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData),this.connect(this.model.source_stream.properties.data.change,this.addData),this.connect(this.model.source_patch.properties.data.change,this.updateOrAddData),this.connect(this.model.properties.columns.change,this.updateColumns),this.connect(this.model.properties.parsed_computed_columns.change,this.updateParsedComputedColumns),this.connect(this.model.properties.computed_columns.change,this.updateComputedColumns),this.connect(this.model.properties.column_pivots.change,this.updateColumnPivots),this.connect(this.model.properties.row_pivots.change,this.updateRowPivots),this.connect(this.model.properties.aggregates.change,this.updateAggregates),this.connect(this.model.properties.filters.change,this.updateFilters),this.connect(this.model.properties.plugin.change,this.updatePlugin),this.connect(this.model.properties.theme.change,this.updateTheme)}render(){super.render();const e=r.div({class:"pnx-perspective-viewer"});e.innerHTML=this.getInnerHTML(),this.perspective_element=e.children[0],u.set_size(e,this.model),this.el.appendChild(e),this.setData();let t=this;this.perspective_element.addEventListener("perspective-config-update",(function(){t.model.columns=this.columns,t.model.column_pivots=JSON.parse(this.getAttribute("column-pivots")),t.model.parsed_computed_columns=JSON.parse(this.getAttribute("parsed-computed-columns")),t.model.computed_columns=JSON.parse(this.getAttribute("computed-columns")),t.model.row_pivots=JSON.parse(this.getAttribute("row-pivots")),t.model.aggregates=JSON.parse(this.getAttribute("aggregates")),t.model.sort=JSON.parse(this.getAttribute("sort")),t.model.filters=JSON.parse(this.getAttribute("filters")),"debug"!==this.getAttribute("plugin")&&(t.model.plugin=this.getAttribute("plugin"))}))}getInnerHTML(){let e="<perspective-viewer style='height:100%;width:100%;'";return e+=u.toAttribute("class",l(this.model.theme)),e+=u.toAttribute("columns",this.model.columns),e+=u.toAttribute("column-pivots",this.model.column_pivots),e+=u.toAttribute("computed-columns",this.model.computed_columns),e+=u.toAttribute("row-pivots",this.model.row_pivots),e+=u.toAttribute("aggregates",this.model.aggregates),e+=u.toAttribute("sort",this.model.sort),e+=u.toAttribute("filters",this.model.filters),e+=u.toAttribute("plugin",this.model.plugin),e+="></perspective-viewer>",e}setData(){console.log("setData"),console.log(this.model.source.data);let e=u.transform_cds_to_records(this.model.source);this.perspective_element.load(e)}addData(){console.log("addData"),this.setData()}updateOrAddData(){console.log("updateOrAddData"),this.setData()}updateAttribute(e,t,s){if(null==t||t===[])return;const i=this.perspective_element.getAttribute(e);s&&(t=JSON.stringify(t)),i!==t&&this.perspective_element.setAttribute(e,t)}updateColumns(){this.updateAttribute("columns",this.model.columns,!0)}updateParsedComputedColumns(){this.updateAttribute("parsed-computed-columns",this.model.parsed_computed_columns,!0)}updateComputedColumns(){this.updateAttribute("computed-columns",this.model.computed_columns,!0)}updateColumnPivots(){this.updateAttribute("column-pivots",this.model.column_pivots,!0)}updateRowPivots(){this.updateAttribute("row-pivots",this.model.row_pivots,!0)}updateAggregates(){this.updateAttribute("aggregates",this.model.row_pivots,!0)}updateSort(){this.updateAttribute("sort",this.model.sort,!0)}updateFilters(){this.updateAttribute("sort",this.model.filters,!0)}updatePlugin(){this.updateAttribute("plugin",this.model.plugin,!1)}updateTheme(){let e=this.perspective_element.getAttribute("class"),t=this.toNewClassAttribute(e,this.model.theme);this.perspective_element.setAttribute("class",t)}toNewClassAttribute(e,t){let s=[];return null!=e&&(s=e.split(" ").filter(a)),s.push(l(t)),s.join(" ")}}s.PerspectiveViewerView=c,c.__name__="PerspectiveViewerView";class d extends o.HTMLBox{constructor(e){super(e)}static init_PerspectiveViewer(){this.prototype.default_view=c,this.define({source:[p.Any],source_stream:[p.Any],source_patch:[p.Any],columns:[p.Array],parsed_computed_columns:[p.Array,[]],computed_columns:[p.Array],column_pivots:[p.Array],row_pivots:[p.Array],aggregates:[p.Any],sort:[p.Array],filters:[p.Array],plugin:[p.String],theme:[p.String]})}}s.PerspectiveViewer=d,d.__name__="PerspectiveViewer",d.__module__="awesome_panel_extensions.bokeh_extensions.perspective_viewer",d.init_PerspectiveViewer()},
"88538263fa": function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0}),i.set_size=function(e,t){let i=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:n}=t;if(null!=n)if("fixed"==n)i=l="fixed";else if("stretch_both"==n)i=l="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)l="max";else switch(n){case"scale_width":i="max",l="min";break;case"scale_height":i="min",l="max";break;case"scale_both":i="max",l="max";break;default:throw new Error("unreachable")}"fixed"==i&&t.width?e.style.width=t.width+"px":"max"==i&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")},i.transform_cds_to_records=function(e){const t=[],i=e.columns(),l=e.get_length();if(0===i.length||null===l)return[];for(let n=0;n<l;n++){const l={};for(const t of i){let i=e.get_array(t);const s=null==i[0].shape?null:i[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=i.slice(n*s[1],n*s[1]+s[1]):l[t]=i[n]}t.push(l)}return t},i.toAttribute=function(e,t){return null===t?"":("string"!=typeof t&&(t=JSON.stringify(t))," "+e+"='"+t+"'")}},
"eb1a40b8a7": function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e("tslib"),i=e("@bokehjs/models/layouts/html_box"),n=e("@bokehjs/core/dom"),a=s.__importStar(e("@bokehjs/core/properties")),l=e("88538263fa");class _ extends i.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,this.setData)}render(){super.render(),this.container=n.div({class:"pnx-pivot-table"}),l.set_size(this.container,this.model),this.el.appendChild(this.container),this.setData()}setData(){console.log("setData"),console.log(this.model.source.data);let e=l.transform_cds_to_records(this.model.source);this.pivot_table_element=$(this.container),console.log(e),this.pivot_table_element.pivotUI(e,{})}}o.PivotTableView=_,_.__name__="PivotTableView";class r extends i.HTMLBox{constructor(e){super(e)}static init_PivotTable(){this.prototype.default_view=_,this.define({source:[a.Any],source_stream:[a.Any],source_patch:[a.Any]})}}o.PivotTable=r,r.__name__="PivotTable",r.__module__="awesome_panel_extensions.bokeh_extensions.pivot_table",r.init_PivotTable()},
"20967df791": function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t("tslib"),s=t("@bokehjs/models/widgets/abstract_icon"),o=n.__importStar(t("@bokehjs/core/properties"));class l extends s.AbstractIconView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.render())}render(){if(super.render(),null===this.model.text&&""===this.model.text)return;this.el.innerHTML="";const t=(e=this.model.text,i=document.createElement("template"),e=e.trim(),i.innerHTML=e,i.content.firstChild);var e,i;if(this.el.appendChild(t),this.el.style.display="inline",this.el.style.height=this.model.size+"em",this.el.style.width=this.model.size+"em",t.style.verticalAlign="middle",t.style.height=this.model.size+"em",t.style.width=this.model.size+"em",t.style.fill=this.model.fill_color,this.model.spin_duration>0){const e=this.model.spin_duration+"ms";t.style.setProperty("-webkit-animation-name","spin"),t.style.setProperty("-webkit-animation-duration",e),t.style.setProperty("-webkit-animation-iteration-count","infinite"),t.style.setProperty("-webkit-animation-timing-function","linear"),t.style.setProperty("-moz-animation-name","spin"),t.style.setProperty("-moz-animation-duration",e),t.style.setProperty("-moz-animation-iteration-count","infinite"),t.style.setProperty("-moz-animation-timing-function","linear"),t.style.setProperty("-ms-animation-name","spin"),t.style.setProperty("-ms-animation-duration",e),t.style.setProperty("-ms-animation-iteration-count","infinite"),t.style.setProperty("-ms-animation-timing-function","linear"),t.style.setProperty("animation-name","spin"),t.style.setProperty("animation-duration",e),t.style.setProperty("animation-iteration-count","infinite"),t.style.setProperty("animation-timing-function","linear")}if(t.classList.add("icon"),null!=this.model.label&&""!==this.model.label){const e=this.model.label.toLowerCase().replace(" ","");t.classList.add("icon-"+e)}}}i.IconView=l,l.__name__="IconView";class r extends s.AbstractIcon{constructor(t){super(t)}static init_Icon(){this.prototype.default_view=l,this.define({label:[o.String],text:[o.String],size:[o.Number,1],fill_color:[o.String,"currentColor"],spin_duration:[o.Int,0]})}}i.Icon=r,r.__name__="Icon",r.__module__="awesome_panel_extensions.bokeh_extensions.icon",r.init_Icon()},
"e2e34597ee": function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const l=e("tslib"),a=e("@bokehjs/models/layouts/html_box"),s=e("@bokehjs/core/dom"),i=l.__importStar(e("@bokehjs/core/properties"));function n(e,t){let o=null!=t.width?"fixed":"fit",l=null!=t.height?"fixed":"fit";const{sizing_mode:a}=t;if(null!=a)if("fixed"==a)o=l="fixed";else if("stretch_both"==a)o=l="max";else if("stretch_width"==a)o="max";else if("stretch_height"==a)l="max";else switch(a){case"scale_width":o="max",l="min";break;case"scale_height":o="min",l="max";break;case"scale_both":o="max",l="max";break;default:throw new Error("unreachable")}"fixed"==o&&t.width?e.style.width=t.width+"px":"max"==o&&(e.style.width="100%"),"fixed"==l&&t.height?e.style.height=t.height+"px":"max"==l&&(e.style.height="100%")}function c(e){const t=[],o=e.columns(),l=e.get_length();if(0===o.length||null===l)return[];for(let a=0;a<l;a++){const l={};for(const t of o){let o=e.get_array(t);const s=null==o[0].shape?null:o[0].shape;null!=s&&s.length>1&&"number"==typeof s[0]?l[t]=o.slice(a*s[1],a*s[1]+s[1]):l[t]=o[a]}t.push(l)}return t}o.set_size=n;class r extends a.HTMLBoxView{constructor(){super(...arguments),this._tabulator_cell_updating=!1}connect_signals(){super.connect_signals(),this.connect(this.model.properties.configuration.change,()=>{this.render()}),this.connect(this.model.source.properties.data.change,()=>{this.setData()}),this.connect(this.model.source.streaming,()=>this.addData()),this.connect(this.model.source.patching,()=>this.updateOrAddData()),this.connect(this.model.source.selected.properties.indices.change,()=>this.updateSelection())}render(){super.render(),console.log("render");const e=s.div({class:"pnx-tabulator"});n(e,this.model);let t=this.getConfiguration();"undefined"==typeof Tabulator&&console.log("Tabulator not loaded. See https://github.com/holoviz/panel/issues/15299"),console.log(Tabulator),this.tabulator=new Tabulator(e,t),this.el.appendChild(e)}getConfiguration(){let e=this;let t={rowSelectionChanged:function(t,o){console.log("rowSelectionChanged");let l=t.map(e=>e.index);e.model.source.selected.indices=l},cellEdited:function(t){console.log("cellEdited");const o=t._cell.column.field,l=t._cell.row.data.index,a=t._cell.value;e._tabulator_cell_updating=!0,e.model.source.patch({[o]:[[l,a]]}),e.model._cell_change={c:o,i:l,v:a},e._tabulator_cell_updating=!1},index:"index"},o=Object.assign(Object.assign({},this.model.configuration),t),l=this.model.source;return null===l||0===Object.keys(l.data).length?o:(console.log("adding data to configuration"),l=c(l),Object.assign(Object.assign({},o),{data:l}))}after_layout(){console.log("after_layout"),super.after_layout(),this.tabulator.redraw(!0)}setData(){console.log("setData");let e=c(this.model.source);this.tabulator.setData(e)}addData(){console.log("addData");let e=c(this.model.source);this.tabulator.setData(e)}updateOrAddData(){if(!0===this._tabulator_cell_updating)return;console.log("updateData");let e=c(this.model.source);this.tabulator.setData(e)}updateSelection(){if(console.log("updateSelection"),null==this.tabulator)return;let e=this.model.source.selected.indices,t=this.tabulator.getSelectedRows();for(let o of t)e.includes(o.getData().index)||o.toggleSelect();for(let t of e)this.tabulator.selectRow(t)}}o.TabulatorModelView=r,r.__name__="TabulatorModelView";class d extends a.HTMLBox{constructor(e){super(e)}static init_TabulatorModel(){this.prototype.default_view=r,this.define({configuration:[i.Any],source:[i.Any],_cell_change:[i.Any]})}}o.TabulatorModel=d,d.__name__="TabulatorModel",d.__module__="awesome_panel_extensions.bokeh_extensions.tabulator_model",d.init_TabulatorModel()},
"5c604c9068": function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e("tslib"),s=e("@bokehjs/core/dom"),i=o.__importStar(e("@bokehjs/core/properties")),r=e("@bokehjs/models/layouts/html_box"),a=e("@bokehjs/styles/widgets/inputs");function l(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}class h extends r.HTMLBoxView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.name.change,()=>this.handleNameChange()),this.connect(this.model.properties.innerHTML.change,()=>this.render()),this.connect(this.model.properties.attributesLastChange.change,()=>this.handleAttributesLastChangeChange()),this.connect(this.model.properties.propertiesLastChange.change,()=>this.handlePropertiesLastChangeChange()),this.connect(this.model.properties.columnDataSource.change,()=>this.handleColumnDataSourceChange())}handleNameChange(){this.label_el&&(this.label_el.textContent=this.model.name)}render(){super.render(),this.el.innerHTML!==this.model.innerHTML&&this.createOrUpdateWebComponentElement()}after_layout(){"after_layout"in this.webComponentElement&&this.webComponentElement.after_layout()}createOrUpdateWebComponentElement(){this.webComponentElement&&(this.webComponentElement.onchange=null);const e=this.model.name;"inputgroup"===this.model.componentType&&e?(this.group_el=s.div({class:a.bk_input_group},this.label_el),this.group_el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.group_el.firstElementChild,this.label_el=s.label({style:{display:0==e.length?"none":""}},e),this.group_el.insertBefore(this.label_el,this.webComponentElement),this.el.appendChild(this.group_el)):(this.el.innerHTML=l(this.model.innerHTML),this.webComponentElement=this.el.firstElementChild),this.activate_scripts(this.webComponentElement.parentNode),this.initPropertyValues(),this.handlePropertiesLastChangeChange(),this.handleColumnDataSourceChange(),this.webComponentElement.onchange=e=>this.handlePropertiesChange(e),this.addEventListeners(),this.addAttributesMutationObserver()}addAttributesMutationObserver(){if(!this.model.attributesToWatch)return;let e={childList:!1,attributes:!0,characterData:!1,subtree:!1,attributeFilter:Object.keys(this.model.attributesToWatch),attributeOldValue:!1,characterDataOldValue:!1};new MutationObserver(e=>{let t=new Object;for(let e in this.model.attributesToWatch){const n=this.webComponentElement.getAttribute(e);t[e]=n}this.model.attributesLastChange!==t&&(this.model.attributesLastChange=t)}).observe(this.webComponentElement,e)}addEventListeners(){this.eventsCount={};for(let e in this.model.eventsToWatch)this.eventsCount[e]=0,this.webComponentElement.addEventListener(e,e=>this.eventHandler(e),!1)}transform_cds_to_records(e){const t=[],n=e.columns(),o=e.get_length();if(0===n.length||null===o)return[];for(let s=0;s<o;s++){const o={};for(const t of n){let n=e.get_array(t);const i=null==n[0].shape?null:n[0].shape;null!=i&&i.length>1&&"number"==typeof i[0]?o[t]=n.slice(s*i[1],s*i[1]+i[1]):o[t]=n[s]}t.push(o)}return t}isFunction(e){if(e){const t={}.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t}return!1}handleColumnDataSourceChange(){if(this.model.columnDataSource){let e;e="records"===this.model.columnDataSourceOrient?this.transform_cds_to_records(this.model.columnDataSource):this.model.columnDataSource.data;const t=this.model.columnDataSourceLoadFunction.toString(),n=this.webComponentElement[t];this.isFunction(n)?this.webComponentElement[t](e):this.webComponentElement[t]=e}}activate_scripts(e){Array.from(e.querySelectorAll("script")).forEach(e=>{const t=document.createElement("script");Array.from(e.attributes).forEach(e=>t.setAttribute(e.name,e.value)),t.appendChild(document.createTextNode(e.innerHTML)),e.parentNode&&e.parentNode.replaceChild(t,e)})}get_nested_property(e,t){let n=(t=(t=t.replace(/\[(\w+)\]/g,".$1")).replace(/^\./,"")).split(".");for(let t=0,o=n.length;t<o;++t){let o=n[t];if(!(o in e))return"";e=e[o]}return e}set_nested_property(e,t,n){const o=t.split(".");if(1===o.length)e[t]=n;else{const t=o.length;for(let n=0;n<t-1;n++){const t=o[n];e[t]||(e[t]={}),e=e[t]}e[o[t-1]]=n}}eventHandler(e){let t=e.type;this.eventsCount[t]+=1;let n={};n[t]=this.eventsCount[t],this.model.eventsCountLastChange=n,this.checkIfPropertiesChanged()}checkIfPropertiesChanged(){const e={};for(const t in this.model.propertiesToWatch){const n=this.propertyValues[t],o=this.get_nested_property(this.webComponentElement,t);n!=o&&(e[t]=o,this.propertyValues[t]=o)}Object.keys(e).length&&(this.model.propertiesLastChange=e)}handlePropertiesChange(e){const t=new Object;for(const n in this.model.propertiesToWatch)e.detail&&n in e.detail?(t[n]=e.detail[n],this.propertyValues[n]=e.detail[n]):e.target&&n in e.target&&(t[n]=e.target[n],this.propertyValues[n]=e.target[n]);Object.keys(t).length&&(this.model.propertiesLastChange=t)}initPropertyValues(){if(this.propertyValues=new Object,this.webComponentElement)for(let e in this.model.propertiesToWatch){let t=this.propertyValues[e],n=this.get_nested_property(this.webComponentElement,e);n!==t&&(this.propertyValues[e]=n)}}handleAttributesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.attributesLastChange;for(let t in this.model.attributesLastChange)if(t in this.model.attributesToWatch){let n=this.webComponentElement.getAttribute(t),o=e[t];n!==o&&(null===o?this.webComponentElement.removeAttribute(t):this.webComponentElement.setAttribute(t,o))}}handlePropertiesLastChangeChange(){if(!this.webComponentElement)return;let e=this.model.propertiesLastChange;for(let t in this.model.propertiesLastChange)if(t in this.model.propertiesToWatch){let n=e[t];this.set_nested_property(this.webComponentElement,t,n)}}}n.WebComponentView=h,h.__name__="WebComponentView";class p extends r.HTMLBox{constructor(e){super(e)}static init_WebComponent(){this.prototype.default_view=h,this.define({componentType:[i.String,"htmlbox"],innerHTML:[i.String,""],attributesToWatch:[i.Any],attributesLastChange:[i.Any],propertiesToWatch:[i.Any],propertiesLastChange:[i.Any],eventsToWatch:[i.Any],eventsCountLastChange:[i.Any],columnDataSource:[i.Any],columnDataSourceOrient:[i.Any],columnDataSourceLoadFunction:[i.Any]})}}n.WebComponent=p,p.__name__="WebComponent",p.__module__="awesome_panel_extensions.bokeh_extensions.web_component",p.init_WebComponent()},
}, "ed583be1cf", {"index":"ed583be1cf","bokeh_extensions/index":"963d0f8803","bokeh_extensions/fast/fast_anchor":"61ceb3906d","bokeh_extensions/fast/fast_button":"cffb3837b7","bokeh_extensions/fast/fast_checkbox_group":"b5be3a3047","bokeh_extensions/fast/fast_switch_group":"ec1eb7e949","bokeh_extensions/fast/fast_textarea_input":"86ebbe8a0e","bokeh_extensions/fast/fast_text_input":"d7e6a9ee16","bokeh_extensions/perspective_viewer":"59f7dfa54f","bokeh_extensions/shared":"88538263fa","bokeh_extensions/pivot_table":"eb1a40b8a7","bokeh_extensions/icon":"20967df791","bokeh_extensions/tabulator_model":"e2e34597ee","bokeh_extensions/web_component":"5c604c9068"}, {});
})

