[![Conda package](https://anaconda.org/bioasp/caspo/badges/version.svg)](https://anaconda.org/bioasp/caspo)
[![Documentation Status](https://readthedocs.org/projects/caspo/badge/?version=latest)](http://caspo.readthedocs.io/en/latest/?badge=latest)
[![license](https://img.shields.io/badge/license-GPLv3+-brightgreen.svg)](https://www.gnu.org/licenses/gpl.html)
[![Gitter](https://badges.gitter.im/bioasp/community.svg)](https://gitter.im/bioasp/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

### Reasoning on the response of logical signaling networks

The manual identification of logic rules underlying a biological system is
often hard, error-prone and time consuming.
Further, it has been shown that, if the inherent experimental noise is considered, many different logical networks
can be compatible with a set of experimental observations.
Thus, automated **inference of logical networks from experimental data** would allow for
identifying admissible large-scale logic models saving a lot of efforts and without any a priori bias.
Next, once a family a logical networks has been identified, one can suggest or **design new experiments** in order to reduce the uncertainty provided by this family.
Finally, one can **look for intervention strategies** that force a set of target species or compounds into a desired steady state.
Altogether, this constitutes a pipeline for automated reasoning on logical signaling networks.
Hence, the aim of **caspo** is to implement such a pipeline providing a powerful and easy-to-use software tool for systems biologists.

### Documentation

Detailed documentation about how to install and use **caspo** is available at http://caspo.readthedocs.io.

### Samples

Sample files are included with **caspo** and available for [download](http://bioasp.github.io/caspo/data.zip)

### Citation

caspo: a toolbox for automated reasoning on the response of logical signaling networks families. (2017). Bioinformatics. [DOI](https://doi.org/10.1093/bioinformatics/btw738)

### Related publications
*  Designing experiments to discriminate families of logic models. (2015). Frontiers in Bioengineering and Biotechnology 3:131. [DOI](http://dx.doi.org/10.3389/fbioe.2015.00131)

* Learning Boolean logic models of signaling networks with ASP. (2015). Theoretical Computer Science. [DOI](http://dx.doi.org/10.1016/j.tcs.2014.06.022)

* Reasoning on the Response of Logical Signaling Networks with ASP. (2014). John Wiley & Sons, Inc. [DOI](http://dx.doi.org/10.1002/9781119005223.ch2)

* Minimal intervention strategies in logical signaling networks with ASP. (2013). Theory and Practice of Logic Programming. [DOI](http://dx.doi.org/10.1017/S1471068413000422)

* Exhaustively characterizing feasible logic models of a signaling network using Answer Set Programming. (2013). Bioinformatics. [DOI](http://dx.doi.org/10.1093/bioinformatics/btt393)

* Revisiting the Training of Logic Models of Protein Signaling Networks with a Formal Approach based on Answer Set Programming. (2012) The 10th Conference on Computational Methods in Systems Biology. [DOI](http://dx.doi.org/10.1007/978-3-642-33636-2_20)
