# constants.py - module for shared constants
# Copyright (C) 2017-2020  Nguyễn Gia Phong
#
# This file is part of Brutal Maze.
#
# Brutal Maze is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# Brutal Maze is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with Brutal Maze.  If not, see <https://www.gnu.org/licenses/>.

__doc__ = 'Brutal Maze module for shared constants'

from string import ascii_lowercase

import pygame
from pkg_resources import resource_filename as pkg_file

SETTINGS = pkg_file('brutalmaze', 'settings.ini')
ICON = pygame.image.load(pkg_file('brutalmaze', 'icon.png'))

SFX_NOISE = pkg_file('brutalmaze', 'soundfx/noise.ogg')
SFX_SPAWN = pkg_file('brutalmaze', 'soundfx/spawn.ogg')
SFX_SLASH_ENEMY = pkg_file('brutalmaze', 'soundfx/slash-enemy.ogg')
SFX_SLASH_HERO = pkg_file('brutalmaze', 'soundfx/slash-hero.ogg')
SFX_SHOT_ENEMY = pkg_file('brutalmaze', 'soundfx/shot-enemy.ogg')
SFX_SHOT_HERO = pkg_file('brutalmaze', 'soundfx/shot-hero.ogg')
SFX_MISSED = pkg_file('brutalmaze', 'soundfx/missed.ogg')
SFX_HEART = pkg_file('brutalmaze', 'soundfx/heart.ogg')
SFX_LOSE = pkg_file('brutalmaze', 'soundfx/lose.ogg')
SFX = (SFX_NOISE, SFX_SPAWN, SFX_SLASH_ENEMY, SFX_SLASH_HERO,
       SFX_SHOT_ENEMY, SFX_SHOT_HERO, SFX_MISSED, SFX_HEART, SFX_LOSE)

SQRT2 = 2 ** 0.5
INIT_SCORE = 2
ROAD_WIDTH = 3  # grids
WALL_WIDTH = 4  # grids
CELL_WIDTH = WALL_WIDTH + ROAD_WIDTH*2  # grids
CELL_NODES = ROAD_WIDTH, ROAD_WIDTH + WALL_WIDTH, 0
MAZE_SIZE = 10  # cells
MIDDLE = MAZE_SIZE // 2 * CELL_WIDTH
HEAL_SPEED = 1  # HP/s
HERO_SPEED = 5  # grid/s
ENEMY_SPEED = 6     # grid/s
BULLET_SPEED = 15   # grid/s
ATTACK_SPEED = 333.333  # ms/strike
MAX_WOUND = 1   # per attack turn
FIRANGE = 6     # grids
BULLET_LIFETIME = 1000 * FIRANGE / (BULLET_SPEED-HERO_SPEED)    # ms
EMPTY, WALL, HERO, ENEMY = range(4)
ADJACENTS = (1, 0), (0, 1), (-1, 0), (0, -1)
CORNERS = (1, 1), (-1, 1), (-1, -1), (1, -1)
AROUND_HERO = set((MIDDLE + x, MIDDLE + y) for x, y in ADJACENTS + CORNERS)

TANGO = {'Butter': ((252, 233, 79), (237, 212, 0), (196, 160, 0)),
         'Orange': ((252, 175, 62), (245, 121, 0), (206, 92, 0)),
         'Chocolate': ((233, 185, 110), (193, 125, 17), (143, 89, 2)),
         'Chameleon': ((138, 226, 52), (115, 210, 22), (78, 154, 6)),
         'SkyBlue': ((114, 159, 207), (52, 101, 164), (32, 74, 135)),
         'Plum': ((173, 127, 168), (117, 80, 123), (92, 53, 102)),
         'ScarletRed': ((239, 41, 41), (204, 0, 0), (164, 0, 0)),
         'Aluminium': ((238, 238, 236), (211, 215, 207), (186, 189, 182),
                       (136, 138, 133), (85, 87, 83), (46, 52, 54))}
TANGO_VALUES = list(TANGO.values())
ENEMIES = ['Butter', 'Orange', 'Chocolate', 'Chameleon',
           'SkyBlue', 'Plum', 'ScarletRed']
COLOR_CODE = ascii_lowercase + '0'
COLORS = {c: COLOR_CODE[i] for i, c in enumerate(
    color for code in ENEMIES + ['Aluminium'] for color in TANGO[code])}
ENEMY_HP = 3
HERO_HP = 5
MIN_BEAT = 420
BG_COLOR = TANGO['Aluminium'][-1]
FG_COLOR = TANGO['Aluminium'][0]

JSON_SEPARATORS = ',', ':'
