import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-solutions-constructs.aws-events-rule-kinesis-streams",
    "version": "1.170.1",
    "description": "CDK Constructs for deploying Amazon CloudWatch Events Rule that invokes Amazon Kinesis Data Stream",
    "license": "Apache-2.0",
    "url": "https://github.com/awslabs/aws-solutions-constructs.git",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/awslabs/aws-solutions-constructs.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_solutions_constructs.aws_events_rule_kinesis_streams",
        "aws_solutions_constructs.aws_events_rule_kinesis_streams._jsii"
    ],
    "package_data": {
        "aws_solutions_constructs.aws_events_rule_kinesis_streams._jsii": [
            "aws-events-rule-kinesisstreams@1.170.1.jsii.tgz"
        ],
        "aws_solutions_constructs.aws_events_rule_kinesis_streams": [
            "py.typed"
        ]
    },
    "python_requires": "~=3.7",
    "install_requires": [
        "aws-cdk.aws-cloudwatch==1.170.1",
        "aws-cdk.aws-events==1.170.1",
        "aws-cdk.aws-iam==1.170.1",
        "aws-cdk.aws-kinesis==1.170.1",
        "aws-cdk.core==1.170.1",
        "aws-solutions-constructs.aws-eventbridge-kinesis-streams==1.170.1",
        "aws-solutions-constructs.core==1.170.1",
        "constructs>=3.2.0, <4.0.0",
        "jsii>=1.67.0, <2.0.0",
        "publication>=0.0.3",
        "typeguard~=2.13.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Typing :: Typed",
        "License :: OSI Approved"
    ],
    "scripts": []
}
"""
)

with open("README.md", encoding="utf8") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
