"""
#    Copyright 2022 Red Hat
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
"""
from unittest import TestCase
from unittest.mock import Mock

from cibyl.sources.zuul.apis.factories.rest import ZuulRESTFactory
from cibyl.sources.zuul.apis.rest import ZuulRESTClient


class TestZuulRESTFactory(TestCase):
    """Tests for :class:`ZuulRESTFactory`.
    """

    def test_creates_rest_api(self):
        """Checks that the correct type of API is generated by this factory.
        """
        url = Mock()

        factory = ZuulRESTFactory()

        self.assertIsInstance(factory.create(url), ZuulRESTClient)

    def test_arguments_passed_to_api(self):
        """Checks that the created API has the arguments passed to the
        factory.
        """
        url = Mock()
        cert = Mock()

        factory = ZuulRESTFactory()

        result = factory.create(url, cert)

        self.assertEqual(result.session.host, url)
        self.assertEqual(result.session.session.verify, cert)
