"""
#    Copyright 2022 Red Hat
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
"""
import logging
import sys
from io import StringIO
from unittest import TestCase


class EndToEndTest(TestCase):
    """Base fixture for e2e tests. Redirects stdout to a buffer to help
    assert the app's output.
    """

    def setUp(self):
        self._stdout = StringIO()
        self._logout = StringIO()

        sys.stdout = self._stdout

        logging.basicConfig(stream=self._logout)

    @property
    def stdout(self):
        """
        :return: What the app wrote to stdout.
        :rtype: str
        """
        return self._stdout.getvalue()

    @property
    def logout(self):
        """
        :return: What the app logged.
        :rtype: str
        """
        return self._logout.getvalue()
