<p align="center"> <img src="https://raw.githubusercontent.com/annehulsey/cranes/master/doc_src/cranes_title.PNG" align="middle" height=75 /></p>

<p align="center"> <b>C</b>ordons</b> in <b>R</b>ecovery</b> <b>A</b>ssessments of <b>N</b>eighborhoods following <b>E</b>arthquake <b>S</b>imulations</p>



## What is it?

`cranes` is a Python package that implements the recovery simulation framework described in Hulsey et at. (2021) "High-resolution post-earthquake recovery simulation: Impact of safety cordons." *Earthquake Spectra*. (In Review)

## What can I use it for?

`cranes` performs post-earthquake recovery assessments at the community-level, using a building inventory (with accompanying vulnerability profiles) and regional ground motion maps to simulate damage, the resulting safety cordons around tall buildings with impaired collapse safety, and the recovery process for each building in the community. The results are presented as recovery curves that quantify the cumulative loss in building functionality across the community as a function of time. The full set of recovery curves reflects the uncertainty in both the shaking intensity due to a scenario earthquake and the vulnerability of the buildings to the shaking. These results are further distilled into scalar metrics for the expected loss of functionality in the first year and the probability of achieving the community's recovery targets. These metrics are useful for investigating the efficacy of various mitigation strategies to expedite recovery.

## How does it work?

`cranes` simulates many realizations of community damage and recovery to account for the uncertainty in both the shaking intensity due to a scenario earthquake and the vulnerability of the buildings to the shaking. This method of handling uncertainty (known as Monte Carlo simulation) is consistent with many state of the art practices for individual building performance assessments (e.g [FEMA P-58](https://femap58.atcouncil.org/)). Each community realization is based on a unique ground motion map, sampled from a set of maps that collectively represents the potential variability in shaking intensities that could be generated by the scenario earthquake. (See the [`seaturtles`](https://github.com/annehulsey/seaturtles) Python package for more details.) The uncertainty of each building's vulnerability to ground shaking is represented by a "vulnerability profile" -  set of stored [FEMA P-58](https://femap58.atcouncil.org/) realizations for the potential range of post-earthquake conditions. Each building's condition is sampled from its vulnerability profile, based on the map's relevant shaking intensity (considering the site location, soil conditions, and the building period). Once each building's post-earthquake condition is sampled, safety cordons are assigned to tall buildings with impaired collapse safety. The presence of these cordons is then included among each neighboring building's impeding factors that must be resolved prior to initiating building repairs. (See the [REDi](https://www.arup.com/perspectives/publications/research/section/redi-rating-system) methodology for details on simulating the impeding factor durations.) The impeding factor durations and repair times are summed to obtain recovery times for each building, which can then be aggregated to track the community recovery over time.

## How can I get started?

You can get oriented with the [example](https://github.com/annehulsey/cranes/tree/master/example/example.zip) provided on the `cranes` GitHub repository. The datafiles are available at DesignSafe ([DOI](https://doi.org/10.17603/ds2-dpam-dm40)), as described in the README files in the ***inputs*** and ***outputs*** folders:

- ***inputs***: 
  - *SF_Downtown_Inventory.csv*: 	locations and attributes of each buildings in the case study area
  - *Mw7.2_SanAndreas_GroundMotionMaps.h5*: 	simulated ground motion maps
  - *Vulnerabilities_original.h5*: 	building vulnerability profiles for each building
  - *Vulnerabilities_retrofits.h5*: 	building vulnerability profiles, assuming the retrofitted buildings conform to current design requirements

- ***outputs***: 
  - *case_study_results.h5*: 	results of the case study
  - *median_ground_motion_comparison_results.h5*: 	results without considering the variability of the ground motions

You can explore the results using the Jupyter Notebooks included in the ***journal figures*** folder. While they were created to produce the figures in Hulsey et at. (2021), they also serve as an orientation for accessing, viewing, and understanding the data.

You can also re-simulate the results using the ***Run Recovery Simulation*** Jupyter Notebook. *Note that the analysis is probabilistic so the new results will not be identical to those in **case_study_results** file.* Alternatively, you can modify the assumptions in each analysis case to consider other mitigation strategies or sensitivity analyses or import your own input files. It would be helpful to explore how each analysis case is stored in the results file before making modifications.

## Installation

`cranes` is available at the Python Package Index (PyPI). You can simply install it using `pip` as follows:

```
pip install cranes
```

## License

`cranes` is distributed under the MIT license, see [LICENSE](https://github.com/annehulsey/cranes/blob/main/LICENSE).

## Contact

Anne Hulsey, University of Auckland, anne.hulsey@auckland.ac.nz

