/**
 * Models an AWS execution environment, for use within the CDK toolkit.
 *
 * @stability stable
 */
export interface Environment {
    /**
     * The arbitrary name of this environment (user-set, or at least user-meaningful).
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The AWS account this environment deploys into.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * The AWS region name where this environment deploys into.
     *
     * @stability stable
     */
    readonly region: string;
}
export declare const UNKNOWN_ACCOUNT = "unknown-account";
export declare const UNKNOWN_REGION = "unknown-region";
/**
 * @stability stable
 */
export declare class EnvironmentUtils {
    /**
     * @stability stable
     */
    static parse(environment: string): Environment;
    /**
     * Build an environment object from an account and region.
     *
     * @stability stable
     */
    static make(account: string, region: string): Environment;
    /**
     * Format an environment string from an account and region.
     *
     * @stability stable
     */
    static format(account: string, region: string): string;
}
