# -*- coding: utf-8 -*-
"""Module defining a dictionary containing longitude-latitude boundary boxes
for all countries and continents covered by the Vmap0 dataset
"""
#: :class:`dict`. lonlatboxes for different countries and continents
lonlatboxes = {
    'Afghanistan': [60.0, 74.0, 29.0, 38.0],
    'Africa': [-26.0, 63.0, -41.0, 37.0],
    'Albania': [19.0, 21.0, 39.0, 42.0],
    'Algeria': [-9.0, 11.0, 18.0, 37.0],
    'American Samoa': [-172.0, -170.0, -15.0, -12.0],
    'Andorra': [1.0, 1.0, 42.0, 42.0],
    'Angola': [11.0, 24.0, -19.0, -5.0],
    'Anguilla': [-64.0, -63.0, 18.0, 18.0],
    'Antarctic Area': [-180.0, 180.0, -90.0, -38.0],
    'Antarctica': [-180.0, 180.0, -90.0, -61.0],
    'Antigua and Barbuda': [-63.0, -62.0, 16.0, 17.0],
    'Argentina': [-74.0, -54.0, -56.0, -22.0],
    'Armenia': [43.0, 46.0, 38.0, 41.0],
    'Aruba': [-71.0, -70.0, 12.0, 12.0],
    'Ashmore and Cartier Islands': [122.0, 123.0, -13.0, -13.0],
    'Asia': [25.0, 190.0, -12.0, 81.0],
    'Australia': [112.0, 159.0, -55.0, -10.0],
    'Australian Area': [96.0, 236.0, -55.0, 16.0],
    'Austria': [9.0, 17.0, 46.0, 49.0],
    'Azerbaijan': [44.0, 50.0, 38.0, 41.0],
    'Bahrain': [50.0, 50.0, 25.0, 26.0],
    'Baker Island': [-177.0, -177.0, 0.0, 0.0],
    'Bangladesh': [88.0, 92.0, 20.0, 26.0],
    'Barbados': [-60.0, -60.0, 13.0, 13.0],
    'Belarus': [23.0, 32.0, 51.0, 56.0],
    'Belgium': [2.0, 6.0, 49.0, 51.0],
    'Belize': [-90.0, -88.0, 15.0, 18.0],
    'Benin': [0.0, 3.0, 6.0, 12.0],
    'Bermuda': [-65.0, -65.0, 32.0, 32.0],
    'Bhutan': [88.0, 92.0, 26.0, 28.0],
    'Bolivia': [-70.0, -58.0, -23.0, -10.0],
    'Bosnia and Herzegovina': [15.0, 19.0, 42.0, 45.0],
    'Botswana': [19.0, 29.0, -27.0, -18.0],
    'Bouvet Island': [3.0, 3.0, -55.0, -55.0],
    'Brazil': [-74.0, -29.0, -34.0, 5.0],
    'British Indian Ocean Territory': [71.0, 72.0, -8.0, -6.0],
    'British Virgin Islands': [-65.0, -65.0, 18.0, 18.0],
    'Brunei': [114.0, 115.0, 4.0, 5.0],
    'Bulgaria': [22.0, 28.0, 41.0, 44.0],
    'Burkina Faso': [-6.0, 2.0, 9.0, 15.0],
    'Burma': [92.0, 101.0, 9.0, 28.0],
    'Burundi': [28.0, 30.0, -5.0, -3.0],
    'Cambodia': [102.0, 107.0, 9.0, 14.0],
    'Cameroon': [8.0, 16.0, 1.0, 13.0],
    'Canada': [-141.0, -53.0, 41.0, 83.0],
    'Cape Verde': [-26.0, -23.0, 14.0, 17.0],
    'Cayman Islands': [-82.0, -80.0, 19.0, 19.0],
    'Central African Republic': [14.0, 27.0, 2.0, 11.0],
    'Chad': [13.0, 24.0, 7.0, 23.0],
    'Chile': [-110.0, -67.0, -56.0, -18.0],
    'China': [73.0, 134.0, 18.0, 53.0],
    'Christmas Island': [105.0, 105.0, -11.0, -11.0],
    'Clipperton Island': [-110.0, -110.0, 10.0, 10.0],
    'Cocos (Keeling) Islands': [96.0, 96.0, -13.0, -12.0],
    'Colombia': [-82.0, -67.0, -5.0, 13.0],
    'Comoros': [43.0, 44.0, -13.0, -12.0],
    'Congo': [11.0, 18.0, -6.0, 3.0],
    'Congo (Democratic Republic of the)': [12.0, 31.0, -14.0, 5.0],
    'Cook Islands': [-166.0, -158.0, -22.0, -9.0],
    'Coral Sea Islands': [149.0, 155.0, -18.0, -17.0],
    'Costa Rica': [-88.0, -83.0, 5.0, 11.0],
    "Cote D'Ivoire": [-9.0, -3.0, 4.0, 10.0],
    'Croatia': [13.0, 19.0, 42.0, 46.0],
    'Cuba': [-85.0, -75.0, 19.0, 23.0],
    'Cyprus': [32.0, 34.0, 34.0, 35.0],
    'Czech Republic': [12.0, 18.0, 48.0, 51.0],
    'Denmark': [8.0, 15.0, 54.0, 57.0],
    'Djibouti': [41.0, 43.0, 10.0, 12.0],
    'Dominica': [-62.0, -62.0, 15.0, 15.0],
    'Dominican Republic': [-73.0, -69.0, 17.0, 19.0],
    'Ecuador': [-93.0, -76.0, -5.0, 1.0],
    'Egypt': [24.0, 36.0, 21.0, 31.0],
    'El Salvador': [-91.0, -88.0, 13.0, 14.0],
    'Equatorial Guinea': [5.0, 11.0, -2.0, 3.0],
    'Eritrea': [36.0, 43.0, 12.0, 18.0],
    'Estonia': [21.0, 28.0, 57.0, 59.0],
    'Ethiopia': [32.0, 47.0, 3.0, 14.0],
    'Europa Island': [40.0, 40.0, -23.0, -23.0],
    'Europe': [-32.0, 69.0, 34.0, 81.0],
    'Falkland Islands (Islas Malvinas)': [-62.0, -58.0, -53.0, -52.0],
    'Faroe Islands': [-8.0, -7.0, 61.0, 62.0],
    'Federated States of Micronesia': [138.0, 163.0, 5.0, 11.0],
    'Fiji': [175.0, 182.0, -21.0, -13.0],
    'Finland': [19.0, 31.0, 59.0, 70.0],
    'France': [-6.0, 9.0, 41.0, 51.0],
    'French Guiana': [-55.0, -52.0, 2.0, 5.0],
    'French Polynesia': [-155.0, -135.0, -28.0, -8.0],
    'French Southern and Antarctic Lands': [50.0, 77.0, -51.0, -38.0],
    'Gabon': [8.0, 14.0, -4.0, 2.0],
    'Gaza Strip': [34.0, 34.0, 31.0, 31.0],
    'Georgia': [40.0, 46.0, 41.0, 43.0],
    'Germany': [5.0, 15.0, 47.0, 55.0],
    'Ghana': [-4.0, 1.0, 4.0, 11.0],
    'Gibraltar': [-6.0, -6.0, 36.0, 36.0],
    'Glorioso Islands': [47.0, 47.0, -12.0, -12.0],
    'Greece': [19.0, 29.0, 34.0, 41.0],
    'Greenland': [-74.0, -12.0, 59.0, 83.0],
    'Grenada': [-62.0, -62.0, 11.0, 12.0],
    'Guadeloupe': [-64.0, -61.0, 15.0, 18.0],
    'Guam': [144.0, 144.0, 13.0, 13.0],
    'Guatemala': [-93.0, -89.0, 13.0, 17.0],
    'Guernsey': [-3.0, -3.0, 49.0, 49.0],
    'Guinea': [-16.0, -8.0, 7.0, 12.0],
    'Guinea-Bissau': [-17.0, -14.0, 10.0, 12.0],
    'Guyana': [-62.0, -57.0, 1.0, 8.0],
    'Haiti': [-75.0, -72.0, 18.0, 20.0],
    'Heard Island and McDonald Islands': [72.0, 73.0, -54.0, -53.0],
    'Honduras': [-90.0, -84.0, 12.0, 17.0],
    'Hong Kong': [113.0, 114.0, 22.0, 22.0],
    'Howland Island': [-177.0, -177.0, 0.0, 0.0],
    'Hungary': [16.0, 22.0, 45.0, 48.0],
    'Iceland': [-25.0, -14.0, 63.0, 66.0],
    'India': [68.0, 97.0, 6.0, 35.0],
    'Indonesia': [95.0, 141.0, -12.0, 5.0],
    'Iran': [44.0, 63.0, 25.0, 39.0],
    'Iraq': [38.0, 48.0, 29.0, 37.0],
    'Ireland': [-11.0, -7.0, 51.0, 55.0],
    'Isle of Man': [-5.0, -5.0, 54.0, 54.0],
    'Israel': [34.0, 35.0, 29.0, 33.0],
    'Italy': [6.0, 18.0, 35.0, 47.0],
    'Jamaica': [-79.0, -77.0, 17.0, 18.0],
    'Jan Mayen': [-10.0, -8.0, 70.0, 71.0],
    'Japan': [122.0, 153.0, 24.0, 45.0],
    'Jarvis Island': [-161.0, -161.0, -1.0, -1.0],
    'Jersey': [-3.0, -3.0, 49.0, 49.0],
    'Johnston Atoll': [-170.0, -170.0, 16.0, 16.0],
    'Jordan': [34.0, 39.0, 29.0, 33.0],
    'Juan De Nova Island': [42.0, 42.0, -18.0, -18.0],
    'Kazakhstan': [46.0, 87.0, 40.0, 55.0],
    'Kenya': [33.0, 41.0, -5.0, 4.0],
    'Kingman Reef': [-163.0, -163.0, 6.0, 6.0],
    'Kiribati': [168.0, 210.0, -12.0, 4.0],
    'Kuwait': [46.0, 48.0, 28.0, 30.0],
    'Kyrgyzstan': [69.0, 80.0, 39.0, 43.0],
    'Laos': [100.0, 107.0, 13.0, 22.0],
    'Latvia': [20.0, 28.0, 55.0, 58.0],
    'Lebanon': [35.0, 36.0, 33.0, 34.0],
    'Lesotho': [27.0, 29.0, -31.0, -29.0],
    'Liberia': [-12.0, -8.0, 4.0, 8.0],
    'Libya': [9.0, 25.0, 19.0, 33.0],
    'Liechtenstein': [9.0, 9.0, 47.0, 47.0],
    'Lithuania': [20.0, 26.0, 53.0, 56.0],
    'Luxembourg': [5.0, 6.0, 49.0, 50.0],
    'Macau': [113.0, 113.0, 22.0, 22.0],
    'Madagascar': [43.0, 50.0, -26.0, -12.0],
    'Malawi': [32.0, 35.0, -18.0, -10.0],
    'Malaysia': [98.0, 119.0, 0.0, 7.0],
    'Maldives': [72.0, 73.0, -1.0, 7.0],
    'Mali': [-13.0, 4.0, 10.0, 25.0],
    'Malta': [14.0, 14.0, 35.0, 36.0],
    'Marshall Islands': [165.0, 172.0, 4.0, 14.0],
    'Martinique': [-62.0, -61.0, 14.0, 14.0],
    'Mauritania': [-18.0, -5.0, 14.0, 27.0],
    'Mauritius': [56.0, 63.0, -21.0, -11.0],
    'Mayotte': [45.0, 45.0, -14.0, -13.0],
    'Mexico': [-119.0, -87.0, 14.0, 32.0],
    'Midway Islands': [-179.0, -178.0, 28.0, 28.0],
    'Moldova': [26.0, 30.0, 45.0, 48.0],
    'Monaco': [7.0, 7.0, 43.0, 43.0],
    'Mongolia': [87.0, 119.0, 41.0, 52.0],
    'Montenegro': [18.0, 20.0, 41.0, 43.0],
    'Montserrat': [-63.0, -63.0, 16.0, 16.0],
    'Morocco': [-14.0, -1.0, 27.0, 35.0],
    'Mozambique': [30.0, 40.0, -27.0, -11.0],
    'Namibia': [11.0, 25.0, -29.0, -17.0],
    'Nauru': [166.0, 166.0, -1.0, -1.0],
    'Navassa Island': [-76.0, -75.0, 18.0, 18.0],
    'Nepal': [80.0, 88.0, 26.0, 30.0],
    'Netherlands': [3.0, 7.0, 50.0, 53.0],
    'Netherlands Antilles': [-70.0, -63.0, 11.0, 18.0],
    'New Caledonia': [158.0, 172.0, -23.0, -20.0],
    'New Zealand': [166.0, 185.0, -53.0, -30.0],
    'Nicaragua': [-88.0, -83.0, 10.0, 15.0],
    'Niger': [0.0, 15.0, 11.0, 23.0],
    'Nigeria': [2.0, 14.0, 4.0, 13.0],
    'Niue': [-170.0, -170.0, -20.0, -19.0],
    'Norfolk Island': [167.0, 168.0, -30.0, -29.0],
    'North America': [172.0, 349.0, 5.0, 83.0],
    'North Korea': [124.0, 130.0, 37.0, 43.0],
    'Northern Mariana Islands': [144.0, 146.0, 14.0, 20.0],
    'Norway': [4.0, 31.0, 57.0, 79.0],
    'Oman': [52.0, 59.0, 16.0, 26.0],
    'Other': [34.0, 43.0, 17.0, 31.0],
    'Pakistan': [60.0, 77.0, 23.0, 37.0],
    'Palau': [131.0, 134.0, 3.0, 8.0],
    'Palmyra Atoll': [-163.0, -163.0, 5.0, 5.0],
    'Panama': [-84.0, -78.0, 7.0, 9.0],
    'Papua New Guinea': [140.0, 159.0, -12.0, -1.0],
    'Paracel Islands': [111.0, 112.0, 15.0, 16.0],
    'Paraguay': [-63.0, -55.0, -28.0, -20.0],
    'Peru': [-82.0, -69.0, -19.0, -1.0],
    'Philippines': [116.0, 126.0, 4.0, 21.0],
    'Pitcairn Islands': [-131.0, -125.0, -26.0, -24.0],
    'Poland': [14.0, 24.0, 49.0, 54.0],
    'Portugal': [-32.0, -7.0, 30.0, 42.0],
    'Puerto Rico': [-68.0, -66.0, 17.0, 18.0],
    'Qatar': [50.0, 52.0, 24.0, 26.0],
    'Reunion': [55.0, 55.0, -22.0, -21.0],
    'Romania': [20.0, 29.0, 43.0, 48.0],
    'Russia': [18.0, 191.0, 41.0, 81.0],
    'Rwanda': [28.0, 30.0, -3.0, -2.0],
    'Saint Helena': [-15.0, -6.0, -41.0, -8.0],
    'Saint Kitts and Nevis': [-63.0, -63.0, 17.0, 17.0],
    'Saint Lucia': [-62.0, -61.0, 13.0, 14.0],
    'Saint Pierre and Miquelon': [-57.0, -57.0, 46.0, 47.0],
    'Saint Vincent and the Grenadines': [-62.0, -62.0, 12.0, 13.0],
    'Samoa': [-173.0, -172.0, -15.0, -14.0],
    'San Marino': [12.0, 12.0, 43.0, 43.0],
    'Sao Tome and Principe': [6.0, 7.0, -1.0, 1.0],
    'Saudi Arabia': [34.0, 55.0, 15.0, 32.0],
    'Senegal': [-18.0, -12.0, 12.0, 16.0],
    'Serbia': [18.0, 23.0, 41.0, 46.0],
    'Seychelles': [46.0, 56.0, -11.0, -4.0],
    'Sierra Leone': [-14.0, -11.0, 6.0, 10.0],
    'Singapore': [103.0, 104.0, 1.0, 1.0],
    'Slovakia': [16.0, 22.0, 47.0, 49.0],
    'Slovenia': [13.0, 16.0, 45.0, 46.0],
    'Solomon Islands': [155.0, 168.0, -13.0, -6.0],
    'Somalia': [40.0, 51.0, -2.0, 11.0],
    'South Africa': [16.0, 38.0, -47.0, -23.0],
    'South America': [-110.0, -29.0, -56.0, 13.0],
    'South Georgia and the South Sandwich Islands': [
        -42.0, -27.0, -60.0, -54.0],
    'South Korea': [124.0, 130.0, 33.0, 38.0],
    'Spain': [-19.0, 4.0, 27.0, 43.0],
    'Spratly Islands': [114.0, 115.0, 9.0, 11.0],
    'Sri Lanka': [79.0, 81.0, 5.0, 9.0],
    'Sudan': [21.0, 38.0, 3.0, 23.0],
    'Suriname': [-59.0, -54.0, 1.0, 6.0],
    'Svalbard': [10.0, 36.0, 74.0, 80.0],
    'Swaziland': [30.0, 32.0, -28.0, -26.0],
    'Sweden': [10.0, 24.0, 55.0, 69.0],
    'Switzerland': [5.0, 10.0, 45.0, 47.0],
    'Syria': [35.0, 42.0, 32.0, 37.0],
    'Taiwan': [116.0, 122.0, 20.0, 26.0],
    'Tajikistan': [67.0, 75.0, 36.0, 41.0],
    'Tanzania': [29.0, 40.0, -12.0, -1.0],
    'Thailand': [97.0, 105.0, 5.0, 20.0],
    'The Bahamas': [-81.0, -73.0, 20.0, 27.0],
    'The Former Yugoslav Republic of Macedonia': [20.0, 23.0, 40.0, 42.0],
    'The Gambia': [-17.0, -14.0, 13.0, 13.0],
    'Togo': [-1.0, 1.0, 6.0, 11.0],
    'Tokelau': [-173.0, -172.0, -10.0, -9.0],
    'Tonga': [-177.0, -174.0, -23.0, -16.0],
    'Trinidad and Tobago': [-62.0, -61.0, 10.0, 11.0],
    'Tromelin Island': [54.0, 54.0, -16.0, -16.0],
    'Tunisia': [7.0, 11.0, 30.0, 37.0],
    'Turkey': [25.0, 44.0, 35.0, 42.0],
    'Turkmenistan': [52.0, 66.0, 35.0, 42.0],
    'Turks and Caicas Islands': [-73.0, -72.0, 21.0, 21.0],
    'Tuvalu': [176.0, 179.0, -10.0, -6.0],
    'Uganda': [29.0, 35.0, -2.0, 4.0],
    'Ukraine': [22.0, 40.0, 44.0, 52.0],
    'United Arab Emirates': [51.0, 56.0, 22.0, 26.0],
    'United Kingdom': [-9.0, 33.0, 34.0, 60.0],
    'United States': [172.0, 294.0, 18.0, 71.0],
    'Uruguay': [-59.0, -54.0, -36.0, -31.0],
    'Uzbekistan': [55.0, 73.0, 37.0, 45.0],
    'Vanuatu': [166.0, 170.0, -21.0, -14.0],
    'Vatican City': [12.0, 12.0, 41.0, 41.0],
    'Venezuela': [-74.0, -60.0, 0.0, 12.0],
    'Vietnam': [102.0, 109.0, 8.0, 23.0],
    'Virgin Islands': [-66.0, -65.0, 17.0, 18.0],
    'Wake Island': [166.0, 166.0, 19.0, 19.0],
    'Wallis and Futuna': [-179.0, -177.0, -15.0, -14.0],
    'Western Sahara': [-18.0, -9.0, 20.0, 27.0],
    'Yemen': [41.0, 54.0, 12.0, 19.0],
    'Zambia': [21.0, 33.0, -19.0, -9.0],
    'Zimbabwe': [25.0, 33.0, -23.0, -16.0]
    }
