"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6 } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        const cfDist = this.distribution.node.findChild('CFDistribution');
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: assosiation.lambdaFunction.functionArn,
        })));
    }
}
exports.StaticWebsite = StaticWebsite;
//# sourceMappingURL=data:application/json;base64,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