PlanetaryPy
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

Potential
logo:![image.png](images/epilup_with_python_logo_with_axis.png)

## Install

``` bash
pip install planetarypy
```

This will pull in these other dependencies and their dependencies:

`tomlkit pandas pvl numpy python-dateutil tqdm lxml yarl hirise-tools kalasiris`

## Suggested standard abbreviations:

- Inside these docs the package will be called `PLPY` for brevity.
- A standard Python import could be: `plp` or `plpy`
  - because the last `p` in `plp` can be pronounced out, we consider
    these equivalent for human conversation and pronounce these
    “plippy”.

## General scope

First and foremost this package should provide support in working with
planetary science data.

With `working` we mean:

- locating
- retrieving
- reading
- further processing

of data.

### Locating

This library manages, via its `PDS tools`, multiple PDS3 index files per
instrument that can be used for identifying data of interest. These
index files are automatically downloaded and converted to the very
performant (and cloud-ready)
[parquet](https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.read_parquet.html)
file format. \> Parquet is able to store advanced datatypes like
nan-capable integer and full datetime objects, as opposed to HDF5.

### Retrieving

The interface to getting data is via a path-retrieving function based on
a PDS product-id. If that product-id is available locally, the path will
be returned. If it is not, it will previously be downloaded, stored in a
systematic fashion organized by mission and instrument, and then the
local path will be returned.

### Reading

For now, the library only returns the path to the object and the user
needs to sort out the reading process. A recently funded NASA project
`Planetary Data Reader` will be integrated here, so that basic reading
into memory can be provided.

As such, we anticipate two classes of reading support: 1. basic reading
into numpy and/or xarray 1. added reader functionality like basic plots
and basic geospatial processing, as supported by interested parties

There will exist larger other packages that focus on working with a
given instrument’s data, in which case that package could become an
affiliated package with the `planetarypy` GitHub organization, if so
desired.

### Further processing

In the future, additional frequently used procedures will be added to
this library, e.g. \* frequently used GDAL/rasterio procedures \*
frequently used SPICE operations \* like surface illumination on a given
body

## PDS tools

Look at the `Apps` docs to see what `pds.apps` exist for easily getting
PDS indexes. The `find_index` app is specifically useful when you don’t
know what index files exist.

So far, the following indexes are supported (but not necessarily all
tested within PLPY):

- Cassini
  - ISS (all)
  - UVIS (all)
- MRO
  - CTX EDR
  - HiRISE
    - EDR, RDR, DTM
      - EDR index has a bug (as delivered by the team, reported), where
        I need to activate an existing fix for it.
- LRO
  - Diviner (DLRE)
    - EDR, RDR
  - LOLA
    - EDR, RDR

### More indexes

More indexes of other instruments can be easily added by following the
existing structure of what has been copied into your config at
`~/.planetarypy_config.toml`.

Please consider submitting a pull request for adding further PDS index
files into the config file at its source:
https://github.com/michaelaye/nbplanetary/blob/master/planetarypy/data/planetarypy_config.toml

## Utils

Find something in `Utils` for working with NASA timestamps and a well
working URL download function
[`url_retrieve`](https://michaelaye.github.io/planetarypy/api/utils.html#url_retrieve),
among other stuff.

## Experiment/Instrument Specific

So far, `planetarypy` supports CTX EDR and HiRISE RGB.NOMAP data. Look
at the
[`CTX`](https://michaelaye.github.io/planetarypy/api/ctx.html#ctx) and
`HiRISE` pages for descriptions of classes for working with these data.

## Bug reports

Please submit bug reports at
https://github.com/michaelaye/nbplanetary/issues

## How to use

### Indexes

See [PDS apps](api/02c_pds.apps.ipynb) for more details.

``` python
from planetarypy.pds.apps import get_index
```

``` python
ctrindex = get_index("mro.ctx", "edr")
ctrindex.sample(5, random_state=42)  # setting random_state to always get same files for docs
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>VOLUME_ID</th>
      <th>FILE_SPECIFICATION_NAME</th>
      <th>ORIGINAL_PRODUCT_ID</th>
      <th>PRODUCT_ID</th>
      <th>IMAGE_TIME</th>
      <th>INSTRUMENT_ID</th>
      <th>INSTRUMENT_MODE_ID</th>
      <th>LINE_SAMPLES</th>
      <th>LINES</th>
      <th>SPATIAL_SUMMING</th>
      <th>...</th>
      <th>SUB_SOLAR_LATITUDE</th>
      <th>SUB_SPACECRAFT_LONGITUDE</th>
      <th>SUB_SPACECRAFT_LATITUDE</th>
      <th>SOLAR_DISTANCE</th>
      <th>SOLAR_LONGITUDE</th>
      <th>LOCAL_TIME</th>
      <th>IMAGE_SKEW_ANGLE</th>
      <th>RATIONALE_DESC</th>
      <th>DATA_QUALITY_DESC</th>
      <th>ORBIT_NUMBER</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>102927</th>
      <td>MROX_3290</td>
      <td>DATA/K09_056855_1472_XN_32S152W.IMG</td>
      <td>4A_04_112001B600</td>
      <td>K09_056855_1472_XN_32S152W</td>
      <td>2018-09-12 15:27:23.819</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>5056</td>
      <td>7168</td>
      <td>1</td>
      <td>...</td>
      <td>-23.61</td>
      <td>152.16</td>
      <td>-32.84</td>
      <td>206674590.7</td>
      <td>248.70</td>
      <td>15.12</td>
      <td>90.1</td>
      <td>Ride-along with HiRISE</td>
      <td>OK</td>
      <td>56855</td>
    </tr>
    <tr>
      <th>116952</th>
      <td>MROX_3714</td>
      <td>DATA/N08_065442_0965_XN_83S191W.IMG</td>
      <td>4A_04_114C019800</td>
      <td>N08_065442_0965_XN_83S191W</td>
      <td>2020-07-12 17:31:23.962</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>5056</td>
      <td>33792</td>
      <td>1</td>
      <td>...</td>
      <td>-21.24</td>
      <td>190.23</td>
      <td>-83.51</td>
      <td>207154930.4</td>
      <td>237.37</td>
      <td>17.12</td>
      <td>91.4</td>
      <td>Planum Australe</td>
      <td>OK</td>
      <td>65442</td>
    </tr>
    <tr>
      <th>16386</th>
      <td>MROX_0690</td>
      <td>DATA/B01_010083_2567_XI_76N181W.IMG</td>
      <td>4A_04_103101E100</td>
      <td>B01_010083_2567_XI_76N181W</td>
      <td>2008-09-20 04:33:05.584</td>
      <td>CTX</td>
      <td>ITL</td>
      <td>5056</td>
      <td>52224</td>
      <td>1</td>
      <td>...</td>
      <td>19.30</td>
      <td>180.80</td>
      <td>76.84</td>
      <td>237461101.1</td>
      <td>129.80</td>
      <td>14.76</td>
      <td>89.7</td>
      <td>North polar outlier</td>
      <td>OK</td>
      <td>10083</td>
    </tr>
    <tr>
      <th>107515</th>
      <td>MROX_3450</td>
      <td>DATA/K15_059059_1434_XN_36S196W.IMG</td>
      <td>4A_04_112C004300</td>
      <td>K15_059059_1434_XN_36S196W</td>
      <td>2019-03-03 08:44:14.027</td>
      <td>CTX</td>
      <td>NIFL</td>
      <td>2528</td>
      <td>9216</td>
      <td>1</td>
      <td>...</td>
      <td>-4.38</td>
      <td>196.66</td>
      <td>-36.69</td>
      <td>229158765.3</td>
      <td>349.79</td>
      <td>14.21</td>
      <td>90.1</td>
      <td>Craters in Terra Cimmeria</td>
      <td>OK</td>
      <td>59059</td>
    </tr>
    <tr>
      <th>57288</th>
      <td>MROX_1890</td>
      <td>DATA/D16_033513_1653_XI_14S108W.IMG</td>
      <td>4A_04_10A9016F00</td>
      <td>D16_033513_1653_XI_14S108W</td>
      <td>2013-09-19 20:45:34.363</td>
      <td>CTX</td>
      <td>ITL</td>
      <td>5056</td>
      <td>15360</td>
      <td>1</td>
      <td>...</td>
      <td>10.17</td>
      <td>108.53</td>
      <td>-14.83</td>
      <td>241359283.4</td>
      <td>24.21</td>
      <td>14.66</td>
      <td>90.2</td>
      <td>Syria/Claritas dust-raising event monitoring site</td>
      <td>OK</td>
      <td>33513</td>
    </tr>
  </tbody>
</table>
<p>5 rows × 51 columns</p>
</div>

``` python
hirise_rdr = get_index("mro.hirise", "rdr")
hirise_rdr.sample(5, random_state=42)
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>VOLUME_ID</th>
      <th>FILE_NAME_SPECIFICATION</th>
      <th>INSTRUMENT_HOST_ID</th>
      <th>INSTRUMENT_ID</th>
      <th>OBSERVATION_ID</th>
      <th>PRODUCT_ID</th>
      <th>PRODUCT_VERSION_ID</th>
      <th>TARGET_NAME</th>
      <th>ORBIT_NUMBER</th>
      <th>MISSION_PHASE_NAME</th>
      <th>...</th>
      <th>LINE_PROJECTION_OFFSET</th>
      <th>SAMPLE_PROJECTION_OFFSET</th>
      <th>CORNER1_LATITUDE</th>
      <th>CORNER1_LONGITUDE</th>
      <th>CORNER2_LATITUDE</th>
      <th>CORNER2_LONGITUDE</th>
      <th>CORNER3_LATITUDE</th>
      <th>CORNER3_LONGITUDE</th>
      <th>CORNER4_LATITUDE</th>
      <th>CORNER4_LONGITUDE</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>95782</th>
      <td>MROHR_0001</td>
      <td>RDR/ESP/ORB_049400_049499/ESP_049456_0945/ESP_...</td>
      <td>MRO</td>
      <td>HIRISE</td>
      <td>ESP_049456_0945</td>
      <td>ESP_049456_0945_COLOR</td>
      <td>1</td>
      <td>MARS</td>
      <td>49456</td>
      <td>Extended Science Phase</td>
      <td>...</td>
      <td>289555.5</td>
      <td>1014477.5</td>
      <td>-85.6701</td>
      <td>286.4690</td>
      <td>-85.6815</td>
      <td>286.3020</td>
      <td>-85.5562</td>
      <td>284.8560</td>
      <td>-85.5452</td>
      <td>285.0210</td>
    </tr>
    <tr>
      <th>142902</th>
      <td>MROHR_0001</td>
      <td>RDR/ESP/ORB_072700_072799/ESP_072755_2030/ESP_...</td>
      <td>MRO</td>
      <td>HIRISE</td>
      <td>ESP_072755_2030</td>
      <td>ESP_072755_2030_RED</td>
      <td>1</td>
      <td>MARS</td>
      <td>72755</td>
      <td>Extended Science Phase</td>
      <td>...</td>
      <td>5448057.5</td>
      <td>-36148404.0</td>
      <td>22.8511</td>
      <td>342.4710</td>
      <td>22.8408</td>
      <td>342.3770</td>
      <td>22.9836</td>
      <td>342.3590</td>
      <td>22.9940</td>
      <td>342.4520</td>
    </tr>
    <tr>
      <th>114241</th>
      <td>MROHR_0001</td>
      <td>RDR/ESP/ORB_057400_057499/ESP_057400_1150/ESP_...</td>
      <td>MRO</td>
      <td>HIRISE</td>
      <td>ESP_057400_1150</td>
      <td>ESP_057400_1150_RED</td>
      <td>1</td>
      <td>MARS</td>
      <td>57400</td>
      <td>Extended Science Phase</td>
      <td>...</td>
      <td>-15324106.0</td>
      <td>9551808.0</td>
      <td>-65.0631</td>
      <td>99.2951</td>
      <td>-65.0739</td>
      <td>99.1184</td>
      <td>-64.9297</td>
      <td>99.0696</td>
      <td>-64.9190</td>
      <td>99.2454</td>
    </tr>
    <tr>
      <th>260</th>
      <td>MROHR_0001</td>
      <td>RDR/PSP/ORB_001300_001399/PSP_001390_2290/PSP_...</td>
      <td>MRO</td>
      <td>HIRISE</td>
      <td>PSP_001390_2290</td>
      <td>PSP_001390_2290_RED</td>
      <td>2</td>
      <td>MARS</td>
      <td>1390</td>
      <td>Primary Science Phase</td>
      <td>...</td>
      <td>11574100.0</td>
      <td>-17349000.0</td>
      <td>48.8086</td>
      <td>283.9690</td>
      <td>48.7969</td>
      <td>283.8150</td>
      <td>48.9486</td>
      <td>283.7880</td>
      <td>48.9603</td>
      <td>283.9430</td>
    </tr>
    <tr>
      <th>148555</th>
      <td>MROHR_0001</td>
      <td>RDR/ESP/ORB_075600_075699/ESP_075617_0955/ESP_...</td>
      <td>MRO</td>
      <td>HIRISE</td>
      <td>ESP_075617_0955</td>
      <td>ESP_075617_0955_RED</td>
      <td>1</td>
      <td>MARS</td>
      <td>75617</td>
      <td>Extended Science Phase</td>
      <td>...</td>
      <td>1299053.5</td>
      <td>-203581.5</td>
      <td>-84.5200</td>
      <td>10.3353</td>
      <td>-84.5620</td>
      <td>9.6666</td>
      <td>-84.4557</td>
      <td>8.9553</td>
      <td>-84.4145</td>
      <td>9.6167</td>
    </tr>
  </tbody>
</table>
<p>5 rows × 54 columns</p>
</div>

## Instrument tools

### CTX

``` python
from planetarypy.ctx import CTX
```

    Unable to display output for mime type(s): application/javascript, application/vnd.holoviews_load.v0+json

    Unable to display output for mime type(s): application/javascript, application/vnd.holoviews_load.v0+json

<style>.bk-root, .bk-root .bk:before, .bk-root .bk:after {
  font-family: var(--jp-ui-font-size1);
  font-size: var(--jp-ui-font-size1);
  color: var(--jp-ui-font-color1);
}
</style>

``` python
pid = ctrindex.sample(random_state=42).squeeze().PRODUCT_ID
pid
```

    'K09_056855_1472_XN_32S152W'

``` python
ctx = CTX(pid)
ctx
```

    PRODUCT_ID: K09_056855_1472_XN_32S152W
    URL: https://pds-imaging.jpl.nasa.gov/data/mro/mars_reconnaissance_orbiter/ctx/mrox_3290/data/K09_056855_1472_XN_32S152W.IMG
    source_path: /home/ayek72/mnt/troveplanets/pds/mrox_3290/K09_056855_1472_XN_32S152W.IMG
    Shape: (7168, 5056)

``` python
ctx.source_path
```

    Path('/home/ayek72/mnt/troveplanets/pds/mrox_3290/K09_056855_1472_XN_32S152W.IMG')

``` python
ctx.download()
```

    File exists. Use `overwrite=True` to download fresh.

## Acknowledgements

The creation of this library was in part supported by:

- NASA Cassini UVIS mission
- NASA SSW grant NNX15AH36G
- NASA PDART grant 80NSSC20K0875
- NASA SSW grant 80NSSC20K0748
- German Space Agency (DLR Bonn), grant 50 OO 2204, on behalf of the
  German Federal Ministry for Economic Affairs and Climate Action.
- This research has made use of the USGS Integrated Software for Imagers
  and Spectrometers (ISIS)(Laura et al. 2022).

<div id="refs" class="references csl-bib-body hanging-indent">

<div id="ref-laura_jason_2022_7443567" class="csl-entry">

Laura, Jason, Alex Acosta, Travis Addair, Lauren Adoram-Kershner, James
Alexander, Oleg Alexandrov, Stacey Alley, et al. 2022. *Integrated
Software for Imagers and Spectrometers* (version 7.2.0_RC1). Zenodo.
<https://doi.org/10.5281/zenodo.7443567>.

</div>

</div>
