import json


def format_json(data):
    return json.dumps(data, indent=2, sort_keys=True)

from collections import namedtuple


# Code by runfalk
# https://github.com/runfalk/loopialib/blob/master/loopialib/utils.py
DomainParts = namedtuple("SplitDomain", ["domain", "subdomain"])

#: Lookup table for second level domains
_sld = {
    'ac': frozenset("com gov mil net org".split(" ")),
    'ae': frozenset("ac co gov mil name net org pro sch".split(" ")),
    'af': frozenset("com edu gov net org".split(" ")),
    'al': frozenset("com edu gov mil net org".split(" ")),
    'ao': frozenset("co ed gv it og pb".split(" ")),
    'ar': frozenset("com edu gob gov int mil net org tur".split(" ")),
    'at': frozenset("ac co gv or".split(" ")),
    'au': frozenset("asn com csiro edu gov id net org".split(" ")),
    'ba': frozenset("co com edu gov mil net org rs unbi unmo unsa untz unze".split(" ")),
    'bb': frozenset("biz co com edu gov info net org store tv".split(" ")),
    'bh': frozenset("biz cc com edu gov info net org".split(" ")),
    'bn': frozenset("com edu gov net org".split(" ")),
    'bo': frozenset("com edu gob gov int mil net org tv".split(" ")),
    'br': frozenset("adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg".split(" ")),
    'bs': frozenset("com edu gov net org".split(" ")),
    'bz': frozenset("du et om ov rg".split(" ")),
    'ca': frozenset("ab bc mb nb nf nl ns nt nu on pe qc sk yk".split(" ")),
    'ck': frozenset("biz co edu gen gov info net org".split(" ")),
    'cn': frozenset("ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj".split(" ")),
    'co': frozenset("com edu gov mil net nom org".split(" ")),
    'cr': frozenset("ac c co ed fi go or sa".split(" ")),
    'cy': frozenset("ac biz com ekloges gov ltd name net org parliament press pro tm".split(" ")),
    'do': frozenset("art com edu gob gov mil net org sld web".split(" ")),
    'dz': frozenset("art asso com edu gov net org pol".split(" ")),
    'ec': frozenset("com edu fin gov info med mil net org pro".split(" ")),
    'eg': frozenset("com edu eun gov mil name net org sci".split(" ")),
    'er': frozenset("com edu gov ind mil net org rochest w".split(" ")),
    'es': frozenset("com edu gob nom org".split(" ")),
    'et': frozenset("biz com edu gov info name net org".split(" ")),
    'fj': frozenset("ac biz com info mil name net org pro".split(" ")),
    'fk': frozenset("ac co gov net nom org".split(" ")),
    'fr': frozenset("asso com f gouv nom prd presse tm".split(" ")),
    'gg': frozenset("co net org".split(" ")),
    'gh': frozenset("com edu gov mil org".split(" ")),
    'gn': frozenset("ac com gov net org".split(" ")),
    'gr': frozenset("com edu gov mil net org".split(" ")),
    'gt': frozenset("com edu gob ind mil net org".split(" ")),
    'gu': frozenset("com edu gov net org".split(" ")),
    'hk': frozenset("com edu gov idv net org".split(" ")),
    'hu': frozenset("2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video".split(" ")),
    'id': frozenset("ac co go mil net or sch web".split(" ")),
    'il': frozenset("ac co gov idf k12 muni net org".split(" ")),
    'in': frozenset("ac co edu ernet firm gen gov i ind mil net nic org res".split(" ")),
    'iq': frozenset("com edu gov i mil net org".split(" ")),
    'ir': frozenset("ac co dnssec gov i id net org sch".split(" ")),
    'it': frozenset("edu gov".split(" ")),
    'je': frozenset("co net org".split(" ")),
    'jo': frozenset("com edu gov mil name net org sch".split(" ")),
    'jp': frozenset("ac ad co ed go gr lg ne or".split(" ")),
    'ke': frozenset("ac co go info me mobi ne or sc".split(" ")),
    'kh': frozenset("com edu gov mil net org per".split(" ")),
    'ki': frozenset("biz com de edu gov info mob net org tel".split(" ")),
    'km': frozenset("asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire".split(" ")),
    'kn': frozenset("edu gov net org".split(" ")),
    'kr': frozenset("ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan".split(" ")),
    'kw': frozenset("com edu gov net org".split(" ")),
    'ky': frozenset("com edu gov net org".split(" ")),
    'kz': frozenset("com edu gov mil net org".split(" ")),
    'lb': frozenset("com edu gov net org".split(" ")),
    'lk': frozenset("assn com edu gov grp hotel int ltd net ngo org sch soc web".split(" ")),
    'lr': frozenset("com edu gov net org".split(" ")),
    'lv': frozenset("asn com conf edu gov id mil net org".split(" ")),
    'ly': frozenset("com edu gov id med net org plc sch".split(" ")),
    'ma': frozenset("ac co gov m net org press".split(" ")),
    'mc': frozenset("asso tm".split(" ")),
    'me': frozenset("ac co edu gov its net org priv".split(" ")),
    'mg': frozenset("com edu gov mil nom org prd tm".split(" ")),
    'mk': frozenset("com edu gov inf name net org pro".split(" ")),
    'ml': frozenset("com edu gov net org presse".split(" ")),
    'mn': frozenset("edu gov org".split(" ")),
    'mo': frozenset("com edu gov net org".split(" ")),
    'mt': frozenset("com edu gov net org".split(" ")),
    'mv': frozenset("aero biz com coop edu gov info int mil museum name net org pro".split(" ")),
    'mw': frozenset("ac co com coop edu gov int museum net org".split(" ")),
    'mx': frozenset("com edu gob net org".split(" ")),
    'my': frozenset("com edu gov mil name net org sch".split(" ")),
    'nf': frozenset("arts com firm info net other per rec store web".split(" ")),
    'ng': frozenset("biz com edu gov mil mobi name net org sch".split(" ")),
    'ni': frozenset("ac co com edu gob mil net nom org".split(" ")),
    'np': frozenset("com edu gov mil net org".split(" ")),
    'nr': frozenset("biz com edu gov info net org".split(" ")),
    'om': frozenset("ac biz co com edu gov med mil museum net org pro sch".split(" ")),
    'pe': frozenset("com edu gob mil net nom org sld".split(" ")),
    'ph': frozenset("com edu gov i mil net ngo org".split(" ")),
    'pk': frozenset("biz com edu fam gob gok gon gop gos gov net org web".split(" ")),
    'pl': frozenset("art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora".split(" ")),
    'pr': frozenset("ac biz com edu est gov info isla name net org pro prof".split(" ")),
    'ps': frozenset("com edu gov net org plo sec".split(" ")),
    'pw': frozenset("belau co ed go ne or".split(" ")),
    'ro': frozenset("arts com firm info nom nt org rec store tm www".split(" ")),
    'rs': frozenset("ac co edu gov in org".split(" ")),
    'sb': frozenset("com edu gov net org".split(" ")),
    'sc': frozenset("com edu gov net org".split(" ")),
    'sh': frozenset("co com edu gov net nom org".split(" ")),
    'sl': frozenset("com edu gov net org".split(" ")),
    'st': frozenset("co com consulado edu embaixada gov mil net org principe saotome store".split(" ")),
    'sv': frozenset("com edu gob org red".split(" ")),
    'sz': frozenset("ac co org".split(" ")),
    'tr': frozenset("av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web".split(" ")),
    'tt': frozenset("aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel".split(" ")),
    'tw': frozenset("club com ebiz edu game gov idv mil net org".split(" ")),
    'mu': frozenset("ac co com gov net or org".split(" ")),
    'mz': frozenset("ac co edu gov org".split(" ")),
    'na': frozenset("co com".split(" ")),
    'nz': frozenset("ac co cri geek gen govt health iwi maori mil net org parliament school".split(" ")),
    'pa': frozenset("abo ac com edu gob ing med net nom org sld".split(" ")),
    'pt': frozenset("com edu gov int net nome org publ".split(" ")),
    'py': frozenset("com edu gov mil net org".split(" ")),
    'qa': frozenset("com edu gov mil net org".split(" ")),
    're': frozenset("asso com nom".split(" ")),
    'ru': frozenset("ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk".split(" ")),
    'rw': frozenset("ac co com edu gouv gov int mil net".split(" ")),
    'sa': frozenset("com edu gov med net org pub sch".split(" ")),
    'sd': frozenset("com edu gov info med net org tv".split(" ")),
    'se': frozenset("a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z".split(" ")),
    'sg': frozenset("com edu gov idn net org per".split(" ")),
    'sn': frozenset("art com edu gouv org perso univ".split(" ")),
    'sy': frozenset("com edu gov mil net news org".split(" ")),
    'th': frozenset("ac co go in mi net or".split(" ")),
    'tj': frozenset("ac biz co com edu go gov info int mil name net nic org test web".split(" ")),
    'tn': frozenset("agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism".split(" ")),
    'tz': frozenset("ac co go ne or".split(" ")),
    'ua': frozenset("biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt".split(" ")),
    'ug': frozenset("ac co go ne or org sc".split(" ")),
    'uk': frozenset("ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc".split(" ")),
    'us': frozenset("dni fed isa kids nsn".split(" ")),
    'uy': frozenset("com edu gub mil net org".split(" ")),
    've': frozenset("co com edu gob info mil net org web".split(" ")),
    'vi': frozenset("co com k12 net org".split(" ")),
    'vn': frozenset("ac biz com edu gov health info int name net org pro".split(" ")),
    'ye': frozenset("co com gov ltd me net org plc".split(" ")),
    'yu': frozenset("ac co edu gov org".split(" ")),
    'za': frozenset("ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web".split(" ")),
    'zm': frozenset("ac co com edu gov net org sch".split(" ")),
    'com': frozenset("ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za".split(" ")),
    'net': frozenset("gb jp se uk".split(" ")),
    'org': frozenset("ae".split(" ")),
    'de': frozenset("com".split(" ")),
}


def split_domain(domain):
    parts = domain.split(".")

    # Supports domains with SLD such as .co.uk
    domain_parts = 2
    if parts[-1] in _sld and len(parts) >= 2 and parts[-2] in _sld[parts[-1]]:
        domain_parts = 3

    return DomainParts(
        domain=".".join(parts[-domain_parts:]),
        subdomain=".".join(parts[:-domain_parts]) or None,
    )

if __name__ == "__main__":
    print(split_domain("internal.egeback.se").domain)