"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
const DEFAULT_STAGE_NAME = '$default';
class HttpStageBase extends base_1.StageBase {
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
}
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends HttpStageBase {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
            defaultRouteSettings: !props.throttle ? undefined : {
                throttlingBurstLimit: (_b = props.throttle) === null || _b === void 0 ? void 0 : _b.burstLimit,
                throttlingRateLimit: (_c = props.throttle) === null || _c === void 0 ? void 0 : _c.rateLimit,
            },
        });
        this.stageName = this.physicalName;
        this.baseApi = props.httpApi;
        this.api = props.httpApi;
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromHttpStageAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpStageAttributes);
            }
            throw error;
        }
        class Import extends HttpStageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get domainUrl() {
                throw new Error('domainUrl is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * The URL to this stage.
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    get domainUrl() {
        var _b;
        if (!this._apiMapping) {
            throw new Error('domainUrl is not available when no API mapping is associated with the Stage');
        }
        return `https://${this._apiMapping.domainName.name}/${(_b = this._apiMapping.mappingKey) !== null && _b !== void 0 ? _b : ''}`;
    }
}
exports.HttpStage = HttpStage;
_a = JSII_RTTI_SYMBOL_1;
HttpStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpStage", version: "2.26.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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