"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainName = exports.EndpointType = exports.SecurityPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 */
var SecurityPolicy;
(function (SecurityPolicy) {
    /** Cipher suite TLS 1.0 */
    SecurityPolicy["TLS_1_0"] = "TLS_1_0";
    /** Cipher suite TLS 1.2 */
    SecurityPolicy["TLS_1_2"] = "TLS_1_2";
})(SecurityPolicy = exports.SecurityPolicy || (exports.SecurityPolicy = {}));
/**
 * Endpoint type for a domain name.
 */
var EndpointType;
(function (EndpointType) {
    /**
     * For an edge-optimized custom domain name.
     */
    EndpointType["EDGE"] = "EDGE";
    /**
     * For a regional custom domain name.
     */
    EndpointType["REGIONAL"] = "REGIONAL";
})(EndpointType = exports.EndpointType || (exports.EndpointType = {}));
/**
 * Custom domain resource for the API
 */
class DomainName extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.domainNameConfigurations = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_DomainNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.domainName === '') {
            throw new Error('empty string for domainName not allowed');
        }
        // validation for ownership certificate
        if (props.ownershipCertificate && !props.mtls) {
            throw new Error('ownership certificate can only be used with mtls domains');
        }
        const mtlsConfig = this.configureMTLS(props.mtls);
        const domainNameProps = {
            domainName: props.domainName,
            domainNameConfigurations: aws_cdk_lib_1.Lazy.any({ produce: () => this.domainNameConfigurations }),
            mutualTlsAuthentication: mtlsConfig,
        };
        const resource = new aws_apigatewayv2_1.CfnDomainName(this, 'Resource', domainNameProps);
        this.name = resource.ref;
        this.regionalDomainName = aws_cdk_lib_1.Token.asString(resource.getAtt('RegionalDomainName'));
        this.regionalHostedZoneId = aws_cdk_lib_1.Token.asString(resource.getAtt('RegionalHostedZoneId'));
        if (props.certificate) {
            this.addEndpoint(props);
        }
    }
    /**
     * Import from attributes
     */
    static fromDomainNameAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_DomainNameAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDomainNameAttributes);
            }
            throw error;
        }
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.regionalDomainName = attrs.regionalDomainName;
                this.regionalHostedZoneId = attrs.regionalHostedZoneId;
                this.name = attrs.name;
            }
        }
        return new Import(scope, id);
    }
    configureMTLS(mtlsConfig) {
        if (!mtlsConfig)
            return undefined;
        return {
            truststoreUri: mtlsConfig.bucket.s3UrlForObject(mtlsConfig.key),
            truststoreVersion: mtlsConfig.version,
        };
    }
    /**
     * Adds an endpoint to a domain name.
     * @param options domain name endpoint properties to be set
     */
    addEndpoint(options) {
        var _b, _c, _d;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_EndpointOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEndpoint);
            }
            throw error;
        }
        const domainNameConfig = {
            certificateArn: options.certificate.certificateArn,
            certificateName: options.certificateName,
            endpointType: options.endpointType ? (_b = options.endpointType) === null || _b === void 0 ? void 0 : _b.toString() : 'REGIONAL',
            ownershipVerificationCertificateArn: (_c = options.ownershipCertificate) === null || _c === void 0 ? void 0 : _c.certificateArn,
            securityPolicy: (_d = options.securityPolicy) === null || _d === void 0 ? void 0 : _d.toString(),
        };
        this.validateEndpointType(domainNameConfig.endpointType);
        this.domainNameConfigurations.push(domainNameConfig);
    }
    // validates that the new domain name configuration has a unique endpoint
    validateEndpointType(endpointType) {
        for (let config of this.domainNameConfigurations) {
            if (endpointType && endpointType == config.endpointType) {
                throw new Error(`an endpoint with type ${endpointType} already exists`);
            }
        }
    }
}
exports.DomainName = DomainName;
_a = JSII_RTTI_SYMBOL_1;
DomainName[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.DomainName", version: "2.26.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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