# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['prometheus_ecs_discoverer']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.14.23,<2.0.0',
 'dynaconf>=3.0.0,<4.0.0',
 'loguru>=0.5.1,<0.6.0',
 'prettyprinter>=0.18.0,<0.19.0',
 'prometheus-client>=0.8.0,<0.9.0']

setup_kwargs = {
    'name': 'prometheus-ecs-discoverer',
    'version': '2.0.1',
    'description': 'Prometheus Service Discovery for AWS ECS',
    'long_description': '# Prometheus ECS Discoverer\n\n[![PyPI version](https://badge.fury.io/py/prometheus-ecs-discoverer.svg)](https://pypi.python.org/pypi/prometheus-ecs-discoverer/)\n[![Maintenance](https://img.shields.io/badge/maintained%3F-yes-green.svg)](https://GitHub.com/Naereen/StrapDown.js/graphs/commit-activity)\n[![downloads](https://img.shields.io/pypi/dm/prometheus-ecs-discoverer)](https://pypi.org/project/prometheus-ecs-discoverer/)\n\n![release](https://github.com/trallnag/prometheus-ecs-discoverer/workflows/release/badge.svg)\n![test branches](https://github.com/trallnag/prometheus-ecs-discoverer/workflows/test%20branches/badge.svg)\n[![codecov](https://codecov.io/gh/trallnag/prometheus-ecs-discoverer/branch/master/graph/badge.svg)](https://codecov.io/gh/trallnag/prometheus-ecs-discoverer)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\nBased on [prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), \nthis project enables your Prometheus to **dynamically scrape targets** deployed \nin AWS ECS. The discoverer is perfect if you don\'t have \na service discovery system like Consul in-place. It provides an easy-to-use \nalternative and can be used in low- to mid-sized environments with **hundreds \nof tasks** running in parallel.\n\nOnce the discoverer is up and running, any task can be made visible to \nPrometheus.\n\n![diagram](https://raw.githubusercontent.com/trallnag/prometheus-ecs-discoverer/master/documents/drawio-diagram.png)\n\nWhat are the advantages of using this project over [prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd\n)?\n\n* Modified throttling allows the usage in environments with hundreds of \n    tasks.\n* Every target can expose custom labels via its environment variables.\n* Deploy as container (provided and can be used directly) or Python package.\n* Instrumented with Prometheus. Allows more insights into the discoverer.\n* Extensive testing with high coverage ensures functionality.\n* Works out of the box with being deployed in a container.\n* More configuration options.\n\n---\n\nContents: **[Setup](#setup)** | **[Configuration](#configuration)** |\n[Prepare targets](#perpare-targets) | [Deploy PromED](#deploy-promed)\n\n---\n\n## Setup\n\nAs this project is based on \n[prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), the setup \nis very similar / exactly the same.\n\n### Prepare targets\n\nTargets are setup via setting environment variables in the task definitions.\n\n#### Mark container as target\n\nSet `PROMETHEUS` to any value to make PromED consider the container. This \nby itself is already enough to make it work with the configured defaults.\n\n```json\n{ "name": "PROMETHEUS", "value": "does not matter" },\n```\n\n#### Specify metrics endpoint(s)\n\nIf your metrics are not exposed on the default `/metrics` endpoint, you can \nspecifiy the endpoint like so:\n\n```json\n{ "name": "PROMETHEUS_ENDPOINT", "value": "/custom/metrics" },\n```\n\nYou can also declare multiple endpoints and different intervals. The supported \nintervals are `15s`, `30s`, `1m` and `5m`. Based on the interval targets will \nend up in different files. The default interval is "generic". Examples for this:\n\n```json\n{ "name": "PROMETHEUS_ENDPOINT", "value": "5m:/mymetrics,30s:/mymetrics2"},\n{ "name": "PROMETHEUS_ENDPOINT", "value": "/mymetrics"},\n{ "name": "PROMETHEUS_ENDPOINT", "value": "/mymetrics,30s:/mymetrics2"},\n```\n\n#### Set custom labels for container\n\nSometimes you might want to add additonal labels to targets to group them. \nFor example by the used API type (REST vs. GraphQL). This can be done by adding \nenvironment variables to the container definition in the respective task \ndefinition with the  `PROMETHEUS_LABEL_` prefix. Environment variables set\nfrom within the container are not visible to PromED and are ignored.\n\n```json\n{ "name": "PROMETHEUS_LABEL_api_type", "value": "GraphQL" },\n{ "name": "PROMETHEUS_LABEL_foo", "value": "bar" },\n``` \n\n#### Customize networking\n\nRegarding networking, all network modes are supported (`bridge`, `host` \nand `awsvpc`).\n\n> If `PROMETHEUS_PORT` and `PROMETHEUS_CONTAINER_PORT` are not set, the script \n> will pick the first port from the container definition (in awsvpc and host \n> network mode) or the container host network bindings in bridge mode. On \n> Fargate, if `PROMETHEUS_PORT` is not set, it will default to port `80`.\n> \n> If `PROMETHEUS_CONTAINER_PORT` is set, it will look at the container host \n> network bindings, and find the entry with a matching `containerPort`. It will \n> then use the `hostPort` found there as target port. This is useful when the \n> container port is known, but the `hostPort` is randomly picked by ECS (by \n> setting `hostPort` to `0` in the task definition).\n> \n> If your container uses multiple ports, it\'s recommended to specify \n> `PROMETHEUS_PORT` (`awsvpc`, `host`) or `PROMETHEUS_CONTAINER_PORT` (`bridge`).\n\nQuoted from [prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd) \ncommit `ece6ca2`.\n\n### Deploy PromED\n\nYou can either use the Python package directly or go for the Docker image. \nPlease note that just running the package / image is not enough. The enviornment\nmust be ready for boto3. This includes credentials and approbiate rights.\n\n#### Using package from PyPI\n\nAvailable under the name `prometheus_ecs_discoverer`. To start PromED:\n\n```sh\npython -m prometheus_ecs_discoverer.run\n```\n\nTo configure PromED you can either provide a settings file or use plain \nenvironment variables.  Please see [Configuration](#configuration) for more \ninfo. Please see [Configuration](#configuration) for more info.\n\n#### Using Docker image\n\nThe image `trallnag/prometheus_ecs_discoverer` can be found \n[here](https://hub.docker.com/repository/docker/trallnag/prometheus_ecs_discoverer).\nThe recommended way for configuring the image is to use environment variables.\nThis might look like this:\n\n```sh\ndocker run \\\n    -e DYNACONF_INTERVAL=60 \\\n    -e DYNACONF_OUTPUT_DIRECTORY=/targets \\\n    -e AWS_ACCESS_KEY_ID=foo \\\n    -e AWS_SECRET_ACCESS_KEY=bar \\\n    -e AWS_DEFAULT_REGION=us-west-2 \\\n    trallnag/prometheus_ecs_discoverer:latest\n```\n\nYou will probably want to run the discoverer in ECS. Here, you don\'t have to \nprovide credentials assuming everything is set up correctly. Boto3 will \nautomatically detect relative credentials URI and retrieve them from AWS.\nNevertheless, the region must be set by you. Here is an exemplary container \ndefinition to deploy PromED:\n\n```json\n{\n    name: "discovery",\n    image : "trallnag/prometheus_ecs_discoverer:latest",\n    environment: [\n        { "name": "DYNACONF_OUTPUT_DIRECTORY", "value": "/targets" },\n        { "name": "AWS_DEFAULT_REGION", "value": "eu-central-1" }\n    ],\n    mountPoints : [{\n        "sourceVolume": "discovery",\n        "containerPath": "/targets",\n    }]\n}\n```\n\n#### AWS IAM\n\nA role with the following policy must be assigned to the PromED scope. If you \ndeploy PromED with ECS this will be the task role.\n\n```json\n{\n  "Version": "2012-10-17",\n  "Statement": [\n    {\n      "Effect": "Allow",\n      "Action": [\n        "ecs:DescribeClusters",\n        "ecs:DescribeContainerInstances",\n        "ecs:DescribeServices",\n        "ecs:DescribeTaskDefinition",\n        "ecs:DescribeTaskSets",\n        "ecs:DescribeTasks",\n        "ecs:ListAccountSettings",\n        "ecs:ListClusters",\n        "ecs:ListContainerInstances",\n        "ecs:ListServices",\n        "ecs:ListTagsForResource",\n        "ecs:ListTaskDefinitionFamilies",\n        "ecs:ListTaskDefinitions",\n        "ecs:ListTasks",\n        "ecs:ListAttributes"\n      ],\n      "Resource": "*"\n    }\n  ]\n}\n```\n\nAttach this policy to the following role:\n\n```json\n{\n  "Version": "2012-10-17",\n  "Statement": [\n    {\n      "Sid": "",\n      "Effect": "Allow",\n      "Principal": {\n        "Service": "ecs-tasks.amazonaws.com"\n      },\n      "Action": "sts:AssumeRole"\n    }\n  ]\n}\n```\n\n## Configuration\n\nAs this project is based on \n[prometheus-ecs-sd](https://github.com/signal-ai/prometheus-ecs-sd), \nthe configuration is mostly compatible.\n\nPromED uses [Dynconf](https://www.dynaconf.com/) for config management. There \nare two main ways you can configure the application. Either by providing a \ncustom settings file with the env var `SETTINGS_FILES_FOR_DYNACONF` (see \n[here](https://www.dynaconf.com/configuration/#on-environment-options)) \nor directly setting the respective values via env vars with the `DYNACONF_` \nprefix. All supported settings together with their default values can be found \n[`settings.toml` (click me)](prometheus_ecs_discoverer/settings.toml).\n\nHere are a few notable settings (together with their defaults) you can modify:\n\n```sh\nINTERVAL = 15\nOUTPUT_DIRECTORY = "/tmp"\n\n# Throttles the first discovery run to ensure that even hundreds of tasks and \n# definitions don\'t overwhelm the AWS API while building up the local cache.\nWARMUP_THROTTLE = true\nTHROTTLE_INTERVAL_SECONDS = 0.1\n\n# Exposes metrics about discoverer itself.\nPROMETHEUS_START_HTTP_SERVER = true\nPROMETHEUS_SERVER_PORT = 8080\n\n# If no endpoint is given in the respective env var, this will be used.\nFALLBACK_METRICS_ENDPOINT = "/metrics"\n\n# And more. See `settings.toml` file.\n```\n',
    'author': 'Tim Schwenke',
    'author_email': 'tim.schwenke+trallnag@protonmail.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/trallnag/prometheus-ecs-discoverer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
