# SPDX-License-Identifier: BSD-3-Clause
# Copyright (c) 2023 Scipp contributors (https://github.com/scipp)

"""
The data here was obtained from the McStas model of the ESS moderator.
See https://www2.mcstas.org/download/components/3.4_current/sources/ESS_butterfly.html.
"""

import scipp as sc

from ..utils import FacilityPulse

pulse = FacilityPulse(
    birth_time=sc.DataArray(
        data=sc.array(
            dims=['birth_time'],
            values=[
                3.35837383e-04,
                7.11462527e-04,
                1.19279849e-03,
                1.75844384e-03,
                2.30312776e-03,
                2.81888175e-03,
                3.29973291e-03,
                3.74342320e-03,
                4.12944139e-03,
                4.50699573e-03,
                4.84309044e-03,
                5.14929712e-03,
                5.45855067e-03,
                5.69936363e-03,
                5.93094105e-03,
                6.17477200e-03,
                6.37362606e-03,
                6.53680137e-03,
                6.73889852e-03,
                6.89076164e-03,
                7.03303086e-03,
                7.16725029e-03,
                7.28150493e-03,
                7.38097004e-03,
                7.47766769e-03,
                7.58743639e-03,
                7.68332632e-03,
                7.76191703e-03,
                7.81004156e-03,
                7.89307474e-03,
                7.99204102e-03,
                8.00486001e-03,
                8.06517551e-03,
                8.12961675e-03,
                8.15018882e-03,
                8.20005390e-03,
                8.24155829e-03,
                8.29947221e-03,
                8.32367988e-03,
                8.35031681e-03,
                8.38183866e-03,
                8.40430754e-03,
                8.41246895e-03,
                8.47906647e-03,
                8.48321568e-03,
                8.51947204e-03,
                8.50648386e-03,
                8.50133270e-03,
                8.52613383e-03,
                8.54115343e-03,
                8.57264133e-03,
                8.56943450e-03,
                8.55472574e-03,
                8.59122615e-03,
                8.62517530e-03,
                8.60719002e-03,
                8.60040235e-03,
                8.63208702e-03,
                8.62533445e-03,
                8.64678861e-03,
                8.64471591e-03,
                8.64182350e-03,
                8.63327922e-03,
                8.66950735e-03,
                8.65129688e-03,
                8.64664447e-03,
                8.64770277e-03,
                8.68294600e-03,
                8.67019185e-03,
                8.66156150e-03,
                8.67539908e-03,
                8.69230509e-03,
                8.66817676e-03,
                8.67640973e-03,
                8.67257086e-03,
                8.71476117e-03,
                8.69738903e-03,
                8.70019388e-03,
                8.68198365e-03,
                8.70585101e-03,
                8.69709781e-03,
                8.70056388e-03,
                8.70854571e-03,
                8.67909089e-03,
                8.68674970e-03,
                8.68150346e-03,
                8.70191501e-03,
                8.69301298e-03,
                8.69085698e-03,
                8.71649943e-03,
                8.67369456e-03,
                8.69969514e-03,
                8.72322806e-03,
                8.70185411e-03,
                8.68939648e-03,
                8.71606837e-03,
                8.68724841e-03,
                8.70218613e-03,
                8.72040120e-03,
                8.69293491e-03,
                8.69351789e-03,
                8.73419233e-03,
                8.69075919e-03,
                8.70522638e-03,
                8.71477349e-03,
                8.70507452e-03,
                8.70227301e-03,
                8.71420193e-03,
                8.71897903e-03,
                8.70425294e-03,
                8.68891152e-03,
                8.68402639e-03,
                8.70486831e-03,
                8.69707245e-03,
                8.70321249e-03,
                8.27644038e-03,
                7.95684870e-03,
                7.43411585e-03,
                6.84769508e-03,
                6.31981817e-03,
                5.79771415e-03,
                5.33668341e-03,
                4.90722076e-03,
                4.51723727e-03,
                4.14674875e-03,
                3.81695136e-03,
                3.51640474e-03,
                3.22513571e-03,
                2.95911995e-03,
                2.73056190e-03,
                2.51716771e-03,
                2.31576802e-03,
                2.12938206e-03,
                1.96285779e-03,
                1.80590850e-03,
                1.66301586e-03,
                1.52912399e-03,
                1.41144832e-03,
                1.29986696e-03,
                1.20219471e-03,
                1.10136923e-03,
                1.01839892e-03,
                9.39143113e-04,
                8.64814579e-04,
                7.96703989e-04,
                7.35063247e-04,
                6.78739795e-04,
                6.24226207e-04,
                5.76731522e-04,
                5.31877313e-04,
                4.91432490e-04,
                4.53724222e-04,
                4.17097140e-04,
                3.84883668e-04,
                3.56053519e-04,
                3.28615077e-04,
                3.03171707e-04,
                2.80212744e-04,
                2.58806676e-04,
                2.39233542e-04,
                2.20830164e-04,
                2.03703468e-04,
                1.88784094e-04,
                1.74177494e-04,
                1.61290974e-04,
                1.48847234e-04,
                1.37594011e-04,
                1.27396903e-04,
                1.17512734e-04,
                1.08817617e-04,
                1.00626721e-04,
                9.30799915e-05,
                8.58308478e-05,
                7.97150769e-05,
                7.36523610e-05,
                6.84294010e-05,
                6.32182918e-05,
                5.85268482e-05,
                5.40528453e-05,
                5.02368808e-05,
                4.65180897e-05,
                4.30575884e-05,
                3.98835225e-05,
                3.70504980e-05,
                3.42857719e-05,
                3.18132215e-05,
                2.95287409e-05,
                2.73577012e-05,
                2.53724318e-05,
                2.35572592e-05,
                2.18844303e-05,
                2.02605458e-05,
                1.88596686e-05,
                1.75580663e-05,
                1.62935792e-05,
                1.51211989e-05,
                1.40303609e-05,
                1.30832864e-05,
                1.21382107e-05,
                1.12829800e-05,
                1.05060755e-05,
            ],
        ),
        coords={
            'birth_time': sc.array(
                dims=['birth_time'],
                values=[
                    1.24378109e-05,
                    3.73134328e-05,
                    6.21890547e-05,
                    8.70646766e-05,
                    1.11940299e-04,
                    1.36815920e-04,
                    1.61691542e-04,
                    1.86567164e-04,
                    2.11442786e-04,
                    2.36318408e-04,
                    2.61194030e-04,
                    2.86069652e-04,
                    3.10945274e-04,
                    3.35820896e-04,
                    3.60696517e-04,
                    3.85572139e-04,
                    4.10447761e-04,
                    4.35323383e-04,
                    4.60199005e-04,
                    4.85074627e-04,
                    5.09950249e-04,
                    5.34825871e-04,
                    5.59701493e-04,
                    5.84577114e-04,
                    6.09452736e-04,
                    6.34328358e-04,
                    6.59203980e-04,
                    6.84079602e-04,
                    7.08955224e-04,
                    7.33830846e-04,
                    7.58706468e-04,
                    7.83582090e-04,
                    8.08457711e-04,
                    8.33333333e-04,
                    8.58208955e-04,
                    8.83084577e-04,
                    9.07960199e-04,
                    9.32835821e-04,
                    9.57711443e-04,
                    9.82587065e-04,
                    1.00746269e-03,
                    1.03233831e-03,
                    1.05721393e-03,
                    1.08208955e-03,
                    1.10696517e-03,
                    1.13184080e-03,
                    1.15671642e-03,
                    1.18159204e-03,
                    1.20646766e-03,
                    1.23134328e-03,
                    1.25621891e-03,
                    1.28109453e-03,
                    1.30597015e-03,
                    1.33084577e-03,
                    1.35572139e-03,
                    1.38059701e-03,
                    1.40547264e-03,
                    1.43034826e-03,
                    1.45522388e-03,
                    1.48009950e-03,
                    1.50497512e-03,
                    1.52985075e-03,
                    1.55472637e-03,
                    1.57960199e-03,
                    1.60447761e-03,
                    1.62935323e-03,
                    1.65422886e-03,
                    1.67910448e-03,
                    1.70398010e-03,
                    1.72885572e-03,
                    1.75373134e-03,
                    1.77860697e-03,
                    1.80348259e-03,
                    1.82835821e-03,
                    1.85323383e-03,
                    1.87810945e-03,
                    1.90298507e-03,
                    1.92786070e-03,
                    1.95273632e-03,
                    1.97761194e-03,
                    2.00248756e-03,
                    2.02736318e-03,
                    2.05223881e-03,
                    2.07711443e-03,
                    2.10199005e-03,
                    2.12686567e-03,
                    2.15174129e-03,
                    2.17661692e-03,
                    2.20149254e-03,
                    2.22636816e-03,
                    2.25124378e-03,
                    2.27611940e-03,
                    2.30099502e-03,
                    2.32587065e-03,
                    2.35074627e-03,
                    2.37562189e-03,
                    2.40049751e-03,
                    2.42537313e-03,
                    2.45024876e-03,
                    2.47512438e-03,
                    2.50000000e-03,
                    2.52487562e-03,
                    2.54975124e-03,
                    2.57462687e-03,
                    2.59950249e-03,
                    2.62437811e-03,
                    2.64925373e-03,
                    2.67412935e-03,
                    2.69900498e-03,
                    2.72388060e-03,
                    2.74875622e-03,
                    2.77363184e-03,
                    2.79850746e-03,
                    2.82338308e-03,
                    2.84825871e-03,
                    2.87313433e-03,
                    2.89800995e-03,
                    2.92288557e-03,
                    2.94776119e-03,
                    2.97263682e-03,
                    2.99751244e-03,
                    3.02238806e-03,
                    3.04726368e-03,
                    3.07213930e-03,
                    3.09701493e-03,
                    3.12189055e-03,
                    3.14676617e-03,
                    3.17164179e-03,
                    3.19651741e-03,
                    3.22139303e-03,
                    3.24626866e-03,
                    3.27114428e-03,
                    3.29601990e-03,
                    3.32089552e-03,
                    3.34577114e-03,
                    3.37064677e-03,
                    3.39552239e-03,
                    3.42039801e-03,
                    3.44527363e-03,
                    3.47014925e-03,
                    3.49502488e-03,
                    3.51990050e-03,
                    3.54477612e-03,
                    3.56965174e-03,
                    3.59452736e-03,
                    3.61940299e-03,
                    3.64427861e-03,
                    3.66915423e-03,
                    3.69402985e-03,
                    3.71890547e-03,
                    3.74378109e-03,
                    3.76865672e-03,
                    3.79353234e-03,
                    3.81840796e-03,
                    3.84328358e-03,
                    3.86815920e-03,
                    3.89303483e-03,
                    3.91791045e-03,
                    3.94278607e-03,
                    3.96766169e-03,
                    3.99253731e-03,
                    4.01741294e-03,
                    4.04228856e-03,
                    4.06716418e-03,
                    4.09203980e-03,
                    4.11691542e-03,
                    4.14179104e-03,
                    4.16666667e-03,
                    4.19154229e-03,
                    4.21641791e-03,
                    4.24129353e-03,
                    4.26616915e-03,
                    4.29104478e-03,
                    4.31592040e-03,
                    4.34079602e-03,
                    4.36567164e-03,
                    4.39054726e-03,
                    4.41542289e-03,
                    4.44029851e-03,
                    4.46517413e-03,
                    4.49004975e-03,
                    4.51492537e-03,
                    4.53980100e-03,
                    4.56467662e-03,
                    4.58955224e-03,
                    4.61442786e-03,
                    4.63930348e-03,
                    4.66417910e-03,
                    4.68905473e-03,
                    4.71393035e-03,
                    4.73880597e-03,
                    4.76368159e-03,
                    4.78855721e-03,
                    4.81343284e-03,
                    4.83830846e-03,
                    4.86318408e-03,
                    4.88805970e-03,
                    4.91293532e-03,
                    4.93781095e-03,
                    4.96268657e-03,
                    4.98756219e-03,
                ],
                unit='s',
            )
        },
    ),
    wavelength=sc.DataArray(
        data=sc.array(
            dims=['wavelength'],
            values=[
                2.47910521e-02,
                3.15394565e-02,
                2.46673832e-02,
                4.24700432e-02,
                6.22005065e-02,
                6.41430908e-02,
                5.63970675e-02,
                4.79885540e-02,
                4.28010531e-02,
                4.17366412e-02,
                4.51519899e-02,
                5.35348380e-02,
                6.07649341e-02,
                5.33537571e-02,
                4.52415054e-02,
                3.85305979e-02,
                3.29632299e-02,
                2.82808267e-02,
                2.43136951e-02,
                2.09961870e-02,
                1.81474939e-02,
                1.57517036e-02,
                1.36839501e-02,
                1.19127479e-02,
                1.04094236e-02,
                9.09390901e-03,
                7.97376111e-03,
                7.03987735e-03,
                6.19641665e-03,
                5.48516928e-03,
                4.84954606e-03,
                4.31560357e-03,
                3.84683395e-03,
                3.43486380e-03,
                3.07473495e-03,
                2.75943204e-03,
                2.48705338e-03,
                2.24190868e-03,
                2.02792878e-03,
                1.83647522e-03,
                1.66751194e-03,
                1.52037927e-03,
                1.38568580e-03,
                1.26625902e-03,
                1.15985092e-03,
                1.06326666e-03,
                9.77402425e-04,
                8.97152751e-04,
                8.28473264e-04,
                7.65517629e-04,
                7.06753047e-04,
                6.53870845e-04,
                6.05626744e-04,
                5.61775168e-04,
                5.21407086e-04,
                4.83706064e-04,
                4.50096590e-04,
                4.18595081e-04,
                3.89942860e-04,
                3.63082390e-04,
                3.38196875e-04,
                3.16116766e-04,
                2.94433976e-04,
                2.74611217e-04,
                2.56804279e-04,
                2.39866263e-04,
                2.24103151e-04,
                2.09428428e-04,
                1.96024411e-04,
                1.83244400e-04,
                1.71452766e-04,
                1.60372237e-04,
                1.50247463e-04,
                1.40620774e-04,
                1.31338349e-04,
                1.23209023e-04,
                1.15219833e-04,
                1.07938245e-04,
                1.01217712e-04,
                9.47807301e-05,
                8.87686984e-05,
                8.31031332e-05,
                7.78786212e-05,
                7.29971694e-05,
                6.83232132e-05,
                6.40614634e-05,
                6.00522902e-05,
                5.63009205e-05,
                5.26437650e-05,
                4.93458816e-05,
                4.62942251e-05,
                4.33867986e-05,
                4.06646952e-05,
                3.80409296e-05,
                3.57000207e-05,
                3.34181377e-05,
                3.13558896e-05,
                2.93784366e-05,
                2.75483925e-05,
                2.57593945e-05,
                2.41535573e-05,
            ],
        ),
        coords={
            'wavelength': sc.array(
                dims=['wavelength'],
                values=[
                    1.98514851e-01,
                    3.95544554e-01,
                    5.92574257e-01,
                    7.89603960e-01,
                    9.86633663e-01,
                    1.18366337e00,
                    1.38069307e00,
                    1.57772277e00,
                    1.77475248e00,
                    1.97178218e00,
                    2.16881188e00,
                    2.36584158e00,
                    2.56287129e00,
                    2.75990099e00,
                    2.95693069e00,
                    3.15396040e00,
                    3.35099010e00,
                    3.54801980e00,
                    3.74504950e00,
                    3.94207921e00,
                    4.13910891e00,
                    4.33613861e00,
                    4.53316832e00,
                    4.73019802e00,
                    4.92722772e00,
                    5.12425743e00,
                    5.32128713e00,
                    5.51831683e00,
                    5.71534653e00,
                    5.91237624e00,
                    6.10940594e00,
                    6.30643564e00,
                    6.50346535e00,
                    6.70049505e00,
                    6.89752475e00,
                    7.09455446e00,
                    7.29158416e00,
                    7.48861386e00,
                    7.68564356e00,
                    7.88267327e00,
                    8.07970297e00,
                    8.27673267e00,
                    8.47376238e00,
                    8.67079208e00,
                    8.86782178e00,
                    9.06485149e00,
                    9.26188119e00,
                    9.45891089e00,
                    9.65594059e00,
                    9.85297030e00,
                    1.00500000e01,
                    1.02470297e01,
                    1.04440594e01,
                    1.06410891e01,
                    1.08381188e01,
                    1.10351485e01,
                    1.12321782e01,
                    1.14292079e01,
                    1.16262376e01,
                    1.18232673e01,
                    1.20202970e01,
                    1.22173267e01,
                    1.24143564e01,
                    1.26113861e01,
                    1.28084158e01,
                    1.30054455e01,
                    1.32024752e01,
                    1.33995050e01,
                    1.35965347e01,
                    1.37935644e01,
                    1.39905941e01,
                    1.41876238e01,
                    1.43846535e01,
                    1.45816832e01,
                    1.47787129e01,
                    1.49757426e01,
                    1.51727723e01,
                    1.53698020e01,
                    1.55668317e01,
                    1.57638614e01,
                    1.59608911e01,
                    1.61579208e01,
                    1.63549505e01,
                    1.65519802e01,
                    1.67490099e01,
                    1.69460396e01,
                    1.71430693e01,
                    1.73400990e01,
                    1.75371287e01,
                    1.77341584e01,
                    1.79311881e01,
                    1.81282178e01,
                    1.83252475e01,
                    1.85222772e01,
                    1.87193069e01,
                    1.89163366e01,
                    1.91133663e01,
                    1.93103960e01,
                    1.95074257e01,
                    1.97044554e01,
                    1.99014851e01,
                ],
                unit='angstrom',
            )
        },
    ),
    frequency=14.0 * sc.Unit('Hz'),
)
