# coding: utf-8

"""
    Aspose.PDF Cloud API Reference


Copyright (c) 2021 Aspose.PDF Cloud
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.



    OpenAPI spec version: 3.0
    
"""


from pprint import pformat
from six import iteritems
import re


class Table(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'links': 'list[Link]',
        'alignment': 'HorizontalAlignment',
        'horizontal_alignment': 'HorizontalAlignment',
        'vertical_alignment': 'VerticalAlignment',
        'top': 'float',
        'left': 'float',
        'default_cell_text_state': 'TextState',
        'default_cell_padding': 'MarginInfo',
        'border': 'BorderInfo',
        'margin': 'MarginInfo',
        'rows': 'list[Row]',
        'default_column_width': 'str',
        'default_cell_border': 'BorderInfo',
        'broken': 'TableBroken',
        'column_widths': 'str',
        'repeating_rows_count': 'int',
        'repeating_columns_count': 'int',
        'repeating_rows_style': 'TextState',
        'corner_style': 'BorderCornerStyle',
        'break_text': 'TextRect',
        'background_color': 'Color',
        'is_borders_included': 'bool',
        'column_adjustment': 'ColumnAdjustment',
        'z_index': 'int'
    }

    attribute_map = {
        'links': 'Links',
        'alignment': 'Alignment',
        'horizontal_alignment': 'HorizontalAlignment',
        'vertical_alignment': 'VerticalAlignment',
        'top': 'Top',
        'left': 'Left',
        'default_cell_text_state': 'DefaultCellTextState',
        'default_cell_padding': 'DefaultCellPadding',
        'border': 'Border',
        'margin': 'Margin',
        'rows': 'Rows',
        'default_column_width': 'DefaultColumnWidth',
        'default_cell_border': 'DefaultCellBorder',
        'broken': 'Broken',
        'column_widths': 'ColumnWidths',
        'repeating_rows_count': 'RepeatingRowsCount',
        'repeating_columns_count': 'RepeatingColumnsCount',
        'repeating_rows_style': 'RepeatingRowsStyle',
        'corner_style': 'CornerStyle',
        'break_text': 'BreakText',
        'background_color': 'BackgroundColor',
        'is_borders_included': 'IsBordersIncluded',
        'column_adjustment': 'ColumnAdjustment',
        'z_index': 'ZIndex'
    }

    def __init__(self, links=None, alignment=None, horizontal_alignment=None, vertical_alignment=None, top=None, left=None, default_cell_text_state=None, default_cell_padding=None, border=None, margin=None, rows=None, default_column_width=None, default_cell_border=None, broken=None, column_widths=None, repeating_rows_count=None, repeating_columns_count=None, repeating_rows_style=None, corner_style=None, break_text=None, background_color=None, is_borders_included=None, column_adjustment=None, z_index=None):
        """
        Table - a model defined in Swagger
        """

        self._links = None
        self._alignment = None
        self._horizontal_alignment = None
        self._vertical_alignment = None
        self._top = None
        self._left = None
        self._default_cell_text_state = None
        self._default_cell_padding = None
        self._border = None
        self._margin = None
        self._rows = None
        self._default_column_width = None
        self._default_cell_border = None
        self._broken = None
        self._column_widths = None
        self._repeating_rows_count = None
        self._repeating_columns_count = None
        self._repeating_rows_style = None
        self._corner_style = None
        self._break_text = None
        self._background_color = None
        self._is_borders_included = None
        self._column_adjustment = None
        self._z_index = None

        if links is not None:
          self.links = links
        if alignment is not None:
          self.alignment = alignment
        if horizontal_alignment is not None:
          self.horizontal_alignment = horizontal_alignment
        if vertical_alignment is not None:
          self.vertical_alignment = vertical_alignment
        if top is not None:
          self.top = top
        if left is not None:
          self.left = left
        if default_cell_text_state is not None:
          self.default_cell_text_state = default_cell_text_state
        if default_cell_padding is not None:
          self.default_cell_padding = default_cell_padding
        if border is not None:
          self.border = border
        if margin is not None:
          self.margin = margin
        self.rows = rows
        if default_column_width is not None:
          self.default_column_width = default_column_width
        if default_cell_border is not None:
          self.default_cell_border = default_cell_border
        if broken is not None:
          self.broken = broken
        if column_widths is not None:
          self.column_widths = column_widths
        if repeating_rows_count is not None:
          self.repeating_rows_count = repeating_rows_count
        if repeating_columns_count is not None:
          self.repeating_columns_count = repeating_columns_count
        if repeating_rows_style is not None:
          self.repeating_rows_style = repeating_rows_style
        if corner_style is not None:
          self.corner_style = corner_style
        if break_text is not None:
          self.break_text = break_text
        if background_color is not None:
          self.background_color = background_color
        if is_borders_included is not None:
          self.is_borders_included = is_borders_included
        if column_adjustment is not None:
          self.column_adjustment = column_adjustment
        if z_index is not None:
          self.z_index = z_index

    @property
    def links(self):
        """
        Gets the links of this Table.
        Link to the document.

        :return: The links of this Table.
        :rtype: list[Link]
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this Table.
        Link to the document.

        :param links: The links of this Table.
        :type: list[Link]
        """

        self._links = links

    @property
    def alignment(self):
        """
        Gets the alignment of this Table.
        Gets HorizontalAlignment of the table alignment.

        :return: The alignment of this Table.
        :rtype: HorizontalAlignment
        """
        return self._alignment

    @alignment.setter
    def alignment(self, alignment):
        """
        Sets the alignment of this Table.
        Gets HorizontalAlignment of the table alignment.

        :param alignment: The alignment of this Table.
        :type: HorizontalAlignment
        """

        self._alignment = alignment

    @property
    def horizontal_alignment(self):
        """
        Gets the horizontal_alignment of this Table.
        Gets HorizontalAlignment of the table alignment.

        :return: The horizontal_alignment of this Table.
        :rtype: HorizontalAlignment
        """
        return self._horizontal_alignment

    @horizontal_alignment.setter
    def horizontal_alignment(self, horizontal_alignment):
        """
        Sets the horizontal_alignment of this Table.
        Gets HorizontalAlignment of the table alignment.

        :param horizontal_alignment: The horizontal_alignment of this Table.
        :type: HorizontalAlignment
        """

        self._horizontal_alignment = horizontal_alignment

    @property
    def vertical_alignment(self):
        """
        Gets the vertical_alignment of this Table.
        Gets VerticalAlignment of the annotation.

        :return: The vertical_alignment of this Table.
        :rtype: VerticalAlignment
        """
        return self._vertical_alignment

    @vertical_alignment.setter
    def vertical_alignment(self, vertical_alignment):
        """
        Sets the vertical_alignment of this Table.
        Gets VerticalAlignment of the annotation.

        :param vertical_alignment: The vertical_alignment of this Table.
        :type: VerticalAlignment
        """

        self._vertical_alignment = vertical_alignment

    @property
    def top(self):
        """
        Gets the top of this Table.
        Gets or sets the table top coordinate.

        :return: The top of this Table.
        :rtype: float
        """
        return self._top

    @top.setter
    def top(self, top):
        """
        Sets the top of this Table.
        Gets or sets the table top coordinate.

        :param top: The top of this Table.
        :type: float
        """

        self._top = top

    @property
    def left(self):
        """
        Gets the left of this Table.
        Gets or sets the table left coordinate.

        :return: The left of this Table.
        :rtype: float
        """
        return self._left

    @left.setter
    def left(self, left):
        """
        Sets the left of this Table.
        Gets or sets the table left coordinate.

        :param left: The left of this Table.
        :type: float
        """

        self._left = left

    @property
    def default_cell_text_state(self):
        """
        Gets the default_cell_text_state of this Table.
        Gets or sets the default cell text state.

        :return: The default_cell_text_state of this Table.
        :rtype: TextState
        """
        return self._default_cell_text_state

    @default_cell_text_state.setter
    def default_cell_text_state(self, default_cell_text_state):
        """
        Sets the default_cell_text_state of this Table.
        Gets or sets the default cell text state.

        :param default_cell_text_state: The default_cell_text_state of this Table.
        :type: TextState
        """

        self._default_cell_text_state = default_cell_text_state

    @property
    def default_cell_padding(self):
        """
        Gets the default_cell_padding of this Table.
        Gets or sets the default cell padding.

        :return: The default_cell_padding of this Table.
        :rtype: MarginInfo
        """
        return self._default_cell_padding

    @default_cell_padding.setter
    def default_cell_padding(self, default_cell_padding):
        """
        Sets the default_cell_padding of this Table.
        Gets or sets the default cell padding.

        :param default_cell_padding: The default_cell_padding of this Table.
        :type: MarginInfo
        """

        self._default_cell_padding = default_cell_padding

    @property
    def border(self):
        """
        Gets the border of this Table.
        Gets or sets the border.

        :return: The border of this Table.
        :rtype: BorderInfo
        """
        return self._border

    @border.setter
    def border(self, border):
        """
        Sets the border of this Table.
        Gets or sets the border.

        :param border: The border of this Table.
        :type: BorderInfo
        """

        self._border = border

    @property
    def margin(self):
        """
        Gets the margin of this Table.
        Gets or sets a outer margin for paragraph (for pdf generation)

        :return: The margin of this Table.
        :rtype: MarginInfo
        """
        return self._margin

    @margin.setter
    def margin(self, margin):
        """
        Sets the margin of this Table.
        Gets or sets a outer margin for paragraph (for pdf generation)

        :param margin: The margin of this Table.
        :type: MarginInfo
        """

        self._margin = margin

    @property
    def rows(self):
        """
        Gets the rows of this Table.
        Sets the rows of the table.

        :return: The rows of this Table.
        :rtype: list[Row]
        """
        return self._rows

    @rows.setter
    def rows(self, rows):
        """
        Sets the rows of this Table.
        Sets the rows of the table.

        :param rows: The rows of this Table.
        :type: list[Row]
        """
        if rows is None:
            raise ValueError("Invalid value for `rows`, must not be `None`")

        self._rows = rows

    @property
    def default_column_width(self):
        """
        Gets the default_column_width of this Table.
        Gets default cell border;

        :return: The default_column_width of this Table.
        :rtype: str
        """
        return self._default_column_width

    @default_column_width.setter
    def default_column_width(self, default_column_width):
        """
        Sets the default_column_width of this Table.
        Gets default cell border;

        :param default_column_width: The default_column_width of this Table.
        :type: str
        """

        self._default_column_width = default_column_width

    @property
    def default_cell_border(self):
        """
        Gets the default_cell_border of this Table.
        Gets default cell border;

        :return: The default_cell_border of this Table.
        :rtype: BorderInfo
        """
        return self._default_cell_border

    @default_cell_border.setter
    def default_cell_border(self, default_cell_border):
        """
        Sets the default_cell_border of this Table.
        Gets default cell border;

        :param default_cell_border: The default_cell_border of this Table.
        :type: BorderInfo
        """

        self._default_cell_border = default_cell_border

    @property
    def broken(self):
        """
        Gets the broken of this Table.
        Gets or sets table vertial broken;

        :return: The broken of this Table.
        :rtype: TableBroken
        """
        return self._broken

    @broken.setter
    def broken(self, broken):
        """
        Sets the broken of this Table.
        Gets or sets table vertial broken;

        :param broken: The broken of this Table.
        :type: TableBroken
        """

        self._broken = broken

    @property
    def column_widths(self):
        """
        Gets the column_widths of this Table.
        Gets the column widths of the table.

        :return: The column_widths of this Table.
        :rtype: str
        """
        return self._column_widths

    @column_widths.setter
    def column_widths(self, column_widths):
        """
        Sets the column_widths of this Table.
        Gets the column widths of the table.

        :param column_widths: The column_widths of this Table.
        :type: str
        """

        self._column_widths = column_widths

    @property
    def repeating_rows_count(self):
        """
        Gets the repeating_rows_count of this Table.
        Gets the first rows count repeated for several pages

        :return: The repeating_rows_count of this Table.
        :rtype: int
        """
        return self._repeating_rows_count

    @repeating_rows_count.setter
    def repeating_rows_count(self, repeating_rows_count):
        """
        Sets the repeating_rows_count of this Table.
        Gets the first rows count repeated for several pages

        :param repeating_rows_count: The repeating_rows_count of this Table.
        :type: int
        """

        self._repeating_rows_count = repeating_rows_count

    @property
    def repeating_columns_count(self):
        """
        Gets the repeating_columns_count of this Table.
        Gets or sets the maximum columns count for table

        :return: The repeating_columns_count of this Table.
        :rtype: int
        """
        return self._repeating_columns_count

    @repeating_columns_count.setter
    def repeating_columns_count(self, repeating_columns_count):
        """
        Sets the repeating_columns_count of this Table.
        Gets or sets the maximum columns count for table

        :param repeating_columns_count: The repeating_columns_count of this Table.
        :type: int
        """

        self._repeating_columns_count = repeating_columns_count

    @property
    def repeating_rows_style(self):
        """
        Gets the repeating_rows_style of this Table.
        Gets the style for repeating rows

        :return: The repeating_rows_style of this Table.
        :rtype: TextState
        """
        return self._repeating_rows_style

    @repeating_rows_style.setter
    def repeating_rows_style(self, repeating_rows_style):
        """
        Sets the repeating_rows_style of this Table.
        Gets the style for repeating rows

        :param repeating_rows_style: The repeating_rows_style of this Table.
        :type: TextState
        """

        self._repeating_rows_style = repeating_rows_style

    @property
    def corner_style(self):
        """
        Gets the corner_style of this Table.
        Gets or sets the styles of the border corners

        :return: The corner_style of this Table.
        :rtype: BorderCornerStyle
        """
        return self._corner_style

    @corner_style.setter
    def corner_style(self, corner_style):
        """
        Sets the corner_style of this Table.
        Gets or sets the styles of the border corners

        :param corner_style: The corner_style of this Table.
        :type: BorderCornerStyle
        """

        self._corner_style = corner_style

    @property
    def break_text(self):
        """
        Gets the break_text of this Table.
        Gets or sets break text for table

        :return: The break_text of this Table.
        :rtype: TextRect
        """
        return self._break_text

    @break_text.setter
    def break_text(self, break_text):
        """
        Sets the break_text of this Table.
        Gets or sets break text for table

        :param break_text: The break_text of this Table.
        :type: TextRect
        """

        self._break_text = break_text

    @property
    def background_color(self):
        """
        Gets the background_color of this Table.
        Gets or sets table background color

        :return: The background_color of this Table.
        :rtype: Color
        """
        return self._background_color

    @background_color.setter
    def background_color(self, background_color):
        """
        Sets the background_color of this Table.
        Gets or sets table background color

        :param background_color: The background_color of this Table.
        :type: Color
        """

        self._background_color = background_color

    @property
    def is_borders_included(self):
        """
        Gets the is_borders_included of this Table.
        Gets or sets border included in column widhts.

        :return: The is_borders_included of this Table.
        :rtype: bool
        """
        return self._is_borders_included

    @is_borders_included.setter
    def is_borders_included(self, is_borders_included):
        """
        Sets the is_borders_included of this Table.
        Gets or sets border included in column widhts.

        :param is_borders_included: The is_borders_included of this Table.
        :type: bool
        """

        self._is_borders_included = is_borders_included

    @property
    def column_adjustment(self):
        """
        Gets the column_adjustment of this Table.
        Gets or sets the table column adjustment.

        :return: The column_adjustment of this Table.
        :rtype: ColumnAdjustment
        """
        return self._column_adjustment

    @column_adjustment.setter
    def column_adjustment(self, column_adjustment):
        """
        Sets the column_adjustment of this Table.
        Gets or sets the table column adjustment.

        :param column_adjustment: The column_adjustment of this Table.
        :type: ColumnAdjustment
        """

        self._column_adjustment = column_adjustment

    @property
    def z_index(self):
        """
        Gets the z_index of this Table.
        Gets ZIndex of the annotation.

        :return: The z_index of this Table.
        :rtype: int
        """
        return self._z_index

    @z_index.setter
    def z_index(self, z_index):
        """
        Sets the z_index of this Table.
        Gets ZIndex of the annotation.

        :param z_index: The z_index of this Table.
        :type: int
        """

        self._z_index = z_index

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Table):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
