# coding: utf-8

# flake8: noqa
"""
    Service Account API

    API to manage Service Accounts and their Access Tokens.  ### System for Cross-domain Identity Management (SCIM) Service Account Service offers SCIM APIs to query state. The SCIM protocol was created as standard for  automating the exchange of user identity information between identity domains, or IT systems. Service accounts  are be handled as indentites similar to SCIM users. A custom SCIM schema has been created: `/ServiceAccounts`  #### Syntax ##### Attribute operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | eq       | equal                    | | ne       | not equal                | | co       | contains                 | | sw       | starts with              | | ew       | ends with                |  ##### Logical operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | and      | logical \"and\"            | | or       | logical \"or\"             |  ##### Grouping operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | ()       | precending grouping      |  ##### Example ``` filter=email eq \"my-service-account-aBc2defg@sa.stackit.cloud\" filter=email ne \"my-service-account-aBc2defg@sa.stackit.cloud\" filter=email co \"my-service-account\" filter=name sw \"my\" filter=name ew \"account\" filter=email co \"my-service-account\" and name sw \"my\" filter=email co \"my-service-account\" and (name sw \"my\" or name ew \"account\") ```  #### Sorting  > Sorting is optional  | PARAMETER | DESCRIPTION                          | |-----------|--------------------------------------| | sortBy    | attribute response is ordered by     | | sortOrder | 'ASCENDING' (default) or 'DESCENDING'|  #### Pagination  | PARAMETER    | DESCRIPTION                                  | |--------------|----------------------------------------------| | startIndex   | index of first query result, default: 1      | | count        | maximum number of query results, default: 100|

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


# import models into model package
from stackit.serviceaccount.models.access_token import AccessToken
from stackit.serviceaccount.models.access_token_metadata import AccessTokenMetadata
from stackit.serviceaccount.models.auth_error import AuthError
from stackit.serviceaccount.models.auth_error_error import AuthErrorError
from stackit.serviceaccount.models.create_access_token_payload import (
    CreateAccessTokenPayload,
)
from stackit.serviceaccount.models.create_service_account_key_payload import (
    CreateServiceAccountKeyPayload,
)
from stackit.serviceaccount.models.create_service_account_key_response import (
    CreateServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.create_service_account_key_response_credentials import (
    CreateServiceAccountKeyResponseCredentials,
)
from stackit.serviceaccount.models.create_service_account_payload import (
    CreateServiceAccountPayload,
)
from stackit.serviceaccount.models.create_short_lived_access_token_response import (
    CreateShortLivedAccessTokenResponse,
)
from stackit.serviceaccount.models.error import Error
from stackit.serviceaccount.models.get_service_account_key_response import (
    GetServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.get_service_account_key_response_credentials import (
    GetServiceAccountKeyResponseCredentials,
)
from stackit.serviceaccount.models.jwk import JWK
from stackit.serviceaccount.models.jwks import JWKS
from stackit.serviceaccount.models.list_access_tokens_response import (
    ListAccessTokensResponse,
)
from stackit.serviceaccount.models.list_service_account_keys_response import (
    ListServiceAccountKeysResponse,
)
from stackit.serviceaccount.models.list_service_accounts_response import (
    ListServiceAccountsResponse,
)
from stackit.serviceaccount.models.partial_update_service_account_key_payload import (
    PartialUpdateServiceAccountKeyPayload,
)
from stackit.serviceaccount.models.partial_update_service_account_key_response import (
    PartialUpdateServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.service_account import ServiceAccount
from stackit.serviceaccount.models.service_account_key_list_response import (
    ServiceAccountKeyListResponse,
)
