# coding: utf-8

# flake8: noqa

"""
    Service Account API

    API to manage Service Accounts and their Access Tokens.  ### System for Cross-domain Identity Management (SCIM) Service Account Service offers SCIM APIs to query state. The SCIM protocol was created as standard for  automating the exchange of user identity information between identity domains, or IT systems. Service accounts  are be handled as indentites similar to SCIM users. A custom SCIM schema has been created: `/ServiceAccounts`  #### Syntax ##### Attribute operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | eq       | equal                    | | ne       | not equal                | | co       | contains                 | | sw       | starts with              | | ew       | ends with                |  ##### Logical operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | and      | logical \"and\"            | | or       | logical \"or\"             |  ##### Grouping operators | OPERATOR | DESCRIPTION              | |----------|--------------------------| | ()       | precending grouping      |  ##### Example ``` filter=email eq \"my-service-account-aBc2defg@sa.stackit.cloud\" filter=email ne \"my-service-account-aBc2defg@sa.stackit.cloud\" filter=email co \"my-service-account\" filter=name sw \"my\" filter=name ew \"account\" filter=email co \"my-service-account\" and name sw \"my\" filter=email co \"my-service-account\" and (name sw \"my\" or name ew \"account\") ```  #### Sorting  > Sorting is optional  | PARAMETER | DESCRIPTION                          | |-----------|--------------------------------------| | sortBy    | attribute response is ordered by     | | sortOrder | 'ASCENDING' (default) or 'DESCENDING'|  #### Pagination  | PARAMETER    | DESCRIPTION                                  | |--------------|----------------------------------------------| | startIndex   | index of first query result, default: 1      | | count        | maximum number of query results, default: 100|

    The version of the OpenAPI document: 2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "DefaultApi",
    "ApiResponse",
    "ApiClient",
    "HostConfiguration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "AccessToken",
    "AccessTokenMetadata",
    "AuthError",
    "AuthErrorError",
    "CreateAccessTokenPayload",
    "CreateServiceAccountKeyPayload",
    "CreateServiceAccountKeyResponse",
    "CreateServiceAccountKeyResponseCredentials",
    "CreateServiceAccountPayload",
    "CreateShortLivedAccessTokenResponse",
    "Error",
    "GetServiceAccountKeyResponse",
    "GetServiceAccountKeyResponseCredentials",
    "JWK",
    "JWKS",
    "ListAccessTokensResponse",
    "ListServiceAccountKeysResponse",
    "ListServiceAccountsResponse",
    "PartialUpdateServiceAccountKeyPayload",
    "PartialUpdateServiceAccountKeyResponse",
    "ServiceAccount",
    "ServiceAccountKeyListResponse",
]

# import apis into sdk package
from stackit.serviceaccount.api.default_api import DefaultApi as DefaultApi
from stackit.serviceaccount.api_client import ApiClient as ApiClient

# import ApiClient
from stackit.serviceaccount.api_response import ApiResponse as ApiResponse
from stackit.serviceaccount.configuration import HostConfiguration as HostConfiguration
from stackit.serviceaccount.exceptions import ApiAttributeError as ApiAttributeError
from stackit.serviceaccount.exceptions import ApiException as ApiException
from stackit.serviceaccount.exceptions import ApiKeyError as ApiKeyError
from stackit.serviceaccount.exceptions import ApiTypeError as ApiTypeError
from stackit.serviceaccount.exceptions import ApiValueError as ApiValueError
from stackit.serviceaccount.exceptions import OpenApiException as OpenApiException

# import models into sdk package
from stackit.serviceaccount.models.access_token import AccessToken as AccessToken
from stackit.serviceaccount.models.access_token_metadata import (
    AccessTokenMetadata as AccessTokenMetadata,
)
from stackit.serviceaccount.models.auth_error import AuthError as AuthError
from stackit.serviceaccount.models.auth_error_error import (
    AuthErrorError as AuthErrorError,
)
from stackit.serviceaccount.models.create_access_token_payload import (
    CreateAccessTokenPayload as CreateAccessTokenPayload,
)
from stackit.serviceaccount.models.create_service_account_key_payload import (
    CreateServiceAccountKeyPayload as CreateServiceAccountKeyPayload,
)
from stackit.serviceaccount.models.create_service_account_key_response import (
    CreateServiceAccountKeyResponse as CreateServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.create_service_account_key_response_credentials import (
    CreateServiceAccountKeyResponseCredentials as CreateServiceAccountKeyResponseCredentials,
)
from stackit.serviceaccount.models.create_service_account_payload import (
    CreateServiceAccountPayload as CreateServiceAccountPayload,
)
from stackit.serviceaccount.models.create_short_lived_access_token_response import (
    CreateShortLivedAccessTokenResponse as CreateShortLivedAccessTokenResponse,
)
from stackit.serviceaccount.models.error import Error as Error
from stackit.serviceaccount.models.get_service_account_key_response import (
    GetServiceAccountKeyResponse as GetServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.get_service_account_key_response_credentials import (
    GetServiceAccountKeyResponseCredentials as GetServiceAccountKeyResponseCredentials,
)
from stackit.serviceaccount.models.jwk import JWK as JWK
from stackit.serviceaccount.models.jwks import JWKS as JWKS
from stackit.serviceaccount.models.list_access_tokens_response import (
    ListAccessTokensResponse as ListAccessTokensResponse,
)
from stackit.serviceaccount.models.list_service_account_keys_response import (
    ListServiceAccountKeysResponse as ListServiceAccountKeysResponse,
)
from stackit.serviceaccount.models.list_service_accounts_response import (
    ListServiceAccountsResponse as ListServiceAccountsResponse,
)
from stackit.serviceaccount.models.partial_update_service_account_key_payload import (
    PartialUpdateServiceAccountKeyPayload as PartialUpdateServiceAccountKeyPayload,
)
from stackit.serviceaccount.models.partial_update_service_account_key_response import (
    PartialUpdateServiceAccountKeyResponse as PartialUpdateServiceAccountKeyResponse,
)
from stackit.serviceaccount.models.service_account import (
    ServiceAccount as ServiceAccount,
)
from stackit.serviceaccount.models.service_account_key_list_response import (
    ServiceAccountKeyListResponse as ServiceAccountKeyListResponse,
)
