# AUTOGENERATED! DO NOT EDIT! File to edit: box.ipynb (unless otherwise specified).

__all__ = ['image_box', 'cat_box']

# Cell
from fastai.vision.all import *

from .core import *
from .utils import *

# Cell
def image_box(size = 224, folder = '', aug_kwargs = None, **kwargs):
    """Make a DataBox from an ImageBlock."""
    if aug_kwargs is not None:
        kwargs = merge_tfms(
            {'batch_tfms': [*aug_transforms(size=size, **aug_kwargs)]}, kwargs
        )

    return DataBox(
        ImageBlock,
        lambda x: Path(x.parent) / folder / x.name,
        merge_tfms(kwargs, {'item_tfms': Resize(size)}),
    )

# Cell
def cat_box():
    """Make a Category Box from the categorial array of the dataset."""
    return DataBox(MultiCategoryBlock, get_array('.cat'))