from deepcinac.cinac_benchmarks import benchmark_neuronal_activity_inferences
import os
from datetime import datetime

"""demo_deepcinac_evaluate_activity_classifier.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1434aNmo0G5Mwr1_r71nb_EkAFTKtJvzd

###DEMO of deepCINAC###

Welcome on this notebook. 

We're going to guide you on how to evaluate the performance of your activity classifier using "ground truth" 
data from a .cinac file. 

To evaluate the performance of a cell type classifier, check this [notebook]
(https://gitlab.com/cossartlab/deepcinac/-/blob/master/demos/notebooks/demo_deepcinac_predictions.ipynb) 
file is available to be run localy. 

This notebook has been conceived in order to be run on google colab. A [python]
(https://gitlab.com/cossartlab/deepcinac/tree/master/demos/general/demo_deepcinac_evaluate_activity_classifier.py) 
file is available to be run localy. 

Here is a link to our [gitlab page](https://gitlab.com/cossartlab/deepcinac) for more information about our package. 

To run this code, you will need some neuronal acitivity predictions files obtained using a classifier, 
you can download some [there](https://bit.ly/2XyNoF5).

To evaluate its performances, you need some ground truth. It need to be in the
.cinac format, you can obtain it by opening your files in the deepCINAC GUI and
save the data. 

You can also compare other inference method results, such as CaImAn results. 

The demo will run on the files used to produce the figures in our pre-print.

"""


"""You will need to upload your data to your drive. To do so, indicate the paths of the different files on 
the code below. You may have to replace the 'My Drive' in 'gdrive/My Drive/' by 
the correct path depending on the language used on your google drive."""

root_path = '/My Drive/demo_deepcinac/'

# path to calcium imaging data
data_path = os.path.join(root_path, "data")

"""
    directory in which the predictions from a classifier and the cinac files
    containin ground truth are.  
    the code will produce a boxplot for each inference method (could be a 
    deepcinac classifier, a human, another algorithm)
    each directory in the "inferences_dir" will correspond to a different 
    session
    a yaml file in the "inferences_dir" will serve to config which session
    should be evaluate and which inference should be displayed in the boxplot
    use to show the performance of each method 
    (see examples there: https://bit.ly/2XyNoF5)
    
    then in each session directory, another yaml file allows to configure
    which cells should be used to evaluate the inferences methods. 
"""
inferences_dir = os.path.join(data_path, "for_benchmarks", "figure_8A")

# path of the directory where the results will be save
# a directory will be created each time the prediction is run
# the directory name will be the date and time at which the analysis has been run
# the predictions will be in this directory.
results_path = os.path.join(root_path, "results")
time_str = datetime.now().strftime("%Y_%m_%d.%H-%M-%S")
results_path = os.path.join(results_path, f"{time_str}")
os.mkdir(results_path)

"""
There are a few options available:
- colorfull_boxplots: if True, the boxplots will be colored (one color by boxplot)
- white_background: if True white background, else black
- with_legend: Add a legend with the name of the session
- put_metric_as_y_axis_label: put labels on the y-axis instead that a the top
- alpha_scatter: transparency level of the scatter (each scatter correspond to a cell)
- save_formats: list of str represent the formats of the figure, could be 'eps',
'pdf', 'jpg', 'png'. If multiple formats, there will be as many figures version
as formats
- using_patch_for_legend: If True one legend by session, otherwise add as many
as cells
- predictions_stat_by_metrics: if True, produce the figures that shows
the distribution of the predictions for each transient
- plot_proportion_frames_in_transients: if True produce the figure that shows
the proportion of frames predicted in the transients
- color_cell_as_boxplot: if True, the cells have the same color of the boxplots,
else the cell are colored according to their session, one color by session
- with_cells: if True, add cells in addition of the boxplot as a scatter plot
- with_cell_number: if True, the cells' number is added 

"""

"""
Outputs: 
- It will produce boxplots displaying sensitivity, specificity & F1 score
- as well as other figures if you put 'predictions_stat_by_metrics' or/and
'plot_proportion_frames_in_transients' to True
- A Wilcoxon signed-rank test will be applied between each pair of inference
methods and the results will be printed (be careful, those might only be valid 
for large distribution)
- Finally the median, 25th and 75th percentile of each metrics distribution 
will be printed
"""
benchmark_neuronal_activity_inferences(inferences_dir=inferences_dir, 
                                       results_path=results_path,
                                       colorfull_boxplots=False, 
                                       white_background=True,
                                       with_legend=True, 
                                       put_metric_as_y_axis_label=True,
                                       alpha_scatter=1, 
                                       save_formats=["png"],
                                       using_patch_for_legend=True, 
                                       predictions_stat_by_metrics=False,
                                       plot_proportion_frames_in_transients=False,
                                       color_cell_as_boxplot=False, 
                                       with_cells=True, 
                                       with_cell_number=True)