# coding: utf-8

"""
    Auth - Application API

    Auth manages access policies for services that need access policies management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 1.0.4
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AccessRole(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ad_endpoint': 'str',
        'bound_group_ids': 'list[str]',
        'bound_resource_groups': 'list[str]',
        'bound_resource_ids': 'list[str]',
        'bound_resource_names': 'list[str]',
        'bound_resource_providers': 'list[str]',
        'bound_resource_types': 'list[str]',
        'bound_service_principal_ids': 'list[str]',
        'bound_subscription_ids': 'list[str]',
        'bound_tenant_id': 'str',
        'issuer': 'str',
        'jwks_uri': 'str'
    }

    attribute_map = {
        'ad_endpoint': 'ad_endpoint',
        'bound_group_ids': 'bound_group_ids',
        'bound_resource_groups': 'bound_resource_groups',
        'bound_resource_ids': 'bound_resource_ids',
        'bound_resource_names': 'bound_resource_names',
        'bound_resource_providers': 'bound_resource_providers',
        'bound_resource_types': 'bound_resource_types',
        'bound_service_principal_ids': 'bound_service_principal_ids',
        'bound_subscription_ids': 'bound_subscription_ids',
        'bound_tenant_id': 'bound_tenant_id',
        'issuer': 'issuer',
        'jwks_uri': 'jwks_uri'
    }

    def __init__(self, ad_endpoint=None, bound_group_ids=None, bound_resource_groups=None, bound_resource_ids=None, bound_resource_names=None, bound_resource_providers=None, bound_resource_types=None, bound_service_principal_ids=None, bound_subscription_ids=None, bound_tenant_id=None, issuer=None, jwks_uri=None):  # noqa: E501
        """AccessRole - a model defined in Swagger"""  # noqa: E501

        self._ad_endpoint = None
        self._bound_group_ids = None
        self._bound_resource_groups = None
        self._bound_resource_ids = None
        self._bound_resource_names = None
        self._bound_resource_providers = None
        self._bound_resource_types = None
        self._bound_service_principal_ids = None
        self._bound_subscription_ids = None
        self._bound_tenant_id = None
        self._issuer = None
        self._jwks_uri = None
        self.discriminator = None

        if ad_endpoint is not None:
            self.ad_endpoint = ad_endpoint
        if bound_group_ids is not None:
            self.bound_group_ids = bound_group_ids
        if bound_resource_groups is not None:
            self.bound_resource_groups = bound_resource_groups
        if bound_resource_ids is not None:
            self.bound_resource_ids = bound_resource_ids
        if bound_resource_names is not None:
            self.bound_resource_names = bound_resource_names
        if bound_resource_providers is not None:
            self.bound_resource_providers = bound_resource_providers
        if bound_resource_types is not None:
            self.bound_resource_types = bound_resource_types
        if bound_service_principal_ids is not None:
            self.bound_service_principal_ids = bound_service_principal_ids
        if bound_subscription_ids is not None:
            self.bound_subscription_ids = bound_subscription_ids
        if bound_tenant_id is not None:
            self.bound_tenant_id = bound_tenant_id
        if issuer is not None:
            self.issuer = issuer
        if jwks_uri is not None:
            self.jwks_uri = jwks_uri

    @property
    def ad_endpoint(self):
        """Gets the ad_endpoint of this AccessRole.  # noqa: E501

        The audience in the JWT.  # noqa: E501

        :return: The ad_endpoint of this AccessRole.  # noqa: E501
        :rtype: str
        """
        return self._ad_endpoint

    @ad_endpoint.setter
    def ad_endpoint(self, ad_endpoint):
        """Sets the ad_endpoint of this AccessRole.

        The audience in the JWT.  # noqa: E501

        :param ad_endpoint: The ad_endpoint of this AccessRole.  # noqa: E501
        :type: str
        """

        self._ad_endpoint = ad_endpoint

    @property
    def bound_group_ids(self):
        """Gets the bound_group_ids of this AccessRole.  # noqa: E501

        The list of group ids that login is restricted to.  # noqa: E501

        :return: The bound_group_ids of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_group_ids

    @bound_group_ids.setter
    def bound_group_ids(self, bound_group_ids):
        """Sets the bound_group_ids of this AccessRole.

        The list of group ids that login is restricted to.  # noqa: E501

        :param bound_group_ids: The bound_group_ids of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_group_ids = bound_group_ids

    @property
    def bound_resource_groups(self):
        """Gets the bound_resource_groups of this AccessRole.  # noqa: E501

        The list of resource groups that login is restricted to.  # noqa: E501

        :return: The bound_resource_groups of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_resource_groups

    @bound_resource_groups.setter
    def bound_resource_groups(self, bound_resource_groups):
        """Sets the bound_resource_groups of this AccessRole.

        The list of resource groups that login is restricted to.  # noqa: E501

        :param bound_resource_groups: The bound_resource_groups of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_resource_groups = bound_resource_groups

    @property
    def bound_resource_ids(self):
        """Gets the bound_resource_ids of this AccessRole.  # noqa: E501

        The list of full resource ids that the login is restricted to.  # noqa: E501

        :return: The bound_resource_ids of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_resource_ids

    @bound_resource_ids.setter
    def bound_resource_ids(self, bound_resource_ids):
        """Sets the bound_resource_ids of this AccessRole.

        The list of full resource ids that the login is restricted to.  # noqa: E501

        :param bound_resource_ids: The bound_resource_ids of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_resource_ids = bound_resource_ids

    @property
    def bound_resource_names(self):
        """Gets the bound_resource_names of this AccessRole.  # noqa: E501

        The list of resource names that the login is restricted to (e.g, a virtual machine name, scale set name, etc).  # noqa: E501

        :return: The bound_resource_names of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_resource_names

    @bound_resource_names.setter
    def bound_resource_names(self, bound_resource_names):
        """Sets the bound_resource_names of this AccessRole.

        The list of resource names that the login is restricted to (e.g, a virtual machine name, scale set name, etc).  # noqa: E501

        :param bound_resource_names: The bound_resource_names of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_resource_names = bound_resource_names

    @property
    def bound_resource_providers(self):
        """Gets the bound_resource_providers of this AccessRole.  # noqa: E501

        The list of resource providers that login is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc).  # noqa: E501

        :return: The bound_resource_providers of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_resource_providers

    @bound_resource_providers.setter
    def bound_resource_providers(self, bound_resource_providers):
        """Sets the bound_resource_providers of this AccessRole.

        The list of resource providers that login is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc).  # noqa: E501

        :param bound_resource_providers: The bound_resource_providers of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_resource_providers = bound_resource_providers

    @property
    def bound_resource_types(self):
        """Gets the bound_resource_types of this AccessRole.  # noqa: E501

        The list of resource types that login is restricted to  (e.g, virtualMachines, userAssignedIdentities, etc).  # noqa: E501

        :return: The bound_resource_types of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_resource_types

    @bound_resource_types.setter
    def bound_resource_types(self, bound_resource_types):
        """Sets the bound_resource_types of this AccessRole.

        The list of resource types that login is restricted to  (e.g, virtualMachines, userAssignedIdentities, etc).  # noqa: E501

        :param bound_resource_types: The bound_resource_types of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_resource_types = bound_resource_types

    @property
    def bound_service_principal_ids(self):
        """Gets the bound_service_principal_ids of this AccessRole.  # noqa: E501

        The list of service principal IDs that login is restricted to.  # noqa: E501

        :return: The bound_service_principal_ids of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_service_principal_ids

    @bound_service_principal_ids.setter
    def bound_service_principal_ids(self, bound_service_principal_ids):
        """Sets the bound_service_principal_ids of this AccessRole.

        The list of service principal IDs that login is restricted to.  # noqa: E501

        :param bound_service_principal_ids: The bound_service_principal_ids of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_service_principal_ids = bound_service_principal_ids

    @property
    def bound_subscription_ids(self):
        """Gets the bound_subscription_ids of this AccessRole.  # noqa: E501

        The list of subscription IDs that login is restricted to.  # noqa: E501

        :return: The bound_subscription_ids of this AccessRole.  # noqa: E501
        :rtype: list[str]
        """
        return self._bound_subscription_ids

    @bound_subscription_ids.setter
    def bound_subscription_ids(self, bound_subscription_ids):
        """Sets the bound_subscription_ids of this AccessRole.

        The list of subscription IDs that login is restricted to.  # noqa: E501

        :param bound_subscription_ids: The bound_subscription_ids of this AccessRole.  # noqa: E501
        :type: list[str]
        """

        self._bound_subscription_ids = bound_subscription_ids

    @property
    def bound_tenant_id(self):
        """Gets the bound_tenant_id of this AccessRole.  # noqa: E501

        The tenants id for the Azure Active Directory organization.  # noqa: E501

        :return: The bound_tenant_id of this AccessRole.  # noqa: E501
        :rtype: str
        """
        return self._bound_tenant_id

    @bound_tenant_id.setter
    def bound_tenant_id(self, bound_tenant_id):
        """Sets the bound_tenant_id of this AccessRole.

        The tenants id for the Azure Active Directory organization.  # noqa: E501

        :param bound_tenant_id: The bound_tenant_id of this AccessRole.  # noqa: E501
        :type: str
        """

        self._bound_tenant_id = bound_tenant_id

    @property
    def issuer(self):
        """Gets the issuer of this AccessRole.  # noqa: E501

        Issuer URL  # noqa: E501

        :return: The issuer of this AccessRole.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this AccessRole.

        Issuer URL  # noqa: E501

        :param issuer: The issuer of this AccessRole.  # noqa: E501
        :type: str
        """

        self._issuer = issuer

    @property
    def jwks_uri(self):
        """Gets the jwks_uri of this AccessRole.  # noqa: E501

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :return: The jwks_uri of this AccessRole.  # noqa: E501
        :rtype: str
        """
        return self._jwks_uri

    @jwks_uri.setter
    def jwks_uri(self, jwks_uri):
        """Sets the jwks_uri of this AccessRole.

        The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.  # noqa: E501

        :param jwks_uri: The jwks_uri of this AccessRole.  # noqa: E501
        :type: str
        """

        self._jwks_uri = jwks_uri

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessRole):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
