# akeyless-auth-api
Auth manages access policies for services that need access policies management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.4
- Package version: 0.0.5
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_auth_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_auth_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_auth_api
from akeyless_auth_api.rest import ApiException
from pprint import pprint
# create an instance of the API class
api_instance = akeyless_auth_api.DefaultApi()
policy_id = 'policy_id_example' # str | Policy id.
timestamp = 789 # int | A Unix timestamp which was used for the signature.
nonce = 'nonce_example' # str | Random string which was used for the signature.
signature = 'signature_example' # str | A digital signature generated with the private key that complies with the access policy.
client_ip = 'client_ip_example' # str | The Client's IP for authentication. Relevant only to the services that mediate between Auth and their clients in obtaining temporary access credentials. (optional)

try:
    # Return a temporary access credentials
    api_response = api_instance.authenticate_api_key_policy(policy_id, timestamp, nonce, signature, client_ip=client_ip)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->authenticate_api_key_policy: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**authenticate_api_key_policy**](docs/DefaultApi.md#authenticate_api_key_policy) | **POST** /auth-api-key-policy | Return a temporary access credentials
*DefaultApi* | [**authenticate_azure_ad_policy**](docs/DefaultApi.md#authenticate_azure_ad_policy) | **POST** /auth-azure-ad-policy | Return a temporary access credentials
*DefaultApi* | [**authenticate_uam_api_key_policy**](docs/DefaultApi.md#authenticate_uam_api_key_policy) | **POST** /auth-uam-api-key-policy | Return a combination of three temporary credentials for accessing Auth, UAM and KFMs instances.
*DefaultApi* | [**authenticate_uam_azure_ad_policy**](docs/DefaultApi.md#authenticate_uam_azure_ad_policy) | **POST** /auth-uam-azure-ad-policy | Return a combination of three temporary credentials for accessing Auth, UAM and KFMs instances.
*DefaultApi* | [**create_account_creds**](docs/DefaultApi.md#create_account_creds) | **POST** /create-account-creds | Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access policy to be used for accessing the account
*DefaultApi* | [**create_policy**](docs/DefaultApi.md#create_policy) | **POST** /policy | Creating a new access policy.
*DefaultApi* | [**delete_policy**](docs/DefaultApi.md#delete_policy) | **DELETE** /policy/{policy_id} | Deleting an existing access policy.
*DefaultApi* | [**get_policies**](docs/DefaultApi.md#get_policies) | **GET** /policies | Geting a list of access policies
*DefaultApi* | [**get_policy**](docs/DefaultApi.md#get_policy) | **GET** /policy/{policy_id} | Getting an existing access policy.
*DefaultApi* | [**get_public_signing_key**](docs/DefaultApi.md#get_public_signing_key) | **GET** /public-signing-key/{signing_key_id} | Getting the public part of the key used by Auth to sign the temporary access credentials.
*DefaultApi* | [**get_status**](docs/DefaultApi.md#get_status) | **GET** /status | 
*DefaultApi* | [**get_time**](docs/DefaultApi.md#get_time) | **GET** /time | 
*DefaultApi* | [**set_uam_policy_creds**](docs/DefaultApi.md#set_uam_policy_creds) | **POST** /set-uam-policy-creds | Getting temporary access credentials to add a new access policy or to update an existing access policy in an UAM account. The UAM service will use this credentials to create/update an access policy to be used for accessing key fragments.
*DefaultApi* | [**update_policy**](docs/DefaultApi.md#update_policy) | **PUT** /policy/{policy_id} | Updating an existing access policy
*DefaultApi* | [**validate_client_credentials**](docs/DefaultApi.md#validate_client_credentials) | **POST** /validate-client-credentials | Validate client credentials


## Documentation For Models

 - [AccessRole](docs/AccessRole.md)
 - [Algorithm](docs/Algorithm.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAccountReplyObj](docs/CreateAccountReplyObj.md)
 - [CreatePolicyReplyObj](docs/CreatePolicyReplyObj.md)
 - [CreateUserReplyObj](docs/CreateUserReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAccountUsersReplyObj](docs/GetAccountUsersReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetPoliciesReplyObj](docs/GetPoliciesReplyObj.md)
 - [GetPolicyReplyObj](docs/GetPolicyReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [GetUserItemsReplyObj](docs/GetUserItemsReplyObj.md)
 - [GetUserReplyObj](docs/GetUserReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [PolicyParams](docs/PolicyParams.md)
 - [PolicyRules](docs/PolicyRules.md)
 - [PolicyRulesType](docs/PolicyRulesType.md)
 - [PolicyType](docs/PolicyType.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetUAMPolicyCredsParams](docs/SetUAMPolicyCredsParams.md)
 - [SystemUserCredentialsReplyObj](docs/SystemUserCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdatePolicyMode](docs/UpdatePolicyMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [UserAccessPolicyInfo](docs/UserAccessPolicyInfo.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

