#!/usr/bin/env python3
##import dependency libraries
import sys,time,glob,os,pickle,fileinput,argparse
from subprocess import Popen
from operator import itemgetter
import gc, fileinput
import numpy as np
from scipy import special 
#import pandas as pd
##############################################################
## basic function library
def read_file(tempFile,linesOraw='lines',quiet=False):
    if not quiet:
        print('reading',tempFile)
    f=open(tempFile,'r')
    if linesOraw=='lines':
        lines=f.readlines()
        for i in range(0,len(lines)):
            lines[i]=lines[i].strip('\n')
    elif linesOraw=='raw':
        lines=f.read()
    f.close()
    return(lines)

def make_file(contents,path):
    f=open(path,'w')
    if isinstance(contents,list):
        f.writelines(contents)
    elif isinstance(contents,str):
        f.write(contents)
    f.close()

    
def flatten_2D_table(table,delim):
    #print(type(table))
    if str(type(table))=="<class 'numpy.ndarray'>":
        out=[]
        for i in range(0,len(table)):
            out.append([])
            for j in range(0,len(table[i])):
                try:
                    str(table[i][j])
                except:
                    print(table[i][j])
                else:
                    out[i].append(str(table[i][j]))
            out[i]=delim.join(out[i])+'\n'
        return(out)
    else:
        for i in range(0,len(table)):
            for j in range(0,len(table[i])):
                try:
                    str(table[i][j])
                except:
                    print(table[i][j])
                else:
                    table[i][j]=str(table[i][j])
            table[i]=delim.join(table[i])+'\n'
    #print(table[0])
        return(table)

def strip_split(line, delim = '\t'):
    return(line.strip('\n').split(delim))

def make_table(lines,delim):
    for i in range(0,len(lines)):
        lines[i]=lines[i].strip()
        lines[i]=lines[i].split(delim)
        for j in range(0,len(lines[i])):
            try:
                float(lines[i][j])
            except:
                lines[i][j]=lines[i][j].replace('"','')
            else:
                lines[i][j]=float(lines[i][j])
    return(lines)


def get_file_path(in_path):
    in_path = in_path.split('/')
    in_path = in_path[:-1]
    in_path = '/'.join(in_path)
    return(in_path+'/')


def read_table(file, sep='\t'):
    return(make_table(read_file(file,'lines'),sep))
    
def write_table(table, out_file, sep = '\t'):
    make_file(flatten_2D_table(table,sep), out_file)
    

def import_dict(f):
    f=open(f,'rb')
    d=pickle.load(f)
    f.close()
    return(d)

def save_dict(d,path):
    f=open(path,'wb')
    pickle.dump(d,f)
    f.close()

def cmd(in_message, com=True):
    print(in_message)
    time.sleep(.25)
    if com:
        Popen(in_message,shell=True).communicate()
    else:
        Popen(in_message,shell=True)



##############################################################



###############################################################
###############################################################

parser = argparse.ArgumentParser()


## global arguments
parser.add_argument(
	'-i','-input',
	dest='in_dir',
	type=str,
	help="This can either be the direcotry of gprofiler results from PyMINEr, or the file generated by cell_signals")
parser.add_argument(
	'-out_file','-o','-out',
	dest='out',
	type=str)

args = parser.parse_args()
###############################################################
###############################################################
## functions for calculating the final ranking metric
def norm(vect):
	vect = vect - min(vect)
	vect = vect / max(vect)
	return(vect)

def kl_from_gaus(vect,fudge=1e-4):
	## first make the default Gaussian distribution probability vector
	vect = np.array(vect)
	gaus_bins = np.histogram(np.random.normal(size=max([10000,len(vect)])),bins=len(vect),density=True)[0]
	observed = np.histogram(norm(vect), bins = len(vect))[0]
	## do the kl divergence, but add the fudge factor to prevent inf
	full_kl = special.kl_div(gaus_bins+fudge,observed+fudge)
	return(np.sum(full_kl))


def get_rank_metric(vect):
	sum_kl = kl_from_gaus(vect)
	# multiply by the range
	rank_metric = (max(vect)-min(vect)) * sum_kl
	return(rank_metric)


###############################################################
###############################################################
## if the gprofiler results were generated by cell_signals it will be in a different format than from pyminer_gprofile.py
## the first thing we have to do is figure out which one it is.
## PyMINEr will be a directory, cell signals will be a single file.

if os.path.isdir(args.in_dir):
	print(args.in_dir,'is a directory')
	pyminer = True
	cell_signals = False
elif os.path.isfile(args.in_dir):
	print(args.in_dir,'is a file')
	cell_signals = True
	pyminer = False
else:
	sys.exit("Huston, we have a problem. The file or directory that was passed through couldn't be found/read")




###############################################################
def get_unique_terms(term_ids):
		## make the terms unique
	print('all terms',len(term_ids))
	term_ids = sorted(list(set(term_ids)))
	print('unqiue',len(term_ids))

	## catelogue the indices of the unique terms
	term_index_hash = {j:i for i, j in enumerate(term_ids)}

	return(term_ids, term_index_hash)

###############################################################
if cell_signals:
	all_groups = []
	term_ids = []
	for line in fileinput.input(args.in_dir):
		## get the list of term ids and group ids
		temp_line = strip_split(line)
		all_groups.append(temp_line[0]+"_&_"+temp_line[1])
		term_ids.append(temp_line[10])

	all_groups = sorted(list(set(all_groups)))
	print(all_groups)
	term_ids, term_index_hash = get_unique_terms(term_ids)


if pyminer:
	## go through all of the files logging all of the pathways that appear

	"""
	p-value: 2
	term id: 8
	term name: 11
	"""

	os.chdir(args.in_dir)
	all_groups = []
	for f in glob.glob("*gprofiler.txt"):
		#print(f)
		all_groups.append(f)

	all_groups = sorted(all_groups)

	###################################################################
	## go through the files & grab the unique term ids
	term_ids = []
	for f in all_groups:
		first = True
		for line in fileinput.input(f):
			if first:
				first = False
			else:
				temp_line = strip_split(line)
				#print(temp_line[2],temp_line[8],temp_line[11])
				term_ids.append(temp_line[8])
		fileinput.close()

	## if there aren't any results, there's really nothing left to do...
	if len(term_ids)==0:
		sys.exit('no gprofiler results...')

	term_ids, term_index_hash = get_unique_terms(term_ids)



	###################################################################
	## make the annotation leader columns
	annotations = []
	for i in range(0,len(term_ids)):
		annotations.append([term_ids[i],None])

	for f in all_groups:
		first = True
		for line in fileinput.input(f):
			if first:
				first = False
			else:
				temp_line = strip_split(line)
				term_idx = term_index_hash[temp_line[8]]
				annotations[term_idx][1] = temp_line[11]

	for i in range(0,5):
		print(annotations[i])


	###################################################################

	## make the neg log p-val matrix
	neg_log_p = np.zeros((len(term_ids),len(all_groups)))


	## add the negative log10 p-values
	for f in range(0,len(all_groups)):
		first = True
		for line in fileinput.input(all_groups[f]):
			if first:
				first = False
			else:
				temp_line = strip_split(line)
				term_idx = term_index_hash[temp_line[8]]
				neg_log_p[term_idx, f] = -np.log10(float(temp_line[2]))


	print(neg_log_p)

###################################################################
## prioritize them based on the sum kl-divergance*range
kl_metric=[]
for i in range(0,len(term_ids)):
	kl_metric.append(get_rank_metric(neg_log_p[i,:]))

reordering = sorted(range(len(kl_metric)), key=lambda k: kl_metric[k])[::-1]

###################################################################


## make the final output list
out_table = [['importance_metric', 'term_id','term_name']+all_groups]

for i in range(0,len(reordering)):
	temp_idx = reordering[i]
	out_table.append([kl_metric[temp_idx]]+annotations[temp_idx]+neg_log_p[temp_idx,:].tolist())
	# print(out_table)

## write the file

write_table(out_table,args.out)