# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tui_rsync',
 'tui_rsync.core',
 'tui_rsync.core.components',
 'tui_rsync.core.components.backup',
 'tui_rsync.core.components.backup.application',
 'tui_rsync.core.components.backup.application.backup_commands',
 'tui_rsync.core.components.backup_plan',
 'tui_rsync.core.components.backup_plan.application',
 'tui_rsync.core.components.backup_plan.application.commands',
 'tui_rsync.core.components.backup_plan.application.queries',
 'tui_rsync.core.components.backup_plan.application.repository',
 'tui_rsync.core.components.backup_plan.application.services',
 'tui_rsync.core.components.backup_plan.domain',
 'tui_rsync.core.components.backup_plan.domain.entities',
 'tui_rsync.core.components.backup_plan.domain.value_objects',
 'tui_rsync.core.components.backup_plan.ports',
 'tui_rsync.core.ports',
 'tui_rsync.core.ports.configuration',
 'tui_rsync.core.ports.orm',
 'tui_rsync.core.shared_kernel',
 'tui_rsync.core.shared_kernel.components',
 'tui_rsync.core.shared_kernel.components.backup',
 'tui_rsync.core.shared_kernel.components.backup.application',
 'tui_rsync.core.shared_kernel.components.backup.application.service',
 'tui_rsync.core.shared_kernel.components.common',
 'tui_rsync.core.shared_kernel.components.common.domain',
 'tui_rsync.core.shared_kernel.components.common.domain.value_objects',
 'tui_rsync.core.shared_kernel.ports.Exceptions',
 'tui_rsync.infrastructure',
 'tui_rsync.infrastructure.configuration',
 'tui_rsync.infrastructure.orm',
 'tui_rsync.infrastructure.orm.dto',
 'tui_rsync.user_interface',
 'tui_rsync.user_interface.cli',
 'tui_rsync.user_interface.cli.components',
 'tui_rsync.user_interface.cli.components.backup',
 'tui_rsync.user_interface.cli.components.backup_plan',
 'tui_rsync.user_interface.cli.components.backup_plan.formating',
 'tui_rsync.user_interface.cli.shared_kernel.components.errors.applications.exceptions',
 'tui_rsync.user_interface.cli.shared_kernel.components.prompts.applications.prompts']

package_data = \
{'': ['*']}

install_requires = \
['injector>=0.22.0,<0.23.0',
 'peewee>=3.15.4,<4.0.0',
 'platformdirs>=3.1.1,<4.0.0',
 'pyfzf>=0.3.1,<0.4.0',
 'rich>=13.3.1,<14.0.0',
 'typer>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['tui-rsync = tui_rsync.main:main']}

setup_kwargs = {
    'name': 'tui-rsync',
    'version': '1.0.0',
    'description': 'tui-rsync will help you to manage yours backups.',
    'long_description': 'tui-rsync\n=========\n\n|PyPI version|\n\ntui-rsync is the application that will help you to manage yours backups.\nIt uses rsync for syncing backups.\n\nDependencies\n============\n\n-  rsync\n-  fzf\n\nAuthor\n======\n\nKostiantyn Klochko (c) 2023-2025\n\nLicense\n=======\n\nUnder GNU GPL v3 license\n\n.. |PyPI version| image:: https://badge.fury.io/py/tui-rsync.svg\n   :target: https://badge.fury.io/py/tui-rsync\n',
    'author': 'Kostiantyn Klochko',
    'author_email': 'kklochko@protonmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://gitlab.com/KKlochko/tui-rsync',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
