from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class VisionPrescriptionSchema:
    """
    An authorization for the supply of glasses and/or contact lenses to a patient.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        An authorization for the supply of glasses and/or contact lenses to a patient.


        resourceType: This is a VisionPrescription resource

        identifier: Business identifier which may be used by other parties to reference or
            identify the prescription.

        status: The status of the resource instance.

        patient: A link to a resource representing the person to whom the vision products will
            be supplied.

        encounter: A link to a resource that identifies the particular occurrence of contact
            between patient and health care provider.

        dateWritten: The date (and perhaps time) when the prescription was written.

        prescriber: The healthcare professional responsible for authorizing the prescription.

        reasonCodeableConcept: Can be the reason or the indication for writing the prescription.

        reasonReference: Can be the reason or the indication for writing the prescription.

        dispense: Deals with details of the dispense part of the supply specification.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.visionprescription_dispense import (
            VisionPrescription_DispenseSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("VisionPrescription") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["VisionPrescription"]
        schema = StructType(
            [
                # This is a VisionPrescription resource
                StructField("resourceType", StringType(), True),
                # Business identifier which may be used by other parties to reference or
                # identify the prescription.
                StructField(
                    "identifier",
                    ArrayType(
                        IdentifierSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The status of the resource instance.
                StructField("status", StringType(), True),
                # A link to a resource representing the person to whom the vision products will
                # be supplied.
                StructField(
                    "patient",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A link to a resource that identifies the particular occurrence of contact
                # between patient and health care provider.
                StructField(
                    "encounter",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The date (and perhaps time) when the prescription was written.
                StructField("dateWritten", StringType(), True),
                # The healthcare professional responsible for authorizing the prescription.
                StructField(
                    "prescriber",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Can be the reason or the indication for writing the prescription.
                StructField(
                    "reasonCodeableConcept",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Can be the reason or the indication for writing the prescription.
                StructField(
                    "reasonReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Deals with details of the dispense part of the supply specification.
                StructField(
                    "dispense",
                    ArrayType(
                        VisionPrescription_DispenseSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
