from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class SubscriptionSchema:
    """
    The subscription resource is used to define a push based subscription from a
    server to another system. Once a subscription is registered with the server,
    the server checks every resource that is created or updated, and if the
    resource matches the given criteria, it sends a message on the defined
    "channel" so that another system is able to take an appropriate action.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        The subscription resource is used to define a push based subscription from a
        server to another system. Once a subscription is registered with the server,
        the server checks every resource that is created or updated, and if the
        resource matches the given criteria, it sends a message on the defined
        "channel" so that another system is able to take an appropriate action.


        resourceType: This is a Subscription resource

        status: The status of the subscription, which marks the server state for managing the
            subscription.

        contact: Contact details for a human to contact about the subscription. The primary use
            of this for system administrator troubleshooting.

        end: The time for the server to turn the subscription off.

        reason: A description of why this subscription is defined.

        criteria: The rules that the server should use to determine when to generate
            notifications for this subscription.

        error: A record of the last error that occurred when the server processed a
            notification.

        channel: Details where to send notifications when resources are received that meet the
            criteria.

        tag: A tag to add to any resource that matches the criteria, after the subscription
            is processed.

        """
        from spark_fhir_schemas.stu3.complex_types.contactpoint import (
            ContactPointSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.subscription_channel import (
            Subscription_ChannelSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema

        if (
            max_recursion_limit
            and nesting_list.count("Subscription") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Subscription"]
        schema = StructType(
            [
                # This is a Subscription resource
                StructField("resourceType", StringType(), True),
                # The status of the subscription, which marks the server state for managing the
                # subscription.
                StructField("status", StringType(), True),
                # Contact details for a human to contact about the subscription. The primary use
                # of this for system administrator troubleshooting.
                StructField(
                    "contact",
                    ArrayType(
                        ContactPointSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The time for the server to turn the subscription off.
                StructField("end", StringType(), True),
                # A description of why this subscription is defined.
                StructField("reason", StringType(), True),
                # The rules that the server should use to determine when to generate
                # notifications for this subscription.
                StructField("criteria", StringType(), True),
                # A record of the last error that occurred when the server processed a
                # notification.
                StructField("error", StringType(), True),
                # Details where to send notifications when resources are received that meet the
                # criteria.
                StructField(
                    "channel",
                    Subscription_ChannelSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A tag to add to any resource that matches the criteria, after the subscription
                # is processed.
                StructField(
                    "tag",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
